/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.NumberFormat;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestDefrag
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.memory && this.config.big && !this.config.ci;
    }

    @Override
    public void test() throws Exception {
        String cipher = this.config.cipher;
        this.config.traceTest = true;
        try {
            this.config.cipher = null;
            this.testIt();
            this.config.cipher = "AES";
            this.testIt();
        }
        finally {
            this.config.cipher = cipher;
        }
    }

    public void testIt() throws Exception {
        Statement st;
        Object var11_22;
        Throwable throwable;
        Object var8_15;
        String dbName = this.getTestName();
        this.deleteDb(dbName);
        File dbFile = new File(this.getBaseDir(), dbName + ".mv.db");
        NumberFormat nf = NumberFormat.getInstance();
        Throwable throwable2 = null;
        Object var5_7 = null;
        try (Connection c = this.getConnection(dbName);){
            Throwable throwable3 = null;
            var8_15 = null;
            try (Statement st2 = c.createStatement();){
                st2.execute("CREATE TABLE IF NOT EXISTS test (id INT PRIMARY KEY, txt varchar) AS SELECT x, x || SPACE(200) FROM SYSTEM_RANGE(1,10000000)");
                st2.execute("checkpoint");
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            long origSize = dbFile.length();
            String message = "before defrag: " + nf.format(origSize);
            this.trace(message);
            this.assertTrue(message, origSize > 4000000000L);
            throwable = null;
            var11_22 = null;
            try {
                st = c.createStatement();
                try {
                    st.execute("shutdown defrag");
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable6) {
            if (throwable2 == null) {
                throwable2 = throwable6;
            } else if (throwable2 != throwable6) {
                throwable2.addSuppressed(throwable6);
            }
            throw throwable2;
        }
        long compactedSize = dbFile.length();
        String message = "after defrag: " + nf.format(compactedSize);
        this.trace(message);
        this.assertTrue(message, compactedSize < 400000000L);
        Throwable throwable7 = null;
        var8_15 = null;
        try (Connection c = this.getConnection(dbName + ";LAZY_QUERY_EXECUTION=1");){
            throwable = null;
            var11_22 = null;
            try {
                st = c.createStatement();
                try {
                    ResultSet rs = st.executeQuery("SELECT * FROM  test");
                    int count = 0;
                    while (rs.next()) {
                        this.assertEquals(++count, rs.getInt(1));
                        this.assertTrue(rs.getString(2).startsWith(count + "   "));
                    }
                    this.assertEquals(10000000, count);
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                } else if (throwable != throwable8) {
                    throwable.addSuppressed(throwable8);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable9) {
            if (throwable7 == null) {
                throwable7 = throwable9;
            } else if (throwable7 != throwable9) {
                throwable7.addSuppressed(throwable9);
            }
            throw throwable7;
        }
        this.deleteDb(dbName);
    }
}

