/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.mvstore.FreeSpaceBitSet;
import org.h2.test.TestBase;
import org.h2.test.store.FreeSpaceList;
import org.h2.test.store.FreeSpaceTree;
import org.h2.util.Utils;

public class TestFreeSpace
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
        TestFreeSpace.testMemoryUsage();
        TestFreeSpace.testPerformance();
    }

    @Override
    public void test() throws Exception {
        this.testSimple();
        this.testRandomized();
    }

    private static void testPerformance() {
        int i = 0;
        while (i < 10) {
            long t = System.nanoTime();
            FreeSpaceBitSet f = new FreeSpaceBitSet(0, 4096);
            int j = 0;
            while (j < 100000) {
                f.markUsed(j * 2 * 4096, 4096);
                ++j;
            }
            j = 0;
            while (j < 100000) {
                f.free(j * 2 * 4096, 4096);
                ++j;
            }
            j = 0;
            while (j < 100000) {
                f.allocate(8192);
                ++j;
            }
            System.out.println(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t));
            ++i;
        }
    }

    private static void testMemoryUsage() {
        long size = 0x400000000L;
        System.gc();
        System.gc();
        long first = Utils.getMemoryUsed();
        FreeSpaceBitSet f = new FreeSpaceBitSet(0, 4096);
        long j = size;
        while (j > 0L) {
            f.markUsed(j, 4096);
            j -= 16384L;
        }
        System.gc();
        System.gc();
        long mem = Utils.getMemoryUsed() - first;
        System.out.println("Memory used: " + mem);
        System.out.println("f: " + f.toString().length());
    }

    private void testSimple() {
        FreeSpaceBitSet f1 = new FreeSpaceBitSet(2, 1024);
        FreeSpaceList f2 = new FreeSpaceList(2, 1024);
        FreeSpaceTree f3 = new FreeSpaceTree(2, 1024);
        this.assertEquals(f1.toString(), f2.toString());
        this.assertEquals(f1.toString(), f3.toString());
        this.assertEquals(2048L, f1.allocate(10240));
        this.assertEquals(2048L, f2.allocate(10240));
        this.assertEquals(2048L, f3.allocate(10240));
        this.assertEquals(f1.toString(), f2.toString());
        this.assertEquals(f1.toString(), f3.toString());
        f1.markUsed(20480L, 1024);
        f2.markUsed(20480L, 1024);
        f3.markUsed(20480L, 1024);
        this.assertEquals(f1.toString(), f2.toString());
        this.assertEquals(f1.toString(), f3.toString());
    }

    private void testRandomized() {
        FreeSpaceBitSet f1 = new FreeSpaceBitSet(2, 8);
        FreeSpaceList f2 = new FreeSpaceList(2, 8);
        Random r = new Random(1L);
        StringBuilder log = new StringBuilder();
        int i = 0;
        while (i < 100000) {
            long pos = r.nextInt(1024);
            int length = 1 + r.nextInt(1024);
            switch (r.nextInt(3)) {
                case 0: {
                    log.append("allocate(" + length + ");\n");
                    long a = f1.allocate(length);
                    long b = f2.allocate(length);
                    this.assertEquals(a, b);
                    break;
                }
                case 1: {
                    if (!f1.isUsed(pos, length)) break;
                    log.append("free(" + pos + ", " + length + ");\n");
                    f1.free(pos, length);
                    f2.free(pos, length);
                    break;
                }
                case 2: {
                    if (!f1.isFree(pos, length)) break;
                    log.append("markUsed(" + pos + ", " + length + ");\n");
                    f1.markUsed(pos, length);
                    f2.markUsed(pos, length);
                }
            }
            this.assertEquals(f1.toString(), f2.toString());
            ++i;
        }
    }
}

