/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.Random;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.utils.FilePathUnstable;

public class TestKillProcessWhileWriting
extends TestBase {
    private String fileName;
    private int seed;
    private FilePathUnstable fs;

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.big = true;
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.fs = FilePathUnstable.register();
        this.fs.setPartialWrites(false);
        this.test("unstable:memFS:killProcess.h3");
        if (this.config.big) {
            try {
                this.fs.setPartialWrites(true);
                this.test("unstable:memFS:killProcess.h3");
            }
            finally {
                this.fs.setPartialWrites(false);
            }
        }
        FileUtils.delete("unstable:memFS:killProcess.h3");
    }

    private void test(String fileName) throws Exception {
        this.seed = 0;
        while (this.seed < 10) {
            this.fileName = fileName;
            FileUtils.delete(fileName);
            this.test(Integer.MAX_VALUE, this.seed);
            int max = Integer.MAX_VALUE - this.fs.getDiskFullCount() + 10;
            this.assertTrue("" + (max - 10), max > 0);
            int i = 0;
            while (i < max) {
                this.test(i, this.seed);
                ++i;
            }
            ++this.seed;
        }
    }

    private void test(int x, int seed) throws Exception {
        FileUtils.delete(this.fileName);
        this.fs.setDiskFullCount(x, seed);
        try {
            this.write();
            this.verify();
        }
        catch (Exception e) {
            if (x == Integer.MAX_VALUE) {
                throw e;
            }
            this.fs.setDiskFullCount(0, seed);
            this.verify();
        }
    }

    private int write() {
        MVStore s = new MVStore.Builder().fileName(this.fileName).pageSplitSize(50).autoCommitDisabled().open();
        MVMap<Integer, byte[]> m = s.openMap("data");
        Random r = new Random(this.seed);
        int op = 0;
        try {
            while (op < 100) {
                int k = r.nextInt(100);
                byte[] v = new byte[r.nextInt(100) * 100];
                int type = r.nextInt(10);
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        m.put(k, v);
                        break;
                    }
                    case 4: 
                    case 5: {
                        m.remove(k);
                        break;
                    }
                    case 6: {
                        s.commit();
                        break;
                    }
                    case 7: {
                        s.compact(80, 1024);
                        break;
                    }
                    case 8: {
                        m.clear();
                        break;
                    }
                    case 9: {
                        s.close();
                        s = new MVStore.Builder().fileName(this.fileName).pageSplitSize(50).autoCommitDisabled().open();
                        m = s.openMap("data");
                    }
                }
                ++op;
            }
            s.close();
            return 0;
        }
        catch (Exception e) {
            s.closeImmediately();
            return op;
        }
    }

    private void verify() {
        FileUtils.delete(this.fileName);
        MVStore s = new MVStore.Builder().fileName(this.fileName).open();
        MVMap m = s.openMap("data");
        int i = 0;
        while (i < 100) {
            byte[] x = (byte[])m.get(i);
            if (x == null) break;
            this.assertEquals(i * 100, x.length);
            ++i;
        }
        s.close();
    }
}

