/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.Cursor;
import org.h2.mvstore.FileStore;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.OffHeapStore;
import org.h2.mvstore.RandomAccessStore;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.store.RowDataType;
import org.h2.test.store.SequenceMap;
import org.h2.util.Utils;

public class TestMVStore
extends TestBase {
    private static final int CURRENT_FORMAT = 3;

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.traceTest = true;
        test.config.big = true;
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testRemoveMapRollback();
        this.testProvidedFileStoreNotOpenedAndClosed();
        this.testVolatileMap();
        this.testEntrySet();
        this.testCompressEmptyPage();
        this.testCompressed();
        this.testFileFormatExample();
        this.testMaxChunkLength();
        this.testCacheInfo();
        this.testRollback();
        this.testVersionsToKeep();
        this.testVersionsToKeep2();
        this.testRemoveMap();
        this.testIsEmpty();
        this.testOffHeapStorage();
        this.testNewerWriteVersion();
        this.testCompactFully();
        this.testBackgroundExceptionListener();
        this.testOldVersion();
        this.testAtomicOperations();
        this.testWriteBuffer();
        this.testWriteDelay();
        this.testEncryptedFile();
        this.testFileFormatChange();
        this.testRecreateMap();
        this.testRenameMapRollback();
        this.testCustomMapType();
        this.testCacheSize();
        this.testConcurrentOpen();
        this.testFileHeader();
        this.testFileHeaderCorruption();
        this.testIndexSkip();
        this.testIndexSkipReverse();
        this.testMinMaxNextKey();
        this.testStoreVersion();
        this.testIterateOldVersion();
        this.testObjects();
        this.testExample();
        this.testExampleMvcc();
        this.testOpenStoreCloseLoop();
        this.testVersion();
        this.testTruncateFile();
        this.testFastDelete();
        this.testRollbackInMemory();
        this.testRollbackStored();
        this.testMeta();
        this.testInMemory();
        this.testLargeImport();
        this.testBtreeStore();
        this.testCompact();
        this.testCompactMapNotOpen();
        this.testReuseSpace();
        this.testRandom();
        this.testKeyValueClasses();
        this.testIterate();
        this.testIterateReverse();
        this.testCloseTwice();
        this.testSimple();
        this.testInvalidSettings();
        this.testLargerThan2G();
    }

    private void testRemoveMapRollback() {
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (MVStore store = new MVStore.Builder().open();){
            MVMap<String, String> map = store.openMap("test");
            map.put("1", "Hello");
            store.commit();
            store.removeMap(map);
            store.rollback();
            this.assertTrue(store.hasMap("test"));
            map = store.openMap("test");
            this.assertEquals("Hello", (String)map.get("1"));
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        FileUtils.createDirectories(TestMVStore.getTestDir(""));
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.createDirectories(this.getBaseDir());
        FileUtils.delete(fileName);
        throwable2 = null;
        Object var3_6 = null;
        try (MVStore store = new MVStore.Builder().autoCommitDisabled().fileName(fileName).open();){
            MVMap<String, String> map = store.openMap("test");
            map.put("1", "Hello");
            store.commit();
            store.removeMap(map);
            store.rollback();
            this.assertTrue(store.hasMap("test"));
            map = store.openMap("test");
            this.assertEquals("Hello", (String)map.get("1"));
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
    }

    private void testProvidedFileStoreNotOpenedAndClosed() {
        final AtomicInteger openClose = new AtomicInteger();
        OffHeapStore fileStore = new OffHeapStore(){

            @Override
            public void open(String fileName, boolean readOnly, char[] encryptionKey) {
                openClose.incrementAndGet();
                super.open(fileName, readOnly, encryptionKey);
            }

            @Override
            public void close() {
                openClose.incrementAndGet();
                super.close();
            }
        };
        MVStore store = new MVStore.Builder().fileStore(fileStore).open();
        store.close();
        this.assertEquals(0, openClose.get());
    }

    private void testVolatileMap() {
        MVMap<String, String> map;
        MVStore store;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            store = new MVStore.Builder().fileName(fileName).open();
            try {
                map = store.openMap("test");
                this.assertFalse(map.isVolatile());
                map.setVolatile(true);
                this.assertTrue(map.isVolatile());
                map.put("1", "Hello");
                this.assertEquals("Hello", (String)map.get("1"));
                this.assertEquals(1, map.size());
            }
            finally {
                if (store != null) {
                    store.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            store = new MVStore.Builder().fileName(fileName).open();
            try {
                this.assertTrue(store.hasMap("test"));
                map = store.openMap("test");
                this.assertEquals(0, map.size());
            }
            finally {
                if (store != null) {
                    store.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testEntrySet() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = new MVStore.Builder().open();){
            MVMap<Integer, Integer> map = s.openMap("data");
            int i = 0;
            while (i < 20) {
                map.put(i, i * 10);
                ++i;
            }
            int next = 0;
            for (Map.Entry e : map.entrySet()) {
                this.assertEquals(next, (int)((Integer)e.getKey()));
                this.assertEquals(next * 10, (int)((Integer)e.getValue()));
                ++next;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCompressEmptyPage() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore store = new MVStore.Builder().cacheSize(100).fileName(fileName).compress().autoCommitBufferSize(10240).open();
        MVMap map = store.openMap("test");
        store.removeMap(map);
        store.commit();
        store.close();
        store = new MVStore.Builder().compress().open();
        store.close();
    }

    private void testCompressed() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        String data = new String(new char[1000]).replace('\u0000', 'x');
        long lastSize = 0L;
        int level = 0;
        while (level <= 2) {
            FileUtils.delete(fileName);
            MVStore.Builder builder = new MVStore.Builder().fileName(fileName);
            if (level == 1) {
                builder.compress();
            } else if (level == 2) {
                builder.compressHigh();
            }
            Throwable throwable = null;
            Object var8_9 = null;
            try (MVStore s = builder.open();){
                MVMap<CallSite, String> map = s.openMap("data");
                int i = 0;
                while (i < 400) {
                    map.put((CallSite)((Object)(data + i)), data);
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            long size = FileUtils.size(fileName);
            if (level > 0) {
                this.assertTrue(size < lastSize);
            }
            lastSize = size;
            Throwable throwable3 = null;
            Object var10_13 = null;
            try (MVStore s = new MVStore.Builder().fileName(fileName).open();){
                MVMap map = s.openMap("data");
                int i = 0;
                while (i < 400) {
                    this.assertEquals(data, (String)map.get(data + i));
                    ++i;
                }
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            ++level;
        }
    }

    private void testFileFormatExample() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = MVStore.open(fileName);){
            MVMap<Integer, String> map = s.openMap("data");
            int i = 0;
            while (i < 400) {
                map.put(i, "Hello");
                ++i;
            }
            s.commit();
            i = 0;
            while (i < 100) {
                map.put(0, "Hi");
                ++i;
            }
            s.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testMaxChunkLength() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = new MVStore.Builder().fileName(fileName).open();){
            MVMap<Integer, byte[]> map = s.openMap("data");
            map.put(0, new byte[0x200000]);
            s.commit();
            map.put(1, new byte[10240]);
            s.commit();
            Map<String, String> layout = s.getLayoutMap();
            Object c = s.getFileStore().createChunk(layout.get("chunk.1"));
            this.assertTrue(((Chunk)c).maxLen < Integer.MAX_VALUE);
            this.assertTrue(((Chunk)c).maxLenLive < Integer.MAX_VALUE);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCacheInfo() {
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = new MVStore.Builder().fileName(fileName).cacheSize(2).open();
            try {
                this.assertEquals(2, s.getCacheSize());
                MVMap<Integer, byte[]> map = s.openMap("data");
                byte[] data = new byte[1024];
                int i = 0;
                while (i < 1000) {
                    map.put(i, data);
                    s.commit();
                    if (i < 50) {
                        this.assertEquals(0, s.getCacheSizeUsed());
                    } else if (i > 300) {
                        this.assertTrue(s.getCacheSizeUsed() >= 1);
                    }
                    ++i;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = new MVStore.Builder().open();
            try {
                this.assertEquals(0, s.getCacheSize());
                this.assertEquals(0, s.getCacheSizeUsed());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testVersionsToKeep() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = new MVStore.Builder().open();){
            this.assertEquals(5L, s.getVersionsToKeep());
            MVMap<Integer, Integer> map = s.openMap("data");
            int i = 0;
            while (i < 20) {
                map.put(i, i);
                s.commit();
                long version = s.getCurrentVersion();
                if (version >= 6L) {
                    map.openVersion(version - 5L);
                    this.assertThrows(IllegalArgumentException.class, () -> map.openVersion(version - 6L));
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testVersionsToKeep2() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = new MVStore.Builder().autoCommitDisabled().open();){
            s.setVersionsToKeep(2);
            MVMap<Integer, String> m = s.openMap("data");
            s.commit();
            this.assertEquals(1L, s.getCurrentVersion());
            m.put(1, "version 1");
            s.commit();
            this.assertEquals(2L, s.getCurrentVersion());
            m.put(1, "version 2");
            s.commit();
            this.assertEquals(3L, s.getCurrentVersion());
            m.put(1, "version 3");
            s.commit();
            m.put(1, "version 4");
            this.assertEquals("version 4", (String)m.openVersion(4L).get(1));
            this.assertEquals("version 3", (String)m.openVersion(3L).get(1));
            this.assertEquals("version 2", (String)m.openVersion(2L).get(1));
            this.assertThrows(IllegalArgumentException.class, () -> m.openVersion(1L));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testRemoveMap() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = new MVStore.Builder().fileName(fileName).open();){
            MVMap<Integer, Integer> map = s.openMap("data");
            map.put(1, 1);
            this.assertEquals(1, (int)((Integer)map.get(1)));
            s.commit();
            s.removeMap(map);
            s.commit();
            map = s.openMap("data");
            this.assertTrue(map.isEmpty());
            map.put(2, 2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testIsEmpty() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = new MVStore.Builder().pageSplitSize(50).open();){
            MVMap<Integer, byte[]> m = s.openMap("data");
            m.put(1, new byte[50]);
            m.put(2, new byte[50]);
            m.put(3, new byte[50]);
            m.remove(1);
            m.remove(2);
            m.remove(3);
            this.assertEquals(0, m.size());
            this.assertTrue(m.isEmpty());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testOffHeapStorage() {
        int i;
        MVMap<Integer, CallSite> map;
        MVStore s;
        OffHeapStore offHeap = new OffHeapStore();
        int count = 1000;
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            s = new MVStore.Builder().fileStore(offHeap).open();
            try {
                map = s.openMap("data");
                i = 0;
                while (i < count) {
                    map.put(i, (CallSite)((Object)("Hello " + i)));
                    s.commit();
                    ++i;
                }
                this.assertTrue(offHeap.getWriteCount() > (long)count);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            s = new MVStore.Builder().fileStore(offHeap).open();
            try {
                map = s.openMap("data");
                i = 0;
                while (i < count) {
                    this.assertEquals("Hello " + i, (String)map.get(i));
                    ++i;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testNewerWriteVersion() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore s = new MVStore.Builder().encryptionKey("007".toCharArray()).fileName(fileName).open();
        s.setRetentionTime(Integer.MAX_VALUE);
        Map<String, Object> header = s.getStoreHeader();
        this.assertEquals(Integer.toString(3), header.get("format").toString());
        header.put("formatRead", Integer.toString(3));
        header.put("format", Integer.toString(4));
        TestMVStore.forceWriteStoreHeader(s);
        MVMap<Integer, String> m = s.openMap("data");
        TestMVStore.forceWriteStoreHeader(s);
        m.put(0, "Hello World");
        s.close();
        try {
            s = new MVStore.Builder().encryptionKey("007".toCharArray()).fileName(fileName).open();
            header = s.getStoreHeader();
            this.fail(header.toString());
        }
        catch (MVStoreException e) {
            this.assertEquals(5, e.getErrorCode());
        }
        s = new MVStore.Builder().encryptionKey("007".toCharArray()).readOnly().fileName(fileName).open();
        this.assertTrue(s.getFileStore().isReadOnly());
        m = s.openMap("data");
        this.assertEquals("Hello World", (String)m.get(0));
        s.close();
        FileUtils.setReadOnly(fileName);
        s = new MVStore.Builder().encryptionKey("007".toCharArray()).fileName(fileName).open();
        this.assertTrue(s.getFileStore().isReadOnly());
        m = s.openMap("data");
        this.assertEquals("Hello World", (String)m.get(0));
        s.close();
    }

    private void testCompactFully() {
        MVMap<Integer, String> m;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore s = new MVStore.Builder().fileName(fileName).autoCommitDisabled().open();
        s.setRetentionTime(0);
        s.setVersionsToKeep(0);
        int i = 0;
        while (i < 100) {
            m = s.openMap("data" + i);
            m.put(0, "Hello World");
            s.commit();
            ++i;
        }
        i = 0;
        while (i < 100) {
            m = s.openMap("data" + i);
            s.removeMap(m);
            s.commit();
            i += 2;
        }
        FileStore<?> fileStore = s.getFileStore();
        long sizeOld = fileStore.size();
        TestMVStore.compactMoveChunks(s);
        s.close();
        long sizeNew = fileStore.size();
        this.assertTrue("old: " + sizeOld + " new: " + sizeNew, sizeNew < sizeOld);
    }

    private static void compactMoveChunks(MVStore s) {
        FileStore<?> fileStore = s.getFileStore();
        if (fileStore instanceof RandomAccessStore) {
            ((RandomAccessStore)fileStore).compactMoveChunks(100, Long.MAX_VALUE, s);
        }
    }

    private void testBackgroundExceptionListener() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        AtomicReference exRef = new AtomicReference();
        MVStore s = new MVStore.Builder().fileName(fileName).backgroundExceptionHandler((t, e) -> exRef.set(e)).open();
        s.setAutoCommitDelay(10);
        MVMap<Integer, String> m = s.openMap("data");
        s.getFileStore().close();
        try {
            m.put(1, "Hello");
            int i = 0;
            while (i < 200) {
                if (exRef.get() != null) break;
                TestMVStore.sleep(10L);
                ++i;
            }
            Throwable e2 = (Throwable)exRef.get();
            this.assertNotNull(e2);
            TestMVStore.checkErrorCode(4, e2);
        }
        catch (MVStoreException e3) {
            this.assertEquals(4, e3.getErrorCode());
        }
        s.closeImmediately();
        FileUtils.delete(fileName);
    }

    private void testAtomicOperations() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = new MVStore.Builder().fileName(fileName).open();){
            MVMap<Integer, byte[]> m = s.openMap("data");
            this.assertNull(m.putIfAbsent(1, new byte[1]));
            this.assertEquals(1, m.putIfAbsent(1, new byte[2]).length);
            this.assertEquals(1, ((byte[])m.get(1)).length);
            this.assertNull(m.replace(2, new byte[2]));
            this.assertNull(m.get(2));
            this.assertEquals(1, m.replace(1, new byte[2]).length);
            this.assertEquals(2, m.replace(1, new byte[3]).length);
            this.assertEquals(3, m.replace(1, new byte[1]).length);
            this.assertFalse(m.replace(1, new byte[2], new byte[10]));
            this.assertTrue(m.replace(1, new byte[1], new byte[2]));
            this.assertTrue(m.replace(1, new byte[2], new byte[1]));
            this.assertFalse(m.remove(1, new byte[2]));
            this.assertTrue(m.remove(1, new byte[1]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FileUtils.delete(fileName);
    }

    private void testWriteBuffer() {
        MVMap<Integer, byte[]> m;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        byte[] data = new byte[1000];
        long lastSize = 0L;
        int len = 1000;
        int bs = 0;
        while (bs <= 1) {
            s = new MVStore.Builder().fileName(fileName).autoCommitBufferSize(bs).open();
            m = s.openMap("data");
            int i = 0;
            while (i < len) {
                m.put(i, data);
                ++i;
            }
            long size = s.getFileStore().size();
            this.assertTrue("last:" + lastSize + " now: " + size, size > lastSize);
            lastSize = size;
            s.close();
            ++bs;
        }
        s = new MVStore.Builder().fileName(fileName).open();
        m = s.openMap("data");
        this.assertTrue(m.containsKey(1));
        m.put(-1, data);
        s.commit();
        m.put(-2, data);
        s.close();
        s = new MVStore.Builder().fileName(fileName).open();
        m = s.openMap("data");
        this.assertTrue(m.containsKey(-1));
        this.assertTrue(m.containsKey(-2));
        s.close();
        FileUtils.delete(fileName);
    }

    private void testWriteDelay() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        FileUtils.delete(fileName);
        MVStore s = new MVStore.Builder().autoCommitDisabled().fileName(fileName).open();
        MVMap<Integer, String> m = s.openMap("data");
        m.put(1, "1");
        s.commit();
        s.close();
        s = new MVStore.Builder().autoCommitDisabled().fileName(fileName).open();
        m = s.openMap("data");
        this.assertEquals(1, m.size());
        s.close();
        FileUtils.delete(fileName);
        s = new MVStore.Builder().fileName(fileName).open();
        m = s.openMap("data");
        m.put(1, "Hello");
        m.put(2, "World.");
        s.commit();
        s.close();
        s = new MVStore.Builder().fileName(fileName).open();
        s.setAutoCommitDelay(2);
        m = s.openMap("data");
        this.assertEquals("World.", (String)m.get(2));
        m.put(2, "World");
        s.commit();
        long v = s.getCurrentVersion();
        long time = System.nanoTime();
        m.put(3, "!");
        int i = 200;
        while (i > 0) {
            if (s.getCurrentVersion() > v) break;
            long diff = System.nanoTime() - time;
            if (diff > TimeUnit.SECONDS.toNanos(1L)) {
                this.fail("diff=" + TimeUnit.NANOSECONDS.toMillis(diff));
            }
            TestMVStore.sleep(10L);
            --i;
        }
        s.closeImmediately();
        s = new MVStore.Builder().fileName(fileName).open();
        m = s.openMap("data");
        this.assertEquals("Hello", (String)m.get(1));
        this.assertEquals("World", (String)m.get(2));
        this.assertEquals("!", (String)m.get(3));
        s.close();
        FileUtils.delete(fileName);
    }

    private void testEncryptedFile() {
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        char[] passwordChars = "007".toCharArray();
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (MVStore s2 = new MVStore.Builder().fileName(fileName).encryptionKey(passwordChars).open();){
            this.assertPasswordErased(passwordChars);
            this.assertTrue(FileUtils.exists(fileName));
            MVMap<Integer, String> m = s2.openMap("test");
            m.put(1, "Hello");
            this.assertEquals("Hello", (String)m.get(1));
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        char[] passwordChars2 = "008".toCharArray();
        this.assertThrows(6, () -> new MVStore.Builder().fileName(fileName).encryptionKey(passwordChars2).open());
        this.assertPasswordErased(passwordChars2);
        passwordChars = "007".toCharArray();
        throwable2 = null;
        Object var5_9 = null;
        try {
            s = new MVStore.Builder().fileName(fileName).encryptionKey(passwordChars).open();
            try {
                this.assertPasswordErased(passwordChars);
                MVMap m = s.openMap("test");
                this.assertEquals("Hello", (String)m.get(1));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        FileUtils.setReadOnly(fileName);
        passwordChars = "007".toCharArray();
        throwable2 = null;
        var5_9 = null;
        try {
            s = new MVStore.Builder().fileName(fileName).encryptionKey(passwordChars).open();
            try {
                this.assertTrue(s.getFileStore().isReadOnly());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable2 == null) {
                throwable2 = throwable5;
            } else if (throwable2 != throwable5) {
                throwable2.addSuppressed(throwable5);
            }
            throw throwable2;
        }
        FileUtils.delete(fileName);
        this.assertFalse(FileUtils.exists(fileName));
    }

    private void assertPasswordErased(char[] passwordChars) {
        this.assertEquals(0, passwordChars[0]);
        this.assertEquals(0, passwordChars[1]);
        this.assertEquals(0, passwordChars[2]);
    }

    private void testFileFormatChange() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = TestMVStore.openStore(fileName);){
            s.setRetentionTime(Integer.MAX_VALUE);
            MVMap<Integer, Integer> m = s.openMap("test");
            m.put(1, 1);
            Map<String, Object> header = s.getStoreHeader();
            int format = Integer.parseInt(header.get("format").toString());
            this.assertEquals(3, format);
            header.put("format", Integer.toString(format + 1));
            TestMVStore.forceWriteStoreHeader(s);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.assertThrows(5, () -> TestMVStore.openStore(fileName).close());
        FileUtils.delete(fileName);
    }

    private void testRecreateMap() {
        MVMap<Integer, Integer> m;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("test");
                m.put(1, 1);
                s.commit();
                s.removeMap(m);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("test");
                this.assertNull(m.get(1));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testRenameMapRollback() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = TestMVStore.openStore(null);){
            MVMap<Integer, Integer> map = s.openMap("hello");
            map.put(1, 10);
            long old = s.commit();
            s.renameMap(map, "world");
            map.put(2, 20);
            this.assertEquals("world", map.getName());
            s.rollbackTo(old);
            this.assertEquals("hello", map.getName());
            s.rollbackTo(0L);
            this.assertTrue(map.isClosed());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCustomMapType() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = TestMVStore.openStore(fileName);){
            MVMap<Long, Long> seq = s.openMap("data", new SequenceMap.Builder());
            StringBuilder buff = new StringBuilder();
            Iterator iterator = seq.keySet().iterator();
            while (iterator.hasNext()) {
                long x = (Long)iterator.next();
                buff.append(x).append(';');
            }
            this.assertEquals("1;2;3;4;5;6;7;8;9;10;", buff.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCacheSize() {
        if (this.config.memory) {
            return;
        }
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = new MVStore.Builder().fileName(fileName).autoCommitDisabled().compress().open();){
            s.setReuseSpace(false);
            MVMap<Integer, String> map = s.openMap("test");
            int i = 0;
            while (i < 1024) {
                map.put(i, new String(new char[10240]));
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int[] expectedReadsForCacheSize = new int[]{7176, 1750, 940, 940, 940, 940, 940};
        int cacheSizeMB = 0;
        while (cacheSizeMB <= 6) {
            Utils.collectGarbage();
            Throwable throwable3 = null;
            Object var5_9 = null;
            try (MVStore s = new MVStore.Builder().fileName(fileName).autoCommitDisabled().cacheSize(cacheSizeMB).open();){
                this.assertEquals(cacheSizeMB, s.getCacheSize());
                MVMap map = s.openMap("test");
                int i = 0;
                while (i < 1024) {
                    int j = 0;
                    while (j < i) {
                        String x = (String)map.get(j);
                        this.assertEquals(10240, x.length());
                        ++j;
                    }
                    i += 128;
                }
                FileStore<?> fileStore = s.getFileStore();
                long readCount = fileStore.getReadCount();
                int expected = expectedReadsForCacheSize[cacheSizeMB];
                this.assertTrue("Cache " + cacheSizeMB + "Mb, reads: " + readCount + " expected: " + expected + " size: " + fileStore.getReadBytes() + " cache used: " + s.getCacheSizeUsed() + " cache hit ratio: " + s.getFileStore().getCacheHitRatio() + " cache ToC hit ratio: " + s.getFileStore().getTocCacheHitRatio(), Math.abs(100L - (long)(100 * expected) / readCount) < 20L);
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            ++cacheSizeMB;
        }
    }

    private void testConcurrentOpen() {
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = new MVStore.Builder().fileName(fileName).open();
            try {
                this.assertThrows(MVStoreException.class, () -> new MVStore.Builder().fileName(fileName).open().close());
                this.assertThrows(MVStoreException.class, () -> new MVStore.Builder().fileName(fileName).readOnly().open().close());
                this.assertFalse(s.getFileStore().isReadOnly());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = new MVStore.Builder().fileName(fileName).readOnly().open();
            try {
                this.assertTrue(s.getFileStore().isReadOnly());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testFileHeader() {
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                s.setRetentionTime(Integer.MAX_VALUE);
                long time = System.currentTimeMillis();
                Map<String, Object> m = s.getStoreHeader();
                this.assertEquals(Integer.toString(3), m.get("format").toString());
                long creationTime = (Long)m.get("created");
                this.assertTrue(Math.abs(time - creationTime) < 100L);
                m.put("test", "123");
                TestMVStore.forceWriteStoreHeader(s);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                Object test = s.getStoreHeader().get("test");
                this.assertNotNull(test);
                this.assertEquals("123", test.toString());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void forceWriteStoreHeader(MVStore s) {
        MVMap<Integer, Integer> map = s.openMap("dummy");
        map.put(10, 100);
        int i = 0;
        while (i < 30) {
            if (i > 5) {
                s.setRetentionTime(0);
                TestMVStore.sleep(1L);
            }
            map.put(10, 110);
            s.commit();
            ++i;
        }
        s.removeMap(map);
        s.commit();
    }

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void testFileHeaderCorruption() throws Exception {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore.Builder builder = new MVStore.Builder().fileName(fileName).pageSplitSize(1000).autoCommitDisabled();
        Throwable throwable = null;
        Object var4_5 = null;
        try (MVStore s = builder.open();){
            s.setRetentionTime(0);
            MVMap<Integer, byte[]> map = s.openMap("test");
            map.put(0, new byte[100]);
            int i = 0;
            while (i < 10) {
                map = s.openMap("test" + i);
                map.put(0, new byte[1000]);
                s.commit();
                ++i;
            }
            FileStore<?> fs = s.getFileStore();
            long size = fs.size();
            int i2 = 0;
            while (i2 < 100) {
                map = s.openMap("test" + i2);
                s.removeMap(map);
                s.commit();
                s.compact(100, 1);
                if (fs.size() <= size) break;
                ++i2;
            }
            s.setReuseSpace(false);
            map = s.openMap("test2");
            map.put(1, new byte[1000]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FilePath f = FilePath.get(fileName);
        int blockSize = 4096;
        int i = 0;
        while (i <= blockSize) {
            block35: {
                Throwable throwable3 = null;
                Object var7_14 = null;
                try (FileChannel fc = f.open("rw");){
                    if (i == 0) {
                        fc.write(ByteBuffer.allocate(256), fc.size() - 256L);
                    }
                    ByteBuffer buff = ByteBuffer.allocate(4096);
                    fc.read(buff, i);
                    String h = new String(buff.array(), StandardCharsets.UTF_8).trim();
                    int idx = h.indexOf("fletcher:");
                    int old = Character.digit(h.charAt(idx + "fletcher:".length()), 16);
                    int bad = old + 1 & 0xF;
                    buff.put(idx + "fletcher:".length(), (byte)Character.forDigit(bad, 16));
                    int b = 0;
                    while (b <= i) {
                        buff.rewind();
                        fc.write(buff, b);
                        b += blockSize;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                if (i == 0) {
                    throwable3 = null;
                    var7_14 = null;
                    try (MVStore s = TestMVStore.openStore(fileName);){
                        MVMap map = s.openMap("test");
                        this.assertEquals(100, ((byte[])map.get(0)).length);
                        map = s.openMap("test2");
                        this.assertFalse(map.containsKey(1));
                        break block35;
                    }
                    catch (Throwable throwable5) {
                        if (throwable3 == null) {
                            throwable3 = throwable5;
                        } else if (throwable3 != throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                        throw throwable3;
                    }
                }
                this.assertThrows(Exception.class, () -> TestMVStore.openStore(fileName));
            }
            i += blockSize;
        }
    }

    private void testIndexSkip() {
        MVStore s = TestMVStore.openStore(null, 4);
        MVMap<Integer, Integer> map = s.openMap("test");
        int i = 0;
        while (i < 100) {
            map.put(i, 10 * i);
            i += 2;
        }
        Cursor c = map.cursor(50);
        c.skip(10L);
        int i2 = 70;
        while (i2 < 100) {
            this.assertTrue(c.hasNext());
            this.assertEquals(i2, (int)c.next());
            i2 += 2;
        }
        this.assertFalse(c.hasNext());
        i2 = -1;
        while (i2 < 100) {
            long index = map.getKeyIndex(i2);
            if (i2 < 0 || i2 % 2 != 0) {
                this.assertEquals((long)(i2 < 0 ? -1 : -(i2 / 2) - 2), index);
            } else {
                this.assertEquals((long)(i2 / 2), index);
            }
            ++i2;
        }
        i2 = -1;
        while (i2 < 60) {
            Integer k = (Integer)map.getKey(i2);
            if (i2 < 0 || i2 >= 50) {
                this.assertNull(k);
            } else {
                this.assertNotNull(k);
                this.assertEquals(i2 * 2, (int)k);
            }
            ++i2;
        }
        c = map.cursor(0);
        this.assertTrue(c.hasNext());
        this.assertEquals(0, (int)c.next());
        c.skip(0L);
        this.assertEquals(2, (int)c.next());
        c.skip(1L);
        this.assertEquals(6, (int)c.next());
        c.skip(20L);
        this.assertEquals(48, (int)c.next());
        c = map.cursor(0);
        c.skip(20L);
        this.assertEquals(40, (int)c.next());
        c = map.cursor(0);
        this.assertEquals(0, (int)c.next());
        this.assertEquals(12, map.keyList().indexOf(24));
        this.assertEquals(24, (int)((Integer)map.keyList().get(12)));
        this.assertEquals(-14, map.keyList().indexOf(25));
        this.assertEquals(map.size(), map.keyList().size());
    }

    private void testIndexSkipReverse() {
        MVStore s = TestMVStore.openStore(null, 4);
        MVMap<Integer, Integer> map = s.openMap("test");
        int i = 0;
        while (i < 100) {
            map.put(i, 10 * i);
            i += 2;
        }
        Cursor c = map.cursor(50, null, true);
        c.skip(10L);
        int i2 = 30;
        while (i2 >= 0) {
            this.assertTrue(c.hasNext());
            this.assertEquals(i2, (int)c.next());
            i2 -= 2;
        }
        this.assertFalse(c.hasNext());
    }

    private void testMinMaxNextKey() {
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (MVStore s = TestMVStore.openStore(null);){
            MVMap<Integer, Integer> map = s.openMap("test");
            map.put(10, 100);
            map.put(20, 200);
            this.assertEquals(10, (int)((Integer)map.firstKey()));
            this.assertEquals(20, (int)((Integer)map.lastKey()));
            this.assertEquals(20, (int)map.ceilingKey(15));
            this.assertEquals(20, (int)map.ceilingKey(20));
            this.assertEquals(10, (int)map.floorKey(15));
            this.assertEquals(10, (int)map.floorKey(10));
            this.assertEquals(20, (int)map.higherKey(10));
            this.assertEquals(10, (int)map.lowerKey(20));
            this.assertEquals(10, (int)map.ceilingKey(null));
            this.assertEquals(10, (int)map.higherKey(null));
            this.assertNull(map.lowerKey(null));
            this.assertNull(map.floorKey(null));
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        int i = 3;
        while (i < 20) {
            throwable2 = null;
            Object var3_7 = null;
            try (MVStore s = TestMVStore.openStore(null, 4);){
                MVMap<Integer, Integer> map = s.openMap("test");
                int j = 3;
                while (j < i) {
                    map.put(j * 2, j * 20);
                    ++j;
                }
                if (i == 3) {
                    this.assertNull(map.firstKey());
                    this.assertNull(map.lastKey());
                } else {
                    this.assertEquals(6, (int)((Integer)map.firstKey()));
                    int max = (i - 1) * 2;
                    this.assertEquals(max, (int)((Integer)map.lastKey()));
                    int j2 = 0;
                    while (j2 < i * 2 + 2) {
                        if (j2 > max) {
                            this.assertNull(map.ceilingKey(j2));
                        } else {
                            int ceiling = Math.max((j2 + 1) / 2 * 2, 6);
                            this.assertEquals(ceiling, (int)map.ceilingKey(j2));
                        }
                        int floor = Math.min(max, Math.max(j2 / 2 * 2, 4));
                        if (floor < 6) {
                            this.assertNull(map.floorKey(j2));
                        } else {
                            map.floorKey(j2);
                        }
                        int lower = Math.min(max, Math.max((j2 - 1) / 2 * 2, 4));
                        if (lower < 6) {
                            this.assertNull(map.lowerKey(j2));
                        } else {
                            this.assertEquals(lower, (int)map.lowerKey(j2));
                        }
                        int higher = Math.max((j2 + 2) / 2 * 2, 6);
                        if (higher > max) {
                            this.assertNull(map.higherKey(j2));
                        } else {
                            this.assertEquals(higher, (int)map.higherKey(j2));
                        }
                        ++j2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            ++i;
        }
    }

    private void testStoreVersion() {
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore store = MVStore.open(fileName);
        this.assertEquals(0L, store.getCurrentVersion());
        this.assertEquals(0, store.getStoreVersion());
        store.setStoreVersion(0);
        store.commit();
        store.setStoreVersion(1);
        store.closeImmediately();
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            s = MVStore.open(fileName);
            try {
                this.assertEquals(1L, s.getCurrentVersion());
                this.assertEquals(0, s.getStoreVersion());
                s.setStoreVersion(1);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            s = MVStore.open(fileName);
            try {
                this.assertEquals(2L, s.getCurrentVersion());
                this.assertEquals(1, s.getStoreVersion());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testIterateOldVersion() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = new MVStore.Builder().open();){
            MVMap<Integer, Integer> map = s.openMap("test");
            int len = 100;
            int i = 0;
            while (i < len) {
                map.put(i, 10 * i);
                ++i;
            }
            int count = 0;
            MVStore.TxCounter txCounter = s.registerVersionUsage();
            try {
                Iterator it = map.keySet().iterator();
                s.commit();
                int i2 = 0;
                while (i2 < len) {
                    map.remove(i2);
                    i2 += 2;
                }
                while (it.hasNext()) {
                    it.next();
                    ++count;
                }
            }
            finally {
                s.deregisterVersionUsage(txCounter);
            }
            this.assertEquals(len, count);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testObjects() {
        MVMap<Object, Object> map;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = new MVStore.Builder().fileName(fileName).open();
            try {
                map = s.openMap("test");
                map.put(1, "Hello");
                map.put("2", 200);
                map.put(new Object[1], new Object[]{1, "2"});
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = new MVStore.Builder().fileName(fileName).open();
            try {
                map = s.openMap("test");
                this.assertEquals("Hello", map.get(1).toString());
                this.assertEquals(200, (int)((Integer)map.get("2")));
                Object[] x = (Object[])map.get(new Object[1]);
                this.assertEquals(2, x.length);
                this.assertEquals(1, (int)((Integer)x[0]));
                this.assertEquals("2", (String)x[1]);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testExample() {
        MVMap<Integer, String> map;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = MVStore.open(fileName);
            try {
                map = s.openMap("data");
                map.put(1, "Hello World");
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = MVStore.open(fileName);
            try {
                map = s.openMap("data");
                this.assertEquals("Hello World", (String)map.get(1));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testExampleMvcc() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = MVStore.open(fileName);){
            MVMap<Integer, String> map = s.openMap("data");
            map.put(1, "Hello");
            map.put(2, "World");
            long oldVersion = s.getCurrentVersion();
            s.commit();
            map.put(1, "Hi");
            map.remove(2);
            MVMap oldMap = map.openVersion(oldVersion);
            this.assertEquals("Hello", (String)oldMap.get(1));
            this.assertEquals("World", (String)oldMap.get(2));
            this.assertEquals("Hi", (String)map.get(1));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testOpenStoreCloseLoop() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        int k = 0;
        while (k < 1) {
            int j = 0;
            while (j < 3) {
                Throwable throwable = null;
                Object var5_6 = null;
                try (MVStore s = TestMVStore.openStore(fileName);){
                    MVMap<String, Integer> m = s.openMap("data");
                    int i = 0;
                    while (i < 3) {
                        Integer x = (Integer)m.get("value");
                        m.put("value", x == null ? 0 : x + 1);
                        s.commit();
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++j;
            }
            ++k;
        }
    }

    private void testOldVersion() {
        int op = 0;
        while (op <= 1) {
            int i = 0;
            while (i < 5) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (MVStore s = TestMVStore.openStore(null);){
                    s.setVersionsToKeep(Integer.MAX_VALUE);
                    MVMap<String, CallSite> m = s.openMap("data");
                    int j = 0;
                    while (j < 5) {
                        if (op == 1) {
                            m.put("1", (CallSite)((Object)("" + s.getCurrentVersion())));
                        }
                        s.commit();
                        ++j;
                    }
                    j = 0;
                    while ((long)j < s.getCurrentVersion()) {
                        MVMap old = m.openVersion(j);
                        if (op == 1) {
                            this.assertEquals("" + j, (String)old.get("1"));
                        }
                        ++j;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++i;
            }
            ++op;
        }
    }

    private void testVersion() {
        MVMap<Object, String> m;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                s.setVersionsToKeep(100);
                s.setAutoCommitDelay(0);
                s.setRetentionTime(Integer.MAX_VALUE);
                m = s.openMap("data");
                s.commit();
                long first = s.getCurrentVersion();
                this.assertEquals(1L, first);
                m.put("0", "test");
                s.commit();
                m.put("1", "Hello");
                m.put("2", "World");
                int i = 10;
                while (i < 20) {
                    m.put("" + i, "data");
                    ++i;
                }
                long old = s.getCurrentVersion();
                s.commit();
                m.put("1", "Hallo");
                m.put("2", "Welt");
                MVMap mFirst = m.openVersion(first);
                this.assertEquals(1, mFirst.size());
                this.assertEquals("Hallo", (String)m.get("1"));
                this.assertEquals("Welt", (String)m.get("2"));
                MVMap mOld = m.openVersion(old);
                this.assertEquals("Hello", (String)mOld.get("1"));
                this.assertEquals("World", (String)mOld.get("2"));
                this.assertTrue(mOld.isReadOnly());
                long old3 = s.getCurrentVersion();
                this.assertEquals(3L, old3);
                s.commit();
                this.assertEquals("Hello", (String)mOld.get("1"));
                this.assertEquals("World", (String)mOld.get("2"));
                mOld = m.openVersion(old3);
                this.assertEquals("Hallo", (String)mOld.get("1"));
                this.assertEquals("Welt", (String)mOld.get("2"));
                m.put("1", "Hi");
                this.assertEquals("Welt", (String)m.remove("2"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("data");
                this.assertEquals("Hi", (String)m.get("1"));
                this.assertEquals(null, (String)m.get("2"));
                this.assertThrows(IllegalArgumentException.class, () -> m.openVersion(-3L));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testTruncateFile() {
        Object s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                MVMap<Integer, String> m = ((MVStore)s).openMap("data");
                String data = new String(new char[10000]).replace('\u0000', 'x');
                int i = 1;
                while (i < 10) {
                    m.put(i, data);
                    ((MVStore)s).commit();
                    ++i;
                }
            }
            finally {
                if (s != null) {
                    ((MVStore)s).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        long len = FileUtils.size(fileName);
        s = null;
        Object var5_10 = null;
        try (MVStore s2 = TestMVStore.openStore(fileName);){
            s2.setRetentionTime(0);
            s2.setVersionsToKeep(0);
            s2.setAutoCommitDelay(0);
            MVMap m = s2.openMap("data");
            int i = 0;
            while (i < 10) {
                if (i % 4 != 0) {
                    TestMVStore.sleep(2L);
                    m.remove(i);
                    s2.commit();
                }
                ++i;
            }
            this.assertTrue(s2.compact(100, 51200));
            TestMVStore.compactMoveChunks(s2);
        }
        catch (Throwable throwable3) {
            if (s == null) {
                s = throwable3;
            } else if (s != throwable3) {
                ((Throwable)s).addSuppressed(throwable3);
            }
            throw s;
        }
        long len2 = FileUtils.size(fileName);
        this.assertTrue("len2: " + len2 + " len: " + len, len2 < len);
    }

    private void testFastDelete() {
        MVMap<Integer, String> m;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName, 700);
            try {
                m = s.openMap("data");
                int i = 0;
                while (i < 1000) {
                    m.put(i, "Hello World");
                    this.assertEquals(i + 1, m.size());
                    ++i;
                }
                this.assertEquals(1000, m.size());
                this.assertEquals(93832, s.getUnsavedMemory());
                s.commit();
                this.assertEquals(2L, s.getFileStore().getWriteCount());
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("data");
                m.clear();
                this.assertEquals(0, m.size());
                s.commit();
                this.assertEquals(7L, s.getFileStore().getReadCount());
                this.assertTrue(s.getFileStore().getWriteCount() < 5L);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testRollback() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            MVMap<Integer, Integer> m = s.openMap("m");
            m.put(1, -1);
            s.commit();
            int i = 0;
            while (i < 10) {
                m.put(1, i);
                s.rollback();
                this.assertEquals(i - 1, (int)((Integer)m.get(1)));
                m.put(1, i);
                s.commit();
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testRollbackStored() {
        MVMap<String, String> m;
        long v3;
        MVStore s;
        long v2;
        MVStore s2;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            s2 = TestMVStore.openStore(fileName);
            try {
                this.assertEquals(45000, s2.getRetentionTime());
                s2.setRetentionTime(0);
                this.assertEquals(0, s2.getRetentionTime());
                s2.setRetentionTime(45000);
                this.assertEquals(45000, s2.getRetentionTime());
                this.assertEquals(0L, s2.getCurrentVersion());
                this.assertFalse(s2.hasUnsavedChanges());
                MVMap<String, String> m2 = s2.openMap("data");
                this.assertTrue(s2.hasUnsavedChanges());
                MVMap m0 = s2.openMap("data0");
                m2.put("1", "Hello");
                this.assertEquals(1L, s2.commit());
                s2.rollbackTo(1L);
                this.assertEquals(1L, s2.getCurrentVersion());
                this.assertEquals("Hello", (String)m2.get("1"));
                m2.put("1", "Hello");
                v2 = s2.commit();
                this.assertEquals(2L, v2);
                this.assertEquals(2L, s2.getCurrentVersion());
                this.assertFalse(s2.hasUnsavedChanges());
                this.assertEquals("Hello", (String)m2.get("1"));
            }
            finally {
                if (s2 != null) {
                    s2.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_6 = null;
        try {
            s2 = TestMVStore.openStore(fileName);
            try {
                s2.setRetentionTime(45000);
                this.assertEquals(2L, s2.getCurrentVersion());
                MVMap<String, String> meta = s2.getMetaMap();
                MVMap<String, String> m3 = s2.openMap("data");
                this.assertFalse(s2.hasUnsavedChanges());
                this.assertEquals("Hello", (String)m3.get("1"));
                MVMap<String, String> m0 = s2.openMap("data0");
                MVMap<String, String> m1 = s2.openMap("data1");
                m3.put("1", "Hallo");
                m0.put("1", "Hallo");
                m1.put("1", "Hallo");
                this.assertEquals("Hallo", (String)m3.get("1"));
                this.assertEquals("Hallo", (String)m1.get("1"));
                this.assertTrue(s2.hasUnsavedChanges());
                s2.rollbackTo(v2);
                this.assertFalse(s2.hasUnsavedChanges());
                this.assertNull(meta.get("name.data1"));
                this.assertNull(m0.get("1"));
                this.assertEquals("Hello", (String)m3.get("1"));
                this.assertEquals(-1L, s2.commit());
            }
            finally {
                if (s2 != null) {
                    s2.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        Throwable throwable4 = null;
        Object var7_14 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                s.setRetentionTime(45000);
                this.assertEquals(2L, s.getCurrentVersion());
                MVMap<String, String> meta = s.getMetaMap();
                this.assertNotNull(meta.get("name.data"));
                this.assertNotNull(meta.get("name.data0"));
                this.assertNull(meta.get("name.data1"));
                MVMap<String, String> m4 = s.openMap("data");
                MVMap m0 = s.openMap("data0");
                this.assertNull(m0.get("1"));
                this.assertEquals("Hello", (String)m4.get("1"));
                this.assertFalse(m0.isReadOnly());
                m4.put("1", "Hallo");
                s.commit();
                v3 = s.getCurrentVersion();
                this.assertEquals(3L, v3);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable4 == null) {
                throwable4 = throwable5;
            } else if (throwable4 != throwable5) {
                throwable4.addSuppressed(throwable5);
            }
            throw throwable4;
        }
        throwable4 = null;
        var7_14 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                s.setRetentionTime(45000);
                this.assertEquals(3L, s.getCurrentVersion());
                m = s.openMap("data");
                m.put("1", "Hi");
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable4 == null) {
                throwable4 = throwable6;
            } else if (throwable4 != throwable6) {
                throwable4.addSuppressed(throwable6);
            }
            throw throwable4;
        }
        throwable4 = null;
        var7_14 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                s.setRetentionTime(45000);
                m = s.openMap("data");
                this.assertEquals("Hi", (String)m.get("1"));
                s.rollbackTo(v3);
                this.assertEquals("Hallo", (String)m.get("1"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable4 == null) {
                throwable4 = throwable7;
            } else if (throwable4 != throwable7) {
                throwable4.addSuppressed(throwable7);
            }
            throw throwable4;
        }
        throwable4 = null;
        var7_14 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                s.setRetentionTime(45000);
                m = s.openMap("data");
                this.assertEquals("Hallo", (String)m.get("1"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable8) {
            if (throwable4 == null) {
                throwable4 = throwable8;
            } else if (throwable4 != throwable8) {
                throwable4.addSuppressed(throwable8);
            }
            throw throwable4;
        }
    }

    private void testRollbackInMemory() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = TestMVStore.openStore(fileName, 5);){
            s.setAutoCommitDelay(0);
            this.assertEquals(0L, s.getCurrentVersion());
            MVMap<String, String> m = s.openMap("data");
            s.rollbackTo(0L);
            this.assertTrue(m.isClosed());
            this.assertEquals(0L, s.getCurrentVersion());
            m = s.openMap("data");
            MVMap<String, String> m0 = s.openMap("data0");
            MVMap<CallSite, String> m2 = s.openMap("data2");
            m.put("1", "Hello");
            int i = 0;
            while (i < 10) {
                m2.put((CallSite)((Object)("" + i)), "Test");
                ++i;
            }
            long v1 = s.commit();
            this.assertEquals(1L, v1);
            this.assertEquals(1L, s.getCurrentVersion());
            MVMap<String, String> m1 = s.openMap("data1");
            this.assertEquals("Test", (String)m2.get("1"));
            m.put("1", "Hallo");
            m0.put("1", "Hallo");
            m1.put("1", "Hallo");
            m2.clear();
            this.assertEquals("Hallo", (String)m.get("1"));
            this.assertEquals("Hallo", (String)m1.get("1"));
            s.rollbackTo(v1);
            this.assertEquals(1L, s.getCurrentVersion());
            int i2 = 0;
            while (i2 < 10) {
                this.assertEquals("Test", (String)m2.get("" + i2));
                ++i2;
            }
            this.assertEquals("Hello", (String)m.get("1"));
            this.assertNull(m0.get("1"));
            this.assertTrue(m1.isClosed());
            this.assertFalse(m0.isReadOnly());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testMeta() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = TestMVStore.openStore(fileName);){
            s.setRetentionTime(Integer.MAX_VALUE);
            Map<String, String> m = s.getMetaMap();
            this.assertEquals("[]", s.getMapNames().toString());
            MVMap<String, String> data = s.openMap("data");
            data.put("1", "Hello");
            data.put("2", "World");
            s.commit();
            this.assertEquals(1L, s.getCurrentVersion());
            this.assertEquals("[data]", s.getMapNames().toString());
            this.assertEquals("data", s.getMapName(data.getId()));
            this.assertNull(s.getMapName(s.getMetaMap().getId()));
            this.assertNull(s.getMapName(data.getId() + 1));
            String id = s.getMetaMap().get("name.data");
            this.assertEquals("name:data", (String)m.get("map." + id));
            this.assertEquals("Hello", data.put("1", "Hallo"));
            s.commit();
            this.assertEquals("name:data", (String)m.get("map." + id));
            m = s.getLayoutMap();
            this.assertTrue(m.get("root." + id).length() > 0);
            this.assertTrue(m.containsKey("chunk.1"));
            this.assertEquals(2L, s.getCurrentVersion());
            s.rollbackTo(1L);
            this.assertEquals("Hello", (String)data.get("1"));
            this.assertEquals("World", (String)data.get("2"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testInMemory() {
        int j = 0;
        while (j < 1) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (MVStore s = TestMVStore.openStore(null);){
                int len = 100;
                MVMap<Integer, String> m = s.openMap("data");
                int i = 0;
                while (i < len) {
                    this.assertNull(m.put(i, "Hello World"));
                    ++i;
                }
                i = 0;
                while (i < len) {
                    this.assertEquals("Hello World", (String)m.get(i));
                    ++i;
                }
                i = 0;
                while (i < len) {
                    this.assertEquals("Hello World", (String)m.remove(i));
                    ++i;
                }
                this.assertEquals(null, (String)m.get(0));
                this.assertEquals(0, m.size());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++j;
        }
    }

    private void testLargeImport() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        int len = 1000;
        int j = 0;
        while (j < 5) {
            FileUtils.delete(fileName);
            Throwable throwable = null;
            Object var5_6 = null;
            try (MVStore s = TestMVStore.openStore(fileName, 40);){
                Object m = s.openMap("data", new MVMap.Builder().valueType((DataType)new RowDataType(new DataType[]{new ObjectDataType(), StringDataType.INSTANCE, StringDataType.INSTANCE})));
                int i = 0;
                while (i < len) {
                    Object[] o = new Object[]{i, "Hello World", "World"};
                    ((MVMap)m).put(i, (Object[])o);
                    if (++i % 10000 != 0) continue;
                    s.commit();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++j;
        }
    }

    private void testBtreeStore() {
        int i;
        MVMap<Integer, CallSite> m;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore store = TestMVStore.openStore(fileName);
        store.close();
        int count = 2000;
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("data");
                i = 0;
                while (i < count) {
                    this.assertNull(m.put(i, (CallSite)((Object)("hello " + i))));
                    this.assertEquals("hello " + i, (String)m.get(i));
                    ++i;
                }
                s.commit();
                this.assertEquals("hello 0", (String)m.remove(0));
                this.assertNull(m.get(0));
                i = 1;
                while (i < count) {
                    this.assertEquals("hello " + i, (String)m.get(i));
                    ++i;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_7 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("data");
                this.assertNull(m.get(0));
                i = 1;
                while (i < count) {
                    this.assertEquals("hello " + i, (String)m.get(i));
                    ++i;
                }
                i = 1;
                while (i < count) {
                    m.remove(i);
                    ++i;
                }
                s.commit();
                this.assertNull(m.get(0));
                i = 0;
                while (i < count) {
                    this.assertNull(m.get(i));
                    ++i;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testCompactMapNotOpen() {
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        int factor = 100;
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            s = TestMVStore.openStore(fileName, 1000);
            try {
                s.setAutoCommitDelay(0);
                MVMap<Integer, CallSite> m = s.openMap("data");
                int j = 0;
                while (j < 10) {
                    int i = j * factor;
                    while (i < 10 * factor) {
                        m.put(i, (CallSite)((Object)("Hello" + j)));
                        ++i;
                    }
                    s.commit();
                    ++j;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                s.setAutoCommitDelay(0);
                s.setRetentionTime(0);
                s.setVersionsToKeep(0);
                int chunkCount1 = TestMVStore.getChunkCount(s);
                s.compact(80, 1);
                s.compact(80, 1);
                int chunkCount2 = TestMVStore.getChunkCount(s);
                this.assertTrue(chunkCount2 >= chunkCount1);
                MVMap m = s.openMap("data");
                int i = 0;
                while (i < 10) {
                    boolean result = s.compact(50, 51200);
                    s.commit();
                    if (!result) break;
                    ++i;
                }
                this.assertFalse(s.compact(50, 1024));
                TestMVStore.compactMoveChunks(s);
                int chunkCount3 = TestMVStore.getChunkCount(s);
                this.assertTrue(chunkCount1 + " >= " + chunkCount2 + " > " + chunkCount3, chunkCount3 < chunkCount1);
                int i2 = 0;
                while (i2 < 10 * factor) {
                    this.assertEquals("x" + i2, "Hello" + i2 / factor, (String)m.get(i2));
                    ++i2;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static int getChunkCount(MVStore s) {
        Map<String, String> layout = s.getLayoutMap();
        int chunkCount = 0;
        for (String k : layout.keySet()) {
            if (!k.startsWith("chunk.")) continue;
            ++chunkCount;
        }
        return chunkCount;
    }

    private void testCompact() {
        MVMap m;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        long initialLength = 0L;
        int j = 0;
        while (j < 20) {
            TestMVStore.sleep(2L);
            Throwable throwable = null;
            Object var6_13 = null;
            try (MVStore s2 = TestMVStore.openStore(fileName);){
                s2.setRetentionTime(0);
                s2.setVersionsToKeep(0);
                MVMap<Integer, CallSite> m2 = s2.openMap("data");
                int i = 0;
                while (i < 100) {
                    m2.put(j + i, (CallSite)((Object)("Hello " + j)));
                    ++i;
                }
                FileStore<?> fileStore = s2.getFileStore();
                this.assertNotNull(fileStore);
                this.trace("Before - fill rate: " + s2.getFillRate() + "%, chunks fill rate: " + fileStore.getChunksFillRate() + ", len: " + FileUtils.size(fileName));
                s2.compact(80, 2048);
                TestMVStore.compactMoveChunks(s2);
                this.trace("After  - fill rate: " + s2.getFillRate() + "%, chunks fill rate: " + fileStore.getChunksFillRate() + ", len: " + FileUtils.size(fileName));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            long len = FileUtils.size(fileName);
            if (initialLength == 0L) {
                initialLength = len;
            } else {
                this.assertTrue("initial: " + initialLength + " len: " + len, len <= initialLength * 3L);
            }
            ++j;
        }
        Throwable throwable = null;
        Object var5_10 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("data");
                int i = 0;
                while (i < 100) {
                    m.remove(i);
                    ++i;
                }
                s.compact(80, 1024);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var5_10 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("data");
                s.compact(80, 1024);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void testReuseSpace() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        long initialLength = 0L;
        int j = 0;
        while (j < 20) {
            TestMVStore.sleep(2L);
            Throwable throwable = null;
            Object var6_7 = null;
            try (MVStore s = TestMVStore.openStore(fileName);){
                s.setRetentionTime(0);
                s.setVersionsToKeep(0);
                MVMap<Integer, String> m = s.openMap("data");
                int i = 0;
                while (i < 10) {
                    m.put(i, "Hello");
                    ++i;
                }
                s.commit();
                i = 0;
                while (i < 10) {
                    this.assertEquals("Hello", (String)m.get(i));
                    this.assertEquals("Hello", (String)m.remove(i));
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            long len = FileUtils.size(fileName);
            if (initialLength == 0L) {
                initialLength = len;
            } else {
                this.assertTrue("len: " + len + " initial: " + initialLength + " j: " + j, len <= initialLength * 3L);
            }
            ++j;
        }
    }

    private void testRandom() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = TestMVStore.openStore(fileName);){
            MVMap<Integer, Integer> m = s.openMap("data");
            TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
            Random r = new Random(1L);
            int operationCount = 1000;
            int maxValue = 30;
            int i = 0;
            while (i < operationCount) {
                boolean compareAll;
                Integer got;
                Integer expected;
                int k = r.nextInt(maxValue);
                int v = r.nextInt();
                switch (r.nextInt(3)) {
                    case 0: {
                        TestMVStore.log(i + ": put " + k + " = " + v);
                        expected = map.put(k, v);
                        got = m.put(k, v);
                        if (expected == null) {
                            this.assertNull(got);
                        } else {
                            this.assertEquals(expected, got);
                        }
                        compareAll = true;
                        break;
                    }
                    case 1: {
                        TestMVStore.log(i + ": remove " + k);
                        expected = (Integer)map.remove(k);
                        got = (Integer)m.remove(k);
                        if (expected == null) {
                            this.assertNull(got);
                        } else {
                            this.assertEquals(expected, got);
                        }
                        compareAll = true;
                        break;
                    }
                    default: {
                        Integer a = (Integer)map.get(k);
                        Integer b = (Integer)m.get(k);
                        if (a == null || b == null) {
                            this.assertTrue(a == b);
                        } else {
                            this.assertEquals((int)a, (int)b);
                        }
                        compareAll = false;
                    }
                }
                if (compareAll) {
                    Iterator<Object> it = m.keyIterator(null);
                    for (Integer integer : map.keySet()) {
                        this.assertTrue(it.hasNext());
                        expected = integer;
                        got = it.next();
                        this.assertEquals(expected, got);
                    }
                    this.assertFalse(it.hasNext());
                }
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testKeyValueClasses() {
        MVMap<String, String> ss;
        MVMap<String, Integer> si;
        MVMap<Integer, Integer> ii;
        MVMap<Integer, String> is;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                is = s.openMap("intString");
                is.put(1, "Hello");
                ii = s.openMap("intInt");
                ii.put(1, 10);
                si = s.openMap("stringInt");
                si.put("Test", 10);
                ss = s.openMap("stringString");
                ss.put("Hello", "World");
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                is = s.openMap("intString");
                this.assertEquals("Hello", (String)is.get(1));
                ii = s.openMap("intInt");
                this.assertEquals(10, (int)((Integer)ii.get(1)));
                si = s.openMap("stringInt");
                this.assertEquals(10, (int)((Integer)si.get("Test")));
                ss = s.openMap("stringString");
                this.assertEquals("World", (String)ss.get("Hello"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testIterate() {
        int size = this.config.big ? 1000 : 10;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var4_5 = null;
        try (MVStore s = TestMVStore.openStore(fileName);){
            MVMap<Integer, CallSite> m = s.openMap("data");
            Iterator<Object> it = m.keyIterator(null);
            this.assertFalse(it.hasNext());
            int i = 0;
            while (i < size) {
                m.put(i, (CallSite)((Object)("hello " + i)));
                ++i;
            }
            s.commit();
            it = m.keyIterator(null);
            it.next();
            this.assertThrows(UnsupportedOperationException.class, it).remove();
            it = m.keyIterator(null);
            i = 0;
            while (i < size) {
                this.assertTrue(it.hasNext());
                this.assertEquals(i, (int)it.next());
                ++i;
            }
            this.assertFalse(it.hasNext());
            this.assertThrows(NoSuchElementException.class, it).next();
            int j = 0;
            while (j < size) {
                it = m.keyIterator(j);
                int i2 = j;
                while (i2 < size) {
                    this.assertTrue(it.hasNext());
                    this.assertEquals(i2, (int)((Integer)it.next()));
                    ++i2;
                }
                this.assertFalse(it.hasNext());
                ++j;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testIterateReverse() {
        int size = this.config.big ? 1000 : 10;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var4_5 = null;
        try (MVStore s = TestMVStore.openStore(fileName);){
            MVMap<Integer, CallSite> m = s.openMap("data");
            int i = 0;
            while (i < size) {
                m.put(i, (CallSite)((Object)("hello " + i)));
                ++i;
            }
            s.commit();
            Iterator<Object> it = m.keyIteratorReverse(null);
            it.next();
            this.assertThrows(UnsupportedOperationException.class, it).remove();
            it = m.keyIteratorReverse(null);
            int i2 = size - 1;
            while (i2 >= 0) {
                this.assertTrue(it.hasNext());
                this.assertEquals(i2, (int)it.next());
                --i2;
            }
            this.assertFalse(it.hasNext());
            this.assertThrows(NoSuchElementException.class, it).next();
            int j = 0;
            while (j < size) {
                it = m.keyIteratorReverse(j);
                int i3 = j;
                while (i3 >= 0) {
                    this.assertTrue(it.hasNext());
                    this.assertEquals(i3, (int)((Integer)it.next()));
                    --i3;
                }
                this.assertFalse(it.hasNext());
                ++j;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCloseTwice() {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore s = TestMVStore.openStore(fileName);
        MVMap<Integer, CallSite> m = s.openMap("data");
        int i = 0;
        while (i < 3) {
            m.put(i, (CallSite)((Object)("hello " + i)));
            ++i;
        }
        s.close();
        s.close();
    }

    private void testSimple() {
        int i;
        MVMap<Integer, CallSite> m;
        MVStore s;
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("data");
                i = 0;
                while (i < 3) {
                    m.put(i, (CallSite)((Object)("hello " + i)));
                    ++i;
                }
                s.commit();
                this.assertEquals("hello 0", (String)m.remove(0));
                this.assertNull(m.get(0));
                i = 1;
                while (i < 3) {
                    this.assertEquals("hello " + i, (String)m.get(i));
                    ++i;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var3_5 = null;
        try {
            s = TestMVStore.openStore(fileName);
            try {
                m = s.openMap("data");
                this.assertNull(m.get(0));
                i = 1;
                while (i < 3) {
                    this.assertEquals("hello " + i, (String)m.get(i));
                    ++i;
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testInvalidSettings() {
        this.assertThrows(IllegalArgumentException.class, () -> new MVStore.Builder().fileName("test").fileStore(new OffHeapStore()).open());
    }

    private void testLargerThan2G() {
        if (!this.config.big) {
            return;
        }
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore store = new MVStore.Builder().cacheSize(16).fileName(fileName).open();
        try {
            MVMap<Integer, String> map = store.openMap("test");
            long last = System.nanoTime();
            String data = new String(new char[2500]).replace('\u0000', 'x');
            int i = 0;
            while (true) {
                map.put(i, data);
                if (i % 10000 == 0) {
                    store.commit();
                    long time = System.nanoTime();
                    if (time - last > TimeUnit.SECONDS.toNanos(2L)) {
                        long mb = store.getFileStore().size() / 1024L / 1024L;
                        this.trace(mb + "/4500");
                        if (mb > 4500L) break;
                        last = time;
                    }
                }
                ++i;
            }
            store.commit();
            store.close();
        }
        finally {
            store.closeImmediately();
        }
        FileUtils.delete(fileName);
    }

    protected static MVStore openStore(String fileName) {
        return TestMVStore.openStore(fileName, 1000);
    }

    protected static MVStore openStore(String fileName, int pageSplitSize) {
        MVStore store = new MVStore.Builder().fileName(fileName).pageSplitSize(pageSplitSize).open();
        return store;
    }

    protected static void log(String msg) {
    }
}

