/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.test.TestBase;

public class TestMVStoreBenchmark
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.traceTest = true;
        test.config.big = true;
        test.test();
    }

    @Override
    public boolean isEnabled() {
        if (!this.config.big) {
            return false;
        }
        return !this.config.codeCoverage;
    }

    @Override
    public void test() throws Exception {
        this.testPerformanceComparison();
        this.testMemoryUsageComparison();
    }

    private void testMemoryUsageComparison() {
        long[] mem = this.getMemoryUsed(10000, 10);
        long hash = mem[0];
        long tree = mem[1];
        long mv = mem[2];
        String msg = Arrays.toString(mem);
        this.assertTrue(msg, hash < mv);
        this.assertTrue(msg, tree < mv);
        mem = this.getMemoryUsed(10000, 30);
        hash = mem[0];
        tree = mem[1];
        mv = mem[2];
        msg = Arrays.toString(mem);
        this.assertTrue(msg, mv < hash);
        this.assertTrue(msg, mv < tree);
    }

    private long[] getMemoryUsed(int count, int size) {
        ArrayList<Map<Integer, String>> mapList = new ArrayList<Map<Integer, String>>(count);
        long mem = TestMVStoreBenchmark.getMemory();
        int i = 0;
        while (i < count) {
            mapList.add(new ConcurrentHashMap(size));
            ++i;
        }
        TestMVStoreBenchmark.addEntries(mapList, size);
        long hash = TestMVStoreBenchmark.getMemory() - mem;
        mapList.size();
        mapList.clear();
        mem = TestMVStoreBenchmark.getMemory();
        i = 0;
        while (i < count) {
            mapList.add(new ConcurrentSkipListMap());
            ++i;
        }
        TestMVStoreBenchmark.addEntries(mapList, size);
        long tree = TestMVStoreBenchmark.getMemory() - mem;
        mapList.size();
        mapList.clear();
        mem = TestMVStoreBenchmark.getMemory();
        MVStore store = MVStore.open(null);
        int i2 = 0;
        while (i2 < count) {
            MVMap map = store.openMap("t" + i2);
            mapList.add(map);
            ++i2;
        }
        TestMVStoreBenchmark.addEntries(mapList, size);
        long mv = TestMVStoreBenchmark.getMemory() - mem;
        mapList.size();
        this.trace("hash: " + hash / 1024L / 1024L + " mb");
        this.trace("tree: " + tree / 1024L / 1024L + " mb");
        this.trace("mv: " + mv / 1024L / 1024L + " mb");
        return new long[]{hash, tree, mv};
    }

    private static void addEntries(List<Map<Integer, String>> mapList, int size) {
        for (Map<Integer, String> map : mapList) {
            int i = 0;
            while (i < size) {
                map.put(i, "Hello World");
                ++i;
            }
        }
    }

    static long getMemory() {
        int i = 0;
        while (i < 16) {
            System.gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
        return TestMVStoreBenchmark.getMemoryUsedBytes();
    }

    private void testPerformanceComparison() {
        if (!this.config.big) {
            return;
        }
        int size = 1000000;
        long hash = 0L;
        long tree = 0L;
        long mv = 0L;
        int i = 0;
        while (i < 5) {
            MVStore store = MVStore.open(null);
            AbstractMap map = store.openMap("test");
            mv = this.testPerformance(map, size);
            store.close();
            map = new ConcurrentHashMap(size);
            hash = this.testPerformance(map, size);
            map = new ConcurrentSkipListMap();
            tree = this.testPerformance(map, size);
            if (hash < tree && (double)mv < (double)tree * 1.5) break;
            ++i;
        }
        String msg = "mv " + mv + " tree " + tree + " hash " + hash;
        this.assertTrue(msg, hash < tree);
        this.assertTrue(msg, mv < tree * 2L);
    }

    private long testPerformance(Map<Integer, String> map, int size) {
        System.gc();
        long time = 0L;
        int t = 0;
        while (t < 3) {
            time = System.nanoTime();
            int b = 0;
            while (b < 3) {
                int i = 0;
                while (i < size) {
                    map.put(i, "Hello World");
                    ++i;
                }
                int a = 0;
                while (a < 5) {
                    int i2 = 0;
                    while (i2 < size) {
                        String x = map.get(i2);
                        this.assertNotNull(x);
                        ++i2;
                    }
                    ++a;
                }
                i = 0;
                while (i < size) {
                    map.remove(i);
                    ++i;
                }
                this.assertEquals(0, map.size());
                ++b;
            }
            time = System.nanoTime() - time;
            ++t;
        }
        this.trace(map.getClass().getName() + ": " + TimeUnit.NANOSECONDS.toMillis(time));
        return time;
    }
}

