/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.h2.mvstore.Chunk;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.store.TestMVStore;
import org.h2.util.IOUtils;
import org.h2.util.Task;

public class TestMVStoreConcurrent
extends TestMVStore {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        FileUtils.createDirectories(this.getBaseDir());
        this.testInterruptReopenAsync();
        this.testInterruptReopenRetryNIO();
        this.testConcurrentSaveCompact();
        this.testConcurrentDataType();
        this.testConcurrentAutoCommitAndChange();
        this.testConcurrentReplaceAndRead();
        this.testConcurrentChangeAndCompact();
        TestMVStoreConcurrent.testConcurrentChangeAndGetVersion();
        this.testConcurrentFree();
        this.testConcurrentStoreAndRemoveMap();
        this.testConcurrentStoreAndClose();
        this.testConcurrentOnlineBackup();
        TestMVStoreConcurrent.testConcurrentMap();
        TestMVStoreConcurrent.testConcurrentIterate();
        this.testConcurrentWrite();
        TestMVStoreConcurrent.testConcurrentRead();
    }

    private void testInterruptReopenAsync() {
        this.testInterruptReopen("async:");
    }

    private void testInterruptReopenRetryNIO() {
        this.testInterruptReopen("retry:");
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testInterruptReopen(String prefix) {
        String fileName = prefix + this.getBaseDir() + "/" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore s = new MVStore.Builder().fileName(fileName).cacheSize(0).open();
        final Thread mainThread = Thread.currentThread();
        Task task = new Task(){

            @Override
            public void call() throws Exception {
                while (!this.stop) {
                    mainThread.interrupt();
                    Thread.sleep(10L);
                }
            }
        };
        try {
            block6: {
                int i;
                MVMap<Integer, byte[]> map;
                block5: {
                    map = s.openMap("data");
                    task.execute();
                    i = 0;
                    if (!true) break block5;
                    if (i >= 1000) return;
                    if (task.isFinished()) break block6;
                }
                do {
                    map.get(i % 1000);
                    map.put(i % 1000, new byte[1024]);
                    s.commit();
                    ++i;
                    if (i >= 1000) return;
                } while (!task.isFinished());
            }
            return;
        }
        finally {
            task.get();
            s.close();
        }
    }

    private void testConcurrentSaveCompact() {
        String fileName = "memFS:" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore.Builder builder = new MVStore.Builder().fileName(fileName).cacheSize(0);
        Throwable throwable = null;
        Object var4_5 = null;
        try (final MVStore s = builder.open();){
            s.setRetentionTime(0);
            final MVMap<Integer, Integer> dataMap = s.openMap("data");
            Task task = new Task(){

                @Override
                public void call() {
                    int i = 0;
                    while (!this.stop) {
                        s.compact(100, 0x100000);
                        MVStore.TxCounter token = s.registerVersionUsage();
                        try {
                            dataMap.put(i % 1000, i * 10);
                        }
                        finally {
                            s.deregisterVersionUsage(token);
                        }
                        s.commit();
                        ++i;
                    }
                }
            };
            task.execute();
            int i = 0;
            while (i < 1000 && !task.isFinished()) {
                s.compact(100, 0x100000);
                MVStore.TxCounter token = s.registerVersionUsage();
                try {
                    dataMap.put(i % 1000, i * 10);
                }
                finally {
                    s.deregisterVersionUsage(token);
                }
                s.commit();
                ++i;
            }
            task.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testConcurrentDataType() throws InterruptedException {
        type = new ObjectDataType();
        v0 = new Object[9];
        v0[1] = -1;
        v0[2] = 1;
        v0[3] = 10;
        v0[4] = "Hello";
        v1 = new Object[2];
        v1[0] = new byte[]{-1, 1};
        v0[5] = v1;
        v0[6] = new Object[]{new byte[]{1, -1}, 10};
        v0[7] = new Object[]{new byte[]{-1, 1}, 20L};
        v0[8] = new Object[]{new byte[]{1, -1}, 5};
        data = v0;
        Arrays.sort(data, type);
        tasks = new Task[2];
        i = 0;
        while (i < tasks.length) {
            tasks[i] = new Task(){

                @Override
                public void call() {
                    Random r = new Random();
                    WriteBuffer buff = new WriteBuffer();
                    while (!this.stop) {
                        int a = r.nextInt(data.length);
                        int b = r.nextInt(data.length);
                        int comp = r.nextBoolean() ? type.compare((Object)a, (Object)b) : -type.compare((Object)b, (Object)a);
                        buff.clear();
                        type.write(buff, (Object)a);
                        buff.clear();
                        type.write(buff, (Object)b);
                        if (a == b) {
                            TestMVStoreConcurrent.this.assertEquals(0, comp);
                            continue;
                        }
                        TestMVStoreConcurrent.this.assertEquals(a > b ? 1 : -1, comp);
                    }
                }
            };
            tasks[i].execute();
            ++i;
        }
        try {
            Thread.sleep(100L);
        }
        finally {
            var8_7 = tasks;
            var7_9 = tasks.length;
            var6_11 = 0;
            ** while (var6_11 < var7_9)
        }
lbl-1000:
        // 1 sources

        {
            t = var8_7[var6_11];
            t.get();
            ++var6_11;
            continue;
        }
lbl36:
        // 1 sources

    }

    private void testConcurrentAutoCommitAndChange() throws InterruptedException {
        String fileName = "memFS:" + this.getTestName();
        FileUtils.delete(fileName);
        MVStore.Builder builder = new MVStore.Builder().fileName(fileName).pageSplitSize(1000);
        Throwable throwable = null;
        Object var4_5 = null;
        try (final MVStore s = builder.open();){
            s.setRetentionTime(1000);
            s.setAutoCommitDelay(1);
            final CountDownLatch latch = new CountDownLatch(2);
            Task task = new Task(){

                @Override
                public void call() {
                    latch.countDown();
                    while (!this.stop) {
                        s.compact(100, 0x100000);
                    }
                }
            };
            final MVMap dataMap = s.openMap("data");
            final MVMap dataSmallMap = s.openMap("dataSmall");
            s.openMap("emptyMap");
            final AtomicInteger counter = new AtomicInteger();
            Task task2 = new Task(){

                @Override
                public void call() {
                    latch.countDown();
                    while (!this.stop) {
                        int i = counter.getAndIncrement();
                        dataMap.put(i, i * 10);
                        dataSmallMap.put(i % 100, i * 10);
                        if (i % 100 != 0) continue;
                        dataSmallMap.clear();
                    }
                }
            };
            task.execute();
            task2.execute();
            latch.await();
            int i = 0;
            while (!task.isFinished() && !task2.isFinished() && i < 1000) {
                MVMap<Integer, Integer> map = s.openMap("d" + i % 3);
                map.put(0, i);
                s.commit();
                ++i;
            }
            task.get();
            task2.get();
            i = 0;
            while (i < counter.get()) {
                this.assertEquals(10 * i, (int)((Integer)dataMap.get(i)));
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void testConcurrentReplaceAndRead() throws InterruptedException {
        final MVStore s = new MVStore.Builder().open();
        final MVMap<Integer, Integer> map = s.openMap("data");
        int i = 0;
        while (i < 100) {
            map.put(i, i % 100);
            ++i;
        }
        Task task = new Task(){

            @Override
            public void call() {
                int i = 0;
                while (!this.stop) {
                    map.put(i % 100, i % 100);
                    if (++i % 1000 != 0) continue;
                    s.commit();
                }
            }
        };
        task.execute();
        try {
            Thread.sleep(1L);
            int i2 = 0;
            while (!task.isFinished() && i2 < 1000000) {
                this.assertEquals(i2 % 100, (int)((Integer)map.get(i2 % 100)));
                ++i2;
            }
        }
        finally {
            task.get();
        }
        s.close();
    }

    private void testConcurrentChangeAndCompact() throws InterruptedException {
        String fileName = "memFS:" + this.getTestName();
        FileUtils.delete(fileName);
        s.setRetentionTime(10000);
        try (final MVStore s = new MVStore.Builder().fileName(fileName).pageSplitSize(10).autoCommitDisabled().open();){
            Task task = new Task(){

                @Override
                public void call() {
                    while (!this.stop) {
                        s.compact(100, 0x100000);
                    }
                }
            };
            task.execute();
            Task task2 = new Task(){

                @Override
                public void call() {
                    while (!this.stop) {
                        s.compact(100, 0x100000);
                    }
                }
            };
            task2.execute();
            Thread.sleep(1L);
            int i = 0;
            while (!task.isFinished() && !task2.isFinished() && i < 1000) {
                MVMap<Integer, Integer> map = s.openMap("d" + i % 3);
                map.put(0, i);
                map.get(0);
                s.commit();
                ++i;
            }
            task.get();
            task2.get();
        }
    }

    private static void testConcurrentChangeAndGetVersion() throws InterruptedException {
        int test = 0;
        while (test < 10) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (final MVStore s = new MVStore.Builder().autoCommitDisabled().open();){
                s.setVersionsToKeep(10);
                final MVMap<Integer, Integer> m = s.openMap("data");
                m.put(1, 1);
                Task task = new Task(){

                    @Override
                    public void call() {
                        while (!this.stop) {
                            m.put(1, 1);
                            s.commit();
                        }
                    }
                };
                task.execute();
                Thread.sleep(1L);
                int i = 0;
                while (i < 10000) {
                    if (task.isFinished()) break;
                    int j = 0;
                    while (j < 20) {
                        m.put(1, 1);
                        s.commit();
                        ++j;
                    }
                    s.setVersionsToKeep(15);
                    long version = s.getCurrentVersion() - 1L;
                    try {
                        m.openVersion(version);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    s.setVersionsToKeep(20);
                    ++i;
                }
                task.get();
                s.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++test;
        }
    }

    private void testConcurrentFree() throws InterruptedException {
        String fileName = "memFS:" + this.getTestName();
        int test = 0;
        while (test < 10) {
            FileUtils.delete(fileName);
            MVStore s1 = new MVStore.Builder().fileName(fileName).autoCommitDisabled().open();
            s1.setRetentionTime(0);
            int count = 200;
            int i = 0;
            while (i < 200) {
                MVMap<Integer, Integer> m = s1.openMap("d" + i);
                m.put(1, 1);
                if (i % 2 == 0) {
                    s1.commit();
                }
                ++i;
            }
            s1.close();
            MVStore.Builder builder = new MVStore.Builder().fileName(fileName).autoCommitDisabled();
            Throwable throwable = null;
            Object var7_9 = null;
            try (final MVStore s = builder.open();){
                int x;
                s.setRetentionTime(0);
                s.setVersionsToKeep(0);
                final ArrayList list = new ArrayList(200);
                int i2 = 0;
                while (i2 < 200) {
                    MVMap m = s.openMap("d" + i2);
                    list.add(m);
                    ++i2;
                }
                final AtomicInteger counter = new AtomicInteger();
                Task task = new Task(){

                    @Override
                    public void call() {
                        while (!this.stop) {
                            int x = counter.getAndIncrement();
                            if (x >= 200) break;
                            MVMap m = (MVMap)list.get(x);
                            m.clear();
                            s.removeMap(m);
                        }
                    }
                };
                task.execute();
                Thread.sleep(1L);
                while ((x = counter.getAndIncrement()) < 200) {
                    MVMap m = (MVMap)list.get(x);
                    m.clear();
                    s.removeMap(m);
                    if (x % 5 != 0) continue;
                    s.commit();
                }
                task.get();
                MVMap<Integer, Integer> m = s.openMap("dummy");
                m.put(0, 0);
                s.commit();
                m.put(1, 1);
                s.commit();
                m.put(2, 2);
                s.commit();
                Map<String, String> layoutMap = s.getLayoutMap();
                int chunkCount = 0;
                for (String k : layoutMap.keySet()) {
                    if (!k.startsWith("chunk.")) continue;
                    Object chunk = s.getFileStore().createChunk(layoutMap.get(k));
                    if (((Chunk)chunk).maxLenLive <= 0L) continue;
                    ++chunkCount;
                }
                this.assertTrue("" + chunkCount, chunkCount < 3);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++test;
        }
    }

    private void testConcurrentStoreAndRemoveMap() throws InterruptedException {
        String fileName = "memFS:" + this.getTestName();
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var3_4 = null;
        try (final MVStore s = TestMVStoreConcurrent.openStore(fileName);){
            int count = 200;
            int i = 0;
            while (i < count) {
                MVMap<Integer, Integer> m = s.openMap("d" + i);
                m.put(1, 1);
                ++i;
            }
            final AtomicInteger counter = new AtomicInteger();
            Task task = new Task(){

                @Override
                public void call() {
                    while (!this.stop) {
                        counter.incrementAndGet();
                        s.commit();
                    }
                }
            };
            task.execute();
            Thread.sleep(1L);
            int i2 = 0;
            while (i2 < count || counter.get() < count) {
                MVMap<Integer, Integer> m = s.openMap("d" + i2);
                m.put(1, 10);
                s.removeMap(m);
                if (task.isFinished()) break;
                ++i2;
            }
            task.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentStoreAndClose() throws InterruptedException {
        String fileName = "memFS:" + this.getTestName();
        int i = 0;
        while (i < 10) {
            FileUtils.delete(fileName);
            Throwable throwable = null;
            Object var4_5 = null;
            try (final MVStore s = TestMVStoreConcurrent.openStore(fileName);){
                final AtomicInteger counter = new AtomicInteger();
                Task task = new Task(){

                    @Override
                    public void call() {
                        while (!this.stop) {
                            s.setStoreVersion(counter.incrementAndGet());
                            s.commit();
                        }
                    }
                };
                task.execute();
                while (counter.get() < 5) {
                    Thread.sleep(1L);
                }
                try {
                    s.close();
                    int x = counter.get();
                    int y = x + 2;
                    while (x <= y) {
                        Thread.sleep(1L);
                        ++x;
                    }
                    Exception e = task.getException();
                    if (e != null) {
                        TestMVStoreConcurrent.checkErrorCode(4, e);
                    }
                }
                catch (MVStoreException e) {
                    this.assertEquals(2, e.getErrorCode());
                    task.get();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
    }

    private static void testConcurrentMap() throws InterruptedException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (MVStore s = TestMVStoreConcurrent.openStore(null);){
            final MVMap<Integer, Integer> m = s.openMap("data");
            int size = 20;
            final Random rand = new Random(1L);
            Task task = new Task(){

                @Override
                public void call() {
                    try {
                        while (!this.stop) {
                            if (rand.nextBoolean()) {
                                m.put(rand.nextInt(20), 1);
                            } else {
                                m.remove(rand.nextInt(20));
                            }
                            m.get(rand.nextInt(20));
                            m.firstKey();
                            m.lastKey();
                            m.ceilingKey(5);
                            m.floorKey(5);
                            m.higherKey(5);
                            m.lowerKey(5);
                            Iterator<Object> it = m.keyIterator(null);
                            while (it.hasNext()) {
                                it.next();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            task.execute();
            Thread.sleep(1L);
            int j = 0;
            while (j < 100) {
                int i = 0;
                while (i < 100) {
                    if (rand.nextBoolean()) {
                        m.put(rand.nextInt(20), 2);
                    } else {
                        m.remove(rand.nextInt(20));
                    }
                    m.get(rand.nextInt(20));
                    ++i;
                }
                s.commit();
                Thread.sleep(1L);
                ++j;
            }
            task.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentOnlineBackup() throws Exception {
        String fileName = this.getBaseDir() + "/" + this.getTestName();
        String fileNameRestore = this.getBaseDir() + "/" + this.getTestName() + ".bck";
        FileUtils.delete(fileName);
        FileUtils.delete(fileNameRestore);
        Throwable throwable = null;
        Object var4_5 = null;
        try (final MVStore s = TestMVStoreConcurrent.openStore(fileName);){
            final MVMap map = s.openMap("test");
            final Random r = new Random();
            Task task = new Task(){

                @Override
                public void call() throws Exception {
                    while (!this.stop) {
                        int i = 0;
                        while (i < 10) {
                            map.put(i, new byte[100 * r.nextInt(100)]);
                            ++i;
                        }
                        s.commit();
                        map.clear();
                        s.commit();
                        long len = s.getFileStore().size();
                        if (len > 0x100000L) {
                            Thread.sleep(200L);
                            continue;
                        }
                        if (len <= 20480L) continue;
                        Thread.sleep(20L);
                    }
                }
            };
            task.execute();
            try {
                String archiveName = fileNameRestore + ".zip";
                int i = 0;
                while (i < 10) {
                    FileUtils.delete(archiveName);
                    Throwable throwable2 = null;
                    Object var12_17 = null;
                    try (OutputStream out = FileUtils.newOutputStream(archiveName, false);){
                        Throwable throwable3 = null;
                        Object var15_24 = null;
                        try (ZipOutputStream zip = new ZipOutputStream(out);){
                            s.getFileStore().backup(zip);
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                    throwable2 = null;
                    var12_17 = null;
                    try (ZipFile zipFile = new ZipFile(archiveName);){
                        String name = FilePath.get(s.getFileStore().getFileName()).getName();
                        ZipEntry zipEntry = zipFile.getEntry(name);
                        Object object = null;
                        Object var17_28 = null;
                        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                            Throwable throwable6 = null;
                            Object var20_33 = null;
                            try (OutputStream out = FilePath.get(fileNameRestore).newOutputStream(false);){
                                IOUtils.copy(inputStream, out);
                            }
                            catch (Throwable throwable7) {
                                if (throwable6 == null) {
                                    throwable6 = throwable7;
                                } else if (throwable6 != throwable7) {
                                    throwable6.addSuppressed(throwable7);
                                }
                                throw throwable6;
                            }
                        }
                        catch (Throwable throwable8) {
                            if (object == null) {
                                object = throwable8;
                            } else if (object != throwable8) {
                                ((Throwable)object).addSuppressed(throwable8);
                            }
                            throw object;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (throwable2 == null) {
                            throwable2 = throwable9;
                        } else if (throwable2 != throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                        throw throwable2;
                    }
                    throwable2 = null;
                    var12_17 = null;
                    try (MVStore s2 = TestMVStoreConcurrent.openStore(fileNameRestore);){
                        MVMap test = s2.openMap("test");
                        for (Integer k : test.keySet()) {
                            test.get(k);
                        }
                    }
                    catch (Throwable throwable10) {
                        if (throwable2 == null) {
                            throwable2 = throwable10;
                        } else if (throwable2 != throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                        throw throwable2;
                    }
                    Thread.sleep(10L);
                    ++i;
                }
            }
            finally {
                task.get();
            }
        }
        catch (Throwable throwable11) {
            if (throwable == null) {
                throwable = throwable11;
            } else if (throwable != throwable11) {
                throwable.addSuppressed(throwable11);
            }
            throw throwable;
        }
    }

    private static void testConcurrentIterate() {
        Throwable throwable = null;
        Object var1_2 = null;
        try (MVStore s = new MVStore.Builder().pageSplitSize(3).open();){
            s.setVersionsToKeep(100);
            final MVMap map = s.openMap("test");
            int len = 10;
            final Random r = new Random();
            Task task = new Task(){

                @Override
                public void call() {
                    while (!this.stop) {
                        int x = r.nextInt(10);
                        if (r.nextBoolean()) {
                            map.remove(x);
                            continue;
                        }
                        map.put(x, r.nextInt(100));
                    }
                }
            };
            task.execute();
            try {
                int k = 0;
                while (k < 10000) {
                    Iterator<Integer> it = map.keyIterator(r.nextInt(10));
                    long old = map.getVersion();
                    s.commit();
                    while (map.getVersion() == old) {
                        Thread.yield();
                    }
                    while (it.hasNext()) {
                        it.next();
                    }
                    ++k;
                }
            }
            finally {
                task.get();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentWrite() throws InterruptedException {
        AtomicInteger detected = new AtomicInteger();
        AtomicInteger notDetected = new AtomicInteger();
        int i = 0;
        while (i < 10) {
            TestMVStoreConcurrent.testConcurrentWrite(detected, notDetected);
            ++i;
        }
        this.assertTrue(notDetected.get() * 10 <= detected.get());
    }

    private static void testConcurrentWrite(final AtomicInteger detected, final AtomicInteger notDetected) throws InterruptedException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (MVStore s = TestMVStoreConcurrent.openStore(null);){
            final MVMap<Integer, Integer> m = s.openMap("data");
            int size = 20;
            final Random rand = new Random(1L);
            Task task = new Task(){

                @Override
                public void call() {
                    while (!this.stop) {
                        try {
                            if (rand.nextBoolean()) {
                                m.put(rand.nextInt(20), 1);
                            } else {
                                m.remove(rand.nextInt(20));
                            }
                            m.get(rand.nextInt(20));
                        }
                        catch (ConcurrentModificationException e) {
                            detected.incrementAndGet();
                        }
                        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NegativeArraySizeException | NullPointerException e) {
                            notDetected.incrementAndGet();
                        }
                    }
                }
            };
            task.execute();
            try {
                Thread.sleep(1L);
                int j = 0;
                while (j < 10) {
                    int i = 0;
                    while (i < 10) {
                        try {
                            if (rand.nextBoolean()) {
                                m.put(rand.nextInt(20), 2);
                            } else {
                                m.remove(rand.nextInt(20));
                            }
                            m.get(rand.nextInt(20));
                        }
                        catch (ConcurrentModificationException e) {
                            detected.incrementAndGet();
                        }
                        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NegativeArraySizeException | NullPointerException e) {
                            notDetected.incrementAndGet();
                        }
                        ++i;
                    }
                    s.commit();
                    Thread.sleep(1L);
                    ++j;
                }
            }
            finally {
                task.get();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void testConcurrentRead() throws InterruptedException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (final MVStore s = TestMVStoreConcurrent.openStore(null);){
            s.setVersionsToKeep(100);
            final MVMap<Integer, Integer> m = s.openMap("data");
            int size = 3;
            int x = (int)s.getCurrentVersion();
            int i = 0;
            while (i < 3) {
                m.put(i, x);
                ++i;
            }
            s.commit();
            Task task = new Task(){

                @Override
                public void call() {
                    while (!this.stop) {
                        long v = s.getCurrentVersion() - 1L;
                        MVMap old = m.openVersion(v);
                        int i = 0;
                        while (i < 3) {
                            Integer x = (Integer)old.get(i);
                            if (x == null || (int)v != x) {
                                MVMap old2 = m.openVersion(v);
                                throw new AssertionError((Object)(String.valueOf(x) + "<>" + v + " at " + i + " " + String.valueOf(old2)));
                            }
                            ++i;
                        }
                    }
                }
            };
            task.execute();
            try {
                Thread.sleep(1L);
                int j = 0;
                while (j < 100) {
                    x = (int)s.getCurrentVersion();
                    int i2 = 0;
                    while (i2 < 3) {
                        m.put(i2, x);
                        ++i2;
                    }
                    s.commit();
                    Thread.sleep(1L);
                    ++j;
                }
            }
            finally {
                task.get();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

