/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.test.TestBase;

public class TestObjectDataType
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testCommonValues();
    }

    private void testCommonValues() {
        int comp;
        BigInteger largeBigInt = BigInteger.probablePrime(200, new Random(1L));
        ObjectDataType ot = new ObjectDataType();
        Object[] objectArray = new Object[148];
        objectArray[0] = false;
        objectArray[1] = true;
        objectArray[2] = (byte)-128;
        objectArray[3] = (byte)-1;
        objectArray[4] = (byte)0;
        objectArray[5] = (byte)1;
        objectArray[6] = (byte)127;
        objectArray[7] = (short)Short.MIN_VALUE;
        objectArray[8] = (short)-1;
        objectArray[9] = (short)0;
        objectArray[10] = (short)1;
        objectArray[11] = (short)Short.MAX_VALUE;
        objectArray[12] = Integer.MIN_VALUE;
        objectArray[13] = -2147483647;
        objectArray[14] = -1000;
        objectArray[15] = -100;
        objectArray[16] = -1;
        objectArray[17] = 0;
        objectArray[18] = 1;
        objectArray[19] = 2;
        objectArray[20] = 14;
        objectArray[21] = 15;
        objectArray[22] = 16;
        objectArray[23] = 17;
        objectArray[24] = 100;
        objectArray[25] = 0x7FFFFFFE;
        objectArray[26] = Integer.MAX_VALUE;
        objectArray[27] = Long.MIN_VALUE;
        objectArray[28] = -9223372036854775807L;
        objectArray[29] = -1000L;
        objectArray[30] = -1L;
        objectArray[31] = 0L;
        objectArray[32] = 1L;
        objectArray[33] = 2L;
        objectArray[34] = 14L;
        objectArray[35] = 15L;
        objectArray[36] = 16L;
        objectArray[37] = 17L;
        objectArray[38] = 100L;
        objectArray[39] = 0x7FFFFFFFFFFFFFFEL;
        objectArray[40] = Long.MAX_VALUE;
        objectArray[41] = largeBigInt.negate();
        objectArray[42] = BigInteger.valueOf(-1L);
        objectArray[43] = BigInteger.ZERO;
        objectArray[44] = BigInteger.ONE;
        objectArray[45] = BigInteger.TEN;
        objectArray[46] = largeBigInt;
        objectArray[47] = Float.valueOf(Float.NEGATIVE_INFINITY);
        objectArray[48] = Float.valueOf(-3.4028235E38f);
        objectArray[49] = Float.valueOf(-1.0f);
        objectArray[50] = Float.valueOf(-0.0f);
        objectArray[51] = Float.valueOf(0.0f);
        objectArray[52] = Float.valueOf(Float.MIN_VALUE);
        objectArray[53] = Float.valueOf(1.0f);
        objectArray[54] = Float.valueOf(Float.MAX_VALUE);
        objectArray[55] = Float.valueOf(Float.POSITIVE_INFINITY);
        objectArray[56] = Float.valueOf(Float.NaN);
        objectArray[57] = Double.NEGATIVE_INFINITY;
        objectArray[58] = -1.7976931348623157E308;
        objectArray[59] = -1.0;
        objectArray[60] = -0.0;
        objectArray[61] = 0.0;
        objectArray[62] = Double.MIN_VALUE;
        objectArray[63] = 1.0;
        objectArray[64] = Double.MAX_VALUE;
        objectArray[65] = Double.POSITIVE_INFINITY;
        objectArray[66] = Double.NaN;
        objectArray[67] = BigDecimal.valueOf(Double.MAX_VALUE).negate();
        objectArray[68] = new BigDecimal(largeBigInt).negate();
        objectArray[69] = BigDecimal.valueOf(-100.0);
        objectArray[70] = BigDecimal.ZERO;
        objectArray[71] = BigDecimal.ONE;
        objectArray[72] = BigDecimal.TEN;
        objectArray[73] = BigDecimal.valueOf(Long.MAX_VALUE);
        objectArray[74] = new BigDecimal(largeBigInt);
        objectArray[75] = BigDecimal.valueOf(Double.MAX_VALUE);
        objectArray[76] = Character.valueOf('\u0000');
        objectArray[77] = Character.valueOf('0');
        objectArray[78] = Character.valueOf('a');
        objectArray[79] = Character.valueOf('\uffff');
        objectArray[80] = "";
        objectArray[81] = " ";
        objectArray[82] = "  ";
        objectArray[83] = "123456789012345";
        objectArray[84] = "1234567890123456";
        objectArray[85] = new String(new char[100]).replace('\u0000', 'x');
        objectArray[86] = new String(new char[100000]).replace('\u0000', 'x');
        objectArray[87] = "y";
        objectArray[88] = "\u1234";
        objectArray[89] = "\u2345";
        objectArray[90] = "\u6789";
        objectArray[91] = "\uffff";
        objectArray[92] = new UUID(Long.MIN_VALUE, Long.MIN_VALUE);
        objectArray[93] = new UUID(Long.MIN_VALUE, 0L);
        objectArray[94] = new UUID(0L, 0L);
        objectArray[95] = new UUID(Long.MAX_VALUE, Long.MAX_VALUE);
        objectArray[96] = new Date(0L);
        objectArray[97] = new Date(1000L);
        objectArray[98] = new Date(4000L);
        objectArray[99] = new Date(5000L);
        objectArray[100] = new boolean[0];
        objectArray[101] = new boolean[2];
        objectArray[102] = new boolean[]{true};
        objectArray[103] = new byte[0];
        objectArray[104] = new byte[1];
        objectArray[105] = new byte[15];
        objectArray[106] = new byte[16];
        objectArray[107] = new byte[10000];
        objectArray[108] = new byte[]{1};
        objectArray[109] = new byte[]{-1};
        objectArray[110] = new short[0];
        objectArray[111] = new short[]{-1};
        objectArray[112] = new short[]{1};
        objectArray[113] = new char[0];
        objectArray[114] = new char[1];
        objectArray[115] = new char[10000];
        objectArray[116] = new char[]{'\u0001'};
        objectArray[117] = new int[0];
        objectArray[118] = new int[1];
        objectArray[119] = new int[15];
        objectArray[120] = new int[16];
        objectArray[121] = new int[10000];
        objectArray[122] = new int[]{1};
        objectArray[123] = new long[0];
        objectArray[124] = new long[1];
        objectArray[125] = new long[15];
        objectArray[126] = new long[16];
        objectArray[127] = new long[10000];
        objectArray[128] = new long[]{1L};
        objectArray[129] = new float[0];
        objectArray[130] = new float[]{Float.NEGATIVE_INFINITY};
        objectArray[131] = new float[1];
        objectArray[132] = new float[]{Float.POSITIVE_INFINITY};
        objectArray[133] = new double[0];
        objectArray[134] = new double[]{Double.NEGATIVE_INFINITY};
        objectArray[135] = new double[1];
        objectArray[136] = new double[]{Double.POSITIVE_INFINITY};
        objectArray[137] = new Object[0];
        objectArray[138] = new Object[100];
        objectArray[139] = new Object[]{1};
        Object[] objectArray2 = new Object[4];
        objectArray2[0] = 0.0;
        objectArray2[1] = "Hello";
        objectArray2[3] = Double.NaN;
        objectArray[140] = objectArray2;
        String[] stringArray = new String[2];
        stringArray[0] = "Hello";
        objectArray[141] = stringArray;
        objectArray[142] = new String[]{"World"};
        objectArray[143] = new java.sql.Date[0];
        objectArray[144] = new Timestamp[0];
        objectArray[145] = new Timestamp[1];
        objectArray[146] = new Timestamp(2000L);
        objectArray[147] = new Timestamp(3000L);
        Object[] array = objectArray;
        Object otherType = false;
        Object last = null;
        Object[] objectArray3 = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object x = objectArray3[n2];
            this.test(otherType, x);
            if (last != null) {
                comp = ot.compare(x, last);
                if (comp <= 0) {
                    this.fail(x.getClass().getSimpleName() + ": " + x.toString() + " " + comp);
                }
                this.assertTrue(x.toString(), ot.compare(last, x) < 0);
            }
            if (last != null && last.getClass() != x.getClass()) {
                otherType = last;
            }
            last = x;
            ++n2;
        }
        Random r = new Random(1L);
        int i = 0;
        while (i < 1000) {
            Object y;
            Object x = array[r.nextInt(array.length)];
            comp = ot.compare(x, y = array[r.nextInt(array.length)]);
            if (comp != 0) {
                this.assertEquals("x:" + String.valueOf(x) + " y:" + String.valueOf(y), -comp, ot.compare(y, x));
            }
            ++i;
        }
    }

    private void test(Object last, Object x) {
        ObjectDataType ot = new ObjectDataType();
        ot.getMemory(last);
        this.assertTrue(ot.getMemory(x) >= 0);
        ot.getMemory(last);
        this.assertTrue(ot.getMemory(x) >= 0);
        ot.getMemory(last);
        this.assertEquals(0, ot.compare(x, x));
        WriteBuffer buff = new WriteBuffer();
        ot.getMemory(last);
        ot.write(buff, x);
        buff.put((byte)123);
        ByteBuffer bb = buff.getBuffer();
        bb.flip();
        ot.getMemory(last);
        Object y = ot.read(bb);
        this.assertEquals(123, bb.get());
        this.assertEquals(0, bb.remaining());
        this.assertEquals(x.getClass().getName(), y.getClass().getName());
        ot.getMemory(last);
        this.assertEquals(0, ot.compare(x, y));
        if (x.getClass().isArray()) {
            if (x instanceof byte[]) {
                this.assertTrue(Arrays.equals((byte[])x, (byte[])y));
            } else if (x instanceof boolean[]) {
                this.assertTrue(Arrays.equals((boolean[])x, (boolean[])y));
            } else if (x instanceof short[]) {
                this.assertTrue(Arrays.equals((short[])x, (short[])y));
            } else if (x instanceof float[]) {
                this.assertTrue(Arrays.equals((float[])x, (float[])y));
            } else if (x instanceof double[]) {
                this.assertTrue(Arrays.equals((double[])x, (double[])y));
            } else if (x instanceof char[]) {
                this.assertTrue(Arrays.equals((char[])x, (char[])y));
            } else if (x instanceof int[]) {
                this.assertTrue(Arrays.equals((int[])x, (int[])y));
            } else if (x instanceof long[]) {
                this.assertTrue(Arrays.equals((long[])x, (long[])y));
            } else {
                this.assertTrue(Arrays.equals((Object[])x, (Object[])y));
            }
        } else {
            this.assertEquals(x.hashCode(), y.hashCode());
            this.assertTrue(x.equals(y));
        }
    }
}

