/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.util.TreeMap;
import org.h2.dev.cluster.ShardedMap;
import org.h2.test.TestBase;

public class TestShardedMap
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testLinearSplit();
        this.testReplication();
        this.testOverlap();
    }

    private void testLinearSplit() {
        ShardedMap map = new ShardedMap();
        TreeMap a = new TreeMap();
        TreeMap b = new TreeMap();
        map.addMap(a, null, 5);
        map.addMap(b, 5, null);
        int i = 0;
        while (i < 10) {
            map.put(i, i * 10);
            ++i;
        }
        this.assertEquals(10, map.size());
        i = 0;
        while (i < 10) {
            this.assertEquals(i * 10, (int)((Integer)map.get(i)));
            ++i;
        }
        this.assertEquals("[0, 1, 2, 3, 4]", a.keySet().toString());
        this.assertEquals("[5, 6, 7, 8, 9]", b.keySet().toString());
        this.assertEquals("[0, 1, 2, 3, 4, 5, 6, 7, 8, 9]", map.keySet().toString());
        this.assertEquals(10L, map.sizeAsLong());
    }

    private void testReplication() {
        ShardedMap map = new ShardedMap();
        TreeMap a = new TreeMap();
        TreeMap b = new TreeMap();
        map.addMap(a, null, null);
        map.addMap(b, null, null);
        int i = 0;
        while (i < 10) {
            map.put(i, i * 10);
            ++i;
        }
        this.assertEquals(10, map.size());
        i = 0;
        while (i < 10) {
            this.assertEquals(i * 10, (int)((Integer)map.get(i)));
            ++i;
        }
        this.assertEquals("[0, 1, 2, 3, 4, 5, 6, 7, 8, 9]", a.keySet().toString());
        this.assertEquals("[0, 1, 2, 3, 4, 5, 6, 7, 8, 9]", b.keySet().toString());
        this.assertEquals("[0, 1, 2, 3, 4, 5, 6, 7, 8, 9]", map.keySet().toString());
        this.assertEquals(10L, map.sizeAsLong());
    }

    private void testOverlap() {
        ShardedMap map = new ShardedMap();
        TreeMap a = new TreeMap();
        TreeMap b = new TreeMap();
        map.addMap(a, null, 10);
        map.addMap(b, 5, null);
        int i = 0;
        while (i < 20) {
            map.put(i, i * 10);
            ++i;
        }
        this.assertEquals(-1, map.size());
        i = 0;
        while (i < 20) {
            this.assertEquals(i * 10, (int)((Integer)map.get(i)));
            ++i;
        }
        this.assertEquals("[0, 1, 2, 3, 4, 5, 6, 7, 8, 9]", a.keySet().toString());
        this.assertEquals("[5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]", b.keySet().toString());
        this.assertEquals(-1L, map.sizeAsLong());
    }
}

