/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import org.h2.test.TestBase;

public class TestSpinLock
extends TestBase {
    volatile int writeVersion;
    volatile Data data = new Data(0, null);

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        final TestSpinLock obj = new TestSpinLock();
        Thread t = new Thread(){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    int i = 0;
                    while (i < 10000) {
                        Data d;
                        obj.data = d = obj.copyOnWrite();
                        d.write(i);
                        d.writing = false;
                        ++i;
                    }
                }
            }
        };
        t.start();
        try {
            int i = 0;
            while (i < 100000) {
                Data d = obj.getImmutable();
                int z = d.x + d.y;
                if (z != 0) {
                    String error = i + " result: " + z + " now: " + d.x + " " + d.y;
                    System.out.println(error);
                    throw new Exception(error);
                }
                ++i;
            }
        }
        finally {
            t.interrupt();
            t.join();
        }
    }

    Data copyOnWrite() {
        Data d = this.data;
        d.writing = true;
        int w = this.writeVersion;
        if (w <= this.data.version) {
            return d;
        }
        Data d2 = new Data(w, this.data);
        d2.writing = true;
        d.writing = false;
        return d2;
    }

    private Data getImmutable() {
        Data d = this.data;
        ++this.writeVersion;
        while (d.writing) {
            Thread.yield();
        }
        return d;
    }

    static class Data {
        final int version;
        int x;
        int y;
        volatile boolean writing;

        Data(int version, Data old) {
            this.version = version;
            if (old != null) {
                this.x = old.x;
                this.y = old.y;
            }
        }

        void write(int value) {
            this.x = value;
            this.y = -value;
        }
    }
}

