/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.store;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionMap;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.type.LongDataType;
import org.h2.mvstore.type.MetaType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.util.Task;

public class TestTransactionStore
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        FileUtils.createDirectories(this.getBaseDir());
        this.testHCLFKey();
        TestTransactionStore.testConcurrentAddRemove();
        this.testConcurrentAdd();
        this.testCountWithOpenTransactions();
        this.testConcurrentUpdate();
        this.testRepeatedChange();
        this.testTransactionAge();
        this.testGetModifiedMaps();
        this.testKeyIterator();
        this.testTwoPhaseCommit();
        this.testSavepoint();
        this.testConcurrentTransactionsReadCommitted();
        this.testSingleConnection();
        this.testCompareWithPostgreSQL();
        TestTransactionStore.testStoreMultiThreadedReads();
        this.testCommitAfterMapRemoval();
        this.testDeadLock();
    }

    private void testHCLFKey() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction t = ts.begin();
            LongDataType keyType = LongDataType.INSTANCE;
            TransactionMap<Long, Long> map = t.openMap("test", keyType, keyType);
            this.assertNull(map.firstEntry());
            this.assertNull(map.firstKey());
            this.assertNull(map.lastEntry());
            this.assertNull(map.lastKey());
            map.put(10L, 100L);
            map.put(20L, 200L);
            map.put(30L, 300L);
            map.put(40L, 400L);
            t.commit();
            t = ts.begin();
            map = t.openMap("test", keyType, keyType);
            map.put(15L, 150L);
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(15L, 150L), map.higherEntry(10L));
            this.assertEquals((Object)15L, map.higherKey(10L));
            t = ts.begin();
            map = t.openMap("test", keyType, keyType);
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(10L, 100L), map.firstEntry());
            this.assertEquals((Object)10L, map.firstKey());
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(40L, 400L), map.lastEntry());
            this.assertEquals((Object)40L, map.lastKey());
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(20L, 200L), map.higherEntry(10L));
            this.assertEquals((Object)20L, map.higherKey(10L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(20L, 200L), map.higherEntry(15L));
            this.assertEquals((Object)20L, map.higherKey(15L));
            this.assertNull(map.higherEntry(40L));
            this.assertNull(map.higherKey(40L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(10L, 100L), map.ceilingEntry(10L));
            this.assertEquals((Object)10L, map.ceilingKey(10L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(20L, 200L), map.ceilingEntry(15L));
            this.assertEquals((Object)20L, map.ceilingKey(15L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(40L, 400L), map.ceilingEntry(40L));
            this.assertEquals((Object)40L, map.ceilingKey(40L));
            this.assertNull(map.higherEntry(45L));
            this.assertNull(map.higherKey(45L));
            this.assertNull(map.lowerEntry(10L));
            this.assertNull(map.lowerKey(10L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(10L, 100L), map.lowerEntry(15L));
            this.assertEquals((Object)10L, map.lowerKey(15L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(10L, 100L), map.lowerEntry(20L));
            this.assertEquals((Object)10L, map.lowerKey(20L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(20L, 200L), map.lowerEntry(25L));
            this.assertEquals((Object)20L, map.lowerKey(25L));
            this.assertNull(map.floorEntry(5L));
            this.assertNull(map.floorKey(5L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(10L, 100L), map.floorEntry(10L));
            this.assertEquals((Object)10L, map.floorKey(10L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(10L, 100L), map.floorEntry(15L));
            this.assertEquals((Object)10L, map.floorKey(15L));
            this.assertEquals(new AbstractMap.SimpleImmutableEntry<Long, Long>(30L, 300L), map.floorEntry(35L));
            this.assertEquals((Object)30L, map.floorKey(35L));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void testConcurrentAddRemove() throws InterruptedException {
        Throwable throwable = null;
        Object var1_2 = null;
        try (MVStore s = MVStore.open(null);){
            int threadCount = 3;
            final int keyCount = 2;
            final TransactionStore ts = new TransactionStore(s);
            ts.init();
            final Random r = new Random(1L);
            Task[] tasks = new Task[threadCount];
            int i = 0;
            while (i < threadCount) {
                Task task = new Task(){

                    @Override
                    public void call() {
                        while (!this.stop) {
                            Transaction tx = ts.begin();
                            TransactionMap<Integer, Integer> map = tx.openMap("data");
                            int k = r.nextInt(keyCount);
                            try {
                                map.remove(k);
                                map.put(k, r.nextInt());
                            }
                            catch (MVStoreException mVStoreException) {
                                // empty catch block
                            }
                            tx.commit();
                        }
                    }
                };
                task.execute();
                tasks[i] = task;
                ++i;
            }
            Thread.sleep(1000L);
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task t = taskArray[n2];
                t.get();
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentAdd() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            final TransactionStore ts = new TransactionStore(s);
            ts.init();
            final Random r = new Random(1L);
            final AtomicInteger key = new AtomicInteger();
            final AtomicInteger failCount = new AtomicInteger();
            Task task = new Task(){

                @Override
                public void call() {
                    while (!this.stop) {
                        int k = key.get();
                        Transaction tx = ts.begin();
                        TransactionMap<Integer, Integer> map = tx.openMap("data");
                        try {
                            map.put(k, r.nextInt());
                        }
                        catch (MVStoreException e) {
                            failCount.incrementAndGet();
                        }
                        tx.commit();
                    }
                }
            };
            task.execute();
            int count = 100000;
            int i = 0;
            while (i < count) {
                key.set(i);
                Transaction tx = ts.begin();
                TransactionMap<Integer, Integer> map = tx.openMap("data");
                try {
                    map.put(i, r.nextInt());
                }
                catch (MVStoreException e) {
                    failCount.incrementAndGet();
                }
                tx.commit();
                if (failCount.get() > 0 && i > 4000) {
                    count = i;
                    break;
                }
                ++i;
            }
            task.get();
            this.assertTrue(String.valueOf(failCount) + " >= " + (double)count * 0.9, (double)failCount.get() < (double)count * 0.9);
            this.assertTrue(failCount.toString(), failCount.get() > 0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCountWithOpenTransactions() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction tx1 = ts.begin();
            TransactionMap<Integer, Integer> map1 = tx1.openMap("data");
            int size = 150;
            int i = 0;
            while (i < size) {
                map1.put(i, i * 10);
                ++i;
            }
            tx1.commit();
            tx1 = ts.begin();
            map1 = tx1.openMap("data");
            Transaction tx2 = ts.begin();
            TransactionMap<Integer, Integer> map2 = tx2.openMap("data");
            Random r = new Random(1L);
            int i2 = 0;
            while (i2 < size * 3) {
                this.assertEquals("op: " + i2, size, map1.size());
                this.assertEquals("op: " + i2, size, (int)map1.sizeAsLong());
                int k = size / 10 + r.nextInt(size);
                if (r.nextBoolean()) {
                    map2.remove(k);
                } else {
                    map2.put(k, i2);
                }
                ++i2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentUpdate() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction tx1 = ts.begin();
            TransactionMap<Integer, Integer> map1 = tx1.openMap("data");
            map1.put(1, 10);
            Transaction tx2 = ts.begin();
            TransactionMap map2 = tx2.openMap("data");
            this.assertThrows(101, () -> map2.put(1, 20));
            this.assertEquals(10, (int)((Integer)map1.get(1)));
            this.assertNull(map2.get(1));
            tx1.commit();
            this.assertEquals(10, (int)((Integer)map2.get(1)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testRepeatedChange() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction tx0 = ts.begin();
            TransactionMap<Integer, Integer> map0 = tx0.openMap("data");
            map0.put(1, -1);
            tx0.commit();
            Transaction tx = ts.begin();
            TransactionMap<Integer, Integer> map = tx.openMap("data");
            int i = 0;
            while (i < 2000) {
                map.put(1, i);
                ++i;
            }
            Transaction tx2 = ts.begin();
            TransactionMap map2 = tx2.openMap("data");
            this.assertEquals(-1, (int)((Integer)map2.get(1)));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testTransactionAge() {
        MVStore s = MVStore.open(null);
        TransactionStore ts = new TransactionStore(s);
        ts.init();
        ts.setMaxTransactionId(16);
        ArrayList<Transaction> openList = new ArrayList<Transaction>();
        int i = 0;
        int j = 1;
        while (i < 64) {
            Transaction t = ts.begin();
            openList.add(t);
            this.assertEquals(j, t.getId());
            if (++j > 16) {
                j = 1;
            }
            if (openList.size() >= 16) {
                t = (Transaction)openList.remove(0);
                t.commit();
            }
            ++i;
        }
        s = MVStore.open(null);
        TransactionStore ts2 = new TransactionStore(s);
        ts2.init();
        ts2.setMaxTransactionId(16);
        ArrayList<Transaction> fifo = new ArrayList<Transaction>();
        int open = 0;
        int i2 = 0;
        while (i2 < 64) {
            if (open >= 16) {
                this.assertThrows(MVStoreException.class, () -> ts2.begin());
                Transaction first = (Transaction)fifo.remove(0);
                first.commit();
                --open;
            }
            Transaction t = ts2.begin();
            t.openMap("data").put(i2, i2);
            fifo.add(t);
            ++open;
            ++i2;
        }
        s.close();
    }

    private void testGetModifiedMaps() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction tx = ts.begin();
            tx.openMap("m1");
            tx.openMap("m2");
            tx.openMap("m3");
            this.assertFalse(tx.getChanges(0L).hasNext());
            tx.commit();
            tx = ts.begin();
            TransactionMap<String, String> m1 = tx.openMap("m1");
            TransactionMap<String, String> m2 = tx.openMap("m2");
            TransactionMap<String, String> m3 = tx.openMap("m3");
            m1.put("1", "100");
            long sp = tx.setSavepoint();
            m2.put("1", "100");
            m3.put("1", "100");
            Iterator<TransactionStore.Change> it = tx.getChanges(sp);
            this.assertTrue(it.hasNext());
            TransactionStore.Change c = it.next();
            this.assertEquals("m3", c.mapName);
            this.assertEquals("1", c.key.toString());
            this.assertNull(c.value);
            this.assertTrue(it.hasNext());
            c = it.next();
            this.assertEquals("m2", c.mapName);
            this.assertEquals("1", c.key.toString());
            this.assertNull(c.value);
            this.assertFalse(it.hasNext());
            it = tx.getChanges(0L);
            this.assertTrue(it.hasNext());
            c = it.next();
            this.assertEquals("m3", c.mapName);
            this.assertEquals("1", c.key.toString());
            this.assertNull(c.value);
            this.assertTrue(it.hasNext());
            c = it.next();
            this.assertEquals("m2", c.mapName);
            this.assertEquals("1", c.key.toString());
            this.assertNull(c.value);
            this.assertTrue(it.hasNext());
            c = it.next();
            this.assertEquals("m1", c.mapName);
            this.assertEquals("1", c.key.toString());
            this.assertNull(c.value);
            this.assertFalse(it.hasNext());
            tx.rollbackToSavepoint(sp);
            it = tx.getChanges(0L);
            this.assertTrue(it.hasNext());
            c = it.next();
            this.assertEquals("m1", c.mapName);
            this.assertEquals("1", c.key.toString());
            this.assertNull(c.value);
            this.assertFalse(it.hasNext());
            tx.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testKeyIterator() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction tx = ts.begin();
            TransactionMap<String, String> m = tx.openMap("test");
            m.put("1", "Hello");
            m.put("2", "World");
            m.put("3", ".");
            tx.commit();
            Transaction tx2 = ts.begin();
            TransactionMap<String, String> m2 = tx2.openMap("test");
            m2.remove("2");
            m2.put("3", "!");
            m2.put("4", "?");
            tx = ts.begin();
            m = tx.openMap("test");
            Iterator<Object> it = m.keyIterator(null);
            this.assertTrue(it.hasNext());
            this.assertEquals("1", it.next());
            this.assertTrue(it.hasNext());
            this.assertEquals("2", it.next());
            this.assertTrue(it.hasNext());
            this.assertEquals("3", it.next());
            this.assertFalse(it.hasNext());
            Iterator entryIt = m.entrySet().iterator();
            this.assertTrue(entryIt.hasNext());
            this.assertEquals("1", (String)entryIt.next().getKey());
            this.assertTrue(entryIt.hasNext());
            this.assertEquals("2", (String)entryIt.next().getKey());
            this.assertTrue(entryIt.hasNext());
            this.assertEquals("3", (String)entryIt.next().getKey());
            this.assertFalse(entryIt.hasNext());
            Iterator<Object> it2 = m2.keyIterator(null);
            this.assertTrue(it2.hasNext());
            this.assertEquals("1", it2.next());
            this.assertTrue(it2.hasNext());
            this.assertEquals("3", it2.next());
            this.assertTrue(it2.hasNext());
            this.assertEquals("4", it2.next());
            this.assertFalse(it2.hasNext());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testTwoPhaseCommit() {
        Transaction txOld;
        List<Transaction> list;
        TransactionMap<String, String> m;
        Transaction tx;
        TransactionStore ts;
        MVStore s;
        String fileName = this.getBaseDir() + "/testTwoPhaseCommit.h3";
        FileUtils.delete(fileName);
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            s = MVStore.open(fileName);
            try {
                ts = new TransactionStore(s);
                ts.init();
                tx = ts.begin();
                this.assertEquals(null, tx.getName());
                tx.setName("first transaction");
                this.assertEquals("first transaction", tx.getName());
                this.assertEquals(1, tx.getId());
                this.assertEquals(1, tx.getStatus());
                m = tx.openMap("test");
                m.put("1", "Hello");
                list = ts.getOpenTransactions();
                this.assertEquals(1, list.size());
                txOld = list.get(0);
                this.assertTrue(tx.getId() == txOld.getId());
                this.assertEquals("first transaction", txOld.getName());
                s.commit();
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            s = MVStore.open(fileName);
            try {
                ts = new TransactionStore(s);
                ts.init();
                tx = ts.begin();
                this.assertEquals(2, tx.getId());
                m = tx.openMap("test");
                this.assertEquals(null, (String)m.get("1"));
                m.put("2", "Hello");
                list = ts.getOpenTransactions();
                this.assertEquals(2, list.size());
                txOld = list.get(0);
                this.assertEquals(1, txOld.getId());
                this.assertEquals(1, txOld.getStatus());
                this.assertEquals("first transaction", txOld.getName());
                txOld.prepare();
                this.assertEquals(2, txOld.getStatus());
                txOld = list.get(1);
                txOld.commit();
                s.commit();
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            s = MVStore.open(fileName);
            try {
                ts = new TransactionStore(s);
                ts.init();
                tx = ts.begin();
                m = tx.openMap("test");
                m.put("3", "Test");
                this.assertEquals(2, tx.getId());
                list = ts.getOpenTransactions();
                this.assertEquals(2, list.size());
                txOld = list.get(1);
                this.assertEquals(2, txOld.getId());
                this.assertEquals(1, txOld.getStatus());
                this.assertEquals(null, txOld.getName());
                txOld.rollback();
                txOld = list.get(0);
                this.assertEquals(1, txOld.getId());
                this.assertEquals(2, txOld.getStatus());
                this.assertEquals("first transaction", txOld.getName());
                txOld.commit();
                this.assertEquals("Hello", (String)m.get("1"));
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        FileUtils.delete(fileName);
    }

    private void testSavepoint() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction tx = ts.begin();
            TransactionMap<String, String> m = tx.openMap("test");
            m.put("1", "Hello");
            m.put("2", "World");
            m.put("1", "Hallo");
            m.remove("2");
            m.put("3", "!");
            long logId = tx.setSavepoint();
            m.put("1", "Hi");
            m.put("2", ".");
            m.remove("3");
            tx.rollbackToSavepoint(logId);
            this.assertEquals("Hallo", (String)m.get("1"));
            this.assertNull(m.get("2"));
            this.assertEquals("!", (String)m.get("3"));
            tx.rollback();
            tx = ts.begin();
            m = tx.openMap("test");
            this.assertNull(m.get("1"));
            this.assertNull(m.get("2"));
            this.assertNull(m.get("3"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCompareWithPostgreSQL() throws Exception {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        ArrayList maps = new ArrayList();
        int connectionCount = 3;
        int opCount = 1000;
        int rowCount = 10;
        try {
            Class.forName("org.postgresql.Driver");
            int i = 0;
            while (i < connectionCount) {
                Connection conn = DriverManager.getConnection("jdbc:postgresql:test?loggerLevel=OFF", "sa", "sa");
                statements.add(conn.createStatement());
                ++i;
            }
        }
        catch (Exception e) {
            return;
        }
        ((Statement)statements.get(0)).execute("drop table if exists test cascade");
        ((Statement)statements.get(0)).execute("create table test(id int primary key, name varchar(255))");
        Throwable throwable = null;
        Object var8_11 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            int i = 0;
            while (i < connectionCount) {
                Statement stat = (Statement)statements.get(i);
                stat.execute("set statement_timeout to 100");
                Connection c = stat.getConnection();
                c.setTransactionIsolation(2);
                c.setAutoCommit(false);
                Transaction transaction = ts.begin();
                transactions.add(transaction);
                TransactionMap map = transaction.openMap("test");
                maps.add(map);
                ++i;
            }
            StringBuilder buff = new StringBuilder();
            Random r = new Random(1L);
            try {
                int i2 = 0;
                while (i2 < opCount) {
                    int connIndex = r.nextInt(connectionCount);
                    Statement stat = (Statement)statements.get(connIndex);
                    Transaction transaction = (Transaction)transactions.get(connIndex);
                    TransactionMap<Integer, CallSite> map = (TransactionMap<Integer, CallSite>)maps.get(connIndex);
                    if (transaction == null) {
                        transaction = ts.begin();
                        map = transaction.openMap("test");
                        transactions.set(connIndex, transaction);
                        maps.set(connIndex, map);
                        ResultSet rs = stat.executeQuery("select * from test order by id");
                        buff.append(i2).append(": [" + connIndex + "]=");
                        int size = 0;
                        while (rs.next()) {
                            buff.append(' ');
                            int k = rs.getInt(1);
                            String v = rs.getString(2);
                            buff.append(k).append(':').append(v);
                            this.assertEquals(v, (String)map.get(k));
                            ++size;
                        }
                        buff.append('\n');
                        if ((long)size != map.sizeAsLong()) {
                            this.assertEquals((long)size, map.sizeAsLong());
                        }
                    }
                    int x = r.nextInt(rowCount);
                    int y = r.nextInt(rowCount);
                    buff.append(i2).append(": [" + connIndex + "]: ");
                    ResultSet rs = null;
                    switch (r.nextInt(7)) {
                        case 0: {
                            buff.append("commit");
                            stat.getConnection().commit();
                            transaction.commit();
                            transactions.set(connIndex, null);
                            break;
                        }
                        case 1: {
                            buff.append("rollback");
                            stat.getConnection().rollback();
                            transaction.rollback();
                            transactions.set(connIndex, null);
                            break;
                        }
                        case 2: {
                            String old = (String)map.get(x);
                            if (old == null) {
                                buff.append("insert " + x + "=" + y);
                                if (map.tryPut(x, (CallSite)((Object)("" + y)))) {
                                    stat.execute("insert into test values(" + x + ", '" + y + "')");
                                    break;
                                }
                                buff.append(" -> row was locked");
                                break;
                            }
                            buff.append("update " + x + "=" + y + " (old:" + old + ")");
                            if (map.tryPut(x, (CallSite)((Object)("" + y)))) {
                                int c = stat.executeUpdate("update test set name = '" + y + "' where id = " + x);
                                this.assertEquals(1, c);
                                break;
                            }
                            buff.append(" -> row was locked");
                            break;
                        }
                        case 3: {
                            buff.append("delete " + x);
                            try {
                                int c = stat.executeUpdate("delete from test where id = " + x);
                                if (c == 1) {
                                    map.remove(x);
                                    break;
                                }
                                this.assertNull(map.get(x));
                            }
                            catch (SQLException e) {
                                this.assertNotNull(map.get(x));
                                this.assertFalse(map.tryRemove(x));
                                buff.append(" -> rollback");
                                stat.getConnection().rollback();
                                transaction.rollback();
                                transactions.set(connIndex, null);
                            }
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            rs = stat.executeQuery("select * from test where id = " + x);
                            String expected = rs.next() ? rs.getString(2) : null;
                            buff.append("select " + x + "=" + expected);
                            this.assertEquals("i:" + i2, expected, (String)map.get(x));
                        }
                    }
                    buff.append('\n');
                    ++i2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.fail(buff.toString());
            }
            for (Statement stat : statements) {
                stat.getConnection().close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentTransactionsReadCommitted() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction tx1 = ts.begin();
            TransactionMap<String, String> m1 = tx1.openMap("test");
            m1.put("1", "Hi");
            m1.put("3", ".");
            tx1.commit();
            tx1 = ts.begin();
            m1 = tx1.openMap("test");
            m1.put("1", "Hello");
            m1.put("2", "World");
            m1.remove("3");
            tx1.commit();
            Transaction tx2 = ts.begin();
            TransactionMap<String, String> m2 = tx2.openMap("test");
            tx1 = ts.begin();
            m1 = tx1.openMap("test");
            m1.put("1", "Hallo");
            m1.remove("2");
            m1.put("3", "!");
            this.assertEquals("Hello", (String)m2.get("1"));
            this.assertEquals("World", (String)m2.get("2"));
            this.assertNull(m2.get("3"));
            tx1.commit();
            this.assertEquals("Hallo", (String)m2.get("1"));
            this.assertNull(m2.get("2"));
            this.assertEquals("!", (String)m2.get("3"));
            tx1 = ts.begin();
            m1 = tx1.openMap("test");
            m1.put("2", "World");
            this.assertNull(m2.get("2"));
            this.assertFalse(m2.tryRemove("2"));
            this.assertFalse(m2.tryPut("2", "Welt"));
            tx2 = ts.begin();
            m2 = tx2.openMap("test");
            this.assertNull(m2.get("2"));
            m1.remove("2");
            this.assertNull(m2.get("2"));
            tx1.commit();
            tx1 = ts.begin();
            m1 = tx1.openMap("test");
            this.assertNull(m1.get("2"));
            m1.put("2", "World");
            m1.put("2", "Welt");
            tx1.rollback();
            tx1 = ts.begin();
            m1 = tx1.openMap("test");
            this.assertNull(m1.get("2"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testSingleConnection() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction tx = ts.begin();
            TransactionMap<String, String> m = tx.openMap("test");
            m.put("1", "Hello");
            this.assertEquals("Hello", (String)m.get("1"));
            m.put("2", "World");
            this.assertEquals("World", (String)m.get("2"));
            tx.rollback();
            tx = ts.begin();
            m = tx.openMap("test");
            this.assertNull(m.get("1"));
            this.assertNull(m.get("2"));
            tx = ts.begin();
            m = tx.openMap("test");
            m.put("1", "Hello");
            m.put("2", "World");
            this.assertEquals("Hello", (String)m.get("1"));
            this.assertEquals("World", (String)m.get("2"));
            tx.commit();
            tx = ts.begin();
            m = tx.openMap("test");
            this.assertEquals("Hello", (String)m.get("1"));
            this.assertEquals("World", (String)m.get("2"));
            tx = ts.begin();
            m = tx.openMap("test");
            m.put("1", "Hallo");
            m.remove("2");
            m.put("3", "!");
            this.assertEquals("Hallo", (String)m.get("1"));
            this.assertNull(m.get("2"));
            this.assertEquals("!", (String)m.get("3"));
            tx.rollback();
            tx = ts.begin();
            m = tx.openMap("test");
            this.assertEquals("Hello", (String)m.get("1"));
            this.assertEquals("World", (String)m.get("2"));
            this.assertNull(m.get("3"));
            tx = ts.begin();
            m = tx.openMap("test");
            m.put("1", "Hallo");
            m.remove("2");
            m.put("3", "!");
            this.assertEquals("Hallo", (String)m.get("1"));
            this.assertNull(m.get("2"));
            this.assertEquals("!", (String)m.get("3"));
            tx.commit();
            tx = ts.begin();
            m = tx.openMap("test");
            this.assertEquals("Hallo", (String)m.get("1"));
            this.assertNull(m.get("2"));
            this.assertEquals("!", (String)m.get("3"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void testStoreMultiThreadedReads() {
        Throwable throwable = null;
        Object var1_2 = null;
        try (MVStore s = MVStore.open(null);){
            final TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction t = ts.begin();
            TransactionMap<Integer, Integer> mapA = t.openMap("a");
            mapA.put(1, 0);
            t.commit();
            Task task = new Task(){

                @Override
                public void call() {
                    int i = 0;
                    while (!this.stop) {
                        Transaction tx = ts.begin();
                        TransactionMap<Integer, Integer> mapA = tx.openMap("a");
                        while (!mapA.tryPut(1, i)) {
                        }
                        tx.commit();
                        tx = ts.begin();
                        TransactionMap<Integer, Integer> mapB = tx.openMap("b");
                        mapB.tryPut(i, -i);
                        tx.commit();
                        ++i;
                    }
                }
            };
            task.execute();
            try {
                int i = 0;
                while (i < 10000) {
                    Transaction tx = ts.begin();
                    mapA = tx.openMap("a");
                    if (mapA.get(1) == null) {
                        throw new AssertionError((Object)"key not found");
                    }
                    tx.commit();
                    ++i;
                }
            }
            finally {
                task.get();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testCommitAfterMapRemoval() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (MVStore s = MVStore.open(null);){
            TransactionStore ts = new TransactionStore(s);
            ts.init();
            Transaction t = ts.begin();
            TransactionMap<Long, String> map = t.openMap("test", LongDataType.INSTANCE, StringDataType.INSTANCE);
            map.put(1L, "A");
            s.removeMap("test");
            try {
                t.commit();
            }
            finally {
                this.assertTrue(ts.getOpenTransactions().isEmpty());
                this.assertFalse(ts.hasMap("test"));
                t = ts.begin();
                map = t.openMap("test", LongDataType.INSTANCE, StringDataType.INSTANCE);
                this.assertTrue(map.isEmpty());
                map.put(2L, "B");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testDeadLock() {
        int threadCount = 2;
        int i = 1;
        while (i < threadCount) {
            this.testDeadLock(threadCount, i);
            ++i;
        }
    }

    private void testDeadLock(final int threadCount, final int stepCount) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (MVStore s = MVStore.open(null);){
            s.setAutoCommitDelay(0);
            final TransactionStore ts = new TransactionStore(s, new MetaType<Object>(null, s.backgroundExceptionHandler), new ObjectDataType(), 10000);
            ts.init();
            Transaction t = ts.begin();
            TransactionMap<Long, Long> m = t.openMap("test", LongDataType.INSTANCE, LongDataType.INSTANCE);
            int i = 0;
            while (i < threadCount) {
                m.put(Long.valueOf(i), 0L);
                ++i;
            }
            t.commit();
            final CountDownLatch latch = new CountDownLatch(threadCount);
            Task[] tasks = new Task[threadCount];
            int i2 = 0;
            while (i2 < threadCount) {
                final long initialKey = i2;
                tasks[i2] = new Task(){

                    @Override
                    public void call() throws Exception {
                        Transaction tx = ts.begin();
                        try {
                            TransactionMap<Long, Long> map = tx.openMap("test", LongDataType.INSTANCE, LongDataType.INSTANCE);
                            long key = initialKey;
                            map.computeIfPresent(key, (k, v) -> v + 1L);
                            latch.countDown();
                            latch.await();
                            int j = 0;
                            while (j < stepCount) {
                                key = (key + 1L) % (long)threadCount;
                                map.lock(key);
                                map.put(key, map.get(key) + 1L);
                                ++j;
                            }
                            tx.commit();
                        }
                        catch (Throwable e) {
                            tx.rollback();
                            throw e;
                        }
                    }
                }.execute();
                ++i2;
            }
            int failureCount = 0;
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task task = taskArray[n2];
                Exception exception = task.getException();
                if (exception != null) {
                    ++failureCount;
                    this.assertEquals(MVStoreException.class, exception.getClass());
                    TestTransactionStore.checkErrorCode(105, exception);
                }
                ++n2;
            }
            this.assertEquals(" " + stepCount, stepCount, failureCount);
            t = ts.begin();
            m = t.openMap("test", LongDataType.INSTANCE, LongDataType.INSTANCE);
            int count = 0;
            int i3 = 0;
            while (i3 < threadCount) {
                Long value = m.get(i3);
                this.assertNotNull("Key " + i3, value);
                count = (int)((long)count + value);
                ++i3;
            }
            t.commit();
            this.assertEquals(" " + stepCount, (stepCount + 1) * (threadCount - failureCount), count);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

