/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.h2.util.IOUtils;

public class OutputCatcher
extends Thread {
    private final InputStream in;
    private final LinkedList<String> list = new LinkedList();

    public OutputCatcher(InputStream in) {
        this.in = in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine(long wait) {
        long start = System.nanoTime();
        while (true) {
            LinkedList<String> linkedList = this.list;
            synchronized (linkedList) {
                if (this.list.size() > 0) {
                    return this.list.removeFirst();
                }
                try {
                    this.list.wait(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long time = System.nanoTime() - start;
                if (time >= TimeUnit.MILLISECONDS.toNanos(wait)) {
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder buff = new StringBuilder();
        try {
            try {
                int x;
                while ((x = this.in.read()) >= 0) {
                    if (x < 32) {
                        if (buff.length() <= 0) continue;
                        String s = buff.toString();
                        buff.setLength(0);
                        LinkedList<String> linkedList = this.list;
                        synchronized (linkedList) {
                            this.list.add(s);
                            this.list.notifyAll();
                            continue;
                        }
                    }
                    buff.append((char)x);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IOUtils.closeSilently(this.in);
        }
        catch (Throwable throwable) {
            if (buff.length() > 0) {
                LinkedList<String> linkedList = this.list;
                synchronized (linkedList) {
                    this.list.add(buff.toString());
                    this.list.notifyAll();
                }
            }
            throw throwable;
        }
        if (buff.length() > 0) {
            LinkedList<String> linkedList = this.list;
            synchronized (linkedList) {
                this.list.add(buff.toString());
                this.list.notifyAll();
            }
        }
    }
}

