/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.h2.Driver;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.DeleteDbFiles;

public class TestBtreeIndex
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.big = true;
        test.test();
        test.test();
        test.test();
    }

    @Override
    public void test() throws SQLException {
        Random random = new Random();
        int i = 0;
        while (i < this.getSize(1, 4)) {
            this.testAddDelete();
            int seed = random.nextInt();
            this.testCase(seed);
            ++i;
        }
    }

    private void testAddDelete() throws SQLException {
        this.deleteDb(this.getTestName());
        try (Connection conn = this.getConnection(this.getTestName());){
            Statement stat = conn.createStatement();
            stat.execute("CREATE TABLE TEST(ID bigint primary key)");
            int count = 1000;
            stat.execute("insert into test select x from system_range(1, " + count + ")");
            if (!this.config.memory) {
                conn.close();
                conn = this.getConnection(this.getTestName());
                stat = conn.createStatement();
            }
            int i = 1;
            while (i < count) {
                ResultSet rs = stat.executeQuery("select * from test order by id");
                int j = i;
                while (rs.next()) {
                    this.assertEquals(j, rs.getInt(1));
                    ++j;
                }
                stat.execute("delete from test where id =" + i);
                ++i;
            }
            stat.execute("drop all objects delete files");
        }
        this.deleteDb(this.getTestName());
    }

    private void testCase(int seed) throws SQLException {
        this.testOne(seed);
    }

    private void testOne(int seed) throws SQLException {
        int prefixLength;
        int distinct;
        Driver.load();
        this.deleteDb(this.getTestName());
        this.printTime("testIndex " + seed);
        Random random = new Random(seed);
        if (random.nextBoolean()) {
            distinct = random.nextInt(8000) + 1;
            prefixLength = random.nextInt(8000) + 1;
        } else if (random.nextBoolean()) {
            distinct = random.nextInt(16000) + 1;
            prefixLength = random.nextInt(100) + 1;
        } else {
            distinct = random.nextInt(10) + 1;
            prefixLength = random.nextInt(10) + 1;
        }
        boolean delete = random.nextBoolean();
        StringBuilder buff = new StringBuilder();
        int j = 0;
        while (j < prefixLength) {
            buff.append("x");
            if (buff.length() % 10 == 0) {
                buff.append(buff.length());
            }
            ++j;
        }
        String prefix = buff.toString().substring(0, prefixLength);
        DeleteDbFiles.execute(this.getBaseDir() + "/" + this.getTestName(), null, true);
        Throwable throwable = null;
        Object var9_11 = null;
        try (Connection conn = this.getConnection(this.getTestName());){
            Statement stat = conn.createStatement();
            stat.execute("CREATE TABLE a(text VARCHAR PRIMARY KEY)");
            PreparedStatement prepInsert = conn.prepareStatement("INSERT INTO a VALUES(?)");
            PreparedStatement prepDelete = conn.prepareStatement("DELETE FROM a WHERE text=?");
            PreparedStatement prepDeleteAllButOne = conn.prepareStatement("DELETE FROM a WHERE text <> ?");
            int count = 0;
            int i = 0;
            while (i < 1000) {
                block31: {
                    int y;
                    block30: {
                        y = random.nextInt(distinct);
                        try {
                            prepInsert.setString(1, prefix + y);
                            prepInsert.executeUpdate();
                            ++count;
                        }
                        catch (SQLException e) {
                            if (e.getSQLState().equals("23505")) break block30;
                            TestBase.logError("error", e);
                            break;
                        }
                    }
                    if (delete && random.nextInt(10) == 1) {
                        if (random.nextInt(4) == 1) {
                            try {
                                prepDeleteAllButOne.setString(1, prefix + y);
                                int deleted = prepDeleteAllButOne.executeUpdate();
                                if (deleted < count - 1) {
                                    this.printError(seed, "deleted:" + deleted + " i:" + i);
                                }
                                count -= deleted;
                                break block31;
                            }
                            catch (SQLException e) {
                                TestBase.logError("error", e);
                                break;
                            }
                        }
                        try {
                            prepDelete.setString(1, prefix + y);
                            int deleted = prepDelete.executeUpdate();
                            if (deleted > 1) {
                                this.printError(seed, "deleted:" + deleted + " i:" + i);
                            }
                            count -= deleted;
                        }
                        catch (SQLException e) {
                            TestBase.logError("error", e);
                            break;
                        }
                    }
                }
                ++i;
            }
            int testCount = 0;
            ResultSet rs = stat.executeQuery("SELECT text FROM a ORDER BY text");
            ResultSet rs2 = conn.createStatement().executeQuery("SELECT text FROM a ORDER BY 'x' || text");
            testCount = 0;
            while (rs.next() && rs2.next()) {
                if (!rs.getString(1).equals(rs2.getString(1))) {
                    this.assertEquals("" + testCount, rs.getString(1), rs2.getString(1));
                }
                ++testCount;
            }
            this.assertFalse(rs.next());
            this.assertFalse(rs2.next());
            if (testCount != count) {
                this.printError(seed, "count:" + count + " testCount:" + testCount);
            }
            if ((rs = stat.executeQuery("SELECT text, count(*) FROM a GROUP BY text HAVING COUNT(*)>1")).next()) {
                this.printError(seed, "testCount:" + testCount + " " + rs.getString(1));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb(this.getTestName());
    }

    private void printError(int seed, String message) {
        TestBase.logError("new TestBtreeIndex().init(test).testCase(" + seed + "); // " + message, null);
        this.fail(message);
    }
}

