/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.h2.test.TestAll;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.Task;

public class TestConcurrentUpdate
extends TestDb {
    private static final int THREADS = 10;
    private static final int ROW_COUNT = 3;

    public static void main(String ... a) throws Exception {
        TestAll config = new TestAll();
        System.out.println(config);
        TestBase test = TestConcurrentUpdate.createCaller().init(config);
        int i = 0;
        while (i < 10) {
            System.out.println("Pass #" + i);
            test.testFromMain();
            ++i;
        }
    }

    @Override
    public void test() throws Exception {
        this.testConcurrent();
        this.testConcurrentShutdown();
    }

    private void testConcurrent() throws Exception {
        this.deleteDb("concurrent");
        final String url = this.getURL("concurrent;LOCK_TIMEOUT=2000", true);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection conn = this.getConnection(url);){
            Statement stat = conn.createStatement();
            stat.execute("create table test(id int primary key, name varchar)");
            Task[] tasks = new Task[10];
            int i = 0;
            while (i < 10) {
                Task t;
                final int threadId = i;
                tasks[i] = t = new Task(){

                    @Override
                    public void call() throws Exception {
                        Random r = new Random(threadId);
                        Throwable throwable = null;
                        Object var3_4 = null;
                        try (Connection conn = TestConcurrentUpdate.this.getConnection(url);){
                            PreparedStatement insert = conn.prepareStatement("merge into test values(?, ?)");
                            PreparedStatement update = conn.prepareStatement("update test set name = ? where id = ?");
                            PreparedStatement delete = conn.prepareStatement("delete from test where id = ?");
                            PreparedStatement select = conn.prepareStatement("select * from test where id = ?");
                            block11: while (!this.stop) {
                                int x = r.nextInt(3);
                                String data = "x" + r.nextInt(3);
                                switch (r.nextInt(4)) {
                                    case 0: {
                                        insert.setInt(1, x);
                                        insert.setString(2, data);
                                        insert.execute();
                                        break;
                                    }
                                    case 1: {
                                        update.setString(1, data);
                                        update.setInt(2, x);
                                        update.execute();
                                        break;
                                    }
                                    case 2: {
                                        delete.setInt(1, x);
                                        delete.execute();
                                        break;
                                    }
                                    case 3: {
                                        select.setInt(1, x);
                                        ResultSet rs = select.executeQuery();
                                        while (rs.next()) {
                                            rs.getString(2);
                                        }
                                        continue block11;
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                };
                t.execute();
                ++i;
            }
            Thread.sleep(2000L);
            boolean success = true;
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task t = taskArray[n2];
                t.join();
                Exception exception = t.getException();
                if (exception != null) {
                    TestConcurrentUpdate.logError("", exception);
                    success = false;
                }
                ++n2;
            }
            assert (success);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void testConcurrentShutdown() throws SQLException {
        if (this.config.memory) {
            return;
        }
        this.deleteDb(this.getTestName());
        final String url = this.getURL(this.getTestName(), true);
        Throwable throwable = null;
        Object var3_5 = null;
        try (Connection connection = this.getConnection(url);){
            connection.createStatement().execute("create table test(id int primary key, v int)");
            connection.createStatement().execute("insert into test values(0, 0)");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        int len = 2;
        final CountDownLatch latch = new CountDownLatch(len + 1);
        ArrayList<Task> tasks = new ArrayList<Task>();
        tasks.add(new Task(){

            @Override
            public void call() throws Exception {
                Throwable throwable = null;
                Object var2_3 = null;
                try (Connection c = TestConcurrentUpdate.this.getConnection(url);){
                    c.setAutoCommit(false);
                    c.createStatement().execute("insert into test values(1, 1)");
                    latch.countDown();
                    latch.await();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
        int i = 0;
        while (i < len) {
            tasks.add(new Task(){

                @Override
                public void call() throws Exception {
                    Throwable throwable = null;
                    Object var2_3 = null;
                    try (Connection c = TestConcurrentUpdate.this.getConnection(url);){
                        Statement stmt = c.createStatement();
                        latch.countDown();
                        latch.await();
                        stmt.execute("shutdown");
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            });
            ++i;
        }
        for (Task task : tasks) {
            task.execute();
        }
        for (Task task : tasks) {
            task.getException();
        }
        Throwable throwable3 = null;
        Iterator iterator = null;
        try (Connection connection = this.getConnection(this.getTestName());){
            ResultSet rs = connection.createStatement().executeQuery("select count(*) from test");
            rs.next();
            this.assertEquals(1, rs.getInt(1));
        }
        catch (Throwable throwable4) {
            if (throwable3 == null) {
                throwable3 = throwable4;
            } else if (throwable3 != throwable4) {
                throwable3.addSuppressed(throwable4);
            }
            throw throwable3;
        }
    }
}

