/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.db.Db;

public class TestFuzzOptimizations
extends TestDb {
    private Connection conn;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(this.getTestName());
        this.conn = this.getConnection(this.getTestName());
        if (!this.config.diskResult) {
            this.testIn();
        }
        this.testGroupSorted();
        this.testInSelect();
        this.conn.close();
        this.deleteDb(this.getTestName());
    }

    private void testIn() throws SQLException {
        Db db = new Db(this.conn);
        db.execute("create table test0(a int, b int, c int)");
        db.execute("create index idx_1 on test0(a)");
        db.execute("create index idx_2 on test0(b, a)");
        db.execute("create table test1(a int, b int, c int)");
        db.execute("insert into test0 select x / 100, mod(x / 10, 10), mod(x, 10) from system_range(0, 999)");
        db.execute("update test0 set a = null where a = 9");
        db.execute("update test0 set b = null where b = 9");
        db.execute("update test0 set c = null where c = 9");
        db.execute("insert into test1 select * from test0");
        Db.Prepared p = db.prepare("select * from test0 where b in(select a from test1 where a <? and a not in(select c from test1 where b <=10 and a in(select a from test1 where b =1 or b =2 and b not in(2))) or c <>a) and c in(0, 10) and c in(10, 0, 0) order by 1, 2, 3");
        p.set(1);
        p.execute();
        Random seedGenerator = new Random();
        String[] columns = new String[]{"a", "b", "c"};
        String[] stringArray = new String[8];
        stringArray[1] = "0";
        stringArray[2] = "0";
        stringArray[3] = "1";
        stringArray[4] = "2";
        stringArray[5] = "10";
        stringArray[6] = "a";
        stringArray[7] = "?";
        String[] values = stringArray;
        String[] compares = new String[]{"in(", "not in(", "=", "=", ">", "<", ">=", "<=", "<>", "in(select", "not in(select"};
        int size = this.getSize(100, 1000);
        int i = 0;
        while (i < size) {
            long seed = seedGenerator.nextLong();
            this.println("testIn() seed: " + seed);
            Random random = new Random(seed);
            ArrayList<String> params = new ArrayList<String>();
            String condition = this.getRandomCondition(random, params, columns, compares, values);
            String message = "testIn() seed: " + seed + " " + condition;
            this.executeAndCompare(condition, params, message);
            if (params.size() > 0) {
                int j = 0;
                while (j < params.size()) {
                    String value = values[random.nextInt(values.length - 2)];
                    params.set(j, value);
                    ++j;
                }
                this.executeAndCompare(condition, params, message);
            }
            ++i;
        }
        this.executeAndCompare("a >=0 and b in(?, 2) and a in(1, ?, null)", Arrays.asList("10", "2"), "testIn() seed=-6191135606105920350L");
        db.execute("drop table test0, test1");
    }

    private void executeAndCompare(String condition, List<String> params, String message) throws SQLException {
        PreparedStatement prep0 = this.conn.prepareStatement("select * from test0 where " + condition + " order by 1, 2, 3");
        PreparedStatement prep1 = this.conn.prepareStatement("select * from test1 where " + condition + " order by 1, 2, 3");
        int j = 0;
        while (j < params.size()) {
            prep0.setString(j + 1, params.get(j));
            prep1.setString(j + 1, params.get(j));
            ++j;
        }
        ResultSet rs0 = prep0.executeQuery();
        ResultSet rs1 = prep1.executeQuery();
        this.assertEquals(message, rs0, rs1);
    }

    private String getRandomCondition(Random random, ArrayList<String> params, String[] columns, String[] compares, String[] values) {
        int comp = 1 + random.nextInt(4);
        StringBuilder buff = new StringBuilder();
        int j = 0;
        while (j < comp) {
            if (j > 0) {
                buff.append(random.nextBoolean() ? " and " : " or ");
            }
            String column = columns[random.nextInt(columns.length)];
            String compare = compares[random.nextInt(compares.length)];
            buff.append(column).append(' ').append(compare);
            if (compare.endsWith("in(")) {
                int len = 1 + random.nextInt(3);
                int k = 0;
                while (k < len) {
                    if (k > 0) {
                        buff.append(", ");
                    }
                    String value = values[random.nextInt(values.length)];
                    buff.append(value);
                    if ("?".equals(value)) {
                        value = values[random.nextInt(values.length - 2)];
                        params.add(value);
                    }
                    ++k;
                }
                buff.append(")");
            } else if (compare.endsWith("(select")) {
                String col = columns[random.nextInt(columns.length)];
                buff.append(" ").append(col).append(" from test1 where ");
                String condition = this.getRandomCondition(random, params, columns, compares, values);
                buff.append(condition);
                buff.append(")");
            } else {
                String value = values[random.nextInt(values.length)];
                buff.append(value);
                if ("?".equals(value)) {
                    value = values[random.nextInt(values.length - 2)];
                    params.add(value);
                }
            }
            ++j;
        }
        return buff.toString();
    }

    private void testInSelect() {
        Db db = new Db(this.conn);
        db.execute("CREATE TABLE TEST(A INT, B INT)");
        db.execute("CREATE INDEX IDX ON TEST(A)");
        db.execute("INSERT INTO TEST SELECT X/4, MOD(X, 4) FROM SYSTEM_RANGE(1, 16)");
        db.execute("UPDATE TEST SET A = NULL WHERE A = 0");
        db.execute("UPDATE TEST SET B = NULL WHERE B = 0");
        Random random = new Random();
        long seed = random.nextLong();
        this.println("testInSelect() seed: " + seed);
        int i = 0;
        while (i < 100) {
            String column = random.nextBoolean() ? "A" : "B";
            String value = (new String[]{"NULL", "0", "A", "B"})[random.nextInt(4)];
            String compare = random.nextBoolean() ? "A" : "B";
            int x = random.nextInt(3);
            String sql1 = "SELECT * FROM TEST T WHERE " + column + "+0 IN(SELECT " + value + " FROM TEST I WHERE I." + compare + "=?) ORDER BY 1, 2";
            String sql2 = "SELECT * FROM TEST T WHERE " + column + " IN(SELECT " + value + " FROM TEST I WHERE I." + compare + "=?) ORDER BY 1, 2";
            List<Map<String, Object>> a = db.prepare(sql1).set(x).query();
            List<Map<String, Object>> b = db.prepare(sql2).set(x).query();
            this.assertTrue("testInSelect() seed: " + seed + " sql: " + sql1 + " a: " + String.valueOf(a) + " b: " + String.valueOf(b), a.equals(b));
            ++i;
        }
        db.execute("DROP TABLE TEST");
    }

    private void testGroupSorted() {
        Db db = new Db(this.conn);
        db.execute("CREATE TABLE TEST(A INT, B INT, C INT)");
        Random random = new Random();
        long seed = random.nextLong();
        this.println("testGroupSorted() seed: " + seed);
        int i = 0;
        while (i < 100) {
            Db.Prepared p = db.prepare("INSERT INTO TEST VALUES(?, ?, ?)");
            String[] stringArray = new String[4];
            stringArray[1] = "0";
            stringArray[2] = "1";
            stringArray[3] = "2";
            p.set(stringArray[random.nextInt(4)]);
            String[] stringArray2 = new String[4];
            stringArray2[1] = "0";
            stringArray2[2] = "1";
            stringArray2[3] = "2";
            p.set(stringArray2[random.nextInt(4)]);
            String[] stringArray3 = new String[4];
            stringArray3[1] = "0";
            stringArray3[2] = "1";
            stringArray3[3] = "2";
            p.set(stringArray3[random.nextInt(4)]);
            p.execute();
            ++i;
        }
        int len = this.getSize(1000, 3000);
        int i2 = 0;
        while (i2 < len / 10) {
            Object x;
            db.execute("CREATE TABLE TEST_INDEXED AS SELECT * FROM TEST");
            int jLen = 1 + random.nextInt(2);
            int j = 0;
            while (j < jLen) {
                x = "CREATE INDEX IDX" + j + " ON TEST_INDEXED(";
                int kLen = 1 + random.nextInt(2);
                int k = 0;
                while (k < kLen) {
                    if (k > 0) {
                        x = (String)x + ",";
                    }
                    x = (String)x + (new String[]{"A", "B", "C"})[random.nextInt(3)];
                    ++k;
                }
                db.execute((String)x + ")");
                ++j;
            }
            j = 0;
            while (j < 10) {
                x = "SELECT ";
                int k = 0;
                while (k < 3) {
                    if (k > 0) {
                        x = (String)x + ",";
                    }
                    x = (String)x + (new String[]{"SUM(A)", "MAX(B)", "AVG(C)", "COUNT(B)"})[random.nextInt(4)];
                    x = (String)x + " S" + k;
                    ++k;
                }
                x = (String)x + " FROM ";
                Object group = " GROUP BY ";
                int kLen = 1 + random.nextInt(2);
                int k2 = 0;
                while (k2 < kLen) {
                    if (k2 > 0) {
                        group = (String)group + ",";
                    }
                    group = (String)group + (new String[]{"A", "B", "C"})[random.nextInt(3)];
                    ++k2;
                }
                group = (String)group + " ORDER BY 1, 2, 3";
                List<Map<String, Object>> a = db.query((String)x + "TEST" + (String)group);
                List<Map<String, Object>> b = db.query((String)x + "TEST_INDEXED" + (String)group);
                this.assertEquals(a.toString(), b.toString());
                this.assertTrue(a.equals(b));
                ++j;
            }
            db.execute("DROP TABLE TEST_INDEXED");
            ++i2;
        }
        db.execute("DROP TABLE TEST");
    }
}

