/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.utils.SelfDestructor;

public class TestKill
extends TestDb {
    private static final String DIR = TestBase.getTestDir("kill");
    private static final int ACCOUNTS = 10;
    private Connection conn;
    private final Random random = new Random(1L);

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        String connect = "";
        connect = ";MAX_LOG_SIZE=10;THROTTLE=80";
        String url = this.getURL(DIR + "/kill" + connect, true);
        String user = this.getUser();
        String password = this.getPassword();
        String selfDestruct = SelfDestructor.getPropertyString(60);
        String[] procDef = new String[]{TestKill.getJVM(), selfDestruct, "-cp", this.getClassPath(), "org.h2.test.synth.TestKillProcess", url, user, password, this.getBaseDir(), "10"};
        int i = 0;
        while (true) {
            this.printTime("TestKill " + i);
            if (i % 10 == 0) {
                this.trace("deleting db...");
                this.deleteDb("kill");
            }
            this.conn = this.getConnection(url);
            this.createTables();
            this.checkData();
            this.initData();
            this.conn.close();
            Process proc = Runtime.getRuntime().exec(procDef);
            int runtime = this.random.nextInt(10000);
            this.trace("running...");
            Thread.sleep(runtime);
            this.trace("stopping...");
            proc.destroy();
            proc.waitFor();
            this.trace("stopped");
            ++i;
        }
    }

    private void createTables() throws SQLException {
        this.trace("createTables...");
        Statement stat = this.conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS ACCOUNT(ID INT PRIMARY KEY, SUM INT)");
        stat.execute("CREATE TABLE IF NOT EXISTS LOG(ID IDENTITY, ACCOUNTID INT, AMOUNT INT, FOREIGN KEY(ACCOUNTID) REFERENCES ACCOUNT(ID))");
        stat.execute("CREATE TABLE IF NOT EXISTS TEST_A(ID INT PRIMARY KEY, DATA VARCHAR)");
        stat.execute("CREATE TABLE IF NOT EXISTS TEST_B(ID INT PRIMARY KEY, DATA VARCHAR)");
    }

    private void initData() throws SQLException {
        this.trace("initData...");
        this.conn.createStatement().execute("DROP TABLE LOG");
        this.conn.createStatement().execute("DROP TABLE ACCOUNT");
        this.conn.createStatement().execute("DROP TABLE TEST_A");
        this.conn.createStatement().execute("DROP TABLE TEST_B");
        this.createTables();
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO ACCOUNT VALUES(?, 0)");
        int i = 0;
        while (i < 10) {
            prep.setInt(1, i);
            prep.execute();
            ++i;
        }
        PreparedStatement p1 = this.conn.prepareStatement("INSERT INTO TEST_A VALUES(?, '')");
        PreparedStatement p2 = this.conn.prepareStatement("INSERT INTO TEST_B VALUES(?, '')");
        int i2 = 0;
        while (i2 < 10) {
            p1.setInt(1, i2);
            p2.setInt(1, i2);
            p1.execute();
            p2.execute();
            ++i2;
        }
    }

    private void checkData() throws SQLException {
        this.trace("checkData...");
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT * FROM ACCOUNT ORDER BY ID");
        PreparedStatement prep = this.conn.prepareStatement("SELECT SUM(AMOUNT) FROM LOG WHERE ACCOUNTID=?");
        while (rs.next()) {
            int account = rs.getInt(1);
            int sum = rs.getInt(2);
            prep.setInt(1, account);
            ResultSet rs2 = prep.executeQuery();
            rs2.next();
            int sumLog = rs2.getInt(1);
            this.assertEquals(sum, sumLog);
            this.trace("account=" + account + " sum=" + sum);
        }
        PreparedStatement p1 = this.conn.prepareStatement("SELECT * FROM TEST_A WHERE ID=?");
        PreparedStatement p2 = this.conn.prepareStatement("SELECT * FROM TEST_B WHERE ID=?");
        int i = 0;
        while (i < 10) {
            p1.setInt(1, i);
            p2.setInt(1, i);
            ResultSet r1 = p1.executeQuery();
            ResultSet r2 = p2.executeQuery();
            boolean hasData = r1.next();
            this.assertEquals(r2.next(), hasData);
            if (hasData) {
                String d1 = r1.getString("DATA");
                String d2 = r2.getString("DATA");
                this.assertEquals(d1, d2);
                this.assertFalse(r1.next());
                this.assertFalse(r2.next());
                this.trace("test: data=" + d1);
            } else {
                this.trace("test: empty");
            }
            ++i;
        }
    }
}

