/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestLimit
extends TestDb {
    private Statement stat;

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("limit");
        Connection conn = this.getConnection("limit");
        this.stat = conn.createStatement();
        this.stat.execute("create table test(id int) as select x from system_range(1, 10)");
        int maxRows = 0;
        while (maxRows < 12) {
            this.stat.setMaxRows(maxRows);
            int limit = -1;
            while (limit < 12) {
                int offset = -1;
                while (offset < 12) {
                    int l = limit < 0 ? 10 : Math.min(10, limit);
                    int d = 0;
                    while (d < 2) {
                        int m = maxRows <= 0 ? 10 : Math.min(10, maxRows);
                        int expected = Math.min(m, l);
                        if (offset > 0) {
                            expected = Math.max(0, Math.min(10 - offset, expected));
                        }
                        String s = "select " + (d == 1 ? "distinct " : "") + "* from test" + (String)(offset >= 0 ? " offset " + offset + " rows" : "") + (String)(limit >= 0 ? " fetch next " + limit + " rows only" : "");
                        this.assertRow(expected, s);
                        String union = "(" + s + ") union (" + s + ")";
                        this.assertRow(expected, union);
                        int n = m = maxRows <= 0 ? 20 : Math.min(20, maxRows);
                        if (offset > 0) {
                            l = Math.max(0, Math.min(10 - offset, l));
                        }
                        expected = Math.min(m, l * 2);
                        union = "(" + s + ") union all (" + s + ")";
                        this.assertRow(expected, union);
                        int unionLimit = -1;
                        while (unionLimit < 5) {
                            int e = unionLimit < 0 ? 20 : Math.min(20, unionLimit);
                            e = Math.min(expected, e);
                            String u = union;
                            if (unionLimit >= 0) {
                                u = u + " fetch first " + unionLimit + " rows only";
                            }
                            this.assertRow(e, u);
                            ++unionLimit;
                        }
                        ++d;
                    }
                    ++offset;
                }
                ++limit;
            }
            ++maxRows;
        }
        this.assertEquals(0, this.stat.executeUpdate("delete from test limit 0"));
        this.assertEquals(1, this.stat.executeUpdate("delete from test limit 1"));
        this.assertEquals(2, this.stat.executeUpdate("delete from test limit 2"));
        this.assertThrows(90008, this.stat).executeUpdate("delete from test limit null");
        conn.close();
        this.deleteDb("limit");
    }

    private void assertRow(int expected, String sql) throws SQLException {
        try {
            this.assertResultRowCount(expected, this.stat.executeQuery(sql));
        }
        catch (AssertionError e) {
            this.stat.executeQuery(sql + " -- cache killer");
            throw e;
        }
    }
}

