/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.File;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.util.ScriptReader;

public class TestNestedJoins
extends TestDb {
    private final ArrayList<Statement> dbs = new ArrayList();

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("nestedJoins");
        this.testCases();
        this.testRandom();
        this.deleteDb("nestedJoins");
    }

    private void testRandom() throws Exception {
        Connection c22;
        Connection conn = this.getConnection("nestedJoins");
        this.dbs.add(conn.createStatement());
        try {
            Class.forName("org.postgresql.Driver");
            c22 = DriverManager.getConnection("jdbc:postgresql:test?loggerLevel=OFF", "sa", "sa");
            this.dbs.add(c22.createStatement());
        }
        catch (Exception c22) {
            // empty catch block
        }
        this.deleteDerby();
        try {
            Class.forName("org.apache.derby.iapi.jdbc.AutoloadedDriver");
            c22 = DriverManager.getConnection("jdbc:derby:" + this.getBaseDir() + "/derby/test;create=true", "sa", "sa");
            this.dbs.add(c22.createStatement());
        }
        catch (Throwable c23) {
            // empty catch block
        }
        String shortest = null;
        Throwable shortestEx = null;
        int i = 0;
        while (i < 10) {
            try {
                this.execute("drop table t" + i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String sql = "create table t" + i + "(x int)";
            this.trace(sql + ";");
            this.execute(sql);
            if (i >= 4) {
                int j = 0;
                while (j < i) {
                    sql = "insert into t" + i + " values(" + j + ")";
                    this.trace(sql + ";");
                    this.execute(sql);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 4) {
                if ((i & 1 << j) != 0) {
                    String sql = "insert into t" + j + " values(" + i + ")";
                    this.trace(sql + ";");
                    this.execute(sql);
                }
                ++j;
            }
            ++i;
        }
        Random random = new Random(1L);
        int size = this.getSize(1000, 10000);
        int i2 = 0;
        while (i2 < size) {
            block23: {
                StringBuilder buff = new StringBuilder();
                int t = 1 + random.nextInt(9);
                buff.append("select ");
                int j = 0;
                while (j < t) {
                    if (j > 0) {
                        buff.append(", ");
                    }
                    buff.append("t" + j + ".x ");
                    ++j;
                }
                buff.append("from ");
                this.appendRandomJoin(random, buff, 0, t - 1);
                String sql = buff.toString();
                try {
                    this.execute(sql);
                }
                catch (Throwable e) {
                    if (e instanceof SQLException) {
                        this.trace(sql);
                        this.fail(sql);
                    }
                    if (shortest != null && sql.length() >= shortest.length()) break block23;
                    shortest = sql;
                    shortestEx = e;
                }
            }
            ++i2;
        }
        if (shortest != null) {
            shortestEx.printStackTrace();
            this.fail(shortest + " " + String.valueOf(shortestEx));
        }
        i2 = 0;
        while (i2 < 10) {
            try {
                this.execute("drop table t" + i2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
        for (Statement s : this.dbs) {
            s.getConnection().close();
        }
        this.deleteDerby();
        this.deleteDb("nestedJoins");
    }

    private void deleteDerby() {
        try {
            new File("derby.log").delete();
            try {
                DriverManager.getConnection("jdbc:derby:" + this.getBaseDir() + "/derby/test;shutdown=true", "sa", "sa");
            }
            catch (Exception exception) {
                // empty catch block
            }
            FileUtils.deleteRecursive(this.getBaseDir() + "/derby", false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendRandomJoin(Random random, StringBuilder buff, int min, int max) {
        if (min == max) {
            buff.append("t" + min);
            return;
        }
        buff.append("(");
        int m = min + random.nextInt(max - min);
        int left = min + (m == min ? 0 : random.nextInt(m - min));
        this.appendRandomJoin(random, buff, min, m);
        switch (random.nextInt(3)) {
            case 0: {
                buff.append(" inner join ");
                break;
            }
            case 1: {
                buff.append(" left outer join ");
                break;
            }
            case 2: {
                buff.append(" right outer join ");
            }
        }
        int right = m + (++m == max ? 0 : random.nextInt(max - m));
        this.appendRandomJoin(random, buff, m, max);
        buff.append(" on t" + left + ".x = t" + right + ".x ");
        buff.append(")");
    }

    private void execute(String sql) throws SQLException {
        String expected = null;
        SQLException e = null;
        for (Statement s : this.dbs) {
            try {
                boolean result = s.execute(sql);
                if (!result) continue;
                String data = TestNestedJoins.getResult(s.getResultSet());
                if (expected == null) {
                    expected = data;
                    continue;
                }
                this.assertEquals(sql, expected, data);
            }
            catch (SQLException e2) {
                e = e2;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    private static String getResult(ResultSet rs) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            StringBuilder buff = new StringBuilder();
            int i = 0;
            while (i < rs.getMetaData().getColumnCount()) {
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(rs.getString(i + 1));
                ++i;
            }
            list.add(buff.toString());
        }
        Collections.sort(list);
        return list.toString();
    }

    private void testCases() throws Exception {
        Connection conn = this.getConnection("nestedJoins");
        Statement stat = conn.createStatement();
        this.assertThrows(42122, stat).execute("select 1 from dual a right outer join (select b.x from dual b) c on unknown_table.x = c.x, dual d");
        stat.execute("create table test(id int primary key)");
        stat.execute("insert into test values(1)");
        stat.execute("select * from test t right outer join (select t2.id, count(*) c from test t2 group by t2.id) x on x.id = t.id where t.id = 1");
        stat.execute("select 1 from (select 2 from ((test t1 inner join test t2 on t1.id=t2.id) inner join test t3 on t3.id=t1.id)) x");
        stat.execute("drop table test");
        stat.execute("create table test(id int)");
        stat.execute("select 1 from test a right outer join test b on a.id = 1, test c");
        stat.execute("drop table test");
        stat.execute("create table a(id int)");
        stat.execute("create table b(id int)");
        stat.execute("create table c(id int)");
        ResultSet rs = stat.executeQuery("explain select * from a inner join b inner join c on c.id = b.id on b.id = a.id");
        this.assertTrue(rs.next());
        String sql = rs.getString(1);
        this.assertContains(sql, "(");
        stat.execute("drop table a, b, c");
        stat.execute("create table test(id int primary key, x int) as select x, x from system_range(1, 10)");
        stat.execute("create index on test(x)");
        stat.execute("create table o(id int primary key) as select x from system_range(1, 10)");
        rs = stat.executeQuery("explain select * from test a inner join test b on a.id=b.id inner join o on o.id=a.id where b.x=1");
        this.assertTrue(rs.next());
        sql = rs.getString(1);
        this.assertTrue("using table scan", sql.indexOf("tableScan") < 0);
        rs = stat.executeQuery("explain select * from test a inner join test b on a.id=b.id left outer join o on o.id=a.id where b.x=1");
        this.assertTrue(rs.next());
        sql = rs.getString(1);
        stat.execute("drop table test");
        stat.execute("drop table o");
        stat.execute("create table test(id int primary key)");
        stat.execute("insert into test values(1)");
        rs = stat.executeQuery("select b.id from test a left outer join test b on a.id = b.id and not exists (select * from test c where c.id = b.id)");
        this.assertTrue(rs.next());
        sql = rs.getString(1);
        this.assertEquals(null, sql);
        stat.execute("drop table test");
        stat.execute("create table test(id int primary key)");
        rs = stat.executeQuery("explain select * from test a left outer join (test c) on a.id = c.id");
        this.assertTrue(rs.next());
        sql = rs.getString(1);
        this.assertContains(sql, "PRIMARY_KEY");
        stat.execute("drop table test");
        stat.execute("create table t1(a int, b int)");
        stat.execute("create table t2(a int, b int)");
        stat.execute("create table t3(a int, b int)");
        stat.execute("create table t4(a int, b int)");
        stat.execute("insert into t1 values(1,1), (2,2), (3,3)");
        stat.execute("insert into t2 values(1,1), (2,2)");
        stat.execute("insert into t3 values(1,1), (3,3)");
        stat.execute("insert into t4 values(1,1), (2,2), (3,3), (4,4)");
        rs = stat.executeQuery("explain select distinct t1.a, t2.a, t3.a from t1 right outer join t3 on t1.b=t3.a right outer join t2 on t2.b=t1.a");
        this.assertTrue(rs.next());
        sql = TestNestedJoins.cleanRemarks(rs.getString(1));
        this.assertEquals("SELECT DISTINCT \"T1\".\"A\", \"T2\".\"A\", \"T3\".\"A\" FROM \"PUBLIC\".\"T2\" LEFT OUTER JOIN ( \"PUBLIC\".\"T3\" LEFT OUTER JOIN \"PUBLIC\".\"T1\" ON \"T1\".\"B\" = \"T3\".\"A\" ) ON \"T2\".\"B\" = \"T1\".\"A\"", sql);
        rs = stat.executeQuery("select distinct t1.a, t2.a, t3.a from t1 right outer join t3 on t1.b=t3.a right outer join t2 on t2.b=t1.a");
        this.assertTrue(rs.next());
        this.assertEquals(null, rs.getString(1));
        this.assertEquals("2", rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("1", rs.getString(2));
        this.assertEquals("1", rs.getString(3));
        this.assertFalse(rs.next());
        stat.execute("drop table t1, t2, t3, t4");
        stat.execute("create table a(x int)");
        stat.execute("create table b(x int)");
        stat.execute("create table c(x int)");
        stat.execute("insert into a values(1)");
        stat.execute("insert into b values(1)");
        stat.execute("insert into c values(1), (2)");
        rs = stat.executeQuery("explain select a.x, b.x, c.x from a inner join b on a.x = b.x right outer join c on c.x = a.x");
        this.assertTrue(rs.next());
        sql = TestNestedJoins.cleanRemarks(rs.getString(1));
        this.assertEquals("SELECT \"A\".\"X\", \"B\".\"X\", \"C\".\"X\" FROM \"PUBLIC\".\"C\" LEFT OUTER JOIN ( \"PUBLIC\".\"A\" INNER JOIN \"PUBLIC\".\"B\" ON \"A\".\"X\" = \"B\".\"X\" ) ON \"C\".\"X\" = \"A\".\"X\"", sql);
        rs = stat.executeQuery("select a.x, b.x, c.x from a inner join b on a.x = b.x right outer join c on c.x = a.x");
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("1", rs.getString(2));
        this.assertEquals("1", rs.getString(3));
        this.assertTrue(rs.next());
        this.assertEquals(null, rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals("2", rs.getString(3));
        this.assertFalse(rs.next());
        stat.execute("drop table a, b, c");
        stat.execute("create table a(x int)");
        stat.execute("create table b(x int)");
        stat.execute("create table c(x int, y int)");
        stat.execute("insert into a values(1), (2)");
        stat.execute("insert into b values(3)");
        stat.execute("insert into c values(1, 3)");
        stat.execute("insert into c values(4, 5)");
        rs = stat.executeQuery("explain select * from a left outer join (b left outer join c on b.x = c.y) on a.x = c.x");
        this.assertTrue(rs.next());
        sql = TestNestedJoins.cleanRemarks(rs.getString(1));
        this.assertEquals("SELECT \"PUBLIC\".\"A\".\"X\", \"PUBLIC\".\"B\".\"X\", \"PUBLIC\".\"C\".\"X\", \"PUBLIC\".\"C\".\"Y\" FROM \"PUBLIC\".\"A\" LEFT OUTER JOIN ( \"PUBLIC\".\"B\" LEFT OUTER JOIN \"PUBLIC\".\"C\" ON \"B\".\"X\" = \"C\".\"Y\" ) ON \"A\".\"X\" = \"C\".\"X\"", sql);
        rs = stat.executeQuery("select * from a left outer join (b left outer join c on b.x = c.y) on a.x = c.x");
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("3", rs.getString(2));
        this.assertEquals("1", rs.getString(3));
        this.assertEquals("3", rs.getString(4));
        this.assertTrue(rs.next());
        this.assertEquals("2", rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertEquals(null, rs.getString(4));
        this.assertFalse(rs.next());
        stat.execute("drop table a, b, c");
        stat.execute("create table a(x int primary key)");
        stat.execute("insert into a values(0), (1)");
        stat.execute("create table b(x int primary key)");
        stat.execute("insert into b values(0)");
        stat.execute("create table c(x int primary key)");
        rs = stat.executeQuery("select a.*, b.*, c.* from a left outer join (b inner join c on b.x = c.x) on a.x = b.x");
        this.assertTrue(rs.next());
        this.assertEquals("0", rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select * from a left outer join b on a.x = b.x inner join c on b.x = c.x");
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select * from a left outer join b on a.x = b.x left outer join c on b.x = c.x");
        this.assertTrue(rs.next());
        this.assertEquals("0", rs.getString(1));
        this.assertEquals("0", rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select * from a left outer join (b inner join c on b.x = c.x) on a.x = b.x");
        this.assertTrue(rs.next());
        this.assertEquals("0", rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("explain select * from a left outer join (b inner join c on c.x = 1) on a.x = b.x");
        this.assertTrue(rs.next());
        sql = TestNestedJoins.cleanRemarks(rs.getString(1));
        this.assertEquals("SELECT \"PUBLIC\".\"A\".\"X\", \"PUBLIC\".\"B\".\"X\", \"PUBLIC\".\"C\".\"X\" FROM \"PUBLIC\".\"A\" LEFT OUTER JOIN ( \"PUBLIC\".\"B\" INNER JOIN \"PUBLIC\".\"C\" ON \"C\".\"X\" = 1 ) ON \"A\".\"X\" = \"B\".\"X\"", sql);
        stat.execute("drop table a, b, c");
        stat.execute("create table test(id int primary key)");
        stat.execute("insert into test values(0), (1), (2)");
        rs = stat.executeQuery("select * from test a left outer join (test b inner join test c on b.id = c.id - 2) on a.id = b.id + 1");
        this.assertTrue(rs.next());
        this.assertEquals("0", rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("0", rs.getString(2));
        this.assertEquals("2", rs.getString(3));
        this.assertTrue(rs.next());
        this.assertEquals("2", rs.getString(1));
        this.assertEquals(null, rs.getString(2));
        this.assertEquals(null, rs.getString(3));
        this.assertFalse(rs.next());
        stat.execute("drop table test");
        stat.execute("create table a(pk int, val varchar(255))");
        stat.execute("create table b(pk int, val varchar(255))");
        stat.execute("create table base(pk int, deleted int)");
        stat.execute("insert into base values(1, 0)");
        stat.execute("insert into base values(2, 1)");
        stat.execute("insert into base values(3, 0)");
        stat.execute("insert into a values(1, 'a')");
        stat.execute("insert into b values(2, 'a')");
        stat.execute("insert into b values(3, 'a')");
        rs = stat.executeQuery("explain select a.pk, a_base.pk, b.pk, b_base.pk from a inner join base a_base on a.pk = a_base.pk left outer join (b inner join base b_base on b.pk = b_base.pk and b_base.deleted = 0) on 1=1");
        this.assertTrue(rs.next());
        sql = TestNestedJoins.cleanRemarks(rs.getString(1));
        this.assertEquals("SELECT \"A\".\"PK\", \"A_BASE\".\"PK\", \"B\".\"PK\", \"B_BASE\".\"PK\" FROM \"PUBLIC\".\"BASE\" \"A_BASE\" LEFT OUTER JOIN ( \"PUBLIC\".\"B\" INNER JOIN \"PUBLIC\".\"BASE\" \"B_BASE\" ON (\"B_BASE\".\"DELETED\" = 0) AND (\"B\".\"PK\" = \"B_BASE\".\"PK\") ) ON 1=1 INNER JOIN \"PUBLIC\".\"A\" ON 1=1 WHERE \"A\".\"PK\" = \"A_BASE\".\"PK\"", sql);
        rs = stat.executeQuery("select a.pk, a_base.pk, b.pk, b_base.pk from a inner join base a_base on a.pk = a_base.pk left outer join (b inner join base b_base on b.pk = b_base.pk and b_base.deleted = 0) on 1=1");
        this.assertTrue(rs.next());
        this.assertEquals("1", rs.getString(1));
        this.assertEquals("1", rs.getString(2));
        this.assertEquals("3", rs.getString(3));
        this.assertEquals("3", rs.getString(3));
        this.assertFalse(rs.next());
        stat.execute("drop table a, b, base");
        conn.close();
        this.deleteDb("nestedJoins");
    }

    private static String cleanRemarks(String sql) {
        ScriptReader r = new ScriptReader(new StringReader(sql));
        r.setSkipRemarks(true);
        sql = r.readStatement();
        sql = sql.replaceAll("\\n", " ");
        while (sql.contains("  ")) {
            sql = sql.replaceAll("  ", " ");
        }
        return sql;
    }

    private void testCases2() throws Exception {
        Connection conn = this.getConnection("nestedJoins");
        Statement stat = conn.createStatement();
        stat.execute("create table a(id int primary key)");
        stat.execute("create table b(id int primary key)");
        stat.execute("create table c(id int primary key)");
        stat.execute("insert into a(id) values(1)");
        stat.execute("insert into c(id) values(1)");
        stat.execute("insert into b(id) values(1)");
        stat.executeQuery("select 1  from a left outer join (a t0 join b t1 on 1 = 1) on t1.id = 1, c");
        conn.close();
        this.deleteDb("nestedJoins");
    }
}

