/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.utils.FilePathDebug;

public class TestPowerOffFs
extends TestDb {
    private FilePathDebug fs;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        boolean end;
        this.fs = FilePathDebug.register();
        this.test(Integer.MAX_VALUE);
        System.out.println(Integer.MAX_VALUE - this.fs.getPowerOffCount());
        System.out.println("done");
        int i = 0;
        while (!(end = this.test(i))) {
            ++i;
        }
        this.deleteDb("memFS:", null);
    }

    private boolean test(int x) throws SQLException {
        this.deleteDb("memFS:", null);
        this.fs.setPowerOffCount(x);
        String url = "jdbc:h2:debug:memFS:powerOffFs;FILE_LOCK=NO;TRACE_LEVEL_FILE=0;WRITE_DELAY=0;CACHE_SIZE=4096";
        Connection conn = null;
        Statement stat = null;
        try {
            conn = DriverManager.getConnection(url);
            stat = conn.createStatement();
            stat.execute("create table test(id int primary key, name varchar)");
            stat.execute("insert into test values(1, 'Hello')");
            stat.execute("create index idx_name on test(name)");
            stat.execute("insert into test values(2, 'World')");
            stat.execute("update test set name='Hallo' where id=1");
            stat.execute("delete from test where name=2");
            stat.execute("insert into test values(3, space(10000))");
            stat.execute("update test set name='Hallo' where id=3");
            stat.execute("drop table test");
            conn.close();
            conn = null;
            boolean bl = this.fs.getPowerOffCount() > 0;
            return bl;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 42101) {
                throw e;
            }
        }
        finally {
            if (conn != null) {
                try {
                    if (stat != null) {
                        stat.execute("shutdown immediately");
                    }
                }
                catch (Exception exception) {}
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        this.fs.setPowerOffCount(0);
        conn = DriverManager.getConnection(url);
        stat = conn.createStatement();
        stat.execute("script to 'memFS:test.sql'");
        conn.close();
        FileUtils.delete("memFS:test.sql");
        return false;
    }
}

