/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestRandomCompare
extends TestDb {
    private final ArrayList<Statement> dbs = new ArrayList();
    private int aliasId;

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.traceTest = true;
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("randomCompare");
        this.testCases();
        this.testRandom();
        this.deleteDb("randomCompare");
    }

    private void testRandom() throws Exception {
        Connection conn = this.getConnection("randomCompare");
        this.dbs.add(conn.createStatement());
        try {
            Class.forName("org.postgresql.Driver");
            Connection c2 = DriverManager.getConnection("jdbc:postgresql:test?loggerLevel=OFF", "sa", "sa");
            this.dbs.add(c2.createStatement());
        }
        catch (Exception c2) {
            // empty catch block
        }
        Object shortest = null;
        Throwable shortestEx = null;
        try {
            this.execute("drop table test");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.execute("drop table test cascade");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object sql = "create table test(x0 int, x1 int)";
        this.trace((String)sql + ";");
        this.execute((String)sql);
        sql = "create index idx_test_x0 on test(x0)";
        this.trace((String)sql + ";");
        this.execute((String)sql);
        int x0 = 0;
        while (x0 < 3) {
            int x1 = 0;
            while (x1 < 3) {
                sql = "insert into test values(" + String.valueOf(x0 == 0 ? "null" : Integer.valueOf(x0)) + ", " + String.valueOf(x1 == 0 ? "null" : Integer.valueOf(x1)) + ")";
                this.trace((String)sql + ";");
                this.execute((String)sql);
                ++x1;
            }
            ++x0;
        }
        Random random = new Random(1L);
        int i = 0;
        while (i < 1000) {
            block17: {
                StringBuilder buff = new StringBuilder();
                this.appendRandomCompare(random, buff);
                sql = buff.toString();
                try {
                    this.execute((String)sql);
                }
                catch (Throwable e) {
                    if (e instanceof SQLException) {
                        this.trace((String)sql);
                        this.fail((String)sql);
                    }
                    if (shortest != null && ((String)sql).length() >= ((String)shortest).length()) break block17;
                    shortest = sql;
                    shortestEx = e;
                }
            }
            ++i;
        }
        if (shortest != null) {
            shortestEx.printStackTrace();
            this.fail(shortest + " " + String.valueOf(shortestEx));
        }
        i = 0;
        while (i < 10) {
            try {
                this.execute("drop table t" + i);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        for (Statement s : this.dbs) {
            s.getConnection().close();
        }
        this.deleteDb("randomCompare");
    }

    private void appendRandomCompare(Random random, StringBuilder buff) {
        buff.append("select * from ");
        int alias = this.aliasId++;
        if (random.nextBoolean()) {
            buff.append("(");
            this.appendRandomCompare(random, buff);
            buff.append(")");
        } else {
            buff.append("test");
        }
        buff.append(" as t").append(alias);
        if (random.nextInt(10) == 0) {
            return;
        }
        buff.append(" where ");
        int count = 1 + random.nextInt(3);
        int i = 0;
        while (i < count) {
            if (i > 0) {
                buff.append(random.nextBoolean() ? " or " : " and ");
            }
            if (random.nextInt(10) == 0) {
                buff.append("not ");
            }
            TestRandomCompare.appendRandomValue(random, buff);
            switch (random.nextInt(8)) {
                case 0: {
                    buff.append("=");
                    TestRandomCompare.appendRandomValue(random, buff);
                    break;
                }
                case 1: {
                    buff.append("<");
                    TestRandomCompare.appendRandomValue(random, buff);
                    break;
                }
                case 2: {
                    buff.append(">");
                    TestRandomCompare.appendRandomValue(random, buff);
                    break;
                }
                case 3: {
                    buff.append("<=");
                    TestRandomCompare.appendRandomValue(random, buff);
                    break;
                }
                case 4: {
                    buff.append(">=");
                    TestRandomCompare.appendRandomValue(random, buff);
                    break;
                }
                case 5: {
                    buff.append("<>");
                    TestRandomCompare.appendRandomValue(random, buff);
                    break;
                }
                case 6: {
                    buff.append(" is distinct from ");
                    TestRandomCompare.appendRandomValue(random, buff);
                    break;
                }
                case 7: {
                    buff.append(" is not distinct from ");
                    TestRandomCompare.appendRandomValue(random, buff);
                }
            }
            ++i;
        }
    }

    private static void appendRandomValue(Random random, StringBuilder buff) {
        switch (random.nextInt(7)) {
            case 0: {
                buff.append("null");
                break;
            }
            case 1: {
                buff.append(1);
                break;
            }
            case 2: {
                buff.append(2);
                break;
            }
            case 3: {
                buff.append(3);
                break;
            }
            case 4: {
                buff.append(-1);
                break;
            }
            case 5: {
                buff.append("x0");
                break;
            }
            case 6: {
                buff.append("x1");
            }
        }
    }

    private void execute(String sql) throws SQLException {
        String expected = null;
        SQLException e = null;
        for (Statement s : this.dbs) {
            try {
                boolean result = s.execute(sql);
                if (!result) continue;
                String data = TestRandomCompare.getResult(s.getResultSet());
                if (expected == null) {
                    expected = data;
                    continue;
                }
                this.assertEquals(sql, expected, data);
            }
            catch (SQLException e2) {
                e = e2;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    private static String getResult(ResultSet rs) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            StringBuilder buff = new StringBuilder();
            int i = 0;
            while (i < rs.getMetaData().getColumnCount()) {
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(rs.getString(i + 1));
                ++i;
            }
            list.add(buff.toString());
        }
        Collections.sort(list);
        return list.toString();
    }

    private void testCases() throws Exception {
        Connection conn = this.getConnection("randomCompare");
        Statement stat = conn.createStatement();
        stat.execute("create table test(x int)");
        stat.execute("insert into test values(null)");
        ResultSet rs = stat.executeQuery("select * from (select x from test union all select x from test) where x is null");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from (select x from test) where x is null");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from (select x from test union all select x from test) where x is null");
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        Connection conn2 = DriverManager.getConnection("jdbc:h2:mem:temp");
        conn2.createStatement().execute("create table test(x int) as select null");
        stat.execute("drop table test");
        stat.execute("create linked table test(null, 'jdbc:h2:mem:temp', null, null, 'TEST')");
        rs = stat.executeQuery("select * from (select x from test) where x is null");
        this.assertTrue(rs.next());
        rs = stat.executeQuery("select * from (select x from test union all select x from test) where x is null");
        this.assertTrue(rs.next());
        this.assertTrue(rs.next());
        conn2.close();
        conn.close();
        this.deleteDb("randomCompare");
    }
}

