/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestReleaseSelectLock
extends TestDb {
    private static final String TEST_DB_NAME = "releaseSelectLock";

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.deleteDb(TEST_DB_NAME);
        Connection conn = this.getConnection(TEST_DB_NAME);
        Statement statement = conn.createStatement();
        statement.execute("create table test(id int primary key)");
        this.runConcurrentSelects();
        statement.execute("drop table test");
        statement.close();
        conn.close();
        this.deleteDb(TEST_DB_NAME);
    }

    private void runConcurrentSelects() throws InterruptedException {
        int tryCount = 500;
        int threadsCount = this.getSize(2, 4);
        int tryNumber = 0;
        while (tryNumber < tryCount) {
            CountDownLatch allFinished = new CountDownLatch(threadsCount);
            int i = 0;
            while (i < threadsCount) {
                new Thread(() -> {
                    try {
                        try {
                            Connection conn = this.getConnection(TEST_DB_NAME);
                            PreparedStatement stmt = conn.prepareStatement("select id from test");
                            ResultSet rs = stmt.executeQuery();
                            while (rs.next()) {
                                rs.getInt(1);
                            }
                            stmt.close();
                            conn.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finally {
                        allFinished.countDown();
                    }
                }).start();
                ++i;
            }
            allFinished.await();
            ++tryNumber;
        }
    }
}

