/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Backup;
import org.h2.tools.DeleteDbFiles;

public class TestTimer
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws SQLException {
        this.validateOld();
        DeleteDbFiles.execute(this.getBaseDir(), "timer", true);
        this.loop();
    }

    private void loop() throws SQLException {
        this.println("loop");
        Connection conn = this.getConnection("timer");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID IDENTITY, NAME VARCHAR)");
        Random random = new Random();
        int max = 0;
        int count = 0;
        long startTime = System.nanoTime();
        while (true) {
            int action = random.nextInt(10);
            int x = max == 0 ? 0 : random.nextInt(max);
            switch (action) {
                case 0: 
                case 1: 
                case 2: {
                    int i;
                    stat.execute("INSERT INTO TEST VALUES(NULL, 'Hello')");
                    ResultSet rs = stat.getGeneratedKeys();
                    rs.next();
                    max = i = rs.getInt(1);
                    ++count;
                    break;
                }
                case 3: 
                case 4: {
                    if (count == 0) break;
                    stat.execute("UPDATE TEST SET NAME=NAME||'+' WHERE ID=" + x);
                    break;
                }
                case 5: 
                case 6: {
                    if (count == 0) break;
                    count -= stat.executeUpdate("DELETE FROM TEST WHERE ID=" + x);
                    break;
                }
                case 7: {
                    ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM TEST");
                    rs.next();
                    int c = rs.getInt(1);
                    this.assertEquals(count, c);
                    long time = System.nanoTime();
                    if (time <= startTime + TimeUnit.SECONDS.toNanos(5L)) break;
                    this.println("rows: " + count);
                    startTime = time;
                }
            }
        }
    }

    private void validateOld() {
        this.println("validate");
        try {
            Connection conn = this.getConnection("timer");
            Statement stat = conn.createStatement();
            stat.execute("CREATE TABLE IF NOT EXISTS TEST(ID IDENTITY, NAME VARCHAR)");
            ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM TEST");
            rs.next();
            int count = rs.getInt(1);
            this.println("row count: " + count);
            int real = 0;
            rs = stat.executeQuery("SELECT * FROM TEST");
            while (rs.next()) {
                ++real;
            }
            if (real != count) {
                this.println("real count: " + real);
                throw new AssertionError((Object)("COUNT(*)=" + count + " SELECT=" + real));
            }
            rs = stat.executeQuery("SCRIPT");
            while (rs.next()) {
                rs.getString(1);
            }
            conn.close();
        }
        catch (Throwable e) {
            TestTimer.logError("validate", e);
            this.backup();
        }
    }

    private void backup() {
        this.println("backup");
        int i = 0;
        while (true) {
            String s;
            File f;
            if (!(f = new File(s = "timer." + i + ".zip")).exists()) {
                try {
                    Backup.execute(s, this.getBaseDir(), "timer", true);
                }
                catch (SQLException e) {
                    TestTimer.logError("backup", e);
                }
                break;
            }
            ++i;
        }
    }
}

