/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.sql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.test.synth.sql.TestSynth;
import org.h2.test.synth.sql.Value;

class Column {
    private static final int[] TYPES = new int[]{4, 12, 3, 91, 92, 93, 16, -2, -3, 2005, 2004, 8, -5, 93, -7};
    private TestSynth config;
    private String name;
    private int type;
    private int precision;
    private int scale;
    private boolean isNullable;
    private boolean isPrimaryKey;

    private Column(TestSynth config) {
        this.config = config;
    }

    Column(ResultSetMetaData meta, int index) throws SQLException {
        this.name = meta.getColumnLabel(index);
        this.type = meta.getColumnType(index);
        switch (this.type) {
            case 3: {
                this.precision = meta.getPrecision(index);
                this.scale = meta.getScale(index);
                break;
            }
            case -7: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2004: 
            case 2005: {
                break;
            }
            default: {
                throw new AssertionError((Object)("type=" + this.type));
            }
        }
    }

    static boolean isConditionType(TestSynth config, int type) {
        switch (config.getMode()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: {
                switch (type) {
                    case -7: 
                    case -5: 
                    case 3: 
                    case 4: 
                    case 8: 
                    case 12: 
                    case 16: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return true;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 2004: 
                    case 2005: {
                        return false;
                    }
                }
                throw new AssertionError((Object)("type=" + type));
            }
        }
        throw new AssertionError((Object)("type=" + type));
    }

    private String getTypeName() {
        switch (this.type) {
            case 4: {
                return "INT";
            }
            case 12: {
                return "VARCHAR(" + this.precision + ")";
            }
            case 3: {
                return "NUMERIC(" + this.precision + ", " + this.scale + ")";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -3: 
            case -2: {
                if (this.config.is(4)) {
                    return "BYTEA";
                }
                return "BINARY(" + this.precision + ")";
            }
            case 2005: {
                if (this.config.is(2)) {
                    return "LONGVARCHAR";
                }
                if (this.config.is(4)) {
                    return "TEXT";
                }
                return "CLOB";
            }
            case 2004: {
                if (this.config.is(2)) {
                    return "LONGVARBINARY";
                }
                return "BLOB";
            }
            case 8: {
                if (this.config.is(4)) {
                    return "DOUBLE PRECISION";
                }
                return "DOUBLE";
            }
            case -5: {
                return "BIGINT";
            }
            case -7: 
            case 16: {
                return "BOOLEAN";
            }
        }
        throw new AssertionError((Object)("type=" + this.type));
    }

    String getCreateSQL() {
        String sql = this.name + " " + this.getTypeName();
        if (!this.isNullable) {
            sql = sql + " NOT NULL";
        }
        return sql;
    }

    String getName() {
        return this.name;
    }

    Value getRandomValue() {
        return Value.getRandom(this.config, this.type, this.precision, this.scale, this.isNullable);
    }

    static Column getRandomColumn(TestSynth config) {
        int randomType;
        Column column = new Column(config);
        column.name = "C_" + config.randomIdentifier();
        do {
            randomType = TYPES[config.random().getLog(TYPES.length)];
        } while (config.is(4) && (randomType == -2 || randomType == -3 || randomType == 2004));
        column.type = randomType;
        column.precision = config.random().getInt(20) + 2;
        column.scale = config.random().getInt(column.precision);
        column.isNullable = config.random().getBoolean(50);
        return column;
    }

    boolean getPrimaryKey() {
        return this.isPrimaryKey;
    }

    void setPrimaryKey(boolean b) {
        this.isPrimaryKey = b;
    }

    void setNullable(boolean b) {
        this.isNullable = b;
    }

    int getType() {
        return this.type;
    }
}

