/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.sql;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.test.synth.sql.Column;
import org.h2.test.synth.sql.DbInterface;
import org.h2.test.synth.sql.Expression;
import org.h2.test.synth.sql.Index;
import org.h2.test.synth.sql.Result;
import org.h2.test.synth.sql.Table;
import org.h2.test.synth.sql.TestSynth;
import org.h2.test.synth.sql.Value;

class Command {
    private static final int CONNECT = 0;
    private static final int RESET = 1;
    private static final int DISCONNECT = 2;
    private static final int CREATE_TABLE = 3;
    private static final int INSERT = 4;
    private static final int DROP_TABLE = 5;
    private static final int SELECT = 6;
    private static final int DELETE = 7;
    private static final int UPDATE = 8;
    private static final int COMMIT = 9;
    private static final int ROLLBACK = 10;
    private static final int AUTOCOMMIT_ON = 11;
    private static final int AUTOCOMMIT_OFF = 12;
    private static final int CREATE_INDEX = 13;
    private static final int DROP_INDEX = 14;
    private static final int END = 15;
    String[] selectList;
    private TestSynth config;
    private final int type;
    private Table table;
    private HashMap<String, Table> tables;
    private Index index;
    private Column[] columns;
    private Value[] values;
    private String condition;
    private String order;
    private final String join = "";
    private Result result;

    private Command(TestSynth config, int type) {
        this.config = config;
        this.type = type;
    }

    private Command(TestSynth config, int type, Table table) {
        this.config = config;
        this.type = type;
        this.table = table;
    }

    private Command(TestSynth config, int type, Table table, String alias) {
        this.config = config;
        this.type = type;
        this.table = table;
        this.tables = new HashMap();
        this.tables.put(alias, table);
    }

    private Command(TestSynth config, int type, Index index) {
        this.config = config;
        this.type = type;
        this.index = index;
    }

    Command(int type, String alias, Table table) {
        this.type = type;
        if (alias == null) {
            alias = table.getName();
        }
        this.addSubqueryTable(alias, table);
        this.table = table;
    }

    static Command getConnect(TestSynth config) {
        return new Command(config, 0);
    }

    static Command getReset(TestSynth config) {
        return new Command(config, 1);
    }

    static Command getDisconnect(TestSynth config) {
        return new Command(config, 2);
    }

    static Command getEnd(TestSynth config) {
        return new Command(config, 15);
    }

    static Command getCreateTable(TestSynth config, Table table) {
        return new Command(config, 3, table);
    }

    static Command getCreateIndex(TestSynth config, Index index) {
        return new Command(config, 13, index);
    }

    static Command getRandomSelect(TestSynth config, Table table) {
        Command command = new Command(config, 6, table, "M");
        command.selectList = Expression.getRandomSelectList(config, command);
        command.condition = Expression.getRandomCondition(config, command).getSQL();
        command.order = Expression.getRandomOrder(config, command);
        return command;
    }

    static Command getRandomDelete(TestSynth config, Table table) {
        Command command = new Command(config, 7, table);
        command.condition = Expression.getRandomCondition(config, command).getSQL();
        return command;
    }

    static Command getRandomUpdate(TestSynth config, Table table) {
        Command command = new Command(config, 8, table);
        command.prepareUpdate();
        return command;
    }

    static Command getRandomInsert(TestSynth config, Table table) {
        Command command = new Command(config, 4, table);
        command.prepareInsert();
        return command;
    }

    void addSubqueryTable(String alias, Table t) {
        this.tables.put(alias, t);
    }

    private void prepareInsert() {
        Column[] c;
        if (this.config.random().getBoolean(70)) {
            c = this.table.getColumns();
        } else {
            int len = this.config.random().getInt(this.table.getColumnCount() - 1) + 1;
            this.columns = this.table.getRandomColumns(len);
            c = this.columns;
        }
        this.values = new Value[c.length];
        int i = 0;
        while (i < c.length) {
            this.values[i] = c[i].getRandomValue();
            ++i;
        }
    }

    private void prepareUpdate() {
        int len = this.config.random().getLog(this.table.getColumnCount() - 1) + 1;
        this.columns = this.table.getRandomColumns(len);
        Column[] c = this.columns;
        this.values = new Value[c.length];
        int i = 0;
        while (i < c.length) {
            this.values[i] = c[i].getRandomValue();
            ++i;
        }
        this.condition = Expression.getRandomCondition(this.config, this).getSQL();
    }

    private Result select(DbInterface db) throws SQLException {
        StringBuilder builder = new StringBuilder("SELECT ");
        int i = 0;
        int length = this.selectList.length;
        while (i < length) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.selectList[i]);
            ++i;
        }
        builder.append("  FROM ").append(this.table.getName()).append(" M").append(' ').append("");
        if (this.condition != null) {
            builder.append("  WHERE ").append(this.condition);
        }
        if (this.order.trim().length() > 0) {
            builder.append("  ORDER BY ").append(this.order);
        }
        return db.select(builder.toString());
    }

    Result run(DbInterface db) throws Exception {
        try {
            switch (this.type) {
                case 0: {
                    db.connect();
                    this.result = new Result("connect");
                    break;
                }
                case 1: {
                    db.reset();
                    this.result = new Result("reset");
                    break;
                }
                case 2: {
                    db.disconnect();
                    this.result = new Result("disconnect");
                    break;
                }
                case 15: {
                    db.end();
                    this.result = new Result("disconnect");
                    break;
                }
                case 3: {
                    db.createTable(this.table);
                    this.result = new Result("createTable");
                    break;
                }
                case 5: {
                    db.dropTable(this.table);
                    this.result = new Result("dropTable");
                    break;
                }
                case 13: {
                    db.createIndex(this.index);
                    this.result = new Result("createIndex");
                    break;
                }
                case 14: {
                    db.dropIndex(this.index);
                    this.result = new Result("dropIndex");
                    break;
                }
                case 4: {
                    this.result = db.insert(this.table, this.columns, this.values);
                    break;
                }
                case 6: {
                    this.result = this.select(db);
                    break;
                }
                case 7: {
                    this.result = db.delete(this.table, this.condition);
                    break;
                }
                case 8: {
                    this.result = db.update(this.table, this.columns, this.values, this.condition);
                    break;
                }
                case 11: {
                    db.setAutoCommit(true);
                    this.result = new Result("setAutoCommit true");
                    break;
                }
                case 12: {
                    db.setAutoCommit(false);
                    this.result = new Result("setAutoCommit false");
                    break;
                }
                case 9: {
                    db.commit();
                    this.result = new Result("commit");
                    break;
                }
                case 10: {
                    db.rollback();
                    this.result = new Result("rollback");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("type=" + this.type));
                }
            }
        }
        catch (SQLException e) {
            this.result = new Result("", e);
        }
        return this.result;
    }

    String getRandomTableAlias() {
        if (this.tables == null) {
            return null;
        }
        Object[] list = this.tables.keySet().toArray();
        int i = this.config.random().getInt(list.length);
        return (String)list[i];
    }

    Table getTable(String alias) {
        if (alias == null) {
            return this.table;
        }
        return this.tables.get(alias);
    }
}

