/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.test.synth.sql.Column;
import org.h2.test.synth.sql.DbInterface;
import org.h2.test.synth.sql.Index;
import org.h2.test.synth.sql.Result;
import org.h2.test.synth.sql.Table;
import org.h2.test.synth.sql.TestSynth;
import org.h2.test.synth.sql.Value;

class DbConnection
implements DbInterface {
    private final TestSynth config;
    private final int id;
    private final String driver;
    private final String url;
    private final String user;
    private final String password;
    private Connection conn;
    private Connection sentinel;
    private final boolean useSentinel;

    DbConnection(TestSynth config, String driver, String url, String user, String password, int id, boolean useSentinel) {
        this.config = config;
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
        this.id = id;
        this.useSentinel = useSentinel;
        this.log("url=" + url);
    }

    @Override
    public void reset() throws SQLException {
        this.log("reset;");
        DatabaseMetaData meta = this.conn.getMetaData();
        Statement stat = this.conn.createStatement();
        ArrayList<String> tables = new ArrayList<String>();
        ResultSet rs = meta.getTables(null, null, null, new String[]{"TABLE"});
        while (rs.next()) {
            String schemaName = rs.getString("TABLE_SCHEM");
            if ("INFORMATION_SCHEMA".equals(schemaName)) continue;
            tables.add(rs.getString("TABLE_NAME"));
        }
        while (tables.size() > 0) {
            int dropped = 0;
            int i = 0;
            while (i < tables.size()) {
                try {
                    String table = (String)tables.get(i);
                    stat.execute("DROP TABLE " + table);
                    ++dropped;
                    tables.remove(i);
                    --i;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++i;
            }
            if (dropped == 0 && tables.size() > 0) {
                throw new AssertionError((Object)("Cannot drop " + String.valueOf(tables)));
            }
        }
    }

    @Override
    public void connect() throws Exception {
        if (this.useSentinel && this.sentinel == null) {
            this.sentinel = this.getConnection();
        }
        this.log("connect to " + this.url + ";");
        this.conn = this.getConnection();
    }

    private Connection getConnection() throws Exception {
        this.log("(getConnection to " + this.url + ");");
        if (this.driver == null) {
            return this.config.getConnection("synth");
        }
        Class.forName(this.driver);
        return DriverManager.getConnection(this.url, this.user, this.password);
    }

    @Override
    public void disconnect() throws SQLException {
        this.log("disconnect " + this.url + ";");
        this.conn.close();
    }

    @Override
    public void end() throws SQLException {
        this.log("end " + this.url + ";");
        if (this.sentinel != null) {
            this.sentinel.close();
            this.sentinel = null;
        }
    }

    @Override
    public void createTable(Table table) throws SQLException {
        this.execute(table.getCreateSQL());
    }

    @Override
    public void dropTable(Table table) throws SQLException {
        this.execute(table.getDropSQL());
    }

    @Override
    public void createIndex(Index index) throws SQLException {
        this.execute(index.getCreateSQL());
        index.getTable().addIndex(index);
    }

    @Override
    public void dropIndex(Index index) throws SQLException {
        this.execute(index.getDropSQL());
        index.getTable().removeIndex(index);
    }

    @Override
    public Result insert(Table table, Column[] c, Value[] v) throws SQLException {
        String sql = table.getInsertSQL(c, v);
        this.execute(sql);
        return new Result(sql, 1);
    }

    private void execute(String sql) throws SQLException {
        this.log(sql + ";");
        this.conn.createStatement().execute(sql);
    }

    @Override
    public Result select(String sql) throws SQLException {
        this.log(sql + ";");
        Statement stat = this.conn.createStatement();
        Result result = new Result(this.config, sql, stat.executeQuery(sql));
        return result;
    }

    @Override
    public Result delete(Table table, String condition) throws SQLException {
        String sql = "DELETE FROM " + table.getName();
        if (condition != null) {
            sql = sql + "  WHERE " + condition;
        }
        this.log(sql + ";");
        Statement stat = this.conn.createStatement();
        Result result = new Result(sql, stat.executeUpdate(sql));
        return result;
    }

    @Override
    public Result update(Table table, Column[] columns, Value[] values, String condition) throws SQLException {
        String sql = "UPDATE " + table.getName() + " SET ";
        int i = 0;
        while (i < columns.length) {
            if (i > 0) {
                sql = sql + ", ";
            }
            sql = sql + columns[i].getName() + "=" + values[i].getSQL();
            ++i;
        }
        if (condition != null) {
            sql = sql + "  WHERE " + condition;
        }
        this.log(sql + ";");
        Statement stat = this.conn.createStatement();
        Result result = new Result(sql, stat.executeUpdate(sql));
        return result;
    }

    @Override
    public void setAutoCommit(boolean b) throws SQLException {
        this.log("set autoCommit " + b + ";");
        this.conn.setAutoCommit(b);
    }

    @Override
    public void commit() throws SQLException {
        this.log("commit;");
        this.conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.log("rollback;");
        this.conn.rollback();
    }

    private void log(String s) {
        this.config.log(this.id, s);
    }

    public String toString() {
        return this.url;
    }
}

