/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.sql;

import java.util.ArrayList;
import org.h2.test.synth.sql.Column;
import org.h2.test.synth.sql.Command;
import org.h2.test.synth.sql.Table;
import org.h2.test.synth.sql.TestSynth;
import org.h2.test.synth.sql.Value;

public class Expression {
    private String sql;
    private final TestSynth config;
    private final Command command;

    private Expression(TestSynth config, Command command) {
        this.config = config;
        this.command = command;
        this.sql = "";
    }

    static String[] getRandomSelectList(TestSynth config, Command command) {
        if (config.random().getBoolean(30)) {
            return new String[]{"*"};
        }
        ArrayList<Object> exp = new ArrayList<Object>();
        Object sql = "";
        if (config.random().getBoolean(10)) {
            sql = (String)sql + "DISTINCT ";
        }
        int len = config.random().getLog(8) + 1;
        int i = 0;
        while (i < len) {
            sql = (String)sql + Expression.getRandomExpression(config, command).getSQL();
            sql = (String)sql + " AS A" + i + " ";
            exp.add(sql);
            sql = "";
            ++i;
        }
        return exp.toArray(new String[0]);
    }

    static Expression getRandomCondition(TestSynth config, Command command) {
        Expression condition = new Expression(config, command);
        if (config.random().getBoolean(50)) {
            condition.create();
        }
        return condition;
    }

    private static Expression getRandomExpression(TestSynth config, Command command) {
        Expression expression = new Expression(config, command);
        String alias = command.getRandomTableAlias();
        Column column = command.getTable(alias).getRandomConditionColumn();
        if (column == null) {
            expression.createValue();
        } else {
            expression.createExpression(alias, column);
        }
        return expression;
    }

    private void createValue() {
        Value v = Column.getRandomColumn(this.config).getRandomValue();
        this.sql = v.getSQL();
    }

    static Expression getRandomJoinOn(TestSynth config, Command command, String alias) {
        Expression expression = new Expression(config, command);
        expression.createJoinComparison(alias);
        return expression;
    }

    static String getRandomOrder(TestSynth config, Command command) {
        int len = config.random().getLog(6);
        Object sql = "";
        int i = 0;
        while (i < len) {
            if (i > 0) {
                sql = (String)sql + ", ";
            }
            int max = command.selectList.length;
            int idx = config.random().getInt(max);
            sql = (String)sql + "A" + idx;
            if (config.random().getBoolean(50)) {
                sql = config.random().getBoolean(10) ? (String)sql + " ASC" : (String)sql + " DESC";
            }
            ++i;
        }
        return sql;
    }

    String getSQL() {
        return this.sql.trim().length() == 0 ? null : this.sql.trim();
    }

    private boolean is(int percent) {
        return this.config.random().getBoolean(percent);
    }

    private String oneOf(String[] list) {
        int i = this.config.random().getInt(list.length);
        if (!this.sql.endsWith(" ")) {
            this.sql = String.valueOf(this.sql) + " ";
        }
        this.sql = String.valueOf(this.sql) + list[i] + " ";
        return list[i];
    }

    private static String getColumnName(String alias, Column column) {
        if (alias == null) {
            return column.getName();
        }
        return alias + "." + column.getName();
    }

    private void createJoinComparison(String alias) {
        int len = this.config.random().getLog(5) + 1;
        int i = 0;
        while (i < len) {
            String a2;
            Column column;
            if (i > 0) {
                this.sql = String.valueOf(this.sql) + "AND ";
            }
            if ((column = this.command.getTable(alias).getRandomConditionColumn()) == null) {
                this.sql = String.valueOf(this.sql) + "1=1";
                return;
            }
            this.sql = String.valueOf(this.sql) + Expression.getColumnName(alias, column);
            this.sql = String.valueOf(this.sql) + "=";
            while ((a2 = this.command.getRandomTableAlias()).equals(alias)) {
            }
            Table t2 = this.command.getTable(a2);
            Column c2 = t2.getRandomColumnOfType(column.getType());
            this.sql = c2 == null ? String.valueOf(this.sql) + column.getRandomValue().getSQL() : String.valueOf(this.sql) + Expression.getColumnName(a2, c2);
            this.sql = String.valueOf(this.sql) + " ";
            ++i;
        }
    }

    private void create() {
        this.createComparison();
        while (this.is(50)) {
            this.oneOf(new String[]{"AND", "OR"});
            this.createComparison();
        }
    }

    private void createComparison() {
        if (this.is(5)) {
            this.sql = String.valueOf(this.sql) + " NOT( ";
            this.createComparisonSub();
            this.sql = String.valueOf(this.sql) + ")";
        } else {
            this.createComparisonSub();
        }
    }

    private void createComparisonSub() {
        Value v;
        if (this.is(10)) {
            this.sql = String.valueOf(this.sql) + "(";
            this.create();
            this.sql = String.valueOf(this.sql) + ")";
            return;
        }
        String alias = this.command.getRandomTableAlias();
        Column column = this.command.getTable(alias).getRandomConditionColumn();
        if (column == null) {
            this.sql = this.is(50) ? String.valueOf(this.sql) + "1=1" : String.valueOf(this.sql) + "1=0";
            return;
        }
        boolean columnFirst = this.is(90);
        if (columnFirst) {
            this.sql = String.valueOf(this.sql) + Expression.getColumnName(alias, column);
        } else {
            v = column.getRandomValue();
            this.sql = String.valueOf(this.sql) + v.getSQL();
        }
        if (this.is(10)) {
            this.oneOf(new String[]{"IS NULL", "IS NOT NULL"});
        } else if (this.is(10)) {
            this.oneOf(new String[]{"BETWEEN", "NOT BETWEEN"});
            v = column.getRandomValue();
            this.sql = String.valueOf(this.sql) + v.getSQL();
            this.sql = String.valueOf(this.sql) + " AND ";
            v = column.getRandomValue();
            this.sql = String.valueOf(this.sql) + v.getSQL();
        } else {
            if (column.getType() == 12) {
                this.oneOf(new String[]{"=", "=", "=", "<", ">", "<=", ">=", "<>", "LIKE", "NOT LIKE"});
            } else {
                this.oneOf(new String[]{"=", "=", "=", "<", ">", "<=", ">=", "<>"});
            }
            if (columnFirst) {
                v = column.getRandomValue();
                this.sql = String.valueOf(this.sql) + v.getSQL();
            } else {
                this.sql = String.valueOf(this.sql) + Expression.getColumnName(alias, column);
            }
        }
    }

    private void createExpression(String alias, Column type) {
        boolean op = this.is(20);
        boolean allowNull = !op;
        this.createTerm(alias, type, true);
        if (op) {
            switch (type.getType()) {
                case 4: {
                    if (this.config.is(4)) {
                        this.oneOf(new String[]{"+", "-", "/"});
                    } else {
                        this.oneOf(new String[]{"+", "-", "*", "/"});
                    }
                    this.createTerm(alias, type, allowNull);
                    break;
                }
                case 3: {
                    this.oneOf(new String[]{"+", "-", "*"});
                    this.createTerm(alias, type, allowNull);
                    break;
                }
                case 12: {
                    this.sql = String.valueOf(this.sql) + " || ";
                    this.createTerm(alias, type, allowNull);
                    break;
                }
            }
        }
    }

    private void createTerm(String alias, Column type, boolean allowNull) {
        String a2;
        Column column;
        int dt = type.getType();
        if (this.is(5) && dt == 4 || dt == 3) {
            this.sql = String.valueOf(this.sql) + " - ";
            allowNull = false;
        }
        if (this.is(10)) {
            this.sql = String.valueOf(this.sql) + "(";
            this.createTerm(alias, type, allowNull);
            this.sql = String.valueOf(this.sql) + ")";
            return;
        }
        if (this.is(20)) {
            switch (dt) {
                case 12: {
                    this.oneOf(new String[]{"LOWER", "UPPER"});
                    this.sql = String.valueOf(this.sql) + "(";
                    this.createTerm(alias, type, allowNull);
                    this.sql = String.valueOf(this.sql) + ")";
                    break;
                }
                default: {
                    this.createTerm(alias, type, allowNull);
                }
            }
            return;
        }
        if (this.is(60) && (column = this.command.getTable(a2 = this.command.getRandomTableAlias()).getRandomColumnOfType(dt)) != null) {
            this.sql = String.valueOf(this.sql) + Expression.getColumnName(a2, column);
            return;
        }
        Value v = Value.getRandom(this.config, dt, 20, 2, allowNull);
        this.sql = String.valueOf(this.sql) + v.getSQL();
    }

    public String toString() {
        throw new AssertionError();
    }
}

