/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.sql;

import org.h2.test.synth.sql.Column;
import org.h2.test.synth.sql.Table;

public class Index {
    private final Table table;
    private final String name;
    private final Column[] columns;
    private final boolean unique;

    Index(Table table, String name, Column[] columns, boolean unique) {
        this.table = table;
        this.name = name;
        this.columns = columns;
        this.unique = unique;
    }

    String getName() {
        return this.name;
    }

    String getCreateSQL() {
        Object sql = "CREATE ";
        if (this.unique) {
            sql = (String)sql + "UNIQUE ";
        }
        sql = (String)sql + "INDEX " + this.name + " ON " + this.table.getName() + "(";
        int i = 0;
        while (i < this.columns.length) {
            if (i > 0) {
                sql = (String)sql + ", ";
            }
            sql = (String)sql + this.columns[i].getName();
            ++i;
        }
        sql = (String)sql + ")";
        return sql;
    }

    String getDropSQL() {
        return "DROP INDEX " + this.name;
    }

    Table getTable() {
        return this.table;
    }
}

