/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.sql;

import java.util.ArrayList;
import org.h2.test.synth.sql.Column;
import org.h2.test.synth.sql.Index;
import org.h2.test.synth.sql.TestSynth;
import org.h2.test.synth.sql.Value;

class Table {
    private final TestSynth config;
    private String name;
    private boolean temporary;
    private boolean globalTemporary;
    private Column[] columns;
    private Column[] primaryKeys;
    private final ArrayList<Index> indexes = new ArrayList();

    Table(TestSynth config) {
        this.config = config;
    }

    static Table newRandomTable(TestSynth config) {
        Table table = new Table(config);
        table.name = "T_" + config.randomIdentifier();
        int len = config.random().getLog(10) + 1;
        table.columns = new Column[len];
        int i = 0;
        while (i < len) {
            Column col;
            table.columns[i] = col = Column.getRandomColumn(config);
            ++i;
        }
        if (config.random().getBoolean(90)) {
            int pkLen = config.random().getLog(len);
            table.primaryKeys = new Column[pkLen];
            int i2 = 0;
            while (i2 < pkLen) {
                Column pk = null;
                while ((pk = table.columns[config.random().getInt(len)]).getPrimaryKey()) {
                }
                table.primaryKeys[i2] = pk;
                pk.setPrimaryKey(true);
                pk.setNullable(false);
                ++i2;
            }
        }
        return table;
    }

    Index newRandomIndex() {
        String indexName = "I_" + this.config.randomIdentifier();
        int len = this.config.random().getLog(this.getColumnCount() - 1) + 1;
        boolean unique = this.config.random().getBoolean(50);
        Column[] cols = this.getRandomColumns(len);
        Index index = new Index(this, indexName, cols, unique);
        return index;
    }

    String getDropSQL() {
        return "DROP TABLE " + this.name;
    }

    String getCreateSQL() {
        Column column;
        Object sql = "CREATE ";
        if (this.temporary) {
            sql = this.globalTemporary ? (String)sql + "GLOBAL " : (String)sql + "LOCAL ";
            sql = (String)sql + "TEMPORARY ";
        }
        sql = (String)sql + "TABLE " + this.name + "(";
        int i = 0;
        while (i < this.columns.length) {
            if (i > 0) {
                sql = (String)sql + ", ";
            }
            column = this.columns[i];
            sql = (String)sql + column.getCreateSQL();
            if (this.primaryKeys != null && this.primaryKeys.length == 1 && this.primaryKeys[0] == column) {
                sql = (String)sql + " PRIMARY KEY";
            }
            ++i;
        }
        if (this.primaryKeys != null && this.primaryKeys.length > 1) {
            sql = (String)sql + ", ";
            sql = (String)sql + "PRIMARY KEY(";
            i = 0;
            while (i < this.primaryKeys.length) {
                if (i > 0) {
                    sql = (String)sql + ", ";
                }
                column = this.primaryKeys[i];
                sql = (String)sql + column.getName();
                ++i;
            }
            sql = (String)sql + ")";
        }
        sql = (String)sql + ")";
        return sql;
    }

    String getInsertSQL(Column[] c, Value[] v) {
        int i;
        String sql = "INSERT INTO " + this.name;
        if (c != null) {
            sql = sql + "(";
            i = 0;
            while (i < c.length) {
                if (i > 0) {
                    sql = sql + ", ";
                }
                sql = sql + c[i].getName();
                ++i;
            }
            sql = sql + ")";
        }
        sql = sql + " VALUES(";
        i = 0;
        while (i < v.length) {
            if (i > 0) {
                sql = sql + ", ";
            }
            sql = sql + v[i].getSQL();
            ++i;
        }
        sql = sql + ")";
        return sql;
    }

    String getName() {
        return this.name;
    }

    Column getRandomConditionColumn() {
        ArrayList<Column> list = new ArrayList<Column>();
        Column[] columnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column col = columnArray[n2];
            if (Column.isConditionType(this.config, col.getType())) {
                list.add(col);
            }
            ++n2;
        }
        if (list.size() == 0) {
            return null;
        }
        return (Column)list.get(this.config.random().getInt(list.size()));
    }

    Column getRandomColumn() {
        return this.columns[this.config.random().getInt(this.columns.length)];
    }

    int getColumnCount() {
        return this.columns.length;
    }

    Column getRandomColumnOfType(int type) {
        ArrayList<Column> list = new ArrayList<Column>();
        Column[] columnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column col = columnArray[n2];
            if (col.getType() == type) {
                list.add(col);
            }
            ++n2;
        }
        if (list.size() == 0) {
            return null;
        }
        return (Column)list.get(this.config.random().getInt(list.size()));
    }

    Column[] getRandomColumns(int len) {
        int[] index = new int[this.columns.length];
        int i = 0;
        while (i < this.columns.length) {
            index[i] = i;
            ++i;
        }
        i = 0;
        while (i < this.columns.length) {
            int temp = index[i];
            int r = index[this.config.random().getInt(this.columns.length)];
            index[i] = index[r];
            index[r] = temp;
            ++i;
        }
        Column[] c = new Column[len];
        int i2 = 0;
        while (i2 < len) {
            c[i2] = this.columns[index[i2]];
            ++i2;
        }
        return c;
    }

    Column[] getColumns() {
        return this.columns;
    }

    void addIndex(Index index) {
        this.indexes.add(index);
    }

    void removeIndex(Index index) {
        this.indexes.remove(index);
    }
}

