/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.sql;

import java.util.ArrayList;
import org.h2.Driver;
import org.h2.test.TestAll;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.synth.sql.Command;
import org.h2.test.synth.sql.DbConnection;
import org.h2.test.synth.sql.DbInterface;
import org.h2.test.synth.sql.DbState;
import org.h2.test.synth.sql.RandomGen;
import org.h2.test.synth.sql.Result;
import org.h2.test.synth.sql.Table;
import org.h2.util.MathUtils;

public class TestSynth
extends TestDb {
    static final int H2 = 0;
    static final int H2_MEM = 1;
    static final int HSQLDB = 2;
    static final int MYSQL = 3;
    static final int POSTGRESQL = 4;
    private final DbState dbState = new DbState(this);
    private ArrayList<DbInterface> databases;
    private ArrayList<Command> commands;
    private final RandomGen random = new RandomGen();
    private boolean showError;
    private boolean showLog;
    private boolean stopImmediately;
    private int mode;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    boolean is(int isType) {
        return this.mode == isType;
    }

    RandomGen random() {
        return this.random;
    }

    String randomIdentifier() {
        int len = this.random.getLog(8) + 2;
        return this.random.randomString(len);
    }

    private void add(Command command) throws Exception {
        command.run(this.dbState);
        this.commands.add(command);
    }

    private void addRandomCommands() throws Exception {
        switch (this.random.getInt(20)) {
            case 0: {
                this.add(Command.getDisconnect(this));
                this.add(Command.getConnect(this));
                break;
            }
            case 1: {
                Table table = Table.newRandomTable(this);
                this.add(Command.getCreateTable(this, table));
                break;
            }
            case 2: {
                Table table = this.randomTable();
                this.add(Command.getCreateIndex(this, table.newRandomIndex()));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Table table = this.randomTable();
                this.add(Command.getRandomInsert(this, table));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Table table = this.randomTable();
                this.add(Command.getRandomUpdate(this, table));
                break;
            }
            case 9: 
            case 10: {
                Table table = this.randomTable();
                this.add(Command.getRandomDelete(this, table));
                break;
            }
            default: {
                Table table = this.randomTable();
                this.add(Command.getRandomSelect(this, table));
            }
        }
    }

    private void testRun(int seed) throws Exception {
        this.random.setSeed(seed);
        this.commands = new ArrayList();
        this.add(Command.getConnect(this));
        this.add(Command.getReset(this));
        int i = 0;
        while (i < 1) {
            Table table = Table.newRandomTable(this);
            this.add(Command.getCreateTable(this, table));
            this.add(Command.getCreateIndex(this, table.newRandomIndex()));
            ++i;
        }
        i = 0;
        while (i < 2000) {
            this.addRandomCommands();
            ++i;
        }
        this.add(Command.getDisconnect(this));
        this.add(Command.getEnd(this));
        i = 0;
        while (i < this.commands.size()) {
            Command command = this.commands.get(i);
            boolean stop = this.process(seed, i, command);
            if (stop) break;
            ++i;
        }
    }

    private boolean process(int seed, int id, Command command) throws Exception {
        try {
            ArrayList<Result> results = new ArrayList<Result>();
            int i = 0;
            while (i < this.databases.size()) {
                DbInterface db = this.databases.get(i);
                Result result = command.run(db);
                results.add(result);
                if (this.showError) {
                    // empty if block
                }
                ++i;
            }
            this.compareResults(results);
        }
        catch (Error e) {
            if (this.showError) {
                TestBase.logError("synth", e);
            }
            System.out.println("new TestSynth().init(test).testCase(" + seed + "); // id=" + id + " " + e.toString());
            if (this.stopImmediately) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    private void compareResults(ArrayList<Result> results) {
        Result original = results.get(0);
        int i = 1;
        while (i < results.size()) {
            Result copy = results.get(i);
            if (original.compareTo(copy) != 0) {
                if (this.showError) {
                    throw new AssertionError((Object)("Results don't match: original (0): \r\n" + String.valueOf(original) + "\r\nother:\r\n" + String.valueOf(copy)));
                }
                throw new AssertionError((Object)"Results don't match");
            }
            ++i;
        }
    }

    Table randomTable() {
        return this.dbState.randomTable();
    }

    void log(int id, String s) {
        if (this.showLog && id == 0) {
            System.out.println(s);
        }
    }

    int getMode() {
        return this.mode;
    }

    private void addDatabase(String className, String url, String user, String password, boolean useSentinel) {
        DbConnection db = new DbConnection(this, className, url, user, password, this.databases.size(), useSentinel);
        this.databases.add(db);
    }

    @Override
    public TestBase init(TestAll conf) throws Exception {
        super.init(conf);
        this.deleteDb("synth/synth");
        this.databases = new ArrayList();
        this.mode = 1;
        Driver.load();
        this.addDatabase("org.h2.Driver", "jdbc:h2:mem:synth", "sa", "", true);
        this.addDatabase("org.h2.Driver", "jdbc:h2:" + this.getBaseDir() + "/synth/synth", "sa", "", false);
        int i = 0;
        while (i < this.databases.size()) {
            DbConnection conn = (DbConnection)this.databases.get(i);
            System.out.println(i + " = " + conn.toString());
            ++i;
        }
        this.showError = true;
        this.showLog = false;
        return this;
    }

    private void testCase(int seed) throws Exception {
        this.deleteDb("synth/synth");
        try {
            this.printTime("TestSynth " + seed);
            this.testRun(seed);
        }
        catch (Error e) {
            TestBase.logError("error", e);
            System.exit(0);
        }
    }

    @Override
    public void test() throws Exception {
        while (true) {
            int seed = MathUtils.randomInt(Integer.MAX_VALUE);
            this.testCase(seed);
        }
    }
}

