/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.test.synth.sql.TestSynth;

public class Value {
    private final int type;
    private final Object data;
    private final TestSynth config;

    private Value(TestSynth config, int type, Object data) {
        this.config = config;
        this.type = type;
        this.data = data;
    }

    String getSQL() {
        if (this.data == null) {
            return "NULL";
        }
        switch (this.type) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return this.data.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2005: {
                return "'" + this.data.toString() + "'";
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBlobSQL();
            }
            case 91: {
                return this.getDateSQL((Date)this.data);
            }
            case 92: {
                return this.getTimeSQL((Time)this.data);
            }
            case 93: {
                return this.getTimestampSQL((Timestamp)this.data);
            }
            case -7: 
            case 16: {
                return (String)this.data;
            }
        }
        throw new AssertionError((Object)("type=" + this.type));
    }

    private static Date randomDate(TestSynth config) {
        return config.random().randomDate();
    }

    private static Double randomDouble(TestSynth config) {
        return (double)config.random().getInt(100) / 10.0;
    }

    private static Long randomLong(TestSynth config) {
        return config.random().getInt(1000);
    }

    private static Time randomTime(TestSynth config) {
        return config.random().randomTime();
    }

    private static Timestamp randomTimestamp(TestSynth config) {
        return config.random().randomTimestamp();
    }

    private String getTimestampSQL(Timestamp ts) {
        String s = "'" + ts.toString() + "'";
        if (this.config.getMode() != 2) {
            s = "TIMESTAMP " + s;
        }
        return s;
    }

    private String getDateSQL(Date date) {
        String s = "'" + date.toString() + "'";
        if (this.config.getMode() != 2) {
            s = "DATE " + s;
        }
        return s;
    }

    private String getTimeSQL(Time time) {
        String s = "'" + time.toString() + "'";
        if (this.config.getMode() != 2) {
            s = "TIME " + s;
        }
        return s;
    }

    private String getBlobSQL() {
        byte[] bytes = (byte[])this.data;
        StringBuilder buff = new StringBuilder("'");
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int c = b & 0xFF;
            buff.append(Integer.toHexString(c >> 4 & 0xF));
            buff.append(Integer.toHexString(c & 0xF));
            ++n2;
        }
        buff.append("'");
        return buff.toString();
    }

    static Value read(TestSynth config, ResultSet rs, int index) throws SQLException {
        Object data;
        ResultSetMetaData meta = rs.getMetaData();
        int type = meta.getColumnType(index);
        switch (type) {
            case 7: 
            case 8: {
                data = rs.getDouble(index);
                break;
            }
            case -5: {
                data = rs.getLong(index);
                break;
            }
            case 2: 
            case 3: {
                data = rs.getBigDecimal(index);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                data = rs.getBytes(index);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2005: {
                data = rs.getString(index);
                break;
            }
            case 91: {
                data = rs.getDate(index);
                break;
            }
            case 92: {
                data = rs.getTime(index);
                break;
            }
            case 93: {
                data = rs.getTimestamp(index);
                break;
            }
            case 4: {
                data = rs.getInt(index);
                break;
            }
            case 0: {
                data = null;
                break;
            }
            case -7: 
            case 16: {
                data = rs.getBoolean(index) ? "TRUE" : "FALSE";
                break;
            }
            default: {
                throw new AssertionError((Object)("type=" + type));
            }
        }
        if (rs.wasNull()) {
            data = null;
        }
        return new Value(config, type, data);
    }

    static Value getRandom(TestSynth config, int type, int precision, int scale, boolean mayBeNull) {
        Object data;
        if (mayBeNull && config.random().getBoolean(20)) {
            return new Value(config, type, null);
        }
        switch (type) {
            case -5: {
                data = Value.randomLong(config);
                break;
            }
            case 8: {
                data = Value.randomDouble(config);
                break;
            }
            case 3: {
                data = Value.randomDecimal(config, precision, scale);
                break;
            }
            case -3: 
            case -2: 
            case 2004: {
                data = Value.randomBytes(config, precision);
                break;
            }
            case 12: 
            case 2005: {
                data = config.random().randomString(config.random().getInt(precision));
                break;
            }
            case 91: {
                data = Value.randomDate(config);
                break;
            }
            case 92: {
                data = Value.randomTime(config);
                break;
            }
            case 93: {
                data = Value.randomTimestamp(config);
                break;
            }
            case 4: {
                data = Value.randomInt(config);
                break;
            }
            case -7: 
            case 16: {
                data = config.random().getBoolean(50) ? "TRUE" : "FALSE";
                break;
            }
            default: {
                throw new AssertionError((Object)("type=" + type));
            }
        }
        return new Value(config, type, data);
    }

    private static Object randomInt(TestSynth config) {
        int value = config.is(4) ? config.random().getInt(1000000) : config.random().getRandomInt();
        return value;
    }

    private static byte[] randomBytes(TestSynth config, int max) {
        int len = config.random().getLog(max);
        byte[] data = new byte[len];
        config.random().getBytes(data);
        return data;
    }

    private static BigDecimal randomDecimal(TestSynth config, int precision, int scale) {
        int len = config.random().getLog(precision - scale) + scale;
        if (len == 0) {
            ++len;
        }
        StringBuilder buff = new StringBuilder();
        int i = 0;
        while (i < len) {
            buff.append((char)(48 + config.random().getInt(10)));
            ++i;
        }
        buff.insert(len - scale, '.');
        if (config.random().getBoolean(20)) {
            buff.insert(0, '-');
        }
        return new BigDecimal(buff.toString());
    }

    public String toString() {
        return this.getSQL();
    }
}

