/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.todo;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.store.fs.rec.FilePathRec;
import org.h2.test.unit.TestReopen;
import org.h2.tools.DeleteDbFiles;

public class TestTempTableCrash {
    public static void main(String[] args) throws Exception {
        TestTempTableCrash.test();
    }

    private static void test() throws Exception {
        System.setProperty("h2.delayWrongPasswordMin", "0");
        FilePathRec.register();
        System.setProperty("reopenShift", "4");
        TestReopen reopen = new TestReopen();
        FilePathRec.setRecorder(reopen);
        String url = "jdbc:h2:rec:memFS:data;PAGE_SIZE=64;ANALYZE_AUTO=100";
        Class.forName("org.h2.Driver");
        DeleteDbFiles.execute("data", "test", true);
        Connection conn = DriverManager.getConnection(url, "sa", "sa");
        Statement stat = conn.createStatement();
        Random random = new Random(1L);
        long start = System.nanoTime();
        int i = 0;
        while (i < 10000) {
            long now = System.nanoTime();
            if (now > start + TimeUnit.SECONDS.toNanos(1L)) {
                System.out.println("i: " + i);
                start = now;
            }
            int x = random.nextInt(100);
            stat.execute("drop table if exists test" + x);
            String type = random.nextBoolean() ? "temp" : "";
            stat.execute("create " + type + " table test" + x + "(id int primary key, name varchar)");
            if (random.nextBoolean()) {
                stat.execute("create index idx_" + x + " on test" + x + "(name, id)");
            }
            if (random.nextBoolean()) {
                stat.execute("insert into test" + x + " select x, x from system_range(1, " + random.nextInt(100) + ")");
            }
            if (random.nextInt(10) == 1) {
                conn.close();
                conn = DriverManager.getConnection(url, "sa", "sa");
                stat = conn.createStatement();
            }
            ++i;
        }
        conn.close();
    }
}

