/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.trace;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.h2.test.trace.Arg;
import org.h2.test.trace.Player;

class Statement {
    private final Player player;
    private boolean assignment;
    private boolean staticCall;
    private String assignClass;
    private String assignVariable;
    private String staticCallClass;
    private String objectName;
    private Object object;
    private String methodName;
    private Arg[] args;
    private Class<?> returnClass;

    Statement(Player player) {
        this.player = player;
    }

    Object execute() throws Exception {
        block7: {
            if (this.object == this.player) {
                this.player.trace("> " + this.assignVariable + " not set");
                if (this.assignment) {
                    this.player.assign(this.assignVariable, this.player);
                }
                return null;
            }
            Class<?> clazz = this.staticCall ? Player.getClass(this.staticCallClass) : this.object.getClass();
            Class[] parameterTypes = new Class[this.args.length];
            Object[] parameters = new Object[this.args.length];
            int i = 0;
            while (i < this.args.length) {
                Arg arg = this.args[i];
                arg.execute();
                parameterTypes[i] = arg.getValueClass();
                parameters[i] = arg.getValue();
                ++i;
            }
            Method method = clazz.getMethod(this.methodName, parameterTypes);
            this.returnClass = method.getReturnType();
            try {
                Object obj = method.invoke(this.object, parameters);
                if (this.assignment) {
                    this.player.assign(this.assignVariable, obj);
                }
                return obj;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                this.player.trace("> " + t.toString());
                if (!this.assignment) break block7;
                this.player.assign(this.assignVariable, this.player);
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.assignment) {
            buff.append(this.assignClass);
            buff.append(' ');
            buff.append(this.assignVariable);
            buff.append('=');
        }
        if (this.staticCall) {
            buff.append(this.staticCallClass);
        } else {
            buff.append(this.objectName);
        }
        buff.append('.');
        buff.append(this.methodName);
        buff.append('(');
        int i = 0;
        while (this.args != null && i < this.args.length) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.args[i].toString());
            ++i;
        }
        buff.append(");");
        return buff.toString();
    }

    Class<?> getReturnClass() {
        return this.returnClass;
    }

    void setAssign(String className, String variableName) {
        this.assignment = true;
        this.assignClass = className;
        this.assignVariable = variableName;
    }

    void setStaticCall(String className) {
        this.staticCall = true;
        this.staticCallClass = className;
    }

    void setMethodCall(String variableName, Object object, String methodName) {
        this.objectName = variableName;
        this.object = object;
        this.methodName = methodName;
    }

    public void setArgs(ArrayList<Arg> list) {
        this.args = list.toArray(new Arg[0]);
    }
}

