/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import org.h2.dev.util.BinaryArithmeticStream;
import org.h2.dev.util.BitStream;
import org.h2.test.TestBase;

public class TestBinaryArithmeticStream
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testCompareWithHuffman();
        this.testHuffmanRandomized();
        this.testCompressionRatio();
        this.testRandomized();
        this.testPerformance();
    }

    private void testCompareWithHuffman() throws IOException {
        Random r = new Random(1L);
        int test = 0;
        while (test < 10) {
            int[] freq = new int[4];
            int i = 0;
            while (i < freq.length) {
                freq[i] = 0 + r.nextInt(1000);
                ++i;
            }
            BinaryArithmeticStream.Huffman ah = new BinaryArithmeticStream.Huffman(freq);
            BitStream.Huffman hh = new BitStream.Huffman(freq);
            ByteArrayOutputStream hbOut = new ByteArrayOutputStream();
            ByteArrayOutputStream abOut = new ByteArrayOutputStream();
            BitStream.Out bOut = new BitStream.Out(hbOut);
            BinaryArithmeticStream.Out aOut = new BinaryArithmeticStream.Out(abOut);
            int i2 = 0;
            while (i2 < freq.length) {
                int j = 0;
                while (j < freq[i2]) {
                    int x = i2;
                    hh.write(bOut, x);
                    ah.write(aOut, x);
                    ++j;
                }
                ++i2;
            }
            this.assertTrue(hbOut.toByteArray().length >= abOut.toByteArray().length);
            ++test;
        }
    }

    private void testHuffmanRandomized() throws IOException {
        Random r = new Random(1L);
        int[] freq = new int[r.nextInt(200) + 1];
        int i = 0;
        while (i < freq.length) {
            freq[i] = r.nextInt(1000) + 1;
            ++i;
        }
        int seed = r.nextInt();
        r.setSeed(seed);
        BinaryArithmeticStream.Huffman huff = new BinaryArithmeticStream.Huffman(freq);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        BinaryArithmeticStream.Out out = new BinaryArithmeticStream.Out(byteOut);
        int i2 = 0;
        while (i2 < 10000) {
            huff.write(out, r.nextInt(freq.length));
            ++i2;
        }
        out.flush();
        BinaryArithmeticStream.In in = new BinaryArithmeticStream.In(new ByteArrayInputStream(byteOut.toByteArray()));
        r.setSeed(seed);
        int i3 = 0;
        while (i3 < 10000) {
            int expected = r.nextInt(freq.length);
            int got = huff.read(in);
            this.assertEquals(expected, got);
            ++i3;
        }
    }

    private void testPerformance() throws IOException {
        Random r = new Random();
        int seed = 0;
        while (seed < 10000) {
            r.setSeed(seed);
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            BinaryArithmeticStream.Out out = new BinaryArithmeticStream.Out(byteOut);
            int len = 100;
            int i = 0;
            while (i < len) {
                boolean v = r.nextBoolean();
                int prob = r.nextInt(4095);
                out.writeBit(v, prob);
                ++i;
            }
            out.flush();
            r.setSeed(seed);
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            BinaryArithmeticStream.In in = new BinaryArithmeticStream.In(byteIn);
            int i2 = 0;
            while (i2 < len) {
                boolean expected = r.nextBoolean();
                int prob = r.nextInt(4095);
                this.assertEquals(expected, in.readBit(prob));
                ++i2;
            }
            ++seed;
        }
    }

    private void testCompressionRatio() throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        BinaryArithmeticStream.Out out = new BinaryArithmeticStream.Out(byteOut);
        int prob = 1000;
        int len = 1024;
        int i = 0;
        while (i < len) {
            out.writeBit(true, prob);
            ++i;
        }
        out.flush();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        BinaryArithmeticStream.In in = new BinaryArithmeticStream.In(byteIn);
        int i2 = 0;
        while (i2 < len) {
            this.assertTrue(in.readBit(prob));
            ++i2;
        }
    }

    private void testRandomized() throws IOException {
        int i = 0;
        while (i < 10000) {
            this.testRandomized(i);
            i = (int)((double)(i + 10) * 1.1);
        }
    }

    private void testRandomized(int len) throws IOException {
        Random r = new Random();
        int seed = r.nextInt();
        r.setSeed(seed);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        BinaryArithmeticStream.Out out = new BinaryArithmeticStream.Out(byteOut);
        int i = 0;
        while (i < len) {
            int prob = r.nextInt(4095);
            out.writeBit(r.nextBoolean(), prob);
            ++i;
        }
        out.flush();
        byteOut.write(r.nextInt(255));
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        BinaryArithmeticStream.In in = new BinaryArithmeticStream.In(byteIn);
        r.setSeed(seed);
        int i2 = 0;
        while (i2 < len) {
            int prob = r.nextInt(4095);
            boolean expected = r.nextBoolean();
            boolean got = in.readBit(prob);
            this.assertEquals(expected, got);
            ++i2;
        }
        this.assertEquals(r.nextInt(255), byteIn.read());
    }
}

