/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import org.h2.bnf.Bnf;
import org.h2.bnf.context.DbContents;
import org.h2.bnf.context.DbContextRule;
import org.h2.bnf.context.DbProcedure;
import org.h2.bnf.context.DbSchema;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestBnf
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        Connection conn;
        this.deleteDb("bnf");
        Throwable throwable = null;
        Object var2_4 = null;
        try {
            conn = this.getConnection("bnf");
            try {
                this.testModes(conn);
                this.testProcedures(conn, false);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.deleteDb("bnf");
        throwable = null;
        var2_4 = null;
        try {
            conn = this.getConnection("bnf;mode=mysql;database_to_lower=true");
            try {
                this.testProcedures(conn, true);
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void testModes(Connection conn) throws Exception {
        DbContents dbContents = new DbContents();
        dbContents.readContents("jdbc:h2:./test", conn);
        this.assertTrue(dbContents.isH2());
        dbContents = new DbContents();
        dbContents.readContents("jdbc:derby:test", conn);
        this.assertTrue(dbContents.isDerby());
        dbContents = new DbContents();
        dbContents.readContents("jdbc:firebirdsql:test", conn);
        this.assertTrue(dbContents.isFirebird());
        dbContents = new DbContents();
        dbContents.readContents("jdbc:sqlserver:test", conn);
        this.assertTrue(dbContents.isMSSQLServer());
        dbContents = new DbContents();
        dbContents.readContents("jdbc:mysql:test", conn);
        this.assertTrue(dbContents.isMySQL());
        dbContents = new DbContents();
        dbContents.readContents("jdbc:oracle:test", conn);
        this.assertTrue(dbContents.isOracle());
        dbContents = new DbContents();
        dbContents.readContents("jdbc:postgresql:test", conn);
        this.assertTrue(dbContents.isPostgreSQL());
        dbContents = new DbContents();
        dbContents.readContents("jdbc:sqlite:test", conn);
        this.assertTrue(dbContents.isSQLite());
    }

    private void testProcedures(Connection conn, boolean isMySQLMode) throws Exception {
        conn.createStatement().execute("DROP ALIAS IF EXISTS CUSTOM_PRINT");
        conn.createStatement().execute("CREATE ALIAS CUSTOM_PRINT AS $$ void print(String s) { System.out.println(s); } $$");
        conn.createStatement().execute("DROP TABLE IF EXISTS TABLE_WITH_STRING_FIELD");
        conn.createStatement().execute("CREATE TABLE TABLE_WITH_STRING_FIELD (STRING_FIELD VARCHAR(50), INT_FIELD integer)");
        DbContents dbContents = new DbContents();
        dbContents.readContents("jdbc:h2:./test", conn);
        this.assertTrue(dbContents.isH2());
        this.assertFalse(dbContents.isDerby());
        this.assertFalse(dbContents.isFirebird());
        this.assertEquals(null, dbContents.quoteIdentifier(null));
        if (isMySQLMode) {
            this.assertEquals("\"TEST\"", dbContents.quoteIdentifier("TEST"));
            this.assertEquals("\"Test\"", dbContents.quoteIdentifier("Test"));
            this.assertEquals("test", dbContents.quoteIdentifier("test"));
        } else {
            this.assertEquals("TEST", dbContents.quoteIdentifier("TEST"));
            this.assertEquals("\"Test\"", dbContents.quoteIdentifier("Test"));
            this.assertEquals("\"test\"", dbContents.quoteIdentifier("test"));
        }
        this.assertFalse(dbContents.isMSSQLServer());
        this.assertFalse(dbContents.isMySQL());
        this.assertFalse(dbContents.isOracle());
        this.assertFalse(dbContents.isPostgreSQL());
        this.assertFalse(dbContents.isSQLite());
        DbSchema defaultSchema = dbContents.getDefaultSchema();
        DbProcedure[] procedures = defaultSchema.getProcedures();
        HashSet<String> procedureName = new HashSet<String>(procedures.length);
        DbProcedure[] dbProcedureArray = procedures;
        int n = procedures.length;
        int n2 = 0;
        while (n2 < n) {
            DbProcedure procedure = dbProcedureArray[n2];
            this.assertTrue(defaultSchema == procedure.getSchema());
            procedureName.add(procedure.getName());
            ++n2;
        }
        if (isMySQLMode) {
            this.assertTrue(procedureName.contains("custom_print"));
        } else {
            this.assertTrue(procedureName.contains("CUSTOM_PRINT"));
        }
        if (isMySQLMode) {
            return;
        }
        Bnf bnf = Bnf.getInstance(null);
        DbContextRule columnRule = new DbContextRule(dbContents, 0);
        bnf.updateTopic("column_name", columnRule);
        bnf.updateTopic("user_defined_function_name", new DbContextRule(dbContents, 6));
        bnf.linkStatements();
        HashMap<String, String> tokens = bnf.getNextTokenList("SELECT CUSTOM_PR");
        this.assertTrue(tokens.values().contains("INT"));
        tokens = bnf.getNextTokenList("create table \"test\" as (sel");
        this.assertTrue(tokens.values().contains("ECT"));
        tokens = bnf.getNextTokenList("create table test as (sel");
        this.assertTrue(tokens.values().contains("ECT"));
        tokens = bnf.getNextTokenList("select 1||f");
        this.assertFalse(tokens.values().contains("ROM"));
        tokens = bnf.getNextTokenList("select 1 || f");
        this.assertFalse(tokens.values().contains("ROM"));
        tokens = bnf.getNextTokenList("select 1 || 2 ");
        this.assertTrue(tokens.values().contains("FROM"));
        tokens = bnf.getNextTokenList("select 1||2");
        this.assertTrue(tokens.values().contains("FROM"));
        tokens = bnf.getNextTokenList("select 1 || 2");
        this.assertTrue(tokens.values().contains("FROM"));
        tokens = bnf.getNextTokenList("SELECT LEAS");
        this.assertTrue(tokens.values().contains("T"));
        tokens = bnf.getNextTokenList("SELECT CUSTOM_PRINT(");
        this.assertTrue(tokens.values().contains("STRING_FIELD"));
        this.assertFalse(tokens.values().contains("INT_FIELD"));
        tokens = bnf.getNextTokenList("SELECT CUSTOM_PRINT ( ");
        this.assertTrue(tokens.values().contains("STRING_FIELD"));
        this.assertFalse(tokens.values().contains("INT_FIELD"));
        tokens = bnf.getNextTokenList("SELECT CUSTOM_PRINT ( STRING_FIELD");
        this.assertTrue(tokens.values().contains(")"));
    }
}

