/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.h2.compress.CompressLZF;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.Task;

public class TestCompress
extends TestDb {
    private boolean testPerformance;
    private final byte[] buff = new byte[10];

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        if (this.testPerformance) {
            this.testDatabase();
            System.exit(0);
            return;
        }
        this.testVariableSizeInt();
        this.testMultiThreaded();
        if (this.config.big) {
            int i = 0;
            while (i < 100) {
                this.test(i);
                ++i;
            }
            i = 100;
            while (i < 10000) {
                this.test(i);
                i += i + i + 1;
            }
        } else {
            this.test(0);
            this.test(1);
            this.test(7);
            this.test(50);
            this.test(200);
        }
        this.test(4000000);
        this.testVariableEnd();
    }

    private void testVariableSizeInt() {
        this.assertEquals(1, CompressTool.getVariableIntLength(0));
        this.assertEquals(2, CompressTool.getVariableIntLength(128));
        this.assertEquals(3, CompressTool.getVariableIntLength(16384));
        this.assertEquals(4, CompressTool.getVariableIntLength(0x200000));
        this.assertEquals(5, CompressTool.getVariableIntLength(0x10000000));
        this.assertEquals(5, CompressTool.getVariableIntLength(-1));
        int x = 0;
        while (x < 131072) {
            this.testVar(x);
            this.testVar(Integer.MIN_VALUE + x);
            this.testVar(Integer.MAX_VALUE - x);
            this.testVar(0x200000 + x - 100);
            this.testVar(0x10000000 + x - 100);
            ++x;
        }
    }

    private void testVar(int x) {
        int len = CompressTool.getVariableIntLength(x);
        int l2 = CompressTool.writeVariableInt(this.buff, 0, x);
        this.assertEquals(len, l2);
        int x2 = CompressTool.readVariableInt(this.buff, 0);
        this.assertEquals(x2, x);
    }

    private void testMultiThreaded() throws Exception {
        Task[] tasks = new Task[3];
        int i = 0;
        while (i < tasks.length) {
            Task t;
            tasks[i] = t = new Task(){

                @Override
                public void call() {
                    CompressTool tool = CompressTool.getInstance();
                    byte[] b = new byte[1024];
                    Random r = new Random();
                    while (!this.stop) {
                        r.nextBytes(b);
                        byte[] test = tool.expand(tool.compress(b, "LZF"));
                        TestCompress.this.assertEquals(b, test);
                    }
                }
            };
            t.execute();
            ++i;
        }
        Thread.sleep(1000L);
        Task[] taskArray = tasks;
        int n = tasks.length;
        int n2 = 0;
        while (n2 < n) {
            Task t = taskArray[n2];
            t.get();
            ++n2;
        }
    }

    private void testVariableEnd() {
        CompressTool utils = CompressTool.getInstance();
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < 90) {
            b.append('0');
            ++i;
        }
        String prefix = b.toString();
        int i2 = 0;
        while (i2 < 100) {
            b = new StringBuilder(prefix);
            int j = 0;
            while (j < i2) {
                b.append((char)(49 + j));
                ++j;
            }
            String test = b.toString();
            byte[] in = test.getBytes();
            this.assertEquals(in, utils.expand(utils.compress(in, "LZF")));
            ++i2;
        }
    }

    private void testDatabase() throws Exception {
        this.deleteDb("memFS:compress");
        Connection conn = this.getConnection("memFS:compress");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select table_name from information_schema.tables");
        Statement stat2 = conn.createStatement();
        while (rs.next()) {
            String table = rs.getString(1);
            if ("COLLATIONS".equals(table)) continue;
            stat2.execute("create table " + table + " as select * from information_schema." + table);
        }
        conn.close();
        CompressLZF compress = new CompressLZF();
        int pageSize = 4096;
        byte[] buff2 = new byte[pageSize];
        byte[] test = new byte[2 * pageSize];
        compress.compress(buff2, 0, pageSize, test, 0);
        int j = 0;
        while (j < 4) {
            long time = System.nanoTime();
            int i = 0;
            while (i < 1000) {
                int len;
                InputStream in = FileUtils.newInputStream("memFS:compress.h2.db");
                while ((len = in.read(buff2)) >= 0) {
                    compress.compress(buff2, 0, pageSize, test, 0);
                }
                in.close();
                ++i;
            }
            System.out.println("compress: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time) + " ms");
            ++j;
        }
        j = 0;
        while (j < 4) {
            int len;
            ArrayList<byte[]> comp = new ArrayList<byte[]>();
            InputStream in = FileUtils.newInputStream("memFS:compress.h2.db");
            while ((len = in.read(buff2)) >= 0) {
                int b = compress.compress(buff2, 0, pageSize, test, 0);
                byte[] data = Arrays.copyOf(test, b);
                comp.add(data);
            }
            in.close();
            byte[] result = new byte[pageSize];
            long time = System.nanoTime();
            int i = 0;
            while (i < 1000) {
                int k = 0;
                while (k < comp.size()) {
                    byte[] data = (byte[])comp.get(k);
                    compress.expand(data, 0, data.length, result, 0, pageSize);
                    ++k;
                }
                ++i;
            }
            System.out.println("expand: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time) + " ms");
            ++j;
        }
    }

    private void test(int len) throws IOException {
        this.testByteArray(len);
        this.testByteBuffer(len);
    }

    private void testByteArray(int len) throws IOException {
        Random r = new Random(len);
        int pattern = 0;
        while (pattern < 4) {
            String a;
            int x;
            byte[] b = new byte[len];
            switch (pattern) {
                case 0: {
                    break;
                }
                case 1: {
                    r.nextBytes(b);
                    break;
                }
                case 2: {
                    x = 0;
                    while (x < len) {
                        b[x] = (byte)(x & 0xA);
                        ++x;
                    }
                    break;
                }
                case 3: {
                    int x2 = 0;
                    while (x2 < len) {
                        b[x2] = (byte)(x2 / 10);
                        ++x2;
                    }
                    break;
                }
            }
            if (r.nextInt(2) < 1) {
                x = 0;
                while (x < len) {
                    if (r.nextInt(20) < 1) {
                        b[x] = (byte)r.nextInt(255);
                    }
                    ++x;
                }
            }
            CompressTool utils = CompressTool.getInstance();
            String[] stringArray = new String[]{"LZF", "No", "Deflate", "Deflate level 9 strategy 2"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                a = stringArray[n2];
                long time = System.nanoTime();
                byte[] out = utils.compress(b, a);
                byte[] test = utils.expand(out);
                if (this.testPerformance) {
                    System.out.println("p:" + pattern + " len: " + out.length + " time: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - time) + " " + a);
                }
                this.assertEquals(b.length, test.length);
                this.assertEquals(b, test);
                Arrays.fill(test, (byte)0);
                CompressTool.expand(out, test, 0);
                this.assertEquals(b, test);
                ++n2;
            }
            String[] stringArray2 = new String[5];
            stringArray2[1] = "LZF";
            stringArray2[2] = "DEFLATE";
            stringArray2[3] = "ZIP";
            stringArray2[4] = "GZIP";
            stringArray = stringArray2;
            n = stringArray2.length;
            n2 = 0;
            while (n2 < n) {
                a = stringArray[n2];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                OutputStream out2 = CompressTool.wrapOutputStream(out, a, "test");
                IOUtils.copy(new ByteArrayInputStream(b), out2);
                out2.close();
                InputStream in = new ByteArrayInputStream(out.toByteArray());
                in = CompressTool.wrapInputStream(in, a, "test");
                out.reset();
                IOUtils.copy(in, (OutputStream)out);
                this.assertEquals(b, out.toByteArray());
                ++n2;
            }
            ++pattern;
        }
    }

    private void testByteBuffer(int len) {
        if (len < 4) {
            return;
        }
        Random r = new Random(len);
        CompressLZF comp = new CompressLZF();
        int pattern = 0;
        while (pattern < 4) {
            int x;
            byte[] b = new byte[len];
            switch (pattern) {
                case 0: {
                    break;
                }
                case 1: {
                    r.nextBytes(b);
                    break;
                }
                case 2: {
                    x = 0;
                    while (x < len) {
                        b[x] = (byte)(x & 0xA);
                        ++x;
                    }
                    break;
                }
                case 3: {
                    int x2 = 0;
                    while (x2 < len) {
                        b[x2] = (byte)(x2 / 10);
                        ++x2;
                    }
                    break;
                }
            }
            if (r.nextInt(2) < 1) {
                x = 0;
                while (x < len) {
                    if (r.nextInt(20) < 1) {
                        b[x] = (byte)r.nextInt(255);
                    }
                    ++x;
                }
            }
            ByteBuffer buff = ByteBuffer.wrap(b);
            byte[] temp = new byte[100 + b.length * 2];
            int compLen = comp.compress(buff, 0, temp, 0);
            ByteBuffer test = ByteBuffer.wrap(temp, 0, compLen);
            byte[] exp = new byte[b.length];
            CompressLZF.expand(test, ByteBuffer.wrap(exp));
            this.assertEquals(b, exp);
            ++pattern;
        }
    }
}

