/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.File;
import org.h2.engine.ConnectionInfo;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.DeleteDbFiles;

public class TestConnectionInfo
extends TestDb {
    public static void main(String[] a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testImplicitRelativePath();
        this.testConnectInitError();
        this.testConnectionInfo();
        this.testName();
    }

    private void testImplicitRelativePath() throws Exception {
        this.assertThrows(90011, () -> this.getConnection("jdbc:h2:" + this.getTestName()));
        this.assertThrows(90011, () -> this.getConnection("jdbc:h2:data/" + this.getTestName()));
        this.getConnection("jdbc:h2:./data/" + this.getTestName()).close();
        DeleteDbFiles.execute("data", this.getTestName(), true);
    }

    private void testConnectInitError() throws Exception {
        this.assertThrows(42001, () -> this.getConnection("jdbc:h2:mem:;init=error"));
        this.assertThrows(90031, () -> this.getConnection("jdbc:h2:mem:;init=runscript from 'wrong.file'"));
    }

    private void testConnectionInfo() {
        ConnectionInfo connectionInfo = new ConnectionInfo("jdbc:h2:mem:" + this.getTestName() + ";ACCESS_MODE_DATA=rws;INIT=CREATE this...\\;INSERT that...;IFEXISTS=TRUE", null, null, null);
        this.assertEquals("jdbc:h2:mem:" + this.getTestName(), connectionInfo.getURL());
        this.assertEquals("rws", connectionInfo.getProperty("ACCESS_MODE_DATA", ""));
        this.assertEquals("CREATE this...;INSERT that...", connectionInfo.getProperty("INIT", ""));
        this.assertEquals("TRUE", connectionInfo.getProperty("IFEXISTS", ""));
        this.assertEquals("undefined", connectionInfo.getProperty("CACHE_TYPE", "undefined"));
    }

    private void testName() throws Exception {
        char differentFileSeparator = File.separatorChar == '/' ? (char)'\\' : '/';
        ConnectionInfo connectionInfo = new ConnectionInfo("./test" + differentFileSeparator + "subDir");
        File file = new File("test" + File.separatorChar + "subDir");
        this.assertEquals(file.getCanonicalPath().replace('\\', '/'), connectionInfo.getName());
    }
}

