/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.test.TestBase;
import org.h2.util.DateTimeUtils;
import org.h2.value.ValueDate;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class TestDateIso8601
extends TestBase {
    private static Type type;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    private static long parse(String s) {
        if (type == null) {
            throw new IllegalStateException();
        }
        switch (type) {
            case DATE: {
                return ValueDate.parse(s).getDateValue();
            }
            case TIMESTAMP: {
                return ValueTimestamp.parse(s, null).getDateValue();
            }
            case TIMESTAMP_TIMEZONE_0: {
                return ValueTimestampTimeZone.parse(s + " 00:00:00.0Z", null).getDateValue();
            }
            case TIMESTAMP_TIMEZONE_PLUS_18: {
                return ValueTimestampTimeZone.parse(s + " 00:00:00+18:00", null).getDateValue();
            }
            case TIMESTAMP_TIMEZONE_MINUS_18: {
                return ValueTimestampTimeZone.parse(s + " 00:00:00-18:00", null).getDateValue();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void test() throws Exception {
        type = Type.DATE;
        this.doTest();
        type = Type.TIMESTAMP;
        this.doTest();
        type = Type.TIMESTAMP_TIMEZONE_0;
        this.doTest();
        type = Type.TIMESTAMP_TIMEZONE_PLUS_18;
        this.doTest();
        type = Type.TIMESTAMP_TIMEZONE_MINUS_18;
        this.doTest();
    }

    private void doTest() throws Exception {
        this.testIsoDayOfWeek();
        this.testIsoWeekJanuary1thMonday();
        this.testIsoWeekJanuary1thTuesday();
        this.testIsoWeekJanuary1thWednesday();
        this.testIsoWeekJanuary1thThursday();
        this.testIsoWeekJanuary1thFriday();
        this.testIsoWeekJanuary1thSaturday();
        this.testIsoWeekJanuary1thSunday();
        this.testIsoYearJanuary1thMonday();
        this.testIsoYearJanuary1thTuesday();
        this.testIsoYearJanuary1thWednesday();
        this.testIsoYearJanuary1thThursday();
        this.testIsoYearJanuary1thFriday();
        this.testIsoYearJanuary1thSaturday();
        this.testIsoYearJanuary1thSunday();
    }

    private void testIsoDayOfWeek() throws Exception {
        this.assertEquals(1, DateTimeUtils.getIsoDayOfWeek(TestDateIso8601.parse("2008-09-29")));
        this.assertEquals(2, DateTimeUtils.getIsoDayOfWeek(TestDateIso8601.parse("2008-09-30")));
        this.assertEquals(3, DateTimeUtils.getIsoDayOfWeek(TestDateIso8601.parse("2008-10-01")));
        this.assertEquals(4, DateTimeUtils.getIsoDayOfWeek(TestDateIso8601.parse("2008-10-02")));
        this.assertEquals(5, DateTimeUtils.getIsoDayOfWeek(TestDateIso8601.parse("2008-10-03")));
        this.assertEquals(6, DateTimeUtils.getIsoDayOfWeek(TestDateIso8601.parse("2008-10-04")));
        this.assertEquals(7, DateTimeUtils.getIsoDayOfWeek(TestDateIso8601.parse("2008-10-05")));
    }

    private void testIsoWeekJanuary1thMonday() throws Exception {
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2006-12-31")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2007-01-01")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2007-01-07")));
        this.assertEquals(2, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2007-01-08")));
    }

    private void testIsoWeekJanuary1thTuesday() throws Exception {
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2007-12-30")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2007-12-31")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2008-01-01")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2008-01-06")));
        this.assertEquals(2, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2008-01-07")));
    }

    private void testIsoWeekJanuary1thWednesday() throws Exception {
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2002-12-28")));
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2002-12-29")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2002-12-30")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2002-12-31")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2003-01-01")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2003-01-05")));
        this.assertEquals(2, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2003-01-06")));
    }

    private void testIsoWeekJanuary1thThursday() throws Exception {
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2008-12-28")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2008-12-29")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2008-12-30")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2008-12-31")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2009-01-01")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2009-01-04")));
        this.assertEquals(2, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2009-01-09")));
    }

    private void testIsoWeekJanuary1thFriday() throws Exception {
        this.assertEquals(53, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2009-12-31")));
        this.assertEquals(53, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2010-01-01")));
        this.assertEquals(53, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2010-01-03")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2010-01-04")));
    }

    private void testIsoWeekJanuary1thSaturday() throws Exception {
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2010-12-31")));
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2011-01-01")));
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2011-01-02")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2011-01-03")));
    }

    private void testIsoWeekJanuary1thSunday() throws Exception {
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2011-12-31")));
        this.assertEquals(52, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2012-01-01")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2012-01-02")));
        this.assertEquals(1, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2012-01-08")));
        this.assertEquals(2, DateTimeUtils.getIsoWeekOfYear(TestDateIso8601.parse("2012-01-09")));
    }

    private void testIsoYearJanuary1thMonday() throws Exception {
        this.assertEquals(2006, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2006-12-28")));
        this.assertEquals(2006, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2006-12-29")));
        this.assertEquals(2006, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2006-12-30")));
        this.assertEquals(2006, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2006-12-31")));
        this.assertEquals(2007, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2007-01-01")));
        this.assertEquals(2007, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2007-01-02")));
        this.assertEquals(2007, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2007-01-03")));
    }

    private void testIsoYearJanuary1thTuesday() throws Exception {
        this.assertEquals(2007, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2007-12-28")));
        this.assertEquals(2007, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2007-12-29")));
        this.assertEquals(2007, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2007-12-30")));
        this.assertEquals(2008, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2007-12-31")));
        this.assertEquals(2008, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2008-01-01")));
        this.assertEquals(2008, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2008-01-02")));
        this.assertEquals(2008, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2008-01-03")));
        this.assertEquals(2008, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2008-01-04")));
    }

    private void testIsoYearJanuary1thWednesday() throws Exception {
        this.assertEquals(2002, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2002-12-28")));
        this.assertEquals(2002, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2002-12-29")));
        this.assertEquals(2003, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2002-12-30")));
        this.assertEquals(2003, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2002-12-31")));
        this.assertEquals(2003, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2003-01-01")));
        this.assertEquals(2003, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2003-01-02")));
        this.assertEquals(2003, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2003-12-02")));
    }

    private void testIsoYearJanuary1thThursday() throws Exception {
        this.assertEquals(2008, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2008-12-28")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2008-12-29")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2008-12-30")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2008-12-31")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2009-01-01")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2009-01-02")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2009-01-03")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2009-01-04")));
    }

    private void testIsoYearJanuary1thFriday() throws Exception {
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2009-12-28")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2009-12-29")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2009-12-30")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2009-12-31")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2010-01-01")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2010-01-02")));
        this.assertEquals(2009, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2010-01-03")));
        this.assertEquals(2010, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2010-01-04")));
    }

    private void testIsoYearJanuary1thSaturday() throws Exception {
        this.assertEquals(2010, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2010-12-28")));
        this.assertEquals(2010, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2010-12-29")));
        this.assertEquals(2010, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2010-12-30")));
        this.assertEquals(2010, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2010-12-31")));
        this.assertEquals(2010, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2011-01-01")));
        this.assertEquals(2010, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2011-01-02")));
        this.assertEquals(2011, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2011-01-03")));
        this.assertEquals(2011, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2011-01-04")));
    }

    private void testIsoYearJanuary1thSunday() throws Exception {
        this.assertEquals(2011, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2011-12-28")));
        this.assertEquals(2011, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2011-12-29")));
        this.assertEquals(2011, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2011-12-30")));
        this.assertEquals(2011, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2011-12-31")));
        this.assertEquals(2011, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2012-01-01")));
        this.assertEquals(2012, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2012-01-02")));
        this.assertEquals(2012, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2012-01-03")));
        this.assertEquals(2012, DateTimeUtils.getIsoWeekYear(TestDateIso8601.parse("2012-01-04")));
    }

    private static enum Type {
        DATE,
        TIMESTAMP,
        TIMESTAMP_TIMEZONE_0,
        TIMESTAMP_TIMEZONE_PLUS_18,
        TIMESTAMP_TIMEZONE_MINUS_18;

    }
}

