/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.api.JavaObjectSerializer;
import org.h2.engine.CastDataProvider;
import org.h2.engine.Mode;
import org.h2.message.DbException;
import org.h2.test.TestBase;
import org.h2.util.DateTimeTemplate;
import org.h2.util.DateTimeUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class TestDateTimeTemplate
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testDate();
        this.testTime();
        this.testTimeTz();
        this.testTimestamp();
        this.testTimestampTz();
        this.testInvalidCombinations();
        this.testInvalidDelimiters();
        this.testInvalidFields();
        this.testInvalidTemplates();
        this.testOutOfRange();
        this.testParseErrors();
    }

    private void testDate() {
        Provider provider = new Provider(2023, 4);
        ValueDate date = TestDateTimeTemplate.date(2022, 10, 12);
        this.assertEquals("2022-10-12", date, "YYYY-MM-DD", provider);
        this.assertEquals("022-10-12", date, "YYY-MM-DD", provider);
        this.assertEquals("22-10-12", date, "YY-MM-DD", provider);
        this.assertEquals("2-10-12", date, "Y-MM-DD", provider);
        this.assertEquals("2022-10-12", date, "RRRR-MM-DD", provider);
        this.assertEquals("22-10-12", date, "RR-MM-DD", provider);
        this.assertEquals("2022-12", TestDateTimeTemplate.date(2022, 4, 12), date, "YYYY-DD", provider);
        this.assertEquals("2022-10", TestDateTimeTemplate.date(2022, 10, 1), date, "YYYY-MM", provider);
        this.assertEquals("12-10", TestDateTimeTemplate.date(2023, 10, 12), date, "DD-MM", provider);
        this.assertEquals("22-10-12", date, "RR-MM-DD", provider);
        this.assertEquals("73-01-01", TestDateTimeTemplate.date(2073, 1, 1), "RR-MM-DD", provider);
        this.assertEquals("74-01-01", TestDateTimeTemplate.date(1974, 1, 1), TestDateTimeTemplate.date(2074, 1, 1), "RR-MM-DD", provider);
        this.assertEquals("73-01-01", TestDateTimeTemplate.date(2073, 1, 1), TestDateTimeTemplate.date(1973, 1, 1), "RR-MM-DD", provider);
        Provider altProvider = new Provider(2090, 1);
        this.assertEquals("40-01-01", TestDateTimeTemplate.date(2040, 1, 1), TestDateTimeTemplate.date(2040, 1, 1), "RR-MM-DD", altProvider);
        date = TestDateTimeTemplate.date(12345, 5, 7);
        this.assertEquals("12345-05-07", date, "YYYY-MM-DD", provider);
        this.assertEquals("345-05-07", TestDateTimeTemplate.date(2345, 5, 7), date, "YYY-MM-DD", provider);
        this.assertEquals("45-05-07", TestDateTimeTemplate.date(2045, 5, 7), date, "YY-MM-DD", provider);
        this.assertEquals("5-05-07", TestDateTimeTemplate.date(2025, 5, 7), date, "Y-MM-DD", provider);
        this.assertEquals("12345-05-07", date, "RRRR-MM-DD", provider);
        this.assertEquals("45-05-07", TestDateTimeTemplate.date(2045, 5, 7), date, "RR-MM-DD", provider);
        date = TestDateTimeTemplate.date(-12345, 5, 7);
        this.assertEquals("-12345-05-07", date, "YYYY-MM-DD", provider);
        this.assertEqualsAndFail("-345-05-07", date, "YYY-MM-DD", provider);
        this.assertEqualsAndFail("-45-05-07", date, "YY-MM-DD", provider);
        this.assertEqualsAndFail("-5-05-07", date, "Y-MM-DD", provider);
        this.assertEqualsAndFail("-12345-05-07", date, "RRRR-MM-DD", provider);
        this.assertEqualsAndFail("-45-05-07", date, "RR-MM-DD", provider);
        this.assertEquals("1900-061", TestDateTimeTemplate.date(1900, 3, 2), "YYYY-DDD", provider);
        this.assertEquals("1904-062", TestDateTimeTemplate.date(1904, 3, 2), "YYYY-DDD", provider);
        this.assertEquals("2000-062", TestDateTimeTemplate.date(2000, 3, 2), "YYYY-DDD", provider);
    }

    private void testTime() {
        Provider provider = new Provider(2023, 4);
        this.assertEquals("12 A.M.", TestDateTimeTemplate.time(0, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("01 A.M.", TestDateTimeTemplate.time(1, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("02 A.M.", TestDateTimeTemplate.time(2, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("03 A.M.", TestDateTimeTemplate.time(3, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("04 A.M.", TestDateTimeTemplate.time(4, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("05 A.M.", TestDateTimeTemplate.time(5, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("06 A.M.", TestDateTimeTemplate.time(6, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("07 A.M.", TestDateTimeTemplate.time(7, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("08 A.M.", TestDateTimeTemplate.time(8, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("09 A.M.", TestDateTimeTemplate.time(9, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("10 A.M.", TestDateTimeTemplate.time(10, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("11 A.M.", TestDateTimeTemplate.time(11, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("12 P.M.", TestDateTimeTemplate.time(12, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("01 P.M.", TestDateTimeTemplate.time(13, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("02 P.M.", TestDateTimeTemplate.time(14, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("03 P.M.", TestDateTimeTemplate.time(15, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("04 P.M.", TestDateTimeTemplate.time(16, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("05 P.M.", TestDateTimeTemplate.time(17, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("06 P.M.", TestDateTimeTemplate.time(18, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("07 P.M.", TestDateTimeTemplate.time(19, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("08 P.M.", TestDateTimeTemplate.time(20, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("09 P.M.", TestDateTimeTemplate.time(21, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("10 P.M.", TestDateTimeTemplate.time(22, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("11 P.M.", TestDateTimeTemplate.time(23, 0, 0, 0), "HH A.M.", provider);
        this.assertEquals("01:02:03.1", TestDateTimeTemplate.time(1, 2, 3, 100000000), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF1", provider);
        this.assertEquals("01:02:03.12", TestDateTimeTemplate.time(1, 2, 3, 120000000), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF2", provider);
        this.assertEquals("01:02:03.123", TestDateTimeTemplate.time(1, 2, 3, 123000000), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF3", provider);
        this.assertEquals("01:02:03.1234", TestDateTimeTemplate.time(1, 2, 3, 123400000), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF4", provider);
        this.assertEquals("01:02:03.12345", TestDateTimeTemplate.time(1, 2, 3, 123450000), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF5", provider);
        this.assertEquals("01:02:03.123456", TestDateTimeTemplate.time(1, 2, 3, 123456000), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF6", provider);
        this.assertEquals("01:02:03.1234567", TestDateTimeTemplate.time(1, 2, 3, 123456700), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF7", provider);
        this.assertEquals("01:02:03.12345678", TestDateTimeTemplate.time(1, 2, 3, 123456780), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF8", provider);
        this.assertEquals("01:02:03.123456789", TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS.FF9", provider);
        this.assertEquals("02:03.123456789", TestDateTimeTemplate.time(0, 2, 3, 123456789), TestDateTimeTemplate.time(1, 2, 3, 123456789), "MI:SS.FF9", provider);
        this.assertEquals("01:03.123456789", TestDateTimeTemplate.time(1, 0, 3, 123456789), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:SS.FF9", provider);
        this.assertEquals("01:02.123456789", TestDateTimeTemplate.time(1, 2, 0, 123456789), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI.FF9", provider);
        this.assertEquals("01:02:03", TestDateTimeTemplate.time(1, 2, 3, 0), TestDateTimeTemplate.time(1, 2, 3, 123456789), "HH24:MI:SS", provider);
        this.assertEquals("37230.987654321", TestDateTimeTemplate.time(10, 20, 30, 987654321), "SSSSS.FF9", provider);
        this.assertEquals("37230987654321", TestDateTimeTemplate.time(10, 20, 30, 987654321), "SSSSSFF9", provider);
    }

    private void testTimeTz() {
        Provider provider = new Provider(2023, 4);
        this.assertEquals("01:02:03.123456789+10:23:45", TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, 10, 23, 45), "HH24:MI:SS.FF9TZH:TZM:TZS", provider);
        this.assertEquals("01:02:03.123456789-10:23:45", TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, -10, -23, -45), "HH24:MI:SS.FF9TZH:TZM:TZS", provider);
        this.assertEquals("01:02:03.123456789-00:23:45", TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, 0, -23, -45), "HH24:MI:SS.FF9TZH:TZM:TZS", provider);
        this.assertEquals("01:02:03.123456789-10:23", TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, -10, -23, 0), TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, -10, -23, -45), "HH24:MI:SS.FF9TZH:TZM", provider);
        this.assertEquals("01:02:03.123456789-10", TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, -10, 0, 0), TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, -10, -23, -45), "HH24:MI:SS.FF9TZH", provider);
        this.assertEquals("01:02:03.123456789", TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, 0, 0, 0), TestDateTimeTemplate.timeTz(1, 2, 3, 123456789, -10, -23, -45), "HH24:MI:SS.FF9", provider);
        this.assertEquals(TestDateTimeTemplate.timeTz(10, 20, 30, 0, 1, 30, 0), DateTimeTemplate.of("HH24:MI:SSTZH:TZM").parse("10:20:30 01:30", TypeInfo.getTypeInfo(19), provider));
    }

    private void testTimestamp() {
        Provider provider = new Provider(2023, 4);
        this.assertEquals("2022-10-12 01:02:03.123456789", TestDateTimeTemplate.timestamp(2022, 10, 12, 1, 2, 3, 123456789), "YYYY-MM-DD HH24:MI:SS.FF9", provider);
    }

    private void testTimestampTz() {
        Provider provider = new Provider(2023, 4);
        this.assertEquals("2022-10-12 01:02:03.123456789+10:23:45", TestDateTimeTemplate.timestampTz(2022, 10, 12, 1, 2, 3, 123456789, 10, 23, 45), "YYYY-MM-DD HH24:MI:SS.FF9TZH:TZM:TZS", provider);
    }

    private void testInvalidCombinations() {
        this.testInvalidCombination("Y YY");
        this.testInvalidCombination("YY RR");
        this.testInvalidCombination("MM MM");
        this.testInvalidCombination("DD DD");
        this.testInvalidCombination("DDD DDD");
        this.testInvalidCombination("HH HH12 A.M.");
        this.testInvalidCombination("HH24 HH24");
        this.testInvalidCombination("MI MI");
        this.testInvalidCombination("SS SS");
        this.testInvalidCombination("SSSSS SSSSS");
        this.testInvalidCombination("FF1 FF9");
        this.testInvalidCombination("A.M. P.M. HH");
        this.testInvalidCombination("TZH TZH");
        this.testInvalidCombination("TZM TZM");
        this.testInvalidCombination("TZS TZS");
        this.testInvalidCombination("DDD MM");
        this.testInvalidCombination("DDD DD");
        this.testInvalidCombination("HH");
        this.testInvalidCombination("A.M.");
        this.testInvalidCombination("A.M. HH HH24");
        this.testInvalidCombination("SSSSS HH");
        this.testInvalidCombination("SSSSS HH24");
        this.testInvalidCombination("SSSSS MI");
        this.testInvalidCombination("SSSSS SS");
        this.testInvalidCombination("TZS TZH");
        this.testInvalidCombination("TZM");
    }

    private void testInvalidCombination(String template) {
        this.assertFail(template);
    }

    private void testInvalidDelimiters() {
        String valid = "-./,';: ";
        DateTimeTemplate.of(valid);
        char ch = ' ';
        while (ch <= '@') {
            if (valid.indexOf(ch) < 0) {
                this.testInvalidDelimiter(String.valueOf(ch));
            }
            ch = (char)(ch + '\u0001');
        }
        ch = '[';
        while (ch <= '`') {
            if (valid.indexOf(ch) < 0) {
                this.testInvalidDelimiter(String.valueOf(ch));
            }
            ch = (char)(ch + '\u0001');
        }
        ch = '{';
        while (ch <= '\u0080') {
            if (valid.indexOf(ch) < 0) {
                this.testInvalidDelimiter(String.valueOf(ch));
            }
            ch = (char)(ch + '\u0001');
        }
    }

    private void testInvalidDelimiter(String template) {
        this.assertFail(template);
    }

    private void testInvalidFields() {
        long dateValue = DateTimeUtils.dateValue(2000L, 11, 15);
        long timeNanos = 51825123456789L;
        int offsetSecons = -13032;
        ValueDate date = ValueDate.fromDateValue(dateValue);
        ValueTime time = ValueTime.fromNanos(timeNanos);
        ValueTimeTimeZone timeTz = ValueTimeTimeZone.fromNanos(timeNanos, offsetSecons);
        ValueTimestamp timestamp = ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
        this.testInvalidTimeFields(date);
        this.testInvalidTimeZoneField(date);
        this.testInvalidDateFields(time);
        this.testInvalidTimeZoneField(time);
        this.testInvalidDateFields(timeTz);
        this.testInvalidTimeZoneField(timestamp);
    }

    private void testInvalidDateFields(Value value) {
        this.testInvalidField(value, "23", "YY");
        this.testInvalidField(value, "23", "RR");
        this.testInvalidField(value, "10", "MM");
        this.testInvalidField(value, "15", "DD");
        this.testInvalidField(value, "100", "DDD");
    }

    private void testInvalidTimeFields(Value value) {
        this.testInvalidField(value, "12 P.M.", "HH A.M.");
        this.testInvalidField(value, "18", "HH24");
        this.testInvalidField(value, "23", "MI");
        this.testInvalidField(value, "55", "SS");
        this.testInvalidField(value, "12345", "SSSSS");
    }

    private void testInvalidTimeZoneField(Value value) {
        this.testInvalidField(value, "+10", "TZH");
        this.testInvalidField(value, "+10 30", "TZH TZM");
        this.testInvalidField(value, "+10 30 45", "TZH TZM TZS");
    }

    private void testInvalidField(Value value, String valueString, String template) {
        DateTimeTemplate t = DateTimeTemplate.of(template);
        try {
            t.format(value);
            this.fail("DbException expected for template \"" + template + "\" and value " + value.getTraceSQL());
        }
        catch (DbException dbException) {
            // empty catch block
        }
        try {
            t.parse(valueString, value.getType(), null);
            this.fail("DbException expected for template \"" + template + "\" and value " + value.getTraceSQL());
        }
        catch (DbException dbException) {
            // empty catch block
        }
    }

    private void testInvalidTemplates() {
        this.assertFail("FF ");
        this.assertFail("FFF");
        this.assertFail("R");
        this.assertFail("RRR");
    }

    private void testOutOfRange() {
        Provider provider = new Provider(2023, 4);
        this.testOutOfRange("YYYY-MM-DD", "2023-02-29", 17, provider);
        this.testOutOfRange("YYYY-MM-DD", "2023--1-20", 17, provider);
        this.testOutOfRange("YYYY-MM-DD", "2023-13-20", 17, provider);
        this.testOutOfRange("YYYY-MM-DD", "2023-01--1", 17, provider);
        this.testOutOfRange("YYYY-MM-DD", "2023-01-32", 17, provider);
        this.testOutOfRange("YYYY-DDD", "2023-000", 17, provider);
        this.testOutOfRange("YYYY-DDD", "2023-366", 17, provider);
        this.testOutOfRange("YYYY-DDD", "2024-367", 17, provider);
        this.testOutOfRange("Y", "10", 17, provider);
        this.testOutOfRange("YY", "100", 17, provider);
        this.testOutOfRange("YYY", "1000", 17, provider);
        this.testOutOfRange("RR", "100", 17, provider);
        this.testOutOfRange("A.M. HH12:MI:SS", "A.M. 13:00:00", 18, provider);
        this.testOutOfRange("HH24:MI:SS", "-1:00:00", 18, provider);
        this.testOutOfRange("HH24:MI:SS", "24:00:00", 18, provider);
        this.testOutOfRange("HH24:MI:SS", "23:-1:00", 18, provider);
        this.testOutOfRange("HH24:MI:SS", "23:60:00", 18, provider);
        this.testOutOfRange("HH24:MI:SS", "23:00:-1", 18, provider);
        this.testOutOfRange("HH24:MI:SS", "23:00:60", 18, provider);
        this.testOutOfRange("SSSSS", "-1", 18, provider);
        this.testOutOfRange("SSSSS", "86400", 18, provider);
        this.testOutOfRange("SSSSS", "9999999999", 18, provider);
        this.testOutOfRange("SSSSS", "9999999999", 18, provider);
        this.testOutOfRange("HH24:MI:SSTZH:TZM:TZS", "10:20:30+19:00:00", 19, provider);
        this.testOutOfRange("HH24:MI:SSTZH:TZM:TZS", "10:20:30+18:00:01", 19, provider);
        this.testOutOfRange("HH24:MI:SSTZH:TZM:TZS", "10:20:30+10:60:00", 19, provider);
        this.testOutOfRange("HH24:MI:SSTZH:TZM:TZS", "10:20:30+10:00:60", 19, provider);
    }

    private void testOutOfRange(String template, String valueString, int valueType, CastDataProvider provider) {
        DateTimeTemplate t = DateTimeTemplate.of(template);
        try {
            t.parse(valueString, TypeInfo.getTypeInfo(valueType), provider);
            this.fail("DbException expected for template \"" + template + "\" and string \"" + valueString + "\"");
        }
        catch (DbException dbException) {
            // empty catch block
        }
    }

    private void testParseErrors() {
        Provider provider = new Provider(2023, 4);
        this.testParseError("SSSSS", "", 18, provider);
        this.testParseError("YYYYSSSSS", "2023", 20, provider);
        this.testParseError("FF1", "", 18, provider);
        this.testParseError("FF1", "A", 18, provider);
        this.testParseError("SSFF9", "10", 18, provider);
        this.testParseError("SSFF1", "10!", 18, provider);
        this.testParseError("SSFF1", "10A", 18, provider);
        this.testParseError("YYYY:", "1999", 17, provider);
        this.testParseError("YYYY:", "1999;", 17, provider);
    }

    private void testParseError(String template, String valueString, int valueType, CastDataProvider provider) {
        DateTimeTemplate t = DateTimeTemplate.of(template);
        try {
            t.parse(valueString, TypeInfo.getTypeInfo(valueType), provider);
            this.fail("DbException expected for template \"" + template + "\" and string \"" + valueString + "\"");
        }
        catch (DbException dbException) {
            // empty catch block
        }
    }

    private void assertEquals(String expected, Value value, String template, CastDataProvider provider) {
        DateTimeTemplate t = DateTimeTemplate.of(template);
        this.assertEquals(expected, t.format(value));
        this.assertEquals(value, t.parse(expected, value.getType(), provider));
    }

    private void assertEquals(String expectedString, Value expectedValue, Value value, String template, CastDataProvider provider) {
        DateTimeTemplate t = DateTimeTemplate.of(template);
        this.assertEquals(expectedString, t.format(value));
        this.assertEquals(expectedValue, t.parse(expectedString, value.getType(), provider));
    }

    private void assertEqualsAndFail(String expectedString, Value value, String template, CastDataProvider provider) {
        DateTimeTemplate t = DateTimeTemplate.of(template);
        this.assertEquals(expectedString, t.format(value));
        try {
            t.parse(expectedString, value.getType(), provider);
            this.fail("DbException expected for template \"" + template + "\" and string \"" + expectedString + "\"");
        }
        catch (DbException dbException) {
            // empty catch block
        }
    }

    private void assertFail(String template) {
        try {
            DateTimeTemplate.of(template);
            this.fail("DbException expected for template \"" + template + "\"");
        }
        catch (DbException dbException) {
            // empty catch block
        }
    }

    private static ValueDate date(int year, int month, int day) {
        return ValueDate.fromDateValue(DateTimeUtils.dateValue(year, month, day));
    }

    private static ValueTime time(int hour, int minute, int second, int nanos) {
        return ValueTime.fromNanos((((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000000000L + (long)nanos);
    }

    private static ValueTimeTimeZone timeTz(int hour, int minute, int second, int nanos, int tzHour, int tzMinute, int tzSeconds) {
        return ValueTimeTimeZone.fromNanos((((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000000000L + (long)nanos, (tzHour * 60 + tzMinute) * 60 + tzSeconds);
    }

    private static ValueTimestamp timestamp(int year, int month, int day, int hour, int minute, int second, int nanos) {
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValue(year, month, day), (((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000000000L + (long)nanos);
    }

    private static ValueTimestampTimeZone timestampTz(int year, int month, int day, int hour, int minute, int second, int nanos, int tzHour, int tzMinute, int tzSeconds) {
        return ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValue(year, month, day), (((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000000000L + (long)nanos, (tzHour * 60 + tzMinute) * 60 + tzSeconds);
    }

    private static final class Provider
    implements CastDataProvider {
        private final ValueTimestampTimeZone currentTimestamp;

        Provider(int year, int month) {
            this.currentTimestamp = ValueTimestampTimeZone.fromDateValueAndNanos(DateTimeUtils.dateValue(year, month, 15), 1234567890123L, -12233);
        }

        @Override
        public ValueTimestampTimeZone currentTimestamp() {
            return this.currentTimestamp;
        }

        @Override
        public TimeZoneProvider currentTimeZone() {
            return null;
        }

        @Override
        public Mode getMode() {
            return null;
        }

        @Override
        public JavaObjectSerializer getJavaObjectSerializer() {
            return null;
        }

        @Override
        public boolean zeroBasedEnums() {
            return false;
        }
    }
}

