/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.h2.Driver;
import org.h2.api.DatabaseEventListener;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.test.utils.SelfDestructor;

public class TestExit
extends TestDb {
    private static Connection conn;
    private static final int OPEN_WITH_CLOSE_ON_EXIT = 1;
    private static final int OPEN_WITHOUT_CLOSE_ON_EXIT = 2;

    @Override
    public boolean isEnabled() {
        if (this.config.codeCoverage || this.config.networked) {
            return false;
        }
        return this.getBaseDir().indexOf(58) <= 0;
    }

    @Override
    public void test() throws Exception {
        int ch;
        this.deleteDb("exit");
        String url = this.getURL(1);
        String selfDestruct = SelfDestructor.getPropertyString(60);
        String[] procDef = new String[]{TestExit.getJVM(), selfDestruct, "-cp", this.getClassPath(), this.getClass().getName(), url};
        Process proc = Runtime.getRuntime().exec(procDef);
        while ((ch = proc.getErrorStream().read()) >= 0) {
            System.out.print((char)ch);
        }
        while ((ch = proc.getInputStream().read()) >= 0) {
            System.out.print((char)ch);
        }
        proc.waitFor();
        Thread.sleep(100L);
        if (!TestExit.getClosedFile().exists()) {
            this.fail("did not close database");
        }
        url = this.getURL(2);
        procDef = new String[]{TestExit.getJVM(), "-cp", this.getClassPath(), this.getClass().getName(), url};
        proc = Runtime.getRuntime().exec(procDef);
        proc.waitFor();
        Thread.sleep(100L);
        if (TestExit.getClosedFile().exists()) {
            this.fail("closed database");
        }
        this.deleteDb("exit");
    }

    private String getURL(int action) {
        Object url = "";
        switch (action) {
            case 1: {
                url = "jdbc:h2:" + this.getBaseDir() + "/exit;database_event_listener='" + MyDatabaseEventListener.class.getName() + "';db_close_on_exit=true";
                break;
            }
            case 2: {
                url = "jdbc:h2:" + this.getBaseDir() + "/exit;database_event_listener='" + MyDatabaseEventListener.class.getName() + "';db_close_on_exit=false";
            }
        }
        url = this.getURL((String)url, true);
        return url;
    }

    public static void main(String ... args) throws SQLException {
        SelfDestructor.startCountdown(60);
        if (args.length == 0) {
            System.exit(1);
        }
        String url = args[0];
        TestExit.execute(url);
    }

    private static void execute(String url) throws SQLException {
        Driver.load();
        conn = TestExit.open(url);
        Connection conn2 = TestExit.open(url);
        conn2.close();
        conn.isClosed();
    }

    private static Connection open(String url) throws SQLException {
        TestExit.getClosedFile().delete();
        return DriverManager.getConnection(url, "sa", "");
    }

    static File getClosedFile() {
        return new File("./data/closed.txt");
    }

    public static final class MyDatabaseEventListener
    implements DatabaseEventListener {
        @Override
        public void closingDatabase() {
            try {
                TestExit.getClosedFile().createNewFile();
            }
            catch (IOException e) {
                TestBase.logError("error", e);
            }
        }
    }
}

