/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.util.Random;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.LobStorageInterface;
import org.h2.store.fs.FileUtils;
import org.h2.test.TestBase;
import org.h2.util.SmallLRUCache;
import org.h2.util.TempFileDeleter;
import org.h2.value.CompareMode;

public class TestFile
extends TestBase
implements DataHandler {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.doTest(false, false);
        this.doTest(false, true);
        this.doTest(true, false);
        this.doTest(true, true);
    }

    private void doTest(boolean nioMem, boolean compress) {
        int len = this.getSize(1000, 10000);
        Random random = new Random();
        FileStore mem = null;
        FileStore file = null;
        byte[] buffMem = null;
        byte[] buffFile = null;
        String prefix = nioMem ? (compress ? "nioMemLZF:" : "nioMemFS:") : (compress ? "memLZF:" : "memFS:");
        FileUtils.delete(prefix + "test");
        FileUtils.delete("~/testFile");
        int i = 0;
        while (i < len) {
            int l;
            if (buffMem == null) {
                int l2 = 1 + random.nextInt(1000);
                buffMem = new byte[l2];
                buffFile = new byte[l2];
            }
            if (file == null) {
                mem = FileStore.open(this, prefix + "test", "rw");
                file = FileStore.open(this, "~/testFile", "rw");
            }
            this.assertEquals(file.getFilePointer(), mem.getFilePointer());
            this.assertEquals(file.length(), mem.length());
            int x = random.nextInt(100);
            if ((x -= 20) < 0) {
                if (file.length() > 0L) {
                    long pos = random.nextInt((int)(file.length() / 16L)) * 16;
                    this.trace("seek " + pos);
                    mem.seek(pos);
                    file.seek(pos);
                }
            } else if ((x -= 20) < 0) {
                this.trace("close");
                mem.close();
                file.close();
                mem = null;
                file = null;
            } else if ((x -= 20) < 0) {
                if (buffFile.length > 16) {
                    random.nextBytes(buffFile);
                    System.arraycopy(buffFile, 0, buffMem, 0, buffFile.length);
                    int off = random.nextInt(buffFile.length - 16);
                    l = random.nextInt((buffFile.length - off) / 16) * 16;
                    this.trace("write " + off + " " + l);
                    mem.write(buffMem, off, l);
                    file.write(buffFile, off, l);
                }
            } else if ((x -= 20) < 0) {
                if (buffFile.length > 16) {
                    int off = random.nextInt(buffFile.length - 16);
                    l = random.nextInt((buffFile.length - off) / 16) * 16;
                    l = (int)Math.min((long)l, file.length() - file.getFilePointer());
                    this.trace("read " + off + " " + l);
                    Exception a = null;
                    Exception b = null;
                    try {
                        file.readFully(buffFile, off, l);
                    }
                    catch (Exception e) {
                        a = e;
                    }
                    try {
                        mem.readFully(buffMem, off, l);
                    }
                    catch (Exception e) {
                        b = e;
                    }
                    if (a != b && (a == null || b == null)) {
                        this.fail("only one threw an exception");
                    }
                    this.assertEquals(buffMem, buffFile);
                }
            } else if ((x -= 10) < 0) {
                this.trace("reset buffers");
                buffMem = null;
                buffFile = null;
            } else {
                int l3 = random.nextInt(10000) * 16;
                long p = file.getFilePointer();
                file.setLength(l3);
                mem.setLength(l3);
                this.trace("setLength " + l3);
                if (p > (long)l3) {
                    file.seek(l3);
                    mem.seek(l3);
                }
            }
            ++i;
        }
        if (mem != null) {
            mem.close();
            file.close();
        }
        FileUtils.delete(prefix + "test");
        FileUtils.delete("~/testFile");
    }

    @Override
    public void checkPowerOff() {
    }

    @Override
    public void checkWritingAllowed() {
    }

    @Override
    public String getDatabasePath() {
        return null;
    }

    @Override
    public Object getLobSyncObject() {
        return null;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return 0;
    }

    @Override
    public FileStore openFile(String name, String mode, boolean mustExist) {
        return null;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return null;
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return TempFileDeleter.getInstance();
    }

    @Override
    public LobStorageInterface getLobStorage() {
        return null;
    }

    @Override
    public int readLob(long lobId, byte[] hmac, long offset, byte[] buff, int off, int length) {
        return -1;
    }

    @Override
    public CompareMode getCompareMode() {
        return CompareMode.getInstance(null, 0);
    }
}

