/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.h2.Driver;
import org.h2.dev.fs.FilePathZip2;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.cache.FilePathCache;
import org.h2.store.fs.FilePath;
import org.h2.store.fs.FileUtils;
import org.h2.store.fs.encrypt.FilePathEncrypt;
import org.h2.store.fs.rec.FilePathRec;
import org.h2.test.TestBase;
import org.h2.test.utils.FilePathDebug;
import org.h2.tools.Backup;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Restore;
import org.h2.util.IOUtils;
import org.h2.util.Task;

public class TestFileSystem
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testFileSystem(this.getBaseDir() + "/fs");
        this.testAbsoluteRelative();
        this.testDirectories(this.getBaseDir());
        this.testMoveTo(this.getBaseDir());
        FilePathZip2.register();
        FilePath.register(new FilePathCache());
        FilePathRec.register();
        this.testZipFileSystem("zip:");
        this.testZipFileSystem("cache:zip:");
        this.testZipFileSystem("zip2:");
        this.testZipFileSystem("cache:zip2:");
        this.testMemFsDir();
        this.testClasspath();
        FilePathDebug.register().setTrace(true);
        FilePathEncrypt.register();
        this.testSimpleExpandTruncateSize();
        this.testSplitDatabaseInZip();
        this.testDatabaseInMemFileSys();
        this.testDatabaseInJar();
        String f = "split:10:" + this.getBaseDir() + "/fs";
        FileUtils.toRealPath(f);
        this.testFileSystem(this.getBaseDir() + "/fs");
        this.testFileSystem("async:" + this.getBaseDir() + "/fs");
        this.testFileSystem("memFS:");
        this.testFileSystem("memLZF:");
        this.testFileSystem("nioMemFS:");
        this.testFileSystem("nioMemLZF:1:");
        this.testFileSystem("nioMemLZF:12:");
        this.testFileSystem("rec:memFS:");
        this.testUserHome();
        try {
            try {
                this.testFileSystem("cache:" + this.getBaseDir() + "/fs");
                this.testFileSystem("nioMapped:" + this.getBaseDir() + "/fs");
                this.testFileSystem("encrypt:0007:" + this.getBaseDir() + "/fs");
                this.testFileSystem("cache:encrypt:0007:" + this.getBaseDir() + "/fs");
                if (!this.config.splitFileSystem) {
                    this.testFileSystem("split:" + this.getBaseDir() + "/fs");
                    this.testFileSystem("split:nioMapped:" + this.getBaseDir() + "/fs");
                }
            }
            catch (Error | Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            FileUtils.delete(this.getBaseDir() + "/fs");
        }
    }

    private void testZipFileSystem(String prefix) throws IOException {
        Random r = new Random(1L);
        int i = 0;
        while (i < 5) {
            this.testZipFileSystem(prefix, r);
            ++i;
        }
    }

    private void testZipFileSystem(String prefix, Random r) throws IOException {
        byte[] data = new byte[r.nextInt(16384)];
        long x = r.nextLong();
        FilePath file = FilePath.get(this.getBaseDir() + "/fs/readonly" + x + ".zip");
        r.nextBytes(data);
        OutputStream out = file.newOutputStream(false);
        ZipOutputStream zipOut = new ZipOutputStream(out);
        ZipEntry entry = new ZipEntry("data");
        zipOut.putNextEntry(entry);
        zipOut.write(data);
        zipOut.closeEntry();
        zipOut.close();
        out.close();
        FilePath fp = FilePath.get(prefix + this.getBaseDir() + "/fs/readonly" + x + ".zip!data");
        FileChannel fc = fp.open("r");
        StringBuilder buff = new StringBuilder();
        try {
            int pos = 0;
            int i = 0;
            while (i < 100) {
                this.trace("op " + i);
                switch (r.nextInt(5)) {
                    case 0: {
                        int p = r.nextInt(data.length);
                        this.trace("seek " + p);
                        buff.append("seek " + p + "\n");
                        fc.position(p);
                        pos = p;
                        break;
                    }
                    case 1: {
                        int len = r.nextInt(1000);
                        int offset = r.nextInt(100);
                        int arrayLen = len + offset;
                        len = Math.min(len, data.length - pos);
                        byte[] b1 = new byte[arrayLen];
                        byte[] b2 = new byte[arrayLen];
                        this.trace("readFully " + len);
                        buff.append("readFully " + len + "\n");
                        System.arraycopy(data, pos, b1, offset, len);
                        ByteBuffer byteBuff = TestFileSystem.createSlicedBuffer(b2, offset, len);
                        FileUtils.readFully(fc, byteBuff);
                        this.assertEquals(b1, b2);
                        pos += len;
                        break;
                    }
                    case 2: {
                        int len = r.nextInt(1000);
                        int offset = r.nextInt(100);
                        int arrayLen = len + offset;
                        int p = r.nextInt(data.length);
                        len = Math.min(len, data.length - p);
                        byte[] b1 = new byte[arrayLen];
                        byte[] b2 = new byte[arrayLen];
                        this.trace("readFully " + p + " " + len);
                        buff.append("readFully " + p + " " + len + "\n");
                        System.arraycopy(data, p, b1, offset, len);
                        ByteBuffer byteBuff = TestFileSystem.createSlicedBuffer(b2, offset, len);
                        DataUtils.readFully(fc, p, byteBuff);
                        this.assertEquals(b1, b2);
                        break;
                    }
                    case 3: {
                        this.trace("getFilePointer");
                        buff.append("getFilePointer\n");
                        this.assertEquals((long)pos, fc.position());
                        break;
                    }
                    case 4: {
                        this.trace("length " + data.length);
                        buff.append("length " + data.length + "\n");
                        this.assertEquals((long)data.length, fc.size());
                    }
                }
                ++i;
            }
            fc.close();
            file.delete();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.fail("Exception: " + String.valueOf(e) + "\n" + buff.toString());
        }
    }

    private void testAbsoluteRelative() {
        this.assertFalse(FileUtils.isAbsolute("test/abc"));
        this.assertFalse(FileUtils.isAbsolute("./test/abc"));
        this.assertTrue(FileUtils.isAbsolute("~/test/abc"));
        this.assertTrue(FileUtils.isAbsolute("/test/abc"));
    }

    private void testMemFsDir() throws IOException {
        FileUtils.newOutputStream("memFS:data/test/a.txt", false).close();
        this.assertEquals(FileUtils.newDirectoryStream("memFS:data/test").toString(), 1, FileUtils.newDirectoryStream("memFS:data/test").size());
        FileUtils.deleteRecursive("memFS:", false);
    }

    private void testClasspath() throws IOException {
        String resource = "org/h2/test/scripts/testSimple.sql";
        InputStream in = this.getClass().getResourceAsStream("/" + resource);
        this.assertNotNull(in);
        in.close();
        in = this.getClass().getClassLoader().getResourceAsStream(resource);
        this.assertNotNull(in);
        in.close();
        in = FileUtils.newInputStream("classpath:" + resource);
        this.assertNotNull(in);
        in.close();
        in = FileUtils.newInputStream("classpath:/" + resource);
        this.assertNotNull(in);
        in.close();
    }

    private void testSimpleExpandTruncateSize() throws Exception {
        String f = "memFS:" + this.getBaseDir() + "/fs/test.data";
        FileUtils.createDirectories("memFS:" + this.getBaseDir() + "/fs");
        FileChannel c = FileUtils.open(f, "rw");
        c.position(4000L);
        c.write(ByteBuffer.wrap(new byte[1]));
        FileLock lock = c.tryLock();
        c.truncate(0L);
        if (lock != null) {
            lock.release();
        }
        c.close();
        FileUtils.deleteRecursive("memFS:", false);
    }

    private void testSplitDatabaseInZip() throws SQLException {
        String dir = this.getBaseDir() + "/fs";
        FileUtils.deleteRecursive(dir, false);
        Connection conn = DriverManager.getConnection("jdbc:h2:split:18:" + dir + "/test");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar) as select x, space(10000) from system_range(1, 100)");
        conn.close();
        Backup.execute(dir + "/test.zip", dir, "", true);
        DeleteDbFiles.execute("split:" + dir, "test", true);
        conn = DriverManager.getConnection("jdbc:h2:split:zip:" + dir + "/test.zip!/test");
        conn.createStatement().execute("select * from test where id=1");
        conn.close();
        FileUtils.deleteRecursive(dir, false);
    }

    private void testDatabaseInMemFileSys() throws SQLException {
        Driver.load();
        String dir = this.getBaseDir() + "/fsMem";
        FileUtils.deleteRecursive(dir, false);
        String url = "jdbc:h2:" + dir + "/fsMem";
        Connection conn = DriverManager.getConnection(url, "sa", "sa");
        conn.createStatement().execute("CREATE TABLE TEST AS SELECT * FROM DUAL");
        conn.createStatement().execute("BACKUP TO '" + this.getBaseDir() + "/fsMem.zip'");
        conn.close();
        Restore.main("-file", this.getBaseDir() + "/fsMem.zip", "-dir", "memFS:");
        conn = DriverManager.getConnection("jdbc:h2:memFS:fsMem", "sa", "sa");
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.close();
        conn.close();
        FileUtils.deleteRecursive(dir, false);
        FileUtils.delete(this.getBaseDir() + "/fsMem.zip");
        FileUtils.delete("memFS:fsMem.mv.db");
    }

    private void testDatabaseInJar() throws Exception {
        if (this.getBaseDir().indexOf(58) > 0) {
            return;
        }
        if (this.config.networked) {
            return;
        }
        Driver.load();
        String dir = this.getBaseDir() + "/fsJar";
        String url = "jdbc:h2:" + dir + "/fsJar";
        Connection conn = DriverManager.getConnection(url, "sa", "sa");
        Statement stat = conn.createStatement();
        stat.execute("create table test(id int primary key, name varchar, b blob, c clob)");
        stat.execute("insert into test values(1, 'Hello', SECURE_RAND(2000), space(2000))");
        ResultSet rs = stat.executeQuery("select * from test");
        rs.next();
        byte[] b1 = rs.getBytes(3);
        String s1 = rs.getString(4);
        conn.close();
        conn = DriverManager.getConnection(url, "sa", "sa");
        stat = conn.createStatement();
        stat.execute("backup to '" + this.getBaseDir() + "/fsJar.zip'");
        conn.close();
        FileUtils.deleteRecursive(dir, false);
        for (String f : FileUtils.newDirectoryStream("zip:" + this.getBaseDir() + "/fsJar.zip")) {
            this.assertFalse(FileUtils.isAbsolute(f));
            this.assertFalse(FileUtils.isDirectory(f));
            this.assertTrue(FileUtils.size(f) > 0L);
            this.assertTrue(f.endsWith(FileUtils.getName(f)));
            this.assertEquals(0L, FileUtils.lastModified(f));
            FileUtils.setReadOnly(f);
            this.assertFalse(FileUtils.canWrite(f));
            InputStream in = FileUtils.newInputStream(f);
            int len = 0;
            while (in.read() >= 0) {
                ++len;
            }
            this.assertEquals((long)len, FileUtils.size(f));
            this.testReadOnly(f);
        }
        String urlJar = "jdbc:h2:zip:" + this.getBaseDir() + "/fsJar.zip!/fsJar";
        conn = DriverManager.getConnection(urlJar, "sa", "sa");
        stat = conn.createStatement();
        rs = stat.executeQuery("select * from test");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        byte[] b2 = rs.getBytes(3);
        String s2 = rs.getString(4);
        this.assertEquals(2000, b2.length);
        this.assertEquals(2000, s2.length());
        this.assertEquals(b1, b2);
        this.assertEquals(s1, s2);
        this.assertFalse(rs.next());
        conn.close();
        FileUtils.delete(this.getBaseDir() + "/fsJar.zip");
    }

    private void testReadOnly(String f) throws IOException {
        this.assertThrows(IOException.class, () -> FileUtils.newOutputStream(f, false));
        this.assertThrows(DbException.class, () -> FileUtils.move(f, f));
        this.assertThrows(DbException.class, () -> FileUtils.move(f, f));
        this.assertThrows(IOException.class, () -> FileUtils.createTempFile(f, ".tmp", false));
        FileChannel channel = FileUtils.open(f, "r");
        this.assertThrows(NonWritableChannelException.class, () -> channel.write(ByteBuffer.allocate(1)));
        this.assertThrows(IOException.class, () -> channel.truncate(0L));
        this.assertNull(channel.tryLock());
        channel.force(false);
        channel.close();
    }

    private void testUserHome() {
        String userDir = System.getProperty("user.home").replace('\\', '/');
        this.assertTrue(FileUtils.toRealPath("~/test").startsWith(userDir));
        this.assertTrue(FileUtils.toRealPath("file:~/test").startsWith(userDir));
    }

    private void testFileSystem(String fsBase) throws Exception {
        this.testConcurrent(fsBase);
        this.testRootExists(fsBase);
        this.testPositionedReadWrite(fsBase);
        this.testSetReadOnly(fsBase);
        this.testParentEventuallyReturnsNull(fsBase);
        this.testSimple(fsBase);
        this.testTempFile(fsBase);
        this.testRandomAccess(fsBase);
    }

    private void testRootExists(String fsBase) {
        String fileName = fsBase + "/testFile";
        FilePath p = FilePath.get(fileName);
        while (p.getParent() != null) {
            p = p.getParent();
        }
        this.assertTrue(p.exists());
    }

    private void testSetReadOnly(String fsBase) {
        String fileName = fsBase + "/testFile";
        if (FileUtils.exists(fileName)) {
            FileUtils.delete(fileName);
        }
        if (FileUtils.createFile(fileName)) {
            FileUtils.setReadOnly(fileName);
            this.assertFalse(FileUtils.canWrite(fileName));
            FileUtils.delete(fileName);
        }
    }

    private void testDirectories(String fsBase) {
        String fileName = fsBase + "/testFile";
        if (FileUtils.exists(fileName)) {
            FileUtils.delete(fileName);
        }
        if (FileUtils.createFile(fileName)) {
            this.assertThrows(DbException.class, () -> FileUtils.createDirectory(fileName));
            this.assertThrows(DbException.class, () -> FileUtils.createDirectories(fileName + "/test"));
            FileUtils.delete(fileName);
        }
    }

    private void testMoveTo(String fsBase) {
        String fileName = fsBase + "/testFile";
        String fileName2 = fsBase + "/testFile2";
        if (FileUtils.exists(fileName)) {
            FileUtils.delete(fileName);
        }
        if (FileUtils.createFile(fileName)) {
            FileUtils.move(fileName, fileName2);
            FileUtils.createFile(fileName);
            this.assertThrows(DbException.class, () -> FileUtils.move(fileName2, fileName));
            FileUtils.delete(fileName);
            FileUtils.delete(fileName2);
            this.assertThrows(DbException.class, () -> FileUtils.move(fileName, fileName2));
        }
    }

    private void testParentEventuallyReturnsNull(String fsBase) {
        FilePath p = FilePath.get(fsBase + "/testFile");
        this.assertTrue(p.getScheme().length() > 0);
        int i = 0;
        while (i < 100) {
            if (p == null) {
                return;
            }
            p = p.getParent();
            ++i;
        }
        this.fail("Parent is not null: " + String.valueOf(p));
        Object path = fsBase + "/testFile";
        int i2 = 0;
        while (i2 < 100) {
            if (path == null) {
                return;
            }
            path = FileUtils.getParent((String)path);
            ++i2;
        }
        this.fail("Parent is not null: " + (String)path);
    }

    private void testSimple(String fsBase) throws Exception {
        int l;
        long time = System.currentTimeMillis();
        for (String s : FileUtils.newDirectoryStream(fsBase)) {
            FileUtils.delete(s);
        }
        FileUtils.createDirectories(fsBase + "/test");
        this.assertTrue(FileUtils.exists(fsBase));
        FileUtils.delete(fsBase + "/test");
        FileUtils.delete(fsBase + "/test2");
        this.assertTrue(FileUtils.createFile(fsBase + "/test"));
        List<FilePath> p = FilePath.get(fsBase).newDirectoryStream();
        this.assertEquals(1, p.size());
        String can = FilePath.get(fsBase + "/test").toRealPath().toString();
        this.assertEquals(can, p.get(0).toString());
        this.assertTrue(FileUtils.canWrite(fsBase + "/test"));
        FileChannel channel = FileUtils.open(fsBase + "/test", "rw");
        byte[] buffer = new byte[10000];
        Random random = new Random(1L);
        random.nextBytes(buffer);
        channel.write(ByteBuffer.wrap(buffer));
        this.assertEquals(10000L, channel.size());
        channel.position(20000L);
        this.assertEquals(20000L, channel.position());
        this.assertEquals(-1, channel.read(ByteBuffer.wrap(buffer, 0, 1)));
        String path = fsBase + "/test";
        this.assertEquals("test", FileUtils.getName(path));
        can = FilePath.get(fsBase).toRealPath().toString();
        String can2 = FileUtils.toRealPath(FileUtils.getParent(path));
        this.assertEquals(can, can2);
        FileLock lock = channel.tryLock();
        if (lock != null) {
            lock.release();
        }
        this.assertEquals(10000L, channel.size());
        channel.close();
        this.assertEquals(10000L, FileUtils.size(fsBase + "/test"));
        channel = FileUtils.open(fsBase + "/test", "r");
        byte[] test = new byte[10000];
        FileUtils.readFully(channel, ByteBuffer.wrap(test, 0, 10000));
        this.assertEquals(buffer, test);
        FileChannel fc = channel;
        this.assertThrows(NonWritableChannelException.class, () -> fc.write(ByteBuffer.wrap(test, 0, 10)));
        this.assertThrows(NonWritableChannelException.class, () -> fc.truncate(10L));
        channel.close();
        long lastMod = FileUtils.lastModified(fsBase + "/test");
        if (lastMod < time - 1999L) {
            this.assertEquals(time, lastMod);
        }
        this.assertEquals(10000L, FileUtils.size(fsBase + "/test"));
        List<String> list = FileUtils.newDirectoryStream(fsBase);
        this.assertEquals(1, list.size());
        this.assertTrue(list.get(0).endsWith("test"));
        IOUtils.copyFiles(fsBase + "/test", fsBase + "/test3");
        FileUtils.move(fsBase + "/test3", fsBase + "/test2");
        FileUtils.move(fsBase + "/test2", fsBase + "/test2");
        this.assertFalse(FileUtils.exists(fsBase + "/test3"));
        this.assertTrue(FileUtils.exists(fsBase + "/test2"));
        this.assertEquals(10000L, FileUtils.size(fsBase + "/test2"));
        byte[] buffer2 = new byte[10000];
        InputStream in = FileUtils.newInputStream(fsBase + "/test2");
        int pos = 0;
        while ((l = in.read(buffer2, pos, Math.min(10000 - pos, 1000))) > 0) {
            pos += l;
        }
        in.close();
        this.assertEquals(10000, pos);
        this.assertEquals(buffer, buffer2);
        this.assertTrue(FileUtils.tryDelete(fsBase + "/test2"));
        FileUtils.delete(fsBase + "/test");
        if (fsBase.indexOf("memFS:") < 0 && fsBase.indexOf("memLZF:") < 0 && fsBase.indexOf("nioMemFS:") < 0 && fsBase.indexOf("nioMemLZF:") < 0) {
            FileUtils.createDirectories(fsBase + "/testDir");
            this.assertTrue(FileUtils.isDirectory(fsBase + "/testDir"));
            if (!fsBase.startsWith("jdbc:")) {
                FileUtils.deleteRecursive(fsBase + "/testDir", false);
                this.assertFalse(FileUtils.exists(fsBase + "/testDir"));
            }
        }
    }

    private void testPositionedReadWrite(String fsBase) throws IOException {
        FileUtils.deleteRecursive(fsBase + "/testFile", false);
        FileUtils.delete(fsBase + "/testFile");
        FileUtils.createDirectories(fsBase);
        this.assertTrue(FileUtils.createFile(fsBase + "/testFile"));
        FileChannel fc = FilePath.get(fsBase + "/testFile").open("rw");
        ByteBuffer buff = ByteBuffer.allocate(4000);
        int i = 0;
        while (i < 4000) {
            buff.put((byte)i);
            ++i;
        }
        buff.flip();
        fc.write(buff, 96L);
        this.assertEquals(0L, fc.position());
        this.assertEquals(4096L, fc.size());
        buff = ByteBuffer.allocate(4000);
        this.assertEquals(4000, fc.read(buff, 96L));
        this.assertEquals(0L, fc.position());
        buff.flip();
        i = 0;
        while (i < 4000) {
            this.assertEquals((byte)i, buff.get());
            ++i;
        }
        buff = ByteBuffer.allocate(0);
        this.assertTrue(fc.read(buff, 8000L) <= 0);
        this.assertEquals(0L, fc.position());
        this.assertTrue(fc.read(buff, 4000L) <= 0);
        this.assertEquals(0L, fc.position());
        this.assertTrue(fc.read(buff, 2000L) <= 0);
        this.assertEquals(0L, fc.position());
        buff = ByteBuffer.allocate(1);
        this.assertEquals(-1, fc.read(buff, 8000L));
        this.assertEquals(1, fc.read(buff, 4000L));
        buff.flip();
        this.assertEquals(1, fc.read(buff, 2000L));
        fc.close();
    }

    private void testRandomAccess(String fsBase) throws Exception {
        this.testRandomAccess(fsBase, 1);
    }

    private void testRandomAccess(String fsBase, int seed) throws Exception {
        StringBuilder buff = new StringBuilder();
        String s = FileUtils.createTempFile(fsBase + "/tmp", ".tmp", false);
        File file = new File("./data/tmp");
        file.getParentFile().mkdirs();
        file.delete();
        RandomAccessFile ra = new RandomAccessFile(file, "rw");
        FileUtils.delete(s);
        FileChannel f = FileUtils.open(s, "rw");
        this.assertEquals(-1, f.read(ByteBuffer.wrap(new byte[1])));
        f.force(true);
        Random random = new Random(seed);
        int size = this.getSize(100, 500);
        try {
            try {
                int i = 0;
                while (i < size) {
                    this.trace("op " + i);
                    int pos = random.nextInt(10000);
                    switch (random.nextInt(7)) {
                        case 0: {
                            pos = (int)Math.min((long)pos, ra.length());
                            this.trace("seek " + pos);
                            buff.append("seek " + pos + "\n");
                            f.position(pos);
                            ra.seek(pos);
                            break;
                        }
                        case 1: {
                            int arrayLen = random.nextInt(1000);
                            int offset = arrayLen / 10;
                            offset = offset == 0 ? 0 : random.nextInt(offset);
                            int len = arrayLen == 0 ? 0 : random.nextInt(arrayLen - offset);
                            byte[] buffer = new byte[arrayLen];
                            ByteBuffer byteBuff = TestFileSystem.createSlicedBuffer(buffer, offset, len);
                            random.nextBytes(buffer);
                            this.trace("write " + offset + " len " + len);
                            buff.append("write " + offset + " " + len + "\n");
                            f.write(byteBuff);
                            ra.write(buffer, offset, len);
                            break;
                        }
                        case 2: {
                            this.trace("truncate " + pos);
                            buff.append("truncate " + pos + "\n");
                            f.truncate(pos);
                            if ((long)pos < ra.length()) {
                                ra.setLength(pos);
                            }
                            this.assertEquals(ra.getFilePointer(), f.position());
                            break;
                        }
                        case 3: {
                            int len = random.nextInt(1000);
                            int offset = random.nextInt(100);
                            int arrayLen = len + offset;
                            len = (int)Math.min((long)len, ra.length() - ra.getFilePointer());
                            byte[] b1 = new byte[arrayLen];
                            byte[] b2 = new byte[arrayLen];
                            this.trace("readFully " + len);
                            buff.append("readFully " + len + "\n");
                            ra.readFully(b1, offset, len);
                            ByteBuffer byteBuff = TestFileSystem.createSlicedBuffer(b2, offset, len);
                            FileUtils.readFully(f, byteBuff);
                            this.assertEquals(b1, b2);
                            break;
                        }
                        case 4: {
                            this.trace("getFilePointer");
                            buff.append("getFilePointer\n");
                            this.assertEquals(ra.getFilePointer(), f.position());
                            break;
                        }
                        case 5: {
                            this.trace("length " + ra.length());
                            buff.append("length " + ra.length() + "\n");
                            this.assertEquals(ra.length(), f.size());
                            break;
                        }
                        case 6: {
                            this.trace("reopen");
                            buff.append("reopen\n");
                            f.close();
                            ra.close();
                            ra = new RandomAccessFile(file, "rw");
                            f = FileUtils.open(s, "rw");
                            this.assertEquals(ra.length(), f.size());
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.fail("Exception: " + String.valueOf(e) + "\n" + buff.toString());
                f.close();
                ra.close();
                file.delete();
                FileUtils.delete(s);
            }
        }
        finally {
            f.close();
            ra.close();
            file.delete();
            FileUtils.delete(s);
        }
    }

    private static ByteBuffer createSlicedBuffer(byte[] buffer, int offset, int len) {
        ByteBuffer byteBuff = ByteBuffer.wrap(buffer);
        byteBuff.position(offset);
        byteBuff = byteBuff.slice();
        byteBuff.limit(len);
        return byteBuff;
    }

    private void testTempFile(String fsBase) throws Exception {
        int len = 10000;
        String s = FileUtils.createTempFile(fsBase + "/tmp", ".tmp", false);
        OutputStream out = FileUtils.newOutputStream(s, false);
        byte[] buffer = new byte[len];
        out.write(buffer);
        out.close();
        out = FileUtils.newOutputStream(s, true);
        out.write(1);
        out.close();
        InputStream in = FileUtils.newInputStream(s);
        int i = 0;
        while (i < len) {
            this.assertEquals(0, in.read());
            ++i;
        }
        this.assertEquals(1, in.read());
        this.assertEquals(-1, in.read());
        in.close();
        out.close();
        FileUtils.delete(s);
    }

    private void testConcurrent(String fsBase) throws Exception {
        String s = FileUtils.createTempFile(fsBase + "/tmp", ".tmp", false);
        File file = new File("./data/tmp");
        file.getParentFile().mkdirs();
        file.delete();
        RandomAccessFile ra = new RandomAccessFile(file, "rw");
        FileUtils.delete(s);
        final FileChannel f = FileUtils.open(s, "rw");
        final int size = this.getSize(10, 50);
        f.write(ByteBuffer.allocate(size * 64 * 1024));
        final AtomicIntegerArray locks = new AtomicIntegerArray(size);
        final AtomicIntegerArray expected = new AtomicIntegerArray(size);
        Random random = new Random(1L);
        System.gc();
        Task task = new Task(){

            @Override
            public void call() throws Exception {
                ByteBuffer byteBuff = ByteBuffer.allocate(16);
                while (!this.stop) {
                    int pos = 0;
                    while (pos < size) {
                        int e;
                        byteBuff.clear();
                        while (!locks.compareAndSet(pos, 0, 1)) {
                        }
                        try {
                            e = expected.get(pos);
                            f.read(byteBuff, pos * 64 * 1024);
                        }
                        finally {
                            locks.set(pos, 0);
                        }
                        byteBuff.position(0);
                        int x = byteBuff.getInt();
                        int y = byteBuff.getInt();
                        TestFileSystem.this.assertEquals(e, x);
                        TestFileSystem.this.assertEquals(e, y);
                        Thread.yield();
                        ++pos;
                    }
                }
            }
        };
        task.execute();
        try {
            try {
                ByteBuffer byteBuff = ByteBuffer.allocate(16);
                int operations = 10000;
                int i = 0;
                while (i < operations) {
                    int e;
                    byteBuff.position(0);
                    byteBuff.putInt(i);
                    byteBuff.putInt(i);
                    byteBuff.flip();
                    int pos = random.nextInt(size);
                    while (!locks.compareAndSet(pos, 0, 1)) {
                    }
                    try {
                        f.write(byteBuff, pos * 64 * 1024);
                        expected.set(pos, i);
                    }
                    finally {
                        locks.set(pos, 0);
                    }
                    pos = random.nextInt(size);
                    byteBuff.clear();
                    while (!locks.compareAndSet(pos, 0, 1)) {
                    }
                    try {
                        e = expected.get(pos);
                        f.read(byteBuff, pos * 64 * 1024);
                    }
                    finally {
                        locks.set(pos, 0);
                    }
                    byteBuff.limit(16);
                    byteBuff.position(0);
                    int x = byteBuff.getInt();
                    int y = byteBuff.getInt();
                    this.assertEquals(e, x);
                    this.assertEquals(e, y);
                    ++i;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.fail("Exception: " + String.valueOf(e));
                task.get();
                f.close();
                ra.close();
                file.delete();
                FileUtils.delete(s);
                System.gc();
            }
        }
        finally {
            task.get();
            f.close();
            ra.close();
            file.delete();
            FileUtils.delete(s);
            System.gc();
        }
    }
}

