/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.api.Interval;
import org.h2.test.TestBase;
import org.h2.util.StringUtils;

public class TestInterval
extends TestBase {
    private static final long MAX = 999999999999999999L;
    private static final long MIN = -999999999999999999L;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testOfYears();
        this.testOfMonths();
        this.testOfDays();
        this.testOfHours();
        this.testOfMinutes();
        this.testOfSeconds();
        this.testOfSeconds2();
        this.testOfNanos();
        this.testOfYearsMonths();
        this.testOfDaysHours();
        this.testOfDaysHoursMinutes();
        this.testOfDaysHoursMinutesSeconds();
        this.testOfHoursMinutes();
        this.testOfHoursMinutesSeconds();
        this.testOfMinutesSeconds();
    }

    private void testOfYears() {
        this.testOfYearsGood(0L);
        this.testOfYearsGood(100L);
        this.testOfYearsGood(-100L);
        this.testOfYearsGood(999999999999999999L);
        this.testOfYearsGood(-999999999999999999L);
        this.testOfYearsBad(1000000000000000000L);
        this.testOfYearsBad(-1000000000000000000L);
        this.testOfYearsBad(Long.MAX_VALUE);
        this.testOfYearsBad(Long.MIN_VALUE);
    }

    private void testOfYearsGood(long years) {
        Interval i = Interval.ofYears(years);
        this.assertEquals(years, i.getYears());
        this.assertEquals("INTERVAL '" + years + "' YEAR", i.toString());
    }

    private void testOfYearsBad(long years) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofYears(years));
    }

    private void testOfMonths() {
        this.testOfMonthsGood(0L);
        this.testOfMonthsGood(100L);
        this.testOfMonthsGood(-100L);
        this.testOfMonthsGood(999999999999999999L);
        this.testOfMonthsGood(-999999999999999999L);
        this.testOfMonthsBad(1000000000000000000L);
        this.testOfMonthsBad(-1000000000000000000L);
        this.testOfMonthsBad(Long.MAX_VALUE);
        this.testOfMonthsBad(Long.MIN_VALUE);
    }

    private void testOfMonthsGood(long months) {
        Interval i = Interval.ofMonths(months);
        this.assertEquals(months, i.getMonths());
        this.assertEquals("INTERVAL '" + months + "' MONTH", i.toString());
    }

    private void testOfMonthsBad(long months) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofMonths(months));
    }

    private void testOfDays() {
        this.testOfDaysGood(0L);
        this.testOfDaysGood(100L);
        this.testOfDaysGood(-100L);
        this.testOfDaysGood(999999999999999999L);
        this.testOfDaysGood(-999999999999999999L);
        this.testOfDaysBad(1000000000000000000L);
        this.testOfDaysBad(-1000000000000000000L);
        this.testOfDaysBad(Long.MAX_VALUE);
        this.testOfDaysBad(Long.MIN_VALUE);
    }

    private void testOfDaysGood(long days) {
        Interval i = Interval.ofDays(days);
        this.assertEquals(days, i.getDays());
        this.assertEquals("INTERVAL '" + days + "' DAY", i.toString());
    }

    private void testOfDaysBad(long days) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofDays(days));
    }

    private void testOfHours() {
        this.testOfHoursGood(0L);
        this.testOfHoursGood(100L);
        this.testOfHoursGood(-100L);
        this.testOfHoursGood(999999999999999999L);
        this.testOfHoursGood(-999999999999999999L);
        this.testOfHoursBad(1000000000000000000L);
        this.testOfHoursBad(-1000000000000000000L);
        this.testOfHoursBad(Long.MAX_VALUE);
        this.testOfHoursBad(Long.MIN_VALUE);
    }

    private void testOfHoursGood(long hours) {
        Interval i = Interval.ofHours(hours);
        this.assertEquals(hours, i.getHours());
        this.assertEquals("INTERVAL '" + hours + "' HOUR", i.toString());
    }

    private void testOfHoursBad(long hours) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofHours(hours));
    }

    private void testOfMinutes() {
        this.testOfMinutesGood(0L);
        this.testOfMinutesGood(100L);
        this.testOfMinutesGood(-100L);
        this.testOfMinutesGood(999999999999999999L);
        this.testOfMinutesGood(-999999999999999999L);
        this.testOfMinutesBad(1000000000000000000L);
        this.testOfMinutesBad(-1000000000000000000L);
        this.testOfMinutesBad(Long.MAX_VALUE);
        this.testOfMinutesBad(Long.MIN_VALUE);
    }

    private void testOfMinutesGood(long minutes) {
        Interval i = Interval.ofMinutes(minutes);
        this.assertEquals(minutes, i.getMinutes());
        this.assertEquals("INTERVAL '" + minutes + "' MINUTE", i.toString());
    }

    private void testOfMinutesBad(long minutes) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofMinutes(minutes));
    }

    private void testOfSeconds() {
        this.testOfSecondsGood(0L);
        this.testOfSecondsGood(100L);
        this.testOfSecondsGood(-100L);
        this.testOfSecondsGood(999999999999999999L);
        this.testOfSecondsGood(-999999999999999999L);
        this.testOfSecondsBad(1000000000000000000L);
        this.testOfSecondsBad(-1000000000000000000L);
        this.testOfSecondsBad(Long.MAX_VALUE);
        this.testOfSecondsBad(Long.MIN_VALUE);
    }

    private void testOfSecondsGood(long seconds) {
        Interval i = Interval.ofSeconds(seconds);
        this.assertEquals(seconds, i.getSeconds());
        this.assertEquals("INTERVAL '" + seconds + "' SECOND", i.toString());
    }

    private void testOfSecondsBad(long seconds) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofSeconds(seconds));
    }

    private void testOfSeconds2() {
        this.testOfSeconds2Good(0L, 0);
        this.testOfSeconds2Good(0L, -2);
        this.testOfSeconds2Good(100L, 5);
        this.testOfSeconds2Good(-100L, -1);
        this.testOfSeconds2Good(999999999999999999L, 999999999);
        this.testOfSeconds2Good(-999999999999999999L, -999999999);
        this.testOfSeconds2Bad(0L, 1000000000);
        this.testOfSeconds2Bad(0L, -1000000000);
        this.testOfSeconds2Bad(1000000000000000000L, 0);
        this.testOfSeconds2Bad(-1000000000000000000L, 0);
        this.testOfSeconds2Bad(Long.MAX_VALUE, 0);
        this.testOfSeconds2Bad(Long.MIN_VALUE, 0);
        this.testOfSeconds2Bad(0L, Integer.MAX_VALUE);
        this.testOfSeconds2Bad(0L, Integer.MIN_VALUE);
    }

    private void testOfSeconds2Good(long seconds, int nanos) {
        Interval i = Interval.ofSeconds(seconds, nanos);
        this.assertEquals(seconds, i.getSeconds());
        this.assertEquals((long)nanos, i.getNanosOfSecond());
        if (Math.abs(seconds) < 9000000000L) {
            this.assertEquals(seconds * 1000000000L + (long)nanos, i.getSecondsAndNanos());
        }
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (seconds < 0L || nanos < 0) {
            b.append('-');
        }
        b.append(Math.abs(seconds));
        if (nanos != 0) {
            b.append('.');
            StringUtils.appendZeroPadded(b, 9, Math.abs(nanos));
            TestInterval.stripTrailingZeroes(b);
        }
        b.append("' SECOND");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfSeconds2Bad(long seconds, int nanos) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofSeconds(seconds, nanos));
    }

    private void testOfNanos() {
        this.testOfNanosGood(0L);
        this.testOfNanosGood(100L);
        this.testOfNanosGood(-100L);
        this.testOfNanosGood(Long.MAX_VALUE);
        this.testOfNanosGood(Long.MIN_VALUE);
    }

    private void testOfNanosGood(long nanos) {
        Interval i = Interval.ofNanos(nanos);
        long seconds = nanos / 1000000000L;
        int nanosOfSecond = (int)(nanos % 1000000000L);
        this.assertEquals(seconds, i.getSeconds());
        this.assertEquals((long)nanosOfSecond, i.getNanosOfSecond());
        this.assertEquals(nanos, i.getSecondsAndNanos());
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (nanos < 0L) {
            b.append('-');
        }
        b.append(Math.abs(seconds));
        if (nanosOfSecond != 0) {
            b.append('.');
            StringUtils.appendZeroPadded(b, 9, Math.abs(nanosOfSecond));
            TestInterval.stripTrailingZeroes(b);
        }
        b.append("' SECOND");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfYearsMonths() {
        this.testOfYearsMonthsGood(0L, 0);
        this.testOfYearsMonthsGood(0L, -2);
        this.testOfYearsMonthsGood(100L, 5);
        this.testOfYearsMonthsGood(-100L, -1);
        this.testOfYearsMonthsGood(999999999999999999L, 11);
        this.testOfYearsMonthsGood(-999999999999999999L, -11);
        this.testOfYearsMonthsBad(0L, 12);
        this.testOfYearsMonthsBad(0L, -12);
        this.testOfYearsMonthsBad(1000000000000000000L, 0);
        this.testOfYearsMonthsBad(-1000000000000000000L, 0);
        this.testOfYearsMonthsBad(Long.MAX_VALUE, 0);
        this.testOfYearsMonthsBad(Long.MIN_VALUE, 0);
        this.testOfYearsMonthsBad(0L, Integer.MAX_VALUE);
        this.testOfYearsMonthsBad(0L, Integer.MIN_VALUE);
    }

    private void testOfYearsMonthsGood(long years, int months) {
        Interval i = Interval.ofYearsMonths(years, months);
        this.assertEquals(years, i.getYears());
        this.assertEquals((long)months, i.getMonths());
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (years < 0L || months < 0) {
            b.append('-');
        }
        b.append(Math.abs(years)).append('-').append(Math.abs(months)).append("' YEAR TO MONTH");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfYearsMonthsBad(long years, int months) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofYearsMonths(years, months));
    }

    private void testOfDaysHours() {
        this.testOfDaysHoursGood(0L, 0);
        this.testOfDaysHoursGood(0L, -2);
        this.testOfDaysHoursGood(100L, 5);
        this.testOfDaysHoursGood(-100L, -1);
        this.testOfDaysHoursGood(999999999999999999L, 23);
        this.testOfDaysHoursGood(-999999999999999999L, -23);
        this.testOfDaysHoursBad(0L, 24);
        this.testOfDaysHoursBad(0L, -24);
        this.testOfDaysHoursBad(1000000000000000000L, 0);
        this.testOfDaysHoursBad(-1000000000000000000L, 0);
        this.testOfDaysHoursBad(Long.MAX_VALUE, 0);
        this.testOfDaysHoursBad(Long.MIN_VALUE, 0);
        this.testOfDaysHoursBad(0L, Integer.MAX_VALUE);
        this.testOfDaysHoursBad(0L, Integer.MIN_VALUE);
    }

    private void testOfDaysHoursGood(long days, int hours) {
        Interval i = Interval.ofDaysHours(days, hours);
        this.assertEquals(days, i.getDays());
        this.assertEquals((long)hours, i.getHours());
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (days < 0L || hours < 0) {
            b.append('-');
        }
        b.append(Math.abs(days)).append(' ');
        StringUtils.appendTwoDigits(b, Math.abs(hours));
        b.append("' DAY TO HOUR");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfDaysHoursBad(long days, int hours) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofDaysHours(days, hours));
    }

    private void testOfDaysHoursMinutes() {
        this.testOfDaysHoursMinutesGood(0L, 0, 0);
        this.testOfDaysHoursMinutesGood(0L, -2, 0);
        this.testOfDaysHoursMinutesGood(0L, 0, -2);
        this.testOfDaysHoursMinutesGood(100L, 5, 3);
        this.testOfDaysHoursMinutesGood(-100L, -1, -3);
        this.testOfDaysHoursMinutesGood(999999999999999999L, 23, 59);
        this.testOfDaysHoursMinutesGood(-999999999999999999L, -23, -59);
        this.testOfDaysHoursMinutesBad(0L, 24, 0);
        this.testOfDaysHoursMinutesBad(0L, -24, 0);
        this.testOfDaysHoursMinutesBad(0L, 0, 60);
        this.testOfDaysHoursMinutesBad(0L, 0, -60);
        this.testOfDaysHoursMinutesBad(1000000000000000000L, 0, 0);
        this.testOfDaysHoursMinutesBad(-1000000000000000000L, 0, 0);
        this.testOfDaysHoursMinutesBad(Long.MAX_VALUE, 0, 0);
        this.testOfDaysHoursMinutesBad(Long.MIN_VALUE, 0, 0);
        this.testOfDaysHoursMinutesBad(0L, Integer.MAX_VALUE, 0);
        this.testOfDaysHoursMinutesBad(0L, Integer.MIN_VALUE, 0);
        this.testOfDaysHoursMinutesBad(0L, 0, Integer.MAX_VALUE);
        this.testOfDaysHoursMinutesBad(0L, 0, Integer.MIN_VALUE);
    }

    private void testOfDaysHoursMinutesGood(long days, int hours, int minutes) {
        Interval i = Interval.ofDaysHoursMinutes(days, hours, minutes);
        this.assertEquals(days, i.getDays());
        this.assertEquals((long)hours, i.getHours());
        this.assertEquals((long)minutes, i.getMinutes());
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (days < 0L || hours < 0 || minutes < 0) {
            b.append('-');
        }
        b.append(Math.abs(days)).append(' ');
        StringUtils.appendTwoDigits(b, Math.abs(hours));
        b.append(':');
        StringUtils.appendTwoDigits(b, Math.abs(minutes));
        b.append("' DAY TO MINUTE");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfDaysHoursMinutesBad(long days, int hours, int minutes) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofDaysHoursMinutes(days, hours, minutes));
    }

    private void testOfDaysHoursMinutesSeconds() {
        this.testOfDaysHoursMinutesSecondsGood(0L, 0, 0, 0);
        this.testOfDaysHoursMinutesSecondsGood(0L, -2, 0, 0);
        this.testOfDaysHoursMinutesSecondsGood(0L, 0, -2, 0);
        this.testOfDaysHoursMinutesSecondsGood(0L, 0, 0, -2);
        this.testOfDaysHoursMinutesSecondsGood(100L, 5, 3, 4);
        this.testOfDaysHoursMinutesSecondsGood(-100L, -1, -3, -4);
        this.testOfDaysHoursMinutesSecondsGood(999999999999999999L, 23, 59, 59);
        this.testOfDaysHoursMinutesSecondsGood(-999999999999999999L, -23, -59, -59);
        this.testOfDaysHoursMinutesSecondsBad(0L, 24, 0, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, -24, 0, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, 0, 60, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, 0, -60, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, 0, 0, 60);
        this.testOfDaysHoursMinutesSecondsBad(0L, 0, 0, -60);
        this.testOfDaysHoursMinutesSecondsBad(1000000000000000000L, 0, 0, 0);
        this.testOfDaysHoursMinutesSecondsBad(-1000000000000000000L, 0, 0, 0);
        this.testOfDaysHoursMinutesSecondsBad(Long.MAX_VALUE, 0, 0, 0);
        this.testOfDaysHoursMinutesSecondsBad(Long.MIN_VALUE, 0, 0, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, Integer.MAX_VALUE, 0, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, Integer.MIN_VALUE, 0, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, 0, Integer.MAX_VALUE, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, 0, Integer.MIN_VALUE, 0);
        this.testOfDaysHoursMinutesSecondsBad(0L, 0, 0, Integer.MAX_VALUE);
        this.testOfDaysHoursMinutesSecondsBad(0L, 0, 0, Integer.MIN_VALUE);
    }

    private void testOfDaysHoursMinutesSecondsGood(long days, int hours, int minutes, int seconds) {
        Interval i = Interval.ofDaysHoursMinutesSeconds(days, hours, minutes, seconds);
        this.assertEquals(days, i.getDays());
        this.assertEquals((long)hours, i.getHours());
        this.assertEquals((long)minutes, i.getMinutes());
        this.assertEquals((long)seconds, i.getSeconds());
        this.assertEquals(0L, i.getNanosOfSecond());
        this.assertEquals((long)seconds * 1000000000L, i.getSecondsAndNanos());
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (days < 0L || hours < 0 || minutes < 0 || seconds < 0) {
            b.append('-');
        }
        b.append(Math.abs(days)).append(' ');
        StringUtils.appendTwoDigits(b, Math.abs(hours));
        b.append(':');
        StringUtils.appendTwoDigits(b, Math.abs(minutes));
        b.append(':');
        StringUtils.appendTwoDigits(b, Math.abs(seconds));
        b.append("' DAY TO SECOND");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfDaysHoursMinutesSecondsBad(long days, int hours, int minutes, int seconds) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofDaysHoursMinutesSeconds(days, hours, minutes, seconds));
    }

    private void testOfHoursMinutes() {
        this.testOfHoursMinutesGood(0L, 0);
        this.testOfHoursMinutesGood(0L, -2);
        this.testOfHoursMinutesGood(100L, 5);
        this.testOfHoursMinutesGood(-100L, -1);
        this.testOfHoursMinutesGood(999999999999999999L, 59);
        this.testOfHoursMinutesGood(-999999999999999999L, -59);
        this.testOfHoursMinutesBad(0L, 60);
        this.testOfHoursMinutesBad(0L, -60);
        this.testOfHoursMinutesBad(1000000000000000000L, 0);
        this.testOfHoursMinutesBad(-1000000000000000000L, 0);
        this.testOfHoursMinutesBad(Long.MAX_VALUE, 0);
        this.testOfHoursMinutesBad(Long.MIN_VALUE, 0);
        this.testOfHoursMinutesBad(0L, Integer.MAX_VALUE);
        this.testOfHoursMinutesBad(0L, Integer.MIN_VALUE);
    }

    private void testOfHoursMinutesGood(long hours, int minutes) {
        Interval i = Interval.ofHoursMinutes(hours, minutes);
        this.assertEquals(hours, i.getHours());
        this.assertEquals((long)minutes, i.getMinutes());
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (hours < 0L || minutes < 0) {
            b.append('-');
        }
        b.append(Math.abs(hours)).append(':');
        StringUtils.appendTwoDigits(b, Math.abs(minutes));
        b.append("' HOUR TO MINUTE");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfHoursMinutesBad(long hours, int minutes) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofHoursMinutes(hours, minutes));
    }

    private void testOfHoursMinutesSeconds() {
        this.testOfHoursMinutesSecondsGood(0L, 0, 0);
        this.testOfHoursMinutesSecondsGood(0L, -2, 0);
        this.testOfHoursMinutesSecondsGood(0L, 0, -2);
        this.testOfHoursMinutesSecondsGood(100L, 5, 3);
        this.testOfHoursMinutesSecondsGood(-100L, -1, -3);
        this.testOfHoursMinutesSecondsGood(999999999999999999L, 59, 59);
        this.testOfHoursMinutesSecondsGood(-999999999999999999L, -59, -59);
        this.testOfHoursMinutesSecondsBad(0L, 60, 0);
        this.testOfHoursMinutesSecondsBad(0L, -60, 0);
        this.testOfHoursMinutesSecondsBad(0L, 0, 60);
        this.testOfHoursMinutesSecondsBad(0L, 0, -60);
        this.testOfHoursMinutesSecondsBad(1000000000000000000L, 0, 0);
        this.testOfHoursMinutesSecondsBad(-1000000000000000000L, 0, 0);
        this.testOfHoursMinutesSecondsBad(Long.MAX_VALUE, 0, 0);
        this.testOfHoursMinutesSecondsBad(Long.MIN_VALUE, 0, 0);
        this.testOfHoursMinutesSecondsBad(0L, Integer.MAX_VALUE, 0);
        this.testOfHoursMinutesSecondsBad(0L, Integer.MIN_VALUE, 0);
        this.testOfHoursMinutesSecondsBad(0L, 0, Integer.MAX_VALUE);
        this.testOfHoursMinutesSecondsBad(0L, 0, Integer.MIN_VALUE);
    }

    private void testOfHoursMinutesSecondsGood(long hours, int minutes, int seconds) {
        Interval i = Interval.ofHoursMinutesSeconds(hours, minutes, seconds);
        this.assertEquals(hours, i.getHours());
        this.assertEquals((long)minutes, i.getMinutes());
        this.assertEquals((long)seconds, i.getSeconds());
        this.assertEquals(0L, i.getNanosOfSecond());
        this.assertEquals((long)seconds * 1000000000L, i.getSecondsAndNanos());
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (hours < 0L || minutes < 0 || seconds < 0) {
            b.append('-');
        }
        b.append(Math.abs(hours)).append(':');
        StringUtils.appendTwoDigits(b, Math.abs(minutes));
        b.append(':');
        StringUtils.appendTwoDigits(b, Math.abs(seconds));
        b.append("' HOUR TO SECOND");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfHoursMinutesSecondsBad(long hours, int minutes, int seconds) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofHoursMinutesSeconds(hours, minutes, seconds));
    }

    private void testOfMinutesSeconds() {
        this.testOfMinutesSecondsGood(0L, 0);
        this.testOfMinutesSecondsGood(0L, -2);
        this.testOfMinutesSecondsGood(100L, 5);
        this.testOfMinutesSecondsGood(-100L, -1);
        this.testOfMinutesSecondsGood(999999999999999999L, 59);
        this.testOfMinutesSecondsGood(-999999999999999999L, -59);
        this.testOfMinutesSecondsBad(0L, 60);
        this.testOfMinutesSecondsBad(0L, -60);
        this.testOfMinutesSecondsBad(1000000000000000000L, 0);
        this.testOfMinutesSecondsBad(-1000000000000000000L, 0);
        this.testOfMinutesSecondsBad(Long.MAX_VALUE, 0);
        this.testOfMinutesSecondsBad(Long.MIN_VALUE, 0);
        this.testOfMinutesSecondsBad(0L, Integer.MAX_VALUE);
        this.testOfMinutesSecondsBad(0L, Integer.MIN_VALUE);
    }

    private void testOfMinutesSecondsGood(long minutes, int seconds) {
        Interval i = Interval.ofMinutesSeconds(minutes, seconds);
        this.assertEquals(minutes, i.getMinutes());
        this.assertEquals((long)seconds, i.getSeconds());
        this.assertEquals(0L, i.getNanosOfSecond());
        this.assertEquals((long)seconds * 1000000000L, i.getSecondsAndNanos());
        StringBuilder b = new StringBuilder("INTERVAL '");
        if (minutes < 0L || seconds < 0) {
            b.append('-');
        }
        b.append(Math.abs(minutes)).append(':');
        StringUtils.appendTwoDigits(b, Math.abs(seconds));
        b.append("' MINUTE TO SECOND");
        this.assertEquals(b.toString(), i.toString());
    }

    private void testOfMinutesSecondsBad(long minutes, int seconds) {
        this.assertThrows(IllegalArgumentException.class, () -> Interval.ofMinutesSeconds(minutes, seconds));
    }

    private static void stripTrailingZeroes(StringBuilder b) {
        int i = b.length() - 1;
        if (b.charAt(i) == '0') {
            while (b.charAt(--i) == '0') {
            }
            b.setLength(i + 1);
        }
    }
}

