/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.h2.engine.Constants;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestJmx
extends TestDb {
    public static void main(String ... a) throws Exception {
        TestBase base = TestBase.createCaller().init();
        base.testFromMain();
    }

    @Override
    public void test() throws Exception {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Connection conn = this.getConnection("mem:jmx;jmx=true");
        Statement stat = conn.createStatement();
        ObjectName name = new ObjectName("org.h2:name=JMX,path=mem_jmx");
        MBeanInfo info = mbeanServer.getMBeanInfo(name);
        this.assertEquals("0", mbeanServer.getAttribute(name, "CacheSizeMax").toString());
        mbeanServer.setAttribute(name, new Attribute("CacheSizeMax", 1));
        this.assertEquals("0", mbeanServer.getAttribute(name, "CacheSizeMax").toString());
        this.assertEquals("0", mbeanServer.getAttribute(name, "CacheSize").toString());
        this.assertEquals("false", mbeanServer.getAttribute(name, "Exclusive").toString());
        this.assertEquals("0", mbeanServer.getAttribute(name, "FileSize").toString());
        this.assertEquals("0", mbeanServer.getAttribute(name, "FileReadCount").toString());
        this.assertEquals("0", mbeanServer.getAttribute(name, "FileWriteCount").toString());
        this.assertEquals("REGULAR", mbeanServer.getAttribute(name, "Mode").toString());
        this.assertEquals("false", mbeanServer.getAttribute(name, "ReadOnly").toString());
        this.assertEquals("1", mbeanServer.getAttribute(name, "TraceLevel").toString());
        mbeanServer.setAttribute(name, new Attribute("TraceLevel", 0));
        this.assertEquals("0", mbeanServer.getAttribute(name, "TraceLevel").toString());
        this.assertEquals(Constants.FULL_VERSION, mbeanServer.getAttribute(name, "Version").toString());
        this.assertEquals(10, info.getAttributes().length);
        String result = mbeanServer.invoke(name, "listSettings", null, null).toString();
        this.assertContains(result, "ANALYZE_AUTO");
        conn.setAutoCommit(false);
        stat.execute("create table test(id int)");
        stat.execute("insert into test values(1)");
        result = mbeanServer.invoke(name, "listSessions", null, null).toString();
        this.assertContains(result, "session id");
        this.assertContains(result, "read lock");
        this.assertEquals(2, info.getOperations().length);
        this.assertContains(info.getDescription(), "database");
        HashMap<String, MBeanAttributeInfo> attrMap = new HashMap<String, MBeanAttributeInfo>();
        MBeanFeatureInfo[] mBeanFeatureInfoArray = info.getAttributes();
        int n = mBeanFeatureInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanAttributeInfo a = mBeanFeatureInfoArray[n2];
            attrMap.put(a.getName(), a);
            ++n2;
        }
        this.assertContains(((MBeanAttributeInfo)attrMap.get("CacheSize")).getDescription(), "KB");
        HashMap<String, MBeanFeatureInfo> opMap = new HashMap<String, MBeanFeatureInfo>();
        mBeanFeatureInfoArray = info.getOperations();
        n = mBeanFeatureInfoArray.length;
        n2 = 0;
        while (n2 < n) {
            MBeanFeatureInfo o = mBeanFeatureInfoArray[n2];
            opMap.put(o.getName(), o);
            ++n2;
        }
        this.assertContains(((MBeanOperationInfo)opMap.get("listSessions")).getDescription(), "lock");
        this.assertEquals(0, ((MBeanOperationInfo)opMap.get("listSessions")).getImpact());
        conn.close();
        conn = this.getConnection("jmx;jmx=true");
        conn.close();
        conn = this.getConnection("jmx;jmx=true");
        name = new ObjectName("org.h2:name=JMX,*");
        Set<ObjectName> set = mbeanServer.queryNames(name, null);
        name = set.iterator().next();
        if (this.config.memory) {
            this.assertEquals("0", mbeanServer.getAttribute(name, "CacheSizeMax").toString());
        } else {
            this.assertEquals("16384", mbeanServer.getAttribute(name, "CacheSizeMax").toString());
        }
        mbeanServer.setAttribute(name, new Attribute("CacheSizeMax", 1));
        if (this.config.memory) {
            this.assertEquals("0", mbeanServer.getAttribute(name, "CacheSizeMax").toString());
        } else {
            this.assertEquals("1024", mbeanServer.getAttribute(name, "CacheSizeMax").toString());
            this.assertEquals("0", mbeanServer.getAttribute(name, "CacheSize").toString());
            this.assertTrue(0L < (Long)mbeanServer.getAttribute(name, "FileReadCount"));
            this.assertTrue(0L <= (Long)mbeanServer.getAttribute(name, "FileWriteCount"));
        }
        conn.close();
    }
}

