/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.h2.test.TestBase;
import org.h2.util.json.JSONByteArrayTarget;
import org.h2.util.json.JSONBytesSource;
import org.h2.util.json.JSONItemType;
import org.h2.util.json.JSONStringSource;
import org.h2.util.json.JSONStringTarget;
import org.h2.util.json.JSONTarget;
import org.h2.util.json.JSONValidationTargetWithUniqueKeys;
import org.h2.util.json.JSONValidationTargetWithoutUniqueKeys;
import org.h2.util.json.JSONValueTarget;

public class TestJsonUtils
extends TestBase {
    private static final Charset[] CHARSETS = new Charset[]{StandardCharsets.UTF_8, StandardCharsets.UTF_16BE, StandardCharsets.UTF_16LE, Charset.forName("UTF-32BE"), Charset.forName("UTF-32LE")};
    private static final Callable<JSONTarget<?>> STRING_TARGET = () -> new JSONStringTarget();
    private static final Callable<JSONTarget<?>> BYTES_TARGET = () -> new JSONByteArrayTarget();
    private static final Callable<JSONTarget<?>> VALUE_TARGET = () -> new JSONValueTarget();
    private static final Callable<JSONTarget<?>> JSON_VALIDATION_TARGET_WITHOUT_UNIQUE_KEYS = () -> new JSONValidationTargetWithoutUniqueKeys();
    private static final Callable<JSONTarget<?>> JSON_VALIDATION_TARGET_WITH_UNIQUE_KEYS = () -> new JSONValidationTargetWithUniqueKeys();

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testTargetErrorDetection();
        this.testSourcesAndTargets();
        this.testUtfError();
        this.testLongNesting();
        this.testEncodeString();
    }

    private void testTargetErrorDetection() throws Exception {
        this.testTargetErrorDetection(STRING_TARGET);
        this.testTargetErrorDetection(BYTES_TARGET);
        this.testTargetErrorDetection(VALUE_TARGET);
        this.testTargetErrorDetection(JSON_VALIDATION_TARGET_WITHOUT_UNIQUE_KEYS);
        this.testTargetErrorDetection(JSON_VALIDATION_TARGET_WITH_UNIQUE_KEYS);
    }

    private void testTargetErrorDetection(Callable<JSONTarget<?>> constructor) throws Exception {
        this.assertThrows(RuntimeException.class, () -> ((JSONTarget)constructor.call()).endObject());
        this.assertThrows(RuntimeException.class, () -> ((JSONTarget)constructor.call()).endArray());
        this.assertThrows(RuntimeException.class, () -> ((JSONTarget)constructor.call()).member("1"));
        JSONTarget<?> target1 = constructor.call();
        target1.startArray();
        this.assertThrows(RuntimeException.class, () -> target1.member("1"));
        JSONTarget<?> target2 = constructor.call();
        target2.startObject();
        target2.member("1");
        this.assertThrows(RuntimeException.class, () -> target2.member("2"));
        JSONTarget<?> target3 = constructor.call();
        target3.startObject();
        target3.member("1");
        this.assertThrows(RuntimeException.class, () -> target3.endObject());
        this.testJsonStringTargetErrorDetectionAllValues(() -> {
            JSONTarget target = (JSONTarget)constructor.call();
            target.startObject();
            return target;
        });
        this.testJsonStringTargetErrorDetectionAllValues(() -> {
            JSONTarget target = (JSONTarget)constructor.call();
            target.valueNull();
            return target;
        });
        this.assertIncomplete(constructor.call());
        JSONTarget<?> target = constructor.call();
        target.startObject();
        this.assertIncomplete(target);
        target = constructor.call();
        target.startObject();
        this.assertIncomplete(target);
        JSONTarget<?> target6 = constructor.call();
        target6.startObject();
        this.assertThrows(RuntimeException.class, () -> target6.endArray());
        JSONTarget<?> target7 = constructor.call();
        target7.startArray();
        this.assertThrows(RuntimeException.class, () -> target7.endObject());
    }

    private void assertIncomplete(JSONTarget<?> target) {
        this.assertThrows(RuntimeException.class, () -> target.getResult());
    }

    private void testJsonStringTargetErrorDetectionAllValues(Callable<JSONTarget<?>> initializer) throws Exception {
        this.assertThrows(RuntimeException.class, () -> ((JSONTarget)initializer.call()).valueNull());
        this.assertThrows(RuntimeException.class, () -> ((JSONTarget)initializer.call()).valueFalse());
        this.assertThrows(RuntimeException.class, () -> ((JSONTarget)initializer.call()).valueTrue());
        this.assertThrows(RuntimeException.class, () -> ((JSONTarget)initializer.call()).valueNumber(BigDecimal.ONE));
        this.assertThrows(RuntimeException.class, () -> ((JSONTarget)initializer.call()).valueString("string"));
    }

    private void testSourcesAndTargets() throws Exception {
        this.testSourcesAndTargets("1", "1");
        this.testSourcesAndTargets("\ufeff0", "0");
        this.testSourcesAndTargets("\ufeff-1", "-1");
        this.testSourcesAndTargets("null", "null");
        this.testSourcesAndTargets("true", "true");
        this.testSourcesAndTargets("false", "false");
        this.testSourcesAndTargets("1.2", "1.2");
        this.testSourcesAndTargets("1.2e+1", "12");
        this.testSourcesAndTargets("10000.0", "10000.0");
        this.testSourcesAndTargets("\t\r\n 1.2E-1 ", "0.12");
        this.testSourcesAndTargets("9.99e99", "9.99E99");
        this.testSourcesAndTargets("\"\"", "\"\"");
        this.testSourcesAndTargets("\"\\b\\f\\t\\r\\n\\\"\\/\\\\\\u0019\\u0020\"", "\"\\b\\f\\t\\r\\n\\\"/\\\\\\u0019 \"");
        this.testSourcesAndTargets("{ }", "{}");
        this.testSourcesAndTargets("{\"a\" : 1}", "{\"a\":1}");
        this.testSourcesAndTargets("{\"a\" : 1, \"b\":[], \"c\":{}}", "{\"a\":1,\"b\":[],\"c\":{}}");
        this.testSourcesAndTargets("{\"a\" : 1, \"b\":[1,null, true,false,{}]}", "{\"a\":1,\"b\":[1,null,true,false,{}]}");
        this.testSourcesAndTargets("{\"1\" : [[[[[[[[[[11.1e-100]]]], null]]], {\n\r}]]]}", "{\"1\":[[[[[[[[[[1.11E-99]]]],null]]],{}]]]}");
        this.testSourcesAndTargets("{\"b\":false,\"a\":1,\"a\":null}", "{\"b\":false,\"a\":1,\"a\":null}", true);
        this.testSourcesAndTargets("[[{\"b\":false,\"a\":1,\"a\":null}]]", "[[{\"b\":false,\"a\":1,\"a\":null}]]", true);
        this.testSourcesAndTargets("\"\ud800\udfff\"", "\"\ud800\udfff\"");
        this.testSourcesAndTargets("\"\\uD800\\uDFFF\"", "\"\ud800\udfff\"");
        this.testSourcesAndTargets("\"\u0700\"", "\"\u0700\"");
        this.testSourcesAndTargets("\"\\u0700\"", "\"\u0700\"");
        StringBuilder builder = new StringBuilder().append('\"');
        int cp = 128;
        while (cp < 55296) {
            builder.appendCodePoint(cp);
            ++cp;
        }
        cp = 57344;
        while (cp < 65534) {
            builder.appendCodePoint(cp);
            ++cp;
        }
        cp = 65535;
        while (cp <= 0x10FFFF) {
            builder.appendCodePoint(cp);
            ++cp;
        }
        String s = builder.append('\"').toString();
        this.testSourcesAndTargets(s, s);
        this.testSourcesAndTargetsError("", true);
        this.testSourcesAndTargetsError("\"", true);
        this.testSourcesAndTargetsError("\"\\u", true);
        this.testSourcesAndTargetsError("\u0080", true);
        this.testSourcesAndTargetsError(".1", true);
        this.testSourcesAndTargetsError("1.", true);
        this.testSourcesAndTargetsError("1.1e", true);
        this.testSourcesAndTargetsError("1.1e+", true);
        this.testSourcesAndTargetsError("1.1e-", true);
        this.testSourcesAndTargetsError("\b1", true);
        this.testSourcesAndTargetsError("\"\\u", true);
        this.testSourcesAndTargetsError("\"\\u0", true);
        this.testSourcesAndTargetsError("\"\\u00", true);
        this.testSourcesAndTargetsError("\"\\u000", true);
        this.testSourcesAndTargetsError("\"\\u0000", true);
        this.testSourcesAndTargetsError("{,}", true);
        this.testSourcesAndTargetsError("{,,}", true);
        this.testSourcesAndTargetsError("{}}", true);
        this.testSourcesAndTargetsError("{\"a\":\"\":\"\"}", true);
        this.testSourcesAndTargetsError("[]]", true);
        this.testSourcesAndTargetsError("\"\\uZZZZ\"", true);
        this.testSourcesAndTargetsError("\"\\x\"", true);
        this.testSourcesAndTargetsError("\"\\", true);
        this.testSourcesAndTargetsError("[1,", true);
        this.testSourcesAndTargetsError("[1,,2]", true);
        this.testSourcesAndTargetsError("[1,]", true);
        this.testSourcesAndTargetsError("{\"a\":1,]", true);
        this.testSourcesAndTargetsError("[1 2]", true);
        this.testSourcesAndTargetsError("{\"a\"-1}", true);
        this.testSourcesAndTargetsError("[1;2]", true);
        this.testSourcesAndTargetsError("{\"a\":1,b:2}", true);
        this.testSourcesAndTargetsError("{\"a\":1;\"b\":2}", true);
        this.testSourcesAndTargetsError("fals", true);
        this.testSourcesAndTargetsError("falsE", true);
        this.testSourcesAndTargetsError("False", true);
        this.testSourcesAndTargetsError("nul", true);
        this.testSourcesAndTargetsError("nulL", true);
        this.testSourcesAndTargetsError("Null", true);
        this.testSourcesAndTargetsError("tru", true);
        this.testSourcesAndTargetsError("truE", true);
        this.testSourcesAndTargetsError("True", true);
        this.testSourcesAndTargetsError("\"\ud800\"", false);
        this.testSourcesAndTargetsError("\"\\uD800\"", true);
        this.testSourcesAndTargetsError("\"\udc00\"", false);
        this.testSourcesAndTargetsError("\"\\uDC00\"", true);
        this.testSourcesAndTargetsError("\"\udbff \"", false);
        this.testSourcesAndTargetsError("\"\\uDBFF \"", true);
        this.testSourcesAndTargetsError("\"\udbff\\\"", true);
        this.testSourcesAndTargetsError("\"\\uDBFF\\\"", true);
        this.testSourcesAndTargetsError("\"\udfff\ud800\"", false);
        this.testSourcesAndTargetsError("\"\\uDFFF\\uD800\"", true);
    }

    private void testSourcesAndTargets(String src, String expected) throws Exception {
        this.testSourcesAndTargets(src, expected, false);
    }

    private void testSourcesAndTargets(String src, String expected, boolean hasNonUniqueKeys) throws Exception {
        JSONItemType itemType;
        switch (expected.charAt(0)) {
            case '[': {
                itemType = JSONItemType.ARRAY;
                break;
            }
            case '{': {
                itemType = JSONItemType.OBJECT;
                break;
            }
            default: {
                itemType = JSONItemType.SCALAR;
            }
        }
        this.assertEquals(expected, JSONStringSource.parse(src, new JSONStringTarget()));
        this.assertEquals(expected.getBytes(StandardCharsets.UTF_8), JSONStringSource.parse(src, new JSONByteArrayTarget()));
        this.assertEquals(expected, JSONStringSource.parse(src, new JSONValueTarget()).toString());
        this.assertEquals((Object)itemType, (Object)JSONStringSource.parse(src, new JSONValidationTargetWithoutUniqueKeys()));
        if (hasNonUniqueKeys) {
            this.testSourcesAndTargetsError(src, JSON_VALIDATION_TARGET_WITH_UNIQUE_KEYS, true);
        } else {
            this.assertEquals((Object)itemType, (Object)JSONStringSource.parse(src, new JSONValidationTargetWithUniqueKeys()));
        }
        Charset[] charsetArray = CHARSETS;
        int n = CHARSETS.length;
        int n2 = 0;
        while (n2 < n) {
            Charset charset = charsetArray[n2];
            this.assertEquals(expected, JSONBytesSource.parse(src.getBytes(charset), new JSONStringTarget()));
            ++n2;
        }
    }

    private void testSourcesAndTargetsError(String src, boolean testBytes) throws Exception {
        this.testSourcesAndTargetsError(src, STRING_TARGET, testBytes);
        this.testSourcesAndTargetsError(src, BYTES_TARGET, testBytes);
        this.testSourcesAndTargetsError(src, VALUE_TARGET, testBytes);
        this.testSourcesAndTargetsError(src, JSON_VALIDATION_TARGET_WITHOUT_UNIQUE_KEYS, testBytes);
        this.testSourcesAndTargetsError(src, JSON_VALIDATION_TARGET_WITH_UNIQUE_KEYS, testBytes);
    }

    private void testSourcesAndTargetsError(String src, Callable<JSONTarget<?>> constructor, boolean testBytes) throws Exception {
        JSONTarget<?> target;
        block5: {
            target = constructor.call();
            try {
                JSONStringSource.parse(src, target);
            }
            catch (IllegalArgumentException | IllegalStateException expected) {
                break block5;
            }
            this.fail();
        }
        if (testBytes) {
            target = constructor.call();
            try {
                JSONBytesSource.parse(src.getBytes(StandardCharsets.UTF_8), target);
            }
            catch (IllegalArgumentException | IllegalStateException expected) {
                return;
            }
            this.fail();
        }
    }

    private void testUtfError() {
        this.testUtfError(new byte[]{34, -62, -64, 34});
        this.testUtfError(new byte[]{34, -63, -65, 34});
        this.testUtfError(new byte[]{34, -62});
        this.testUtfError(new byte[]{34, -31, -64, -128, 34});
        this.testUtfError(new byte[]{34, -31, -128, -64, 34});
        this.testUtfError(new byte[]{34, -32, -97, -65, 34});
        this.testUtfError(new byte[]{34, -31, -128});
        this.testUtfError(new byte[]{34, -15, -64, -128, -128, 34});
        this.testUtfError(new byte[]{34, -15, -128, -64, -128, 34});
        this.testUtfError(new byte[]{34, -15, -128, -128, -64, 34});
        this.testUtfError(new byte[]{34, -16, -113, -65, -65, 34});
        this.testUtfError(new byte[]{34, -12, -112, -128, -128, 34});
        this.testUtfError(new byte[]{34, -15, -128, -128});
    }

    private void testUtfError(byte[] bytes) {
        this.assertThrows(IllegalArgumentException.class, () -> JSONBytesSource.parse(bytes, new JSONValidationTargetWithoutUniqueKeys()));
    }

    private void testLongNesting() {
        int halfLevel = 2048;
        StringBuilder builder = new StringBuilder(16384);
        int i = 0;
        while (i < 2048) {
            builder.append("{\"a\":[");
            ++i;
        }
        i = 0;
        while (i < 2048) {
            builder.append("]}");
            ++i;
        }
        String string = builder.toString();
        this.assertEquals(string, JSONStringSource.parse(string, new JSONStringTarget()));
        byte[] bytes = string.getBytes(StandardCharsets.ISO_8859_1);
        this.assertEquals(bytes, JSONBytesSource.normalize(bytes));
    }

    private void testEncodeString() {
        this.testEncodeString("abc \"\u0001\u007f\u0080\u1000\uabcd\n'\t", "\"abc \\\"\\u0001\u007f\u0080\u1000\uabcd\\n'\\t\"", "\"abc \\\"\\u0001\u007f\\u0080\\u1000\\uabcd\\n\\u0027\\t\"");
    }

    private void testEncodeString(String source, String expected, String expectedPrintable) {
        this.assertEquals(expected, JSONStringTarget.encodeString(new StringBuilder(), source, false).toString());
        this.assertEquals(expectedPrintable, JSONStringTarget.encodeString(new StringBuilder(), source, true).toString());
    }
}

