/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.test.TestBase;
import org.h2.util.MathUtils;

public class TestMathUtils
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() {
        this.testRandom();
        this.testNextPowerOf2Int();
    }

    private void testRandom() {
        int bits = 0;
        int i = 0;
        while (i < 1000) {
            bits |= 1 << MathUtils.randomInt(8);
            ++i;
        }
        this.assertEquals(255, bits);
        bits = 0;
        i = 0;
        while (i < 1000) {
            bits |= 1 << MathUtils.secureRandomInt(8);
            ++i;
        }
        this.assertEquals(255, bits);
        bits = 0;
        i = 0;
        while (i < 1000) {
            bits |= 1 << (int)(MathUtils.secureRandomLong() & 7L);
            ++i;
        }
        this.assertEquals(255, bits);
        byte[] data = MathUtils.generateAlternativeSeed();
        this.assertTrue(data.length > 10);
    }

    private void testNextPowerOf2Int() {
        int largestPower2 = 0x40000000;
        int[] nArray = new int[11];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 12;
        nArray[6] = 17;
        nArray[7] = 500;
        nArray[8] = 1023;
        nArray[9] = 1073741324;
        nArray[10] = 0x40000000;
        int[] testValues = nArray;
        int[] resultValues = new int[]{1, 1, 2, 4, 4, 16, 32, 512, 1024, 0x40000000, 0x40000000};
        int i = 0;
        while (i < testValues.length) {
            this.assertEquals(resultValues[i], MathUtils.nextPowerOf2(testValues[i]));
            ++i;
        }
        int[] nArray2 = testValues = new int[]{Integer.MIN_VALUE, -1, 0x40000001, Integer.MAX_VALUE};
        int n = testValues.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray2[n2];
            this.assertThrows(IllegalArgumentException.class, () -> MathUtils.nextPowerOf2(v));
            ++n2;
        }
    }
}

