/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.nio.ByteBuffer;
import org.h2.test.TestBase;
import org.h2.util.MemoryUnmapper;

public class TestMemoryUnmapper
extends TestBase {
    private static final int OK = 0;
    private static final int UNAVAILABLE = 2;

    public static void main(String ... a) throws Exception {
        if (a.length == 0) {
            TestBase.createCaller().init().testFromMain();
        } else {
            ByteBuffer buffer = ByteBuffer.allocateDirect(10);
            System.exit(MemoryUnmapper.unmap(buffer) ? 0 : 2);
        }
    }

    @Override
    public void test() throws Exception {
        ProcessBuilder pb = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.command(TestMemoryUnmapper.getJVM(), "-cp", this.getClassPath(), "-ea", this.getClass().getName(), "dummy");
        this.assertEquals(2, pb.start().waitFor());
        pb.command(TestMemoryUnmapper.getJVM(), "-cp", this.getClassPath(), "-ea", "-Dh2.nioCleanerHack=true", this.getClass().getName(), "dummy");
        this.assertEquals(0, pb.start().waitFor());
        pb.command(TestMemoryUnmapper.getJVM(), "-cp", this.getClassPath(), "-ea", "-Djava.security.manager", "-Dh2.nioCleanerHack=true", this.getClass().getName(), "dummy");
        this.assertEquals(2, pb.start().waitFor());
    }
}

