/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import org.h2.engine.Mode;
import org.h2.test.TestBase;

public class TestMode
extends TestBase {
    public static void main(String[] a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        this.testDb2ClientInfo();
        this.testDerbyClientInfo();
        this.testHsqlDbClientInfo();
        this.testMsSqlServerClientInfo();
        this.testMySqlClientInfo();
        this.testOracleClientInfo();
        this.testPostgresqlClientInfo();
    }

    private void testDb2ClientInfo() {
        Mode db2Mode = Mode.getInstance("DB2");
        this.assertTrue(db2Mode.supportedClientInfoPropertiesRegEx.matcher("ApplicationName").matches());
        this.assertTrue(db2Mode.supportedClientInfoPropertiesRegEx.matcher("ClientAccountingInformation").matches());
        this.assertTrue(db2Mode.supportedClientInfoPropertiesRegEx.matcher("ClientUser").matches());
        this.assertTrue(db2Mode.supportedClientInfoPropertiesRegEx.matcher("ClientCorrelationToken").matches());
        this.assertFalse(db2Mode.supportedClientInfoPropertiesRegEx.matcher("AnyOtherValue").matches());
    }

    private void testDerbyClientInfo() {
        Mode derbyMode = Mode.getInstance("Derby");
        this.assertNull(derbyMode.supportedClientInfoPropertiesRegEx);
    }

    private void testHsqlDbClientInfo() {
        Mode hsqlMode = Mode.getInstance("HSQLDB");
        this.assertNull(hsqlMode.supportedClientInfoPropertiesRegEx);
    }

    private void testMsSqlServerClientInfo() {
        Mode msSqlMode = Mode.getInstance("MSSQLServer");
        this.assertNull(msSqlMode.supportedClientInfoPropertiesRegEx);
    }

    private void testMySqlClientInfo() {
        Mode mySqlMode = Mode.getInstance("MySQL");
        this.assertTrue(mySqlMode.supportedClientInfoPropertiesRegEx.matcher("AnyString").matches());
    }

    private void testOracleClientInfo() {
        Mode oracleMode = Mode.getInstance("Oracle");
        this.assertTrue(oracleMode.supportedClientInfoPropertiesRegEx.matcher("anythingContaining.aDot").matches());
        this.assertFalse(oracleMode.supportedClientInfoPropertiesRegEx.matcher("anythingContainingNoDot").matches());
    }

    private void testPostgresqlClientInfo() {
        Mode postgresqlMode = Mode.getInstance("PostgreSQL");
        this.assertTrue(postgresqlMode.supportedClientInfoPropertiesRegEx.matcher("ApplicationName").matches());
        this.assertFalse(postgresqlMode.supportedClientInfoPropertiesRegEx.matcher("AnyOtherValue").matches());
    }
}

