/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.Driver;
import org.h2.test.TestBase;
import org.h2.test.TestDb;

public class TestMultiThreadedKernel
extends TestDb
implements Runnable {
    private String url;
    private String user;
    private String password;
    private int id;
    private TestMultiThreadedKernel master;
    private volatile boolean stop;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return !this.config.networked;
    }

    @Override
    public void test() throws Exception {
        this.deleteDb("multiThreadedKernel");
        int count = this.getSize(2, 5);
        Thread[] list = new Thread[count];
        int i = 0;
        while (i < count) {
            TestMultiThreadedKernel r = new TestMultiThreadedKernel();
            r.url = this.getURL("multiThreadedKernel", true);
            r.user = this.getUser();
            r.password = this.getPassword();
            r.master = this;
            r.id = i;
            Thread thread = new Thread(r);
            thread.setName("Thread " + i);
            thread.start();
            list[i] = thread;
            ++i;
        }
        Thread.sleep(this.getSize(2000, 5000));
        this.stop = true;
        i = 0;
        while (i < count) {
            list[i].join();
            ++i;
        }
        this.deleteDb("multiThreadedKernel");
    }

    @Override
    public void run() {
        try {
            Driver.load();
            Connection conn = DriverManager.getConnection(this.url + ";LOCK_MODE=3;WRITE_DELAY=0", this.user, this.password);
            conn.createStatement().execute("CREATE TABLE TEST" + this.id + "(COL1 BIGINT AUTO_INCREMENT PRIMARY KEY, COL2 BIGINT)");
            PreparedStatement prep = conn.prepareStatement("insert into TEST" + this.id + "(col2) values (?)");
            int i = 0;
            while (!this.master.stop) {
                prep.setLong(1, i);
                prep.execute();
                ++i;
            }
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

