/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.h2.build.BuildBase;
import org.h2.test.TestBase;
import org.h2.util.NetUtils;
import org.h2.util.Task;
import org.h2.util.Utils10;

public class TestNetUtils
extends TestBase {
    private static final int WORKER_COUNT = 10;
    private static final int PORT = 9111;

    public static void main(String ... a) throws Exception {
        TestBase.createCaller().init().testFromMain();
    }

    @Override
    public void test() throws Exception {
        TestNetUtils.testFrequentConnections(true, 100);
        TestNetUtils.testFrequentConnections(false, 1000);
        this.testIpToShortForm();
        this.testTcpQuickack();
    }

    private static void testFrequentConnections(boolean ssl, int count) throws Exception {
        final ServerSocket serverSocket = NetUtils.createServerSocket(9111, ssl);
        AtomicInteger counter = new AtomicInteger(count);
        Task serverThread = new Task(){

            @Override
            public void call() {
                while (!this.stop) {
                    try {
                        Socket socket = serverSocket.accept();
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        serverThread.execute();
        try {
            HashSet<ConnectWorker> workers = new HashSet<ConnectWorker>();
            int i = 0;
            while (i < 10) {
                workers.add(new ConnectWorker(ssl, counter));
                ++i;
            }
            Thread.sleep(100L);
            for (ConnectWorker worker : workers) {
                worker.start();
            }
            for (ConnectWorker worker : workers) {
                worker.join();
                Exception e = worker.getException();
                if (e == null) continue;
                e.printStackTrace();
            }
        }
        finally {
            try {
                serverSocket.close();
            }
            catch (Exception exception) {}
            serverThread.get();
        }
    }

    private void testIpToShortForm() throws Exception {
        this.testIpToShortForm("1.2.3.4", "1.2.3.4");
        this.testIpToShortForm("1:2:3:4:a:b:c:d", "1:2:3:4:a:b:c:d");
        this.testIpToShortForm("::1", "::1");
        this.testIpToShortForm("1::", "1::");
        this.testIpToShortForm("c1c1:0:0:2::fffe", "c1c1:0:0:2:0:0:0:fffe");
    }

    private void testIpToShortForm(String expected, String source) throws Exception {
        byte[] addr = InetAddress.getByName(source).getAddress();
        this.testIpToShortForm((String)expected, addr, false);
        if (((String)expected).indexOf(58) >= 0) {
            expected = "[" + (String)expected + "]";
        }
        this.testIpToShortForm((String)expected, addr, true);
    }

    private void testIpToShortForm(String expected, byte[] addr, boolean addBrackets) {
        this.assertEquals(expected, NetUtils.ipToShortForm(null, addr, addBrackets).toString());
        this.assertEquals(expected, NetUtils.ipToShortForm(new StringBuilder(), addr, addBrackets).toString());
        this.assertEquals(expected, NetUtils.ipToShortForm(new StringBuilder("*"), addr, addBrackets).deleteCharAt(0).toString());
    }

    private void testTcpQuickack() {
        final boolean ssl = !this.config.ci && BuildBase.getJavaVersion() < 11;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ServerSocket serverSocket = NetUtils.createServerSocket(9111, ssl);){
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Throwable throwable = null;
                            Object var2_4 = null;
                            try (Socket s = NetUtils.createLoopbackSocket(9111, ssl);){
                                s.getInputStream().read();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                thread.start();
                try {
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (Socket socket = serverSocket.accept();){
                        boolean supported = Utils10.setTcpQuickack(socket, true);
                        if (supported) {
                            this.assertTrue(Utils10.getTcpQuickack(socket));
                            Utils10.setTcpQuickack(socket, false);
                            this.assertFalse(Utils10.getTcpQuickack(socket));
                        }
                        socket.getOutputStream().write(1);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                finally {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class ConnectWorker
    extends Thread {
        private final boolean ssl;
        private final AtomicInteger counter;
        private Exception exception;

        ConnectWorker(boolean ssl, AtomicInteger counter) {
            this.ssl = ssl;
            this.counter = counter;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    if (this.counter.decrementAndGet() <= 0) {
                        return;
                    }
                    Socket socket = NetUtils.createLoopbackSocket(9111, this.ssl);
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (Exception e) {
                this.exception = new Exception("count: " + String.valueOf(this.counter), e);
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

