/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.h2.dev.hash.MinimalPerfectHash;
import org.h2.dev.hash.PerfectHash;
import org.h2.test.TestBase;

public class TestPerfectHash
extends TestBase {
    public static void main(String ... a) throws Exception {
        TestPerfectHash test = (TestPerfectHash)TestBase.createCaller().init();
        test.measure();
        TestPerfectHash.largeFile();
        test.test();
        test.measure();
    }

    private static void largeFile() throws IOException {
        TestPerfectHash.largeFile("sequence.txt");
        int i = 1;
        while (i <= 4) {
            TestPerfectHash.largeFile("unique" + i + ".txt");
            ++i;
        }
        TestPerfectHash.largeFile("enwiki-20140811-all-titles.txt");
    }

    private static void largeFile(String s) throws IOException {
        String fileName = System.getProperty("user.home") + "/temp/" + s;
        if (!new File(fileName).exists()) {
            System.out.println("not found: " + fileName);
            return;
        }
        RandomAccessFile f = new RandomAccessFile(fileName, "r");
        byte[] data = new byte[(int)f.length()];
        f.readFully(data);
        MinimalPerfectHash.UniversalHash<Text> hf = Text::hashCode;
        f.close();
        HashSet<Text> set = new HashSet<Text>();
        Text t = new Text(data, 0);
        while (true) {
            set.add(t);
            int end = t.getEnd();
            if (end >= data.length - 1) break;
            t = new Text(data, end + 1);
            if (set.size() % 1000000 != 0) continue;
            System.out.println("size: " + set.size());
        }
        System.out.println("file: " + s);
        System.out.println("size: " + set.size());
        long time = System.nanoTime();
        byte[] desc = MinimalPerfectHash.generate(set, hf);
        time = System.nanoTime() - time;
        System.out.println("millis: " + TimeUnit.NANOSECONDS.toMillis(time));
        System.out.println("len: " + desc.length);
        int bits = desc.length * 8;
        System.out.println((double)bits / (double)set.size() + " bits/key");
    }

    public void measure() {
        int size = 1000000;
        this.testMinimal(size / 10);
        long time = System.nanoTime();
        int s = this.testMinimal(size);
        time = System.nanoTime() - time;
        System.out.println((double)s / (double)size + " bits/key (minimal) in " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
        time = System.nanoTime();
        s = this.testMinimalWithString(size);
        time = System.nanoTime() - time;
        System.out.println((double)s / (double)size + " bits/key (minimal; String keys) in " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
        time = System.nanoTime();
        s = this.test(size, true);
        time = System.nanoTime() - time;
        System.out.println((double)s / (double)size + " bits/key (minimal old) in " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
        time = System.nanoTime();
        s = this.test(size, false);
        time = System.nanoTime() - time;
        System.out.println((double)s / (double)size + " bits/key (not minimal) in " + TimeUnit.NANOSECONDS.toMillis(time) + " ms");
    }

    @Override
    public void test() {
        this.testBrokenHashFunction();
        int i = 0;
        while (i < 100) {
            this.testMinimal(i);
            ++i;
        }
        i = 100;
        while (i <= 100000) {
            this.testMinimal(i);
            i *= 10;
        }
        i = 0;
        while (i < 100) {
            this.test(i, true);
            this.test(i, false);
            ++i;
        }
        i = 100;
        while (i <= 100000) {
            this.test(i, true);
            this.test(i, false);
            i *= 10;
        }
    }

    private void testBrokenHashFunction() {
        int size = 10000;
        Random r = new Random(10000L);
        HashSet<CallSite> set = new HashSet<CallSite>(size);
        while (set.size() < size) {
            set.add((CallSite)((Object)("x " + r.nextDouble())));
        }
        int test = 1;
        while (test < 10) {
            int badUntilLevel = test++;
            MinimalPerfectHash.UniversalHash<String> badHash = (o, index, seed) -> {
                if (index < badUntilLevel) {
                    return 0;
                }
                return MinimalPerfectHash.StringHash.getFastHash(o, index, seed);
            };
            byte[] desc = MinimalPerfectHash.generate(set, badHash);
            this.testMinimal(desc, set, badHash);
        }
    }

    private int test(int size, boolean minimal) {
        Random r = new Random(size);
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < size) {
            set.add(r.nextInt());
        }
        byte[] desc = PerfectHash.generate(set, minimal);
        int max = this.test(desc, set);
        if (minimal) {
            this.assertEquals(size - 1, max);
        } else if (size > 10) {
            this.assertTrue((double)max < 1.5 * (double)size);
        }
        return desc.length * 8;
    }

    private int test(byte[] desc, Set<Integer> set) {
        int max = -1;
        HashSet<Integer> test = new HashSet<Integer>();
        PerfectHash hash = new PerfectHash(desc);
        for (int x : set) {
            int h = hash.get(x);
            this.assertTrue(h >= 0);
            this.assertTrue(h <= set.size() * 3);
            max = Math.max(max, h);
            this.assertFalse(test.contains(h));
            test.add(h);
        }
        return max;
    }

    private int testMinimal(int size) {
        Random r = new Random(size);
        HashSet<Long> set = new HashSet<Long>(size);
        while (set.size() < size) {
            set.add(Long.valueOf(r.nextInt()));
        }
        MinimalPerfectHash.LongHash hf = new MinimalPerfectHash.LongHash();
        byte[] desc = MinimalPerfectHash.generate(set, hf);
        int max = this.testMinimal(desc, set, hf);
        this.assertEquals(size - 1, max);
        return desc.length * 8;
    }

    private int testMinimalWithString(int size) {
        Random r = new Random(size);
        HashSet<CallSite> set = new HashSet<CallSite>(size);
        while (set.size() < size) {
            set.add((CallSite)((Object)("x " + r.nextDouble())));
        }
        MinimalPerfectHash.StringHash hf = new MinimalPerfectHash.StringHash();
        byte[] desc = MinimalPerfectHash.generate(set, hf);
        int max = this.testMinimal(desc, set, hf);
        this.assertEquals(size - 1, max);
        return desc.length * 8;
    }

    private <K> int testMinimal(byte[] desc, Set<K> set, MinimalPerfectHash.UniversalHash<K> hf) {
        int max = -1;
        BitSet test = new BitSet();
        MinimalPerfectHash<K> hash = new MinimalPerfectHash<K>(desc, hf);
        for (K x : set) {
            int h = hash.get(x);
            this.assertTrue(h >= 0);
            this.assertTrue(h <= set.size() * 3);
            max = Math.max(max, h);
            this.assertFalse(test.get(h));
            test.set(h);
        }
        return max;
    }

    static class Text {
        final byte[] data;
        final int start;

        Text(byte[] data, int start) {
            this.data = data;
            this.start = start;
        }

        public int hashCode(int index, int seed) {
            if (index < 8) {
                int c;
                int x = index * 40763 ^ seed;
                int result = seed;
                int p = this.start;
                while ((c = this.data[p++] & 0xFF) != 10) {
                    x = 31 + x * 40763;
                    result ^= x * (1 + c);
                }
                return result;
            }
            int end = this.getEnd();
            return MinimalPerfectHash.StringHash.getSipHash24(this.data, this.start, end, index, seed);
        }

        int getEnd() {
            int end = this.start;
            while (this.data[end] != 10) {
                ++end;
            }
            return end;
        }

        public int hashCode() {
            return this.hashCode(0, 0);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Text)) {
                return false;
            }
            Text o = (Text)other;
            int end = this.getEnd();
            int s2 = o.start;
            int e2 = o.getEnd();
            if (e2 - s2 != end - this.start) {
                return false;
            }
            int s1 = this.start;
            while (s1 < end) {
                if (this.data[s1] != o.data[s2]) {
                    return false;
                }
                ++s1;
                ++s2;
            }
            return true;
        }

        public String toString() {
            return new String(this.data, this.start, this.getEnd() - this.start);
        }
    }
}

