/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.h2.test.TestBase;
import org.h2.test.TestDb;
import org.h2.tools.Server;
import org.h2.util.DateTimeUtils;

public class TestPgServer
extends TestDb {
    private static Set<Integer> supportedBinaryOids;

    static {
        try {
            supportedBinaryOids = TestPgServer.getSupportedBinaryOids();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String ... a) throws Exception {
        TestBase test = TestBase.createCaller().init();
        test.config.memory = true;
        test.testFromMain();
    }

    @Override
    public boolean isEnabled() {
        return this.config.memory;
    }

    @Override
    public void test() throws Exception {
        this.testPgAdapter();
        this.testKeyAlias();
        this.testCancelQuery();
        this.testTextualAndBinaryTypes();
        this.testBinaryNumeric();
        this.testDateTime();
        this.testPrepareWithUnspecifiedType();
        this.testOtherPgClients();
        this.testArray();
    }

    private boolean getPgJdbcDriver() {
        try {
            Class.forName("org.postgresql.Driver");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.println("PostgreSQL JDBC driver not found - PgServer not tested");
            return false;
        }
    }

    private Server createPgServer(String ... args) throws SQLException {
        Server server = Server.createPgServer(args);
        int failures = 0;
        while (true) {
            try {
                server.start();
                return server;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != 90061 || ++failures > 10) {
                    throw e;
                }
                this.println("Sleeping");
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    private void testPgAdapter() throws SQLException {
        this.deleteDb("pgserver");
        Server server = Server.createPgServer("-ifNotExists", "-baseDir", this.getBaseDir(), "-pgPort", "5535", "-pgDaemon");
        this.assertEquals(5535, server.getPort());
        this.assertEquals("Not started", server.getStatus());
        server.start();
        this.assertStartsWith(server.getStatus(), "PG server running at pg://");
        try {
            if (this.getPgJdbcDriver()) {
                this.testPgClient();
                this.testPgClientSimple();
            }
        }
        finally {
            server.stop();
        }
    }

    private void testCancelQuery() throws Exception {
        if (!this.getPgJdbcDriver()) {
            return;
        }
        Server server = this.createPgServer("-ifNotExists", "-pgPort", "5535", "-pgDaemon", "-key", "pgserver", "mem:pgserver");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", "sa", "sa");
            Statement stat = conn.createStatement();
            stat.execute("create alias sleep for 'java.lang.Thread.sleep(long)'");
            stat.execute("create table test(id int)");
            int i = 0;
            while (i < 200) {
                stat.execute("insert into test (id) values (rand())");
                ++i;
            }
            Future<Boolean> future = executor.submit(() -> stat.execute("select id, sleep(5) from test"));
            Thread.sleep(100L);
            stat.cancel();
            try {
                try {
                    future.get();
                    throw new IllegalStateException();
                }
                catch (ExecutionException e) {
                    this.assertStartsWith(e.getCause().getMessage(), "ERROR: canceling statement due to user request");
                    conn.close();
                }
            }
            catch (Throwable throwable) {
                conn.close();
                throw throwable;
            }
        }
        finally {
            server.stop();
            executor.shutdown();
        }
        this.deleteDb("pgserver");
    }

    private void testPgClient() throws SQLException {
        int indexId;
        int userId;
        ResultSet rs22;
        Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", "sa", "sa");
        Statement stat = conn.createStatement();
        this.assertThrows(SQLException.class, stat).execute("select ***");
        stat.execute("create user test password 'test'");
        stat.execute("create table test(id int primary key, name varchar)");
        stat.execute("create index idx_test_name on test(name, id)");
        stat.execute("grant all on test to test");
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            rs22 = stat.executeQuery("call db_object_id('USER', 'test')");
            try {
                rs22.next();
                userId = rs22.getInt(1);
            }
            finally {
                if (rs22 != null) {
                    rs22.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable2 = null;
        rs22 = null;
        try (ResultSet rs = stat.executeQuery("call db_object_id('INDEX', 'public', 'idx_test_name')");){
            rs.next();
            indexId = rs.getInt(1);
        }
        catch (Throwable rs22) {
            if (throwable2 == null) {
                throwable2 = rs22;
            } else if (throwable2 != rs22) {
                throwable2.addSuppressed(rs22);
            }
            throw throwable2;
        }
        stat.close();
        conn.close();
        conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", "test", "test");
        stat = conn.createStatement();
        stat.execute("prepare test(int, int) as select ?1*?2");
        ResultSet rs = stat.executeQuery("execute test(3, 2)");
        rs.next();
        this.assertEquals(6, rs.getInt(1));
        stat.execute("deallocate test");
        PreparedStatement prep = conn.prepareStatement("select * from test where name = ?");
        prep.setNull(1, 12);
        rs = prep.executeQuery();
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("insert into test values(?, ?)");
        ParameterMetaData meta = prep.getParameterMetaData();
        this.assertEquals(2, meta.getParameterCount());
        prep.setInt(1, 1);
        prep.setString(2, "Hello");
        prep.execute();
        rs = stat.executeQuery("select *, null nul from test");
        rs.next();
        ResultSetMetaData rsMeta = rs.getMetaData();
        this.assertEquals(4, rsMeta.getColumnType(1));
        this.assertEquals(12, rsMeta.getColumnType(2));
        this.assertEquals(12, rsMeta.getColumnType(3));
        this.assertEquals("test", rsMeta.getTableName(1));
        prep.close();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        prep = conn.prepareStatement("select * from test where id = ? and name = ?");
        prep.setInt(1, 1);
        prep.setString(2, "Hello");
        rs = prep.executeQuery();
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hello", rs.getString(2));
        this.assertFalse(rs.next());
        rs.close();
        DatabaseMetaData dbMeta = conn.getMetaData();
        rs = dbMeta.getTables(null, null, "TEST", null);
        this.assertFalse(rs.next());
        rs = dbMeta.getTables(null, null, "test", null);
        this.assertTrue(rs.next());
        this.assertEquals("test", rs.getString("TABLE_NAME"));
        this.assertFalse(rs.next());
        rs = dbMeta.getColumns(null, null, "test", null);
        rs.next();
        this.assertEquals("id", rs.getString("COLUMN_NAME"));
        rs.next();
        this.assertEquals("name", rs.getString("COLUMN_NAME"));
        this.assertFalse(rs.next());
        rs = dbMeta.getIndexInfo(null, null, "TEST", false, false);
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select version(), pg_postmaster_start_time(), current_schema()");
        rs.next();
        String s = rs.getString(1);
        this.assertContains(s, "H2");
        this.assertContains(s, "PostgreSQL");
        s = rs.getString(2);
        s = rs.getString(3);
        this.assertEquals(s, "public");
        this.assertFalse(rs.next());
        conn.setAutoCommit(false);
        stat.execute("delete from test");
        conn.rollback();
        stat.execute("update test set name = 'Hallo'");
        conn.commit();
        rs = stat.executeQuery("select * from test order by id");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        this.assertEquals("Hallo", rs.getString(2));
        this.assertFalse(rs.next());
        rs = stat.executeQuery("select pg_get_userbyid(" + userId + ")");
        rs.next();
        this.assertEquals("test", rs.getString(1));
        rs.close();
        rs = stat.executeQuery("select currTid2('x', 1)");
        rs.next();
        this.assertEquals(1, rs.getInt(1));
        rs = stat.executeQuery("select has_table_privilege('TEST', 'READ')");
        rs.next();
        this.assertTrue(rs.getBoolean(1));
        rs = stat.executeQuery("select has_schema_privilege(1, 'READ')");
        rs.next();
        this.assertTrue(rs.getBoolean(1));
        rs = stat.executeQuery("select has_database_privilege(1, 'READ')");
        rs.next();
        this.assertTrue(rs.getBoolean(1));
        rs = stat.executeQuery("select pg_get_userbyid(1000000000)");
        rs.next();
        this.assertEquals("unknown (OID=1000000000)", rs.getString(1));
        rs = stat.executeQuery("select pg_encoding_to_char(0)");
        rs.next();
        this.assertEquals("SQL_ASCII", rs.getString(1));
        rs = stat.executeQuery("select pg_encoding_to_char(6)");
        rs.next();
        this.assertEquals("UTF8", rs.getString(1));
        rs = stat.executeQuery("select pg_encoding_to_char(8)");
        rs.next();
        this.assertEquals("LATIN1", rs.getString(1));
        rs = stat.executeQuery("select pg_encoding_to_char(20)");
        rs.next();
        this.assertEquals("UTF8", rs.getString(1));
        rs = stat.executeQuery("select pg_encoding_to_char(40)");
        rs.next();
        this.assertEquals("", rs.getString(1));
        rs = stat.executeQuery("select 0::regclass");
        rs.next();
        this.assertEquals(0, rs.getInt(1));
        rs = stat.executeQuery("select pg_get_indexdef(0, 0, false)");
        rs.next();
        this.assertNull(rs.getString(1));
        rs = stat.executeQuery("select pg_get_indexdef(" + indexId + ", 0, false)");
        rs.next();
        this.assertEquals("CREATE INDEX \"public\".\"idx_test_name\" ON \"public\".\"test\"(\"name\" NULLS LAST, \"id\" NULLS LAST)", rs.getString(1));
        rs = stat.executeQuery("select pg_get_indexdef(" + indexId + ", null, false)");
        rs.next();
        this.assertNull(rs.getString(1));
        rs = stat.executeQuery("select pg_get_indexdef(" + indexId + ", 1, false)");
        rs.next();
        this.assertEquals("name", rs.getString(1));
        rs = stat.executeQuery("select pg_get_indexdef(" + indexId + ", 2, false)");
        rs.next();
        this.assertEquals("id", rs.getString(1));
        rs = stat.executeQuery("select * from pg_type where oid = 1015");
        rs.next();
        this.assertEquals("_varchar", rs.getString("typname"));
        this.assertEquals((Object)"_varchar", rs.getObject("typname"));
        this.assertEquals("b", rs.getString("typtype"));
        this.assertEquals(",", rs.getString("typdelim"));
        this.assertEquals(1043, rs.getInt("typelem"));
        stat.setMaxRows(10);
        rs = stat.executeQuery("select * from generate_series(0, 10)");
        this.assertNRows(rs, 10);
        stat.setMaxRows(0);
        stat.setFetchSize(2);
        rs = stat.executeQuery("select * from generate_series(0, 4)");
        this.assertNRows(rs, 5);
        rs = stat.executeQuery("select * from generate_series(0, 1)");
        this.assertNRows(rs, 2);
        stat.setFetchSize(0);
        conn.close();
    }

    private void assertNRows(ResultSet rs, int n) throws SQLException {
        int i = 0;
        while (i < n) {
            this.assertTrue(rs.next());
            this.assertEquals(i, rs.getInt(1));
            ++i;
        }
        this.assertFalse(rs.next());
    }

    private void testPgClientSimple() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver?preferQueryMode=simple", "sa", "sa");
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("select 1");
        this.assertTrue(rs.next());
        this.assertEquals(1, rs.getInt(1));
        this.assertFalse(rs.next());
        stat.setMaxRows(0);
        stat.execute("create table test2(int integer)");
        stat.execute("drop table test2");
        this.assertThrows(SQLException.class, stat).execute("drop table test2");
        conn.close();
    }

    private void testKeyAlias() throws SQLException {
        if (!this.getPgJdbcDriver()) {
            return;
        }
        Server server = this.createPgServer("-ifNotExists", "-pgPort", "5535", "-pgDaemon", "-key", "pgserver", "mem:pgserver");
        try {
            Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", "sa", "sa");
            Statement stat = conn.createStatement();
            stat.execute("create table test(id int primary key, name varchar)");
            ResultSet rs = stat.executeQuery("select storage_type from information_schema.tables where table_name = 'test'");
            this.assertTrue(rs.next());
            this.assertEquals("MEMORY", rs.getString(1));
            conn.close();
        }
        finally {
            server.stop();
        }
    }

    private static Set<Integer> getSupportedBinaryOids() throws ReflectiveOperationException {
        Field supportedBinaryOidsField = Class.forName("org.postgresql.jdbc.PgConnection").getDeclaredField("SUPPORTED_BINARY_OIDS");
        supportedBinaryOidsField.setAccessible(true);
        return (Set)supportedBinaryOidsField.get(null);
    }

    private void testTextualAndBinaryTypes() throws SQLException {
        this.testTextualAndBinaryTypes(false);
        this.testTextualAndBinaryTypes(true);
        supportedBinaryOids.add(1700);
        this.testTextualAndBinaryTypes(true);
        supportedBinaryOids.remove(1700);
    }

    private void testTextualAndBinaryTypes(boolean binary) throws SQLException {
        if (!this.getPgJdbcDriver()) {
            return;
        }
        Server server = this.createPgServer("-ifNotExists", "-pgPort", "5535", "-pgDaemon", "-key", "pgserver", "mem:pgserver");
        try {
            Properties props = new Properties();
            props.setProperty("user", "sa");
            props.setProperty("password", "sa");
            if (binary) {
                props.setProperty("prepareThreshold", "-1");
            }
            Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", props);
            Statement stat = conn.createStatement();
            stat.execute("create table test(x1 varchar, x2 int, x3 smallint, x4 bigint, x5 double precision, x6 float, x7 real, x8 boolean, x9 char(3), x10 bytea, x11 date, x12 time, x13 timestamp, x14 numeric(25, 5),x15 time with time zone, x16 timestamp with time zone)");
            PreparedStatement ps = conn.prepareStatement("insert into test values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ps.setString(1, "test");
            ps.setInt(2, 12345678);
            ps.setShort(3, (short)12345);
            ps.setLong(4, 1234567890123L);
            ps.setDouble(5, 123.456);
            ps.setFloat(6, 123.456f);
            ps.setFloat(7, 123.456f);
            ps.setBoolean(8, true);
            ps.setByte(9, (byte)-2);
            byte[] byArray = new byte[6];
            byArray[0] = 97;
            byArray[1] = -2;
            byArray[2] = 87;
            byArray[4] = 127;
            byArray[5] = 92;
            ps.setBytes(10, byArray);
            ps.setDate(11, Date.valueOf("2015-01-31"));
            ps.setTime(12, Time.valueOf("20:11:15"));
            ps.setTimestamp(13, Timestamp.valueOf("2001-10-30 14:16:10.111"));
            ps.setBigDecimal(14, new BigDecimal("12345678901234567890.12345"));
            ps.setTime(15, Time.valueOf("20:11:15"));
            ps.setTimestamp(16, Timestamp.valueOf("2001-10-30 14:16:10.111"));
            ps.execute();
            int i = 1;
            while (i <= 16) {
                ps.setNull(i, 0);
                ++i;
            }
            ps.execute();
            ResultSet rs = stat.executeQuery("select * from test");
            this.assertTrue(rs.next());
            this.assertEquals("test", rs.getString(1));
            this.assertEquals(12345678, rs.getInt(2));
            this.assertEquals(12345, rs.getShort(3));
            this.assertEquals(1234567890123L, rs.getLong(4));
            this.assertEquals(123.456, rs.getDouble(5));
            this.assertEquals(123.456f, rs.getFloat(6));
            this.assertEquals(123.456f, rs.getFloat(7));
            this.assertEquals(true, rs.getBoolean(8));
            this.assertEquals(-2, rs.getByte(9));
            byte[] byArray2 = new byte[6];
            byArray2[0] = 97;
            byArray2[1] = -2;
            byArray2[2] = 87;
            byArray2[4] = 127;
            byArray2[5] = 92;
            this.assertEquals(byArray2, rs.getBytes(10));
            this.assertEquals(Date.valueOf("2015-01-31"), rs.getDate(11));
            this.assertEquals(Time.valueOf("20:11:15"), rs.getTime(12));
            this.assertEquals(Timestamp.valueOf("2001-10-30 14:16:10.111"), rs.getTimestamp(13));
            this.assertEquals(new BigDecimal("12345678901234567890.12345"), rs.getBigDecimal(14));
            this.assertEquals(Time.valueOf("20:11:15"), rs.getTime(15));
            this.assertEquals(Timestamp.valueOf("2001-10-30 14:16:10.111"), rs.getTimestamp(16));
            this.assertTrue(rs.next());
            int i2 = 1;
            while (i2 <= 16) {
                this.assertNull(rs.getObject(i2));
                ++i2;
            }
            this.assertFalse(rs.next());
            conn.close();
        }
        finally {
            server.stop();
        }
    }

    private void testBinaryNumeric() throws SQLException {
        if (!this.getPgJdbcDriver()) {
            return;
        }
        Server server = this.createPgServer("-ifNotExists", "-pgPort", "5535", "-pgDaemon", "-key", "pgserver", "mem:pgserver");
        supportedBinaryOids.add(1700);
        try {
            ResultSet rs;
            Properties props = new Properties();
            props.setProperty("user", "sa");
            props.setProperty("password", "sa");
            props.setProperty("prepareThreshold", "-1");
            Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", props);
            Statement stat = conn.createStatement();
            Throwable throwable = null;
            Object var6_11 = null;
            try {
                rs = stat.executeQuery("SELECT 1E-16383, 1E+1, 1E+89, 1E-16384");
                try {
                    rs.next();
                    this.assertEquals(new BigDecimal("1E-16383"), rs.getBigDecimal(1));
                    this.assertEquals(new BigDecimal("10"), rs.getBigDecimal(2));
                    this.assertEquals(new BigDecimal("10").pow(89), rs.getBigDecimal(3));
                    try {
                        rs.getBigDecimal(4);
                        this.fail();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            try {
                throwable = null;
                var6_11 = null;
                try {
                    rs = stat.executeQuery("SELECT 1E-32768");
                    try {
                        this.fail();
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                this.assertEquals("22003", e.getSQLState());
            }
            try {
                Throwable e = null;
                var6_11 = null;
                try {
                    rs = stat.executeQuery("SELECT 1E+131072");
                    try {
                        this.fail();
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (e == null) {
                        e = throwable4;
                    } else if (e != throwable4) {
                        e.addSuppressed(throwable4);
                    }
                    throw e;
                }
            }
            catch (SQLException e) {
                this.assertEquals("22003", e.getSQLState());
            }
            conn.close();
        }
        finally {
            supportedBinaryOids.remove(1700);
            server.stop();
        }
    }

    private void testDateTime() throws SQLException {
        if (!this.getPgJdbcDriver()) {
            return;
        }
        TimeZone old = TimeZone.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT+01"));
        DateTimeUtils.resetCalendar();
        try {
            Server server = this.createPgServer("-ifNotExists", "-pgPort", "5535", "-pgDaemon", "-key", "pgserver", "mem:pgserver");
            try {
                Properties props = new Properties();
                props.setProperty("user", "sa");
                props.setProperty("password", "sa");
                props.setProperty("prepareThreshold", "-1");
                Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", props);
                Statement stat = conn.createStatement();
                stat.execute("create table test(x1 date, x2 time, x3 timestamp)");
                Date[] dateArray = new Date[7];
                dateArray[1] = Date.valueOf("2017-02-20");
                dateArray[2] = Date.valueOf("1970-01-01");
                dateArray[3] = Date.valueOf("1969-12-31");
                dateArray[4] = Date.valueOf("1940-01-10");
                dateArray[5] = Date.valueOf("1950-11-10");
                dateArray[6] = Date.valueOf("1500-01-01");
                Date[] dates = dateArray;
                Time[] timeArray = new Time[7];
                timeArray[1] = Time.valueOf("14:15:16");
                timeArray[2] = Time.valueOf("00:00:00");
                timeArray[3] = Time.valueOf("23:59:59");
                timeArray[4] = Time.valueOf("00:10:59");
                timeArray[5] = Time.valueOf("08:30:42");
                timeArray[6] = Time.valueOf("10:00:00");
                Time[] times = timeArray;
                Timestamp[] timestampArray = new Timestamp[7];
                timestampArray[1] = Timestamp.valueOf("2017-02-20 14:15:16.763");
                timestampArray[2] = Timestamp.valueOf("1970-01-01 00:00:00");
                timestampArray[3] = Timestamp.valueOf("1969-12-31 23:59:59");
                timestampArray[4] = Timestamp.valueOf("1940-01-10 00:10:59");
                timestampArray[5] = Timestamp.valueOf("1950-11-10 08:30:42.12");
                timestampArray[6] = Timestamp.valueOf("1500-01-01 10:00:10");
                Timestamp[] timestamps = timestampArray;
                int count = dates.length;
                PreparedStatement ps = conn.prepareStatement("insert into test values (?,?,?)");
                int i = 0;
                while (i < count) {
                    ps.setDate(1, dates[i]);
                    ps.setTime(2, times[i]);
                    ps.setTimestamp(3, timestamps[i]);
                    ps.execute();
                    ++i;
                }
                ResultSet rs = stat.executeQuery("select * from test");
                int i2 = 0;
                while (i2 < count) {
                    this.assertTrue(rs.next());
                    this.assertEquals(dates[i2], rs.getDate(1));
                    this.assertEquals(times[i2], rs.getTime(2));
                    this.assertEquals(timestamps[i2], rs.getTimestamp(3));
                    ++i2;
                }
                this.assertFalse(rs.next());
                conn.close();
            }
            finally {
                server.stop();
            }
        }
        finally {
            TimeZone.setDefault(old);
            DateTimeUtils.resetCalendar();
        }
    }

    private void testPrepareWithUnspecifiedType() throws Exception {
        if (!this.getPgJdbcDriver()) {
            return;
        }
        Server server = this.createPgServer("-ifNotExists", "-pgPort", "5535", "-pgDaemon", "-key", "pgserver", "mem:pgserver");
        try {
            Properties props = new Properties();
            props.setProperty("user", "sa");
            props.setProperty("password", "sa");
            props.setProperty("prepareThreshold", "1");
            Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", props);
            Statement stmt = conn.createStatement();
            stmt.executeUpdate("create table t1 (id integer, v timestamp)");
            stmt.close();
            PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(100500, ?)");
            this.assertEquals(93, pstmt.getParameterMetaData().getParameterType(1));
            Timestamp t = new Timestamp(System.currentTimeMillis());
            pstmt.setObject(1, t);
            this.assertEquals(1, pstmt.executeUpdate());
            pstmt.close();
            pstmt = conn.prepareStatement("SELECT * FROM t1 WHERE v = ?");
            this.assertEquals(93, pstmt.getParameterMetaData().getParameterType(1));
            pstmt.setObject(1, t);
            ResultSet rs = pstmt.executeQuery();
            this.assertTrue(rs.next());
            this.assertEquals(100500, rs.getInt(1));
            rs.close();
            pstmt.close();
            conn.close();
        }
        finally {
            server.stop();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testOtherPgClients() throws SQLException {
        if (!this.getPgJdbcDriver()) {
            return;
        }
        Server server = this.createPgServer("-ifNotExists", "-pgPort", "5535", "-pgDaemon", "-key", "pgserver", "mem:pgserver");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", "sa", "sa");
                try {
                    try (Statement stat = conn.createStatement();){
                        int oid;
                        ResultSet rs;
                        ResultSet rs2;
                        stat.execute("create table test(id serial primary key, x1 integer)");
                        stat.execute("SET client_min_messages=notice");
                        Throwable throwable2 = null;
                        Throwable throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT set_config('bytea_output','escape',false) FROM pg_settings WHERE name = 'bytea_output'");
                            try {
                                this.assertFalse(rs2.next());
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable4) throw throwable2;
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                        stat.execute("SET client_encoding='UNICODE'");
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT version()");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertNotNull(rs2.getString("version"));
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable5) throw throwable2;
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT db.oid as did, db.datname, db.datallowconn, pg_encoding_to_char(db.encoding) AS serverencoding, has_database_privilege(db.oid, 'CREATE') as cancreate, datlastsysoid FROM pg_database db WHERE db.datname = current_database()");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("pgserver", rs2.getString("datname"));
                                this.assertFalse(rs2.next());
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable2 == null) {
                                throwable2 = throwable6;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable6) throw throwable2;
                                throwable2.addSuppressed(throwable6);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT oid as id, rolname as name, rolsuper as is_superuser, CASE WHEN rolsuper THEN true ELSE rolcreaterole END as can_create_role, CASE WHEN rolsuper THEN true ELSE rolcreatedb END as can_create_db FROM pg_catalog.pg_roles WHERE rolname = current_user");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("sa", rs2.getString("name"));
                                this.assertFalse(rs2.next());
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable2 == null) {
                                throwable2 = throwable7;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable7) throw throwable2;
                                throwable2.addSuppressed(throwable7);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT db.oid as did, db.datname as name, ta.spcname as spcname, db.datallowconn, has_database_privilege(db.oid, 'CREATE') as cancreate, datdba as owner FROM pg_database db LEFT OUTER JOIN pg_tablespace ta ON db.dattablespace = ta.oid WHERE db.oid > 100000::OID");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("pgserver", rs2.getString("name"));
                                this.assertFalse(rs2.next());
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable8) {
                            if (throwable2 == null) {
                                throwable2 = throwable8;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable8) throw throwable2;
                                throwable2.addSuppressed(throwable8);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT nsp.oid, nsp.nspname as name, has_schema_privilege(nsp.oid, 'CREATE') as can_create, has_schema_privilege(nsp.oid, 'USAGE') as has_usage FROM pg_namespace nsp WHERE nspname NOT LIKE 'pg\\_%' AND NOT ((nsp.nspname = 'pg_catalog' AND EXISTS (SELECT 1 FROM pg_class WHERE relname = 'pg_class' AND relnamespace = nsp.oid LIMIT 1)) OR (nsp.nspname = 'pgagent' AND EXISTS (SELECT 1 FROM pg_class WHERE relname = 'pga_job' AND relnamespace = nsp.oid LIMIT 1)) OR (nsp.nspname = 'information_schema' AND EXISTS (SELECT 1 FROM pg_class WHERE relname = 'tables' AND relnamespace = nsp.oid LIMIT 1))) ORDER BY nspname");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("public", rs2.getString("name"));
                                this.assertFalse(rs2.next());
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable9) {
                            if (throwable2 == null) {
                                throwable2 = throwable9;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable9) throw throwable2;
                                throwable2.addSuppressed(throwable9);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT format_type(23, NULL)");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("INTEGER", rs2.getString(1));
                                this.assertFalse(rs2.next());
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable10) {
                            if (throwable2 == null) {
                                throwable2 = throwable10;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable10) throw throwable2;
                                throwable2.addSuppressed(throwable10);
                            }
                            throw throwable2;
                        }
                        stat.execute("SET join_collapse_limit=8");
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SHOW ssl");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("off", rs2.getString(1));
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable11) {
                            if (throwable2 == null) {
                                throwable2 = throwable11;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable11) throw throwable2;
                                throwable2.addSuppressed(throwable11);
                            }
                            throw throwable2;
                        }
                        stat.execute("SET search_path TO 'public', '$user'");
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT *, NULL AS data_length, pg_relation_size(QUOTE_IDENT(t.TABLE_SCHEMA) || '.' || QUOTE_IDENT(t.TABLE_NAME))::bigint AS index_length, c.reltuples, obj_description(c.oid) AS comment FROM \"information_schema\".\"tables\" AS t LEFT JOIN \"pg_namespace\" n ON t.table_schema = n.nspname LEFT JOIN \"pg_class\" c ON n.oid = c.relnamespace AND c.relname=t.table_name WHERE t.\"table_schema\"='public'");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("test", rs2.getString("table_name"));
                                this.assertTrue(rs2.getLong("index_length") >= 0L);
                                this.assertNull(rs2.getString("comment"));
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable12) {
                            if (throwable2 == null) {
                                throwable2 = throwable12;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable12) throw throwable2;
                                throwable2.addSuppressed(throwable12);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT \"p\".\"proname\", \"p\".\"proargtypes\" FROM \"pg_catalog\".\"pg_namespace\" AS \"n\" JOIN \"pg_catalog\".\"pg_proc\" AS \"p\" ON \"p\".\"pronamespace\" = \"n\".\"oid\" WHERE \"n\".\"nspname\"='public'");
                            try {
                                this.assertFalse(rs2.next());
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable13) {
                            if (throwable2 == null) {
                                throwable2 = throwable13;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable13) throw throwable2;
                                throwable2.addSuppressed(throwable13);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT DISTINCT a.attname AS column_name, a.attnum, a.atttypid, FORMAT_TYPE(a.atttypid, a.atttypmod) AS data_type, CASE a.attnotnull WHEN false THEN 'YES' ELSE 'NO' END AS IS_NULLABLE, com.description AS column_comment, pg_get_expr(def.adbin, def.adrelid) AS column_default, NULL AS character_maximum_length FROM pg_attribute AS a JOIN pg_class AS pgc ON pgc.oid = a.attrelid LEFT JOIN pg_description AS com ON (pgc.oid = com.objoid AND a.attnum = com.objsubid) LEFT JOIN pg_attrdef AS def ON (a.attrelid = def.adrelid AND a.attnum = def.adnum) WHERE a.attnum > 0 AND pgc.oid = a.attrelid AND pg_table_is_visible(pgc.oid) AND NOT a.attisdropped AND pgc.relname = 'test' ORDER BY a.attnum");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("id", rs2.getString("column_name"));
                                this.assertTrue(rs2.next());
                                this.assertEquals("x1", rs2.getString("column_name"));
                                this.assertFalse(rs2.next());
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable14) {
                            if (throwable2 == null) {
                                throwable2 = throwable14;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable14) throw throwable2;
                                throwable2.addSuppressed(throwable14);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SHOW ALL");
                            try {
                                ResultSetMetaData rsMeta = rs2.getMetaData();
                                this.assertEquals("name", rsMeta.getColumnName(1));
                                this.assertEquals("setting", rsMeta.getColumnName(2));
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable15) {
                            if (throwable2 == null) {
                                throwable2 = throwable15;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable15) throw throwable2;
                                throwable2.addSuppressed(throwable15);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SELECT t.oid,t.*,c.relkind FROM pg_catalog.pg_type t LEFT OUTER JOIN pg_class c ON c.oid=t.typrelid WHERE typnamespace=-1000");
                            if (rs2 != null) {
                                rs2.close();
                            }
                        }
                        catch (Throwable throwable16) {
                            if (throwable2 == null) {
                                throwable2 = throwable16;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable16) throw throwable2;
                                throwable2.addSuppressed(throwable16);
                            }
                            throw throwable2;
                        }
                        stat.execute("SET search_path TO 'ab', 'c\"d', 'e''f'");
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SHOW search_path");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("pg_catalog, ab, \"c\"\"d\", \"e'f\"", rs2.getString("search_path"));
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable17) {
                            if (throwable2 == null) {
                                throwable2 = throwable17;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable17) throw throwable2;
                                throwable2.addSuppressed(throwable17);
                            }
                            throw throwable2;
                        }
                        stat.execute("SET search_path TO ab, \"c\"\"d\", \"e'f\"");
                        throwable2 = null;
                        throwable3 = null;
                        try {
                            rs2 = stat.executeQuery("SHOW search_path");
                            try {
                                this.assertTrue(rs2.next());
                                this.assertEquals("pg_catalog, ab, \"c\"\"d\", \"e'f\"", rs2.getString("search_path"));
                            }
                            finally {
                                if (rs2 != null) {
                                    rs2.close();
                                }
                            }
                        }
                        catch (Throwable throwable18) {
                            if (throwable2 == null) {
                                throwable2 = throwable18;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable18) throw throwable2;
                                throwable2.addSuppressed(throwable18);
                            }
                            throw throwable2;
                        }
                        throwable3 = null;
                        Object var8_44 = null;
                        try {
                            rs = stat.executeQuery("SELECT oid FROM pg_class WHERE relname = 'test'");
                            try {
                                rs.next();
                                oid = rs.getInt("oid");
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (Throwable throwable19) {
                            if (throwable3 == null) {
                                throwable3 = throwable19;
                                throw throwable3;
                            } else {
                                if (throwable3 == throwable19) throw throwable3;
                                throwable3.addSuppressed(throwable19);
                            }
                            throw throwable3;
                        }
                        throwable3 = null;
                        var8_44 = null;
                        try {
                            rs = stat.executeQuery("SELECT i.*,i.indkey as keys,c.relname,c.relnamespace,c.relam,c.reltablespace,tc.relname as tabrelname,dsc.description,pg_catalog.pg_get_expr(i.indpred, i.indrelid) as pred_expr,pg_catalog.pg_get_expr(i.indexprs, i.indrelid, true) as expr,pg_catalog.pg_relation_size(i.indexrelid) as index_rel_size,pg_catalog.pg_stat_get_numscans(i.indexrelid) as index_num_scans FROM pg_catalog.pg_index i INNER JOIN pg_catalog.pg_class c ON c.oid=i.indexrelid INNER JOIN pg_catalog.pg_class tc ON tc.oid=i.indrelid LEFT OUTER JOIN pg_catalog.pg_description dsc ON i.indexrelid=dsc.objoid WHERE i.indrelid=" + oid + " ORDER BY c.relname");
                            try {
                                this.assertFalse(rs.next());
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (Throwable throwable20) {
                            if (throwable3 == null) {
                                throwable3 = throwable20;
                                throw throwable3;
                            } else {
                                if (throwable3 == throwable20) throw throwable3;
                                throwable3.addSuppressed(throwable20);
                            }
                            throw throwable3;
                        }
                        throwable3 = null;
                        var8_44 = null;
                        try {
                            rs = stat.executeQuery("SELECT c.oid,c.*,t.relname as tabrelname,rt.relnamespace as refnamespace,d.description FROM pg_catalog.pg_constraint c INNER JOIN pg_catalog.pg_class t ON t.oid=c.conrelid LEFT OUTER JOIN pg_catalog.pg_class rt ON rt.oid=c.confrelid LEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=c.oid AND d.objsubid=0 AND d.classoid='pg_constraint'::regclass WHERE c.conrelid=" + oid);
                            try {
                                this.assertTrue(rs.next());
                                this.assertEquals("test", rs.getString("tabrelname"));
                                this.assertEquals("p", rs.getString("contype"));
                                this.assertEquals((Object)1, ((Object[])rs.getArray("conkey").getArray())[0]);
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (Throwable throwable21) {
                            if (throwable3 == null) {
                                throwable3 = throwable21;
                                throw throwable3;
                            } else {
                                if (throwable3 == throwable21) throw throwable3;
                                throwable3.addSuppressed(throwable21);
                            }
                            throw throwable3;
                        }
                    }
                    if (conn == null) return;
                }
                catch (Throwable throwable22) {
                    if (throwable == null) {
                        throwable = throwable22;
                    } else if (throwable != throwable22) {
                        throwable.addSuppressed(throwable22);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                return;
            }
            catch (Throwable throwable23) {
                if (throwable == null) {
                    throwable = throwable23;
                    throw throwable;
                } else {
                    if (throwable == throwable23) throw throwable;
                    throwable.addSuppressed(throwable23);
                }
                throw throwable;
            }
        }
        finally {
            server.stop();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void testArray() throws Exception {
        if (!this.getPgJdbcDriver()) {
            return;
        }
        Server server = this.createPgServer("-ifNotExists", "-pgPort", "5535", "-pgDaemon", "-key", "pgserver", "mem:pgserver");
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                Connection conn = DriverManager.getConnection("jdbc:postgresql://localhost:5535/pgserver", "sa", "sa");
                try {
                    try (Statement stat = conn.createStatement();){
                        ResultSet rs;
                        stat.execute("CREATE TABLE test (id int primary key, x1 varchar array)");
                        stat.execute("INSERT INTO test (id, x1) VALUES (1, ARRAY['abc', 'd\\\"e', '{,}'])");
                        Throwable throwable2 = null;
                        Object var7_13 = null;
                        try {
                            rs = stat.executeQuery("SELECT x1 FROM test WHERE id = 1");
                            try {
                                this.assertTrue(rs.next());
                                Object[] arr = (Object[])rs.getArray(1).getArray();
                                this.assertEquals((Object)"abc", arr[0]);
                                this.assertEquals((Object)"d\\\"e", arr[1]);
                                this.assertEquals((Object)"{,}", arr[2]);
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable3) throw throwable2;
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        var7_13 = null;
                        try {
                            rs = stat.executeQuery("SELECT data_type FROM information_schema.columns WHERE table_schema = 'pg_catalog' AND table_name = 'pg_database' AND column_name = 'datacl'");
                            try {
                                this.assertTrue(rs.next());
                                this.assertEquals("array", rs.getString(1));
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable4) throw throwable2;
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                        throwable2 = null;
                        var7_13 = null;
                        try {
                            rs = stat.executeQuery("SELECT data_type FROM information_schema.columns WHERE table_schema = 'pg_catalog' AND table_name = 'pg_tablespace' AND column_name = 'spcacl'");
                            try {
                                this.assertTrue(rs.next());
                                this.assertEquals("array", rs.getString(1));
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                                throw throwable2;
                            } else {
                                if (throwable2 == throwable5) throw throwable2;
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    if (conn == null) return;
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                return;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                    throw throwable;
                } else {
                    if (throwable == throwable7) throw throwable;
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        finally {
            server.stop();
        }
    }
}

